/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mqtt;

import com.github.netty.protocol.mqtt.IRetainedRepository;
import com.github.netty.protocol.mqtt.MqttRetainedMessage;
import com.github.netty.protocol.mqtt.subscriptions.Topic;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public final class MemoryRetainedRepository
implements IRetainedRepository {
    private final ConcurrentMap<Topic, MqttRetainedMessage> storage = new ConcurrentHashMap<Topic, MqttRetainedMessage>();

    @Override
    public void cleanRetained(Topic topic) {
        this.storage.remove(topic);
    }

    @Override
    public void retain(Topic topic, MqttPublishMessage msg) {
        ByteBuf payload = msg.content();
        byte[] rawPayload = new byte[payload.readableBytes()];
        payload.getBytes(0, rawPayload);
        MqttRetainedMessage toStore = new MqttRetainedMessage(msg.fixedHeader().qosLevel(), rawPayload);
        this.storage.put(topic, toStore);
    }

    @Override
    public boolean isEmpty() {
        return this.storage.isEmpty();
    }

    @Override
    public List<MqttRetainedMessage> retainedOnTopic(String topic) {
        Topic searchTopic = new Topic(topic);
        ArrayList<MqttRetainedMessage> matchingMessages = new ArrayList<MqttRetainedMessage>();
        for (Map.Entry entry : this.storage.entrySet()) {
            Topic scanTopic = (Topic)entry.getKey();
            if (!searchTopic.match(scanTopic)) continue;
            matchingMessages.add((MqttRetainedMessage)entry.getValue());
        }
        return matchingMessages;
    }
}

