/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mqtt;

import com.github.netty.core.AbstractChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.EventExecutor;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class MqttInflightResenderChannelHandler
extends AbstractChannelHandler {
    private static final long MIN_TIMEOUT_NANOS = TimeUnit.MILLISECONDS.toNanos(1L);
    private final long resenderTimeNanos;
    private volatile ScheduledFuture<?> resenderTimeout;
    private volatile long lastExecutionTime;
    private volatile int state;

    public MqttInflightResenderChannelHandler(long writerIdleTime, TimeUnit unit) {
        super(false);
        if (unit == null) {
            throw new NullPointerException("unit");
        }
        this.resenderTimeNanos = Math.max(unit.toNanos(writerIdleTime), MIN_TIMEOUT_NANOS);
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isActive() && ctx.channel().isRegistered()) {
            this.initialize(ctx);
        }
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        this.destroy();
    }

    public void channelRegistered(ChannelHandlerContext ctx) throws Exception {
        if (ctx.channel().isActive()) {
            this.initialize(ctx);
        }
        super.channelRegistered(ctx);
    }

    public void channelActive(ChannelHandlerContext ctx) throws Exception {
        this.initialize(ctx);
        super.channelActive(ctx);
    }

    public void channelInactive(ChannelHandlerContext ctx) throws Exception {
        this.destroy();
        super.channelInactive(ctx);
    }

    private void initialize(ChannelHandlerContext ctx) {
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Initializing autoflush handler on channel {}", (Object)ctx.channel());
        }
        switch (this.state) {
            case 1: 
            case 2: {
                return;
            }
        }
        this.state = 1;
        EventExecutor loop = ctx.executor();
        this.lastExecutionTime = System.nanoTime();
        this.resenderTimeout = loop.schedule((Runnable)new WriterIdleTimeoutTask(ctx), this.resenderTimeNanos, TimeUnit.NANOSECONDS);
    }

    private void destroy() {
        this.state = 2;
        if (this.resenderTimeout != null) {
            this.resenderTimeout.cancel(false);
            this.resenderTimeout = null;
        }
    }

    private void resendNotAcked(ChannelHandlerContext ctx) {
        ctx.fireUserEventTriggered((Object)new ResendNotAckedPublishes());
    }

    private final class WriterIdleTimeoutTask
    implements Runnable {
        private final ChannelHandlerContext ctx;

        WriterIdleTimeoutTask(ChannelHandlerContext ctx) {
            this.ctx = ctx;
        }

        @Override
        public void run() {
            if (!this.ctx.channel().isOpen()) {
                return;
            }
            long nextDelay = MqttInflightResenderChannelHandler.this.resenderTimeNanos - (System.nanoTime() - MqttInflightResenderChannelHandler.this.lastExecutionTime);
            if (nextDelay <= 0L) {
                MqttInflightResenderChannelHandler.this.resenderTimeout = (ScheduledFuture)this.ctx.executor().schedule((Runnable)this, MqttInflightResenderChannelHandler.this.resenderTimeNanos, TimeUnit.NANOSECONDS);
                try {
                    MqttInflightResenderChannelHandler.this.resendNotAcked(this.ctx);
                }
                catch (Throwable t) {
                    this.ctx.fireExceptionCaught(t);
                }
            } else {
                MqttInflightResenderChannelHandler.this.resenderTimeout = (ScheduledFuture)this.ctx.executor().schedule((Runnable)this, nextDelay, TimeUnit.NANOSECONDS);
            }
        }
    }

    public static class ResendNotAckedPublishes {
    }
}

