/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mqtt;

import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.protocol.mqtt.IRetainedRepository;
import com.github.netty.protocol.mqtt.MqttConnection;
import com.github.netty.protocol.mqtt.MqttRetainedMessage;
import com.github.netty.protocol.mqtt.MqttSession;
import com.github.netty.protocol.mqtt.MqttSessionRegistry;
import com.github.netty.protocol.mqtt.MqttUtil;
import com.github.netty.protocol.mqtt.interception.BrokerInterceptor;
import com.github.netty.protocol.mqtt.security.IAuthorizatorPolicy;
import com.github.netty.protocol.mqtt.subscriptions.ISubscriptionsDirectory;
import com.github.netty.protocol.mqtt.subscriptions.Subscription;
import com.github.netty.protocol.mqtt.subscriptions.Topic;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.mqtt.MqttFixedHeader;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttMessageIdVariableHeader;
import io.netty.handler.codec.mqtt.MqttMessageType;
import io.netty.handler.codec.mqtt.MqttPublishMessage;
import io.netty.handler.codec.mqtt.MqttQoS;
import io.netty.handler.codec.mqtt.MqttSubAckMessage;
import io.netty.handler.codec.mqtt.MqttSubAckPayload;
import io.netty.handler.codec.mqtt.MqttSubscribeMessage;
import io.netty.handler.codec.mqtt.MqttTopicSubscription;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

public class MqttPostOffice {
    private static final LoggerX LOG = LoggerFactoryX.getLogger(MqttPostOffice.class);
    private final IAuthorizatorPolicy authorizatorPolicy;
    private final ISubscriptionsDirectory subscriptions;
    private final IRetainedRepository retainedRepository;
    private MqttSessionRegistry sessionRegistry;
    private BrokerInterceptor interceptor;

    public MqttPostOffice(ISubscriptionsDirectory subscriptions, IAuthorizatorPolicy authorizatorPolicy, IRetainedRepository retainedRepository, MqttSessionRegistry sessionRegistry, BrokerInterceptor interceptor) {
        this.authorizatorPolicy = authorizatorPolicy;
        this.subscriptions = subscriptions;
        this.retainedRepository = retainedRepository;
        this.sessionRegistry = sessionRegistry;
        this.interceptor = interceptor;
    }

    public void fireWill(MqttSession.Will will) {
        this.publish2Subscribers(will.payload, new Topic(will.topic), will.qos);
    }

    public void subscribeClientToTopics(MqttSubscribeMessage msg, String clientID, String username, MqttConnection mqttConnection) {
        int messageID = MqttUtil.messageId((MqttMessage)msg);
        List<MqttTopicSubscription> ackTopics = this.verifyTopicsReadAccess(clientID, username, msg);
        MqttSubAckMessage ackMessage = this.doAckMessageFromValidateFilters(ackTopics, messageID);
        List<Subscription> newSubscriptions = ackTopics.stream().filter(req -> req.qualityOfService() != MqttQoS.FAILURE).map(req -> {
            Topic topic = new Topic(req.topicName());
            return new Subscription(clientID, topic, req.qualityOfService());
        }).collect(Collectors.toList());
        for (Subscription subscription : newSubscriptions) {
            this.subscriptions.add(subscription);
        }
        MqttSession session = this.sessionRegistry.retrieve(clientID);
        session.addSubscriptions(newSubscriptions);
        mqttConnection.sendSubAckMessage(messageID, ackMessage);
        this.publishRetainedMessagesForSubscriptions(clientID, newSubscriptions);
        for (Subscription subscription : newSubscriptions) {
            this.interceptor.notifyTopicSubscribed(subscription, username);
        }
    }

    List<MqttTopicSubscription> verifyTopicsReadAccess(String clientID, String username, MqttSubscribeMessage msg) {
        ArrayList<MqttTopicSubscription> ackTopics = new ArrayList<MqttTopicSubscription>();
        int messageId = MqttUtil.messageId((MqttMessage)msg);
        for (MqttTopicSubscription req : msg.payload().topicSubscriptions()) {
            Topic topic = new Topic(req.topicName());
            if (this.authorizatorPolicy.canRead(topic, username, clientID)) {
                MqttQoS qos;
                if (topic.isValid()) {
                    LOG.debug("Client will be subscribed to the topic CId={}, username: {}, messageId: {}, topic: {}", clientID, username, messageId, topic);
                    qos = req.qualityOfService();
                } else {
                    LOG.warn("Topic filter is not valid CId={}, username: {}, messageId: {}, topic: {}", clientID, username, messageId, topic);
                    qos = MqttQoS.FAILURE;
                }
                ackTopics.add(new MqttTopicSubscription(topic.toString(), qos));
                continue;
            }
            LOG.warn("Client does not have read permissions on the topic CId={}, username: {}, messageId: {}, topic: {}", clientID, username, messageId, topic);
            ackTopics.add(new MqttTopicSubscription(topic.toString(), MqttQoS.FAILURE));
        }
        return ackTopics;
    }

    private void publishRetainedMessagesForSubscriptions(String clientID, List<Subscription> newSubscriptions) {
        MqttSession targetSession = this.sessionRegistry.retrieve(clientID);
        for (Subscription subscription : newSubscriptions) {
            String topicFilter = subscription.getTopicFilter().toString();
            List<MqttRetainedMessage> retainedMsgs = this.retainedRepository.retainedOnTopic(topicFilter);
            if (retainedMsgs.isEmpty()) continue;
            for (MqttRetainedMessage retainedMsg : retainedMsgs) {
                MqttQoS retainedQos = retainedMsg.qosLevel();
                MqttQoS qos = MqttPostOffice.lowerQosToTheSubscriptionDesired(subscription, retainedQos);
                ByteBuf payloadBuf = Unpooled.wrappedBuffer((byte[])retainedMsg.getPayload());
                targetSession.sendRetainedPublishOnSessionAtQos(subscription.getTopicFilter(), qos, payloadBuf);
            }
        }
    }

    private MqttSubAckMessage doAckMessageFromValidateFilters(List<MqttTopicSubscription> topicFilters, int messageId) {
        ArrayList<Integer> grantedQoSLevels = new ArrayList<Integer>();
        for (MqttTopicSubscription req : topicFilters) {
            grantedQoSLevels.add(req.qualityOfService().value());
        }
        MqttFixedHeader fixedHeader = new MqttFixedHeader(MqttMessageType.SUBACK, false, MqttQoS.AT_MOST_ONCE, false, 0);
        MqttSubAckPayload payload = new MqttSubAckPayload(grantedQoSLevels);
        return new MqttSubAckMessage(fixedHeader, MqttMessageIdVariableHeader.from((int)messageId), payload);
    }

    public void unsubscribe(List<String> topics, MqttConnection mqttConnection, int messageId) {
        String clientID = mqttConnection.getClientId();
        for (String t : topics) {
            Topic topic = new Topic(t);
            boolean validTopic = topic.isValid();
            if (!validTopic) {
                mqttConnection.dropConnection();
                LOG.warn("Topic filter is not valid. CId={}, topics: {}, offending topic filter: {}", clientID, topics, topic);
                return;
            }
            LOG.trace("Removing subscription. CId={}, topic={}", (Object)clientID, (Object)topic);
            this.subscriptions.removeSubscription(topic, clientID);
            String username = MqttUtil.userName(mqttConnection.channel);
            this.interceptor.notifyTopicUnsubscribed(topic.toString(), clientID, username);
        }
        mqttConnection.sendUnsubAckMessage(topics, clientID, messageId);
    }

    void receivedPublishQos0(Topic topic, String username, String clientID, ByteBuf payload, boolean retain, MqttPublishMessage msg) {
        if (!this.authorizatorPolicy.canWrite(topic, username, clientID)) {
            LOG.error("MQTT client: {} is not authorized to publish on topic: {}", (Object)clientID, (Object)topic);
            return;
        }
        this.publish2Subscribers(payload, topic, MqttQoS.AT_MOST_ONCE);
        if (retain) {
            this.retainedRepository.cleanRetained(topic);
        }
        this.interceptor.notifyTopicPublished(msg, clientID, username);
    }

    void receivedPublishQos1(MqttConnection connection, Topic topic, String username, ByteBuf payload, int messageID, boolean retain, MqttPublishMessage msg) {
        topic.getTokens();
        if (!topic.isValid()) {
            LOG.warn("Invalid topic format, force close the connection");
            connection.dropConnection();
            return;
        }
        String clientId = connection.getClientId();
        if (!this.authorizatorPolicy.canWrite(topic, username, clientId)) {
            LOG.error("MQTT client: {} is not authorized to publish on topic: {}", (Object)clientId, (Object)topic);
            return;
        }
        this.publish2Subscribers(payload, topic, MqttQoS.AT_LEAST_ONCE);
        connection.sendPubAck(messageID);
        if (retain) {
            if (!payload.isReadable()) {
                this.retainedRepository.cleanRetained(topic);
            } else {
                this.retainedRepository.retain(topic, msg);
            }
        }
        this.interceptor.notifyTopicPublished(msg, clientId, username);
    }

    private void publish2Subscribers(ByteBuf origPayload, Topic topic, MqttQoS publishingQos) {
        Set<Subscription> topicMatchingSubscriptions = this.subscriptions.matchQosSharpening(topic);
        for (Subscription sub : topicMatchingSubscriptions) {
            boolean isSessionPresent;
            MqttQoS qos = MqttPostOffice.lowerQosToTheSubscriptionDesired(sub, publishingQos);
            MqttSession targetSession = this.sessionRegistry.retrieve(sub.getClientId());
            boolean bl = isSessionPresent = targetSession != null;
            if (isSessionPresent) {
                LOG.debug("Sending PUBLISH message to active subscriber CId: {}, topicFilter: {}, qos: {}", sub.getClientId(), sub.getTopicFilter(), qos);
                if (!this.authorizatorPolicy.canRead(topic, "TODO", sub.getClientId())) {
                    LOG.debug("Authorizator prohibit Client {} to be notified on {}", (Object)sub.getClientId(), (Object)topic);
                    return;
                }
                ByteBuf payload = origPayload.retainedDuplicate();
                targetSession.sendPublishOnSessionAtQos(topic, qos, payload);
                continue;
            }
            LOG.debug("PUBLISH to not yet present session. CId: {}, topicFilter: {}, qos: {}", sub.getClientId(), sub.getTopicFilter(), qos);
        }
    }

    void receivedPublishQos2(MqttConnection connection, MqttPublishMessage mqttPublishMessage, String username) {
        LOG.trace("Processing PUBREL message on connection: {}", (Object)connection);
        Topic topic = new Topic(mqttPublishMessage.variableHeader().topicName());
        ByteBuf payload = mqttPublishMessage.payload();
        String clientId = connection.getClientId();
        if (!this.authorizatorPolicy.canWrite(topic, username, clientId)) {
            LOG.error("MQTT client is not authorized to publish on topic. CId={}, topic: {}", (Object)clientId, (Object)topic);
            return;
        }
        this.publish2Subscribers(payload, topic, MqttQoS.EXACTLY_ONCE);
        boolean retained = mqttPublishMessage.fixedHeader().isRetain();
        if (retained) {
            if (!payload.isReadable()) {
                this.retainedRepository.cleanRetained(topic);
            } else {
                this.retainedRepository.retain(topic, mqttPublishMessage);
            }
        }
        String clientID = connection.getClientId();
        this.interceptor.notifyTopicPublished(mqttPublishMessage, clientID, username);
    }

    static MqttQoS lowerQosToTheSubscriptionDesired(Subscription sub, MqttQoS qos) {
        if (qos.value() > sub.getRequestedQos().value()) {
            qos = sub.getRequestedQos();
        }
        return qos;
    }

    public void internalPublish(MqttPublishMessage msg) {
        MqttQoS qos = msg.fixedHeader().qosLevel();
        Topic topic = new Topic(msg.variableHeader().topicName());
        ByteBuf payload = msg.payload();
        LOG.info("Sending internal PUBLISH message Topic={}, qos={}", (Object)topic, (Object)qos);
        this.publish2Subscribers(payload, topic, qos);
        if (!msg.fixedHeader().isRetain()) {
            return;
        }
        if (qos == MqttQoS.AT_MOST_ONCE || msg.payload().readableBytes() == 0) {
            this.retainedRepository.cleanRetained(topic);
            return;
        }
        this.retainedRepository.retain(topic, msg);
    }
}

