/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mqtt.config;

import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.protocol.mqtt.config.IResourceLoader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;

public class ClasspathResourceLoader
implements IResourceLoader {
    private static final LoggerX LOG = LoggerFactoryX.getLogger(ClasspathResourceLoader.class);
    private final String defaultResource;
    private final ClassLoader classLoader;

    public ClasspathResourceLoader() {
        this("config/moquette.conf");
    }

    public ClasspathResourceLoader(String defaultResource) {
        this(defaultResource, Thread.currentThread().getContextClassLoader());
    }

    public ClasspathResourceLoader(String defaultResource, ClassLoader classLoader) {
        this.defaultResource = defaultResource;
        this.classLoader = classLoader;
    }

    @Override
    public Reader loadDefaultResource() {
        return this.loadResource(this.defaultResource);
    }

    @Override
    public Reader loadResource(String relativePath) {
        LOG.info("Loading resource. RelativePath = {}.", (Object)relativePath);
        InputStream is = this.classLoader.getResourceAsStream(relativePath);
        return is != null ? new InputStreamReader(is, Charset.forName("UTF-8")) : null;
    }

    @Override
    public String getName() {
        return "classpath resource";
    }
}

