/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mqtt.config;

import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.protocol.mqtt.config.IResourceLoader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.file.Files;

public class FileResourceLoader
implements IResourceLoader {
    private static final LoggerX LOG = LoggerFactoryX.getLogger(FileResourceLoader.class);
    private final File defaultFile;
    private final String parentPath;

    public FileResourceLoader() {
        this((File)null);
    }

    public FileResourceLoader(File defaultFile) {
        this(defaultFile, System.getProperty("moquette.path", null));
    }

    public FileResourceLoader(String parentPath) {
        this(null, parentPath);
    }

    public FileResourceLoader(File defaultFile, String parentPath) {
        this.defaultFile = defaultFile;
        this.parentPath = parentPath;
    }

    @Override
    public Reader loadDefaultResource() {
        if (this.defaultFile != null) {
            return this.loadResource(this.defaultFile);
        }
        throw new IllegalArgumentException("Default file not set!");
    }

    @Override
    public Reader loadResource(String relativePath) {
        return this.loadResource(new File(this.parentPath, relativePath));
    }

    public Reader loadResource(File f) {
        LOG.info("Loading file. Path = {}.", (Object)f.getAbsolutePath());
        if (f.isDirectory()) {
            LOG.error("The given file is a directory. Path = {}.", (Object)f.getAbsolutePath());
            throw new IResourceLoader.ResourceIsDirectoryException("File \"" + f + "\" is a directory!");
        }
        try {
            return Files.newBufferedReader(f.toPath(), Charset.forName("UTF-8"));
        }
        catch (IOException e) {
            LOG.error("The file does not exist. Path = {}.", (Object)f.getAbsolutePath());
            return null;
        }
    }

    @Override
    public String getName() {
        return "file";
    }
}

