/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mqtt.config;

import com.github.netty.protocol.mqtt.config.IResourceLoader;

public abstract class IConfig {
    public static final String DEFAULT_CONFIG = "config/moquette.conf";

    public abstract void setProperty(String var1, String var2);

    public abstract String getProperty(String var1);

    public abstract String getProperty(String var1, String var2);

    void assignDefaults() {
        this.setProperty("port", Integer.toString(1883));
        this.setProperty("host", "0.0.0.0");
        this.setProperty("password_file", "");
        this.setProperty("allow_anonymous", Boolean.TRUE.toString());
        this.setProperty("authenticator_class", "");
        this.setProperty("authorizator_class", "");
        this.setProperty("netty.mqtt.message_size", String.valueOf(8092));
    }

    public abstract IResourceLoader getResourceLoader();

    public int intProp(String propertyName, int defaultValue) {
        String propertyValue = this.getProperty(propertyName);
        if (propertyValue == null) {
            return defaultValue;
        }
        return Integer.parseInt(propertyValue);
    }

    public boolean boolProp(String propertyName, boolean defaultValue) {
        String propertyValue = this.getProperty(propertyName);
        if (propertyValue == null) {
            return defaultValue;
        }
        return Boolean.parseBoolean(propertyValue);
    }
}

