/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mqtt.interception;

import com.github.netty.protocol.mqtt.interception.InterceptAbstractMessage;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.mqtt.MqttMessage;
import io.netty.handler.codec.mqtt.MqttPublishMessage;

public class InterceptPublishMessage
extends InterceptAbstractMessage {
    private final MqttPublishMessage msg;
    private final String clientID;
    private final String username;

    public InterceptPublishMessage(MqttPublishMessage msg, String clientID, String username) {
        super((MqttMessage)msg);
        this.msg = msg;
        this.clientID = clientID;
        this.username = username;
    }

    public String getTopicName() {
        return this.msg.variableHeader().topicName();
    }

    public ByteBuf getPayload() {
        return this.msg.payload();
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getUsername() {
        return this.username;
    }
}

