/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mqtt.security;

import com.github.netty.protocol.mqtt.subscriptions.Topic;

public class Authorization {
    protected final Topic topic;
    protected final Permission permission;

    Authorization(Topic topic) {
        this(topic, Permission.READWRITE);
    }

    Authorization(Topic topic, Permission permission) {
        this.topic = topic;
        this.permission = permission;
    }

    public boolean grant(Permission desiredPermission) {
        return this.permission == desiredPermission || this.permission == Permission.READWRITE;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Authorization that = (Authorization)o;
        if (this.permission != that.permission) {
            return false;
        }
        return this.topic.equals(that.topic);
    }

    public int hashCode() {
        int result = this.topic.hashCode();
        result = 31 * result + this.permission.hashCode();
        return result;
    }

    static enum Permission {
        READ,
        WRITE,
        READWRITE;

    }
}

