/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mqtt.subscriptions;

import com.github.netty.protocol.mqtt.subscriptions.Topic;
import io.netty.handler.codec.mqtt.MqttQoS;
import java.io.Serializable;

public final class Subscription
implements Serializable {
    private static final long serialVersionUID = -3383457629635732794L;
    private final MqttQoS requestedQos;
    final String clientId;
    final Topic topicFilter;

    public Subscription(String clientId, Topic topicFilter, MqttQoS requestedQos) {
        this.requestedQos = requestedQos;
        this.clientId = clientId;
        this.topicFilter = topicFilter;
    }

    public Subscription(Subscription orig) {
        this.requestedQos = orig.requestedQos;
        this.clientId = orig.clientId;
        this.topicFilter = orig.topicFilter;
    }

    public String getClientId() {
        return this.clientId;
    }

    public MqttQoS getRequestedQos() {
        return this.requestedQos;
    }

    public Topic getTopicFilter() {
        return this.topicFilter;
    }

    public boolean qosLessThan(Subscription sub) {
        return this.requestedQos.value() < sub.requestedQos.value();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Subscription that = (Subscription)o;
        if (this.clientId != null ? !this.clientId.equals(that.clientId) : that.clientId != null) {
            return false;
        }
        return !(this.topicFilter == null ? that.topicFilter != null : !this.topicFilter.equals(that.topicFilter));
    }

    public int hashCode() {
        int result = this.clientId != null ? this.clientId.hashCode() : 0;
        result = 31 * result + (this.topicFilter != null ? this.topicFilter.hashCode() : 0);
        return result;
    }

    public String toString() {
        return String.format("[filter:%s, clientID: %s, qos: %s]", this.topicFilter, this.clientId, this.requestedQos);
    }

    public Subscription clone() {
        try {
            return (Subscription)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
    }
}

