/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mqtt.subscriptions;

import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.protocol.mqtt.subscriptions.Token;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

public class Topic
implements Serializable {
    private static final LoggerX LOG = LoggerFactoryX.getLogger(Topic.class);
    private static final long serialVersionUID = 2438799283749822L;
    private final String topic;
    private transient List<Token> tokens;
    private transient boolean valid;

    public static Topic asTopic(String s) {
        return new Topic(s);
    }

    public Topic(String topic) {
        this.topic = topic;
    }

    Topic(List<Token> tokens) {
        this.tokens = tokens;
        List strTokens = tokens.stream().map(Token::toString).collect(Collectors.toList());
        this.topic = String.join((CharSequence)"/", strTokens);
        this.valid = true;
    }

    public List<Token> getTokens() {
        if (this.tokens == null) {
            try {
                this.tokens = this.parseTopic(this.topic);
                this.valid = true;
            }
            catch (ParseException e) {
                this.valid = false;
                LOG.error("Error parsing the topic: {}, message: {}", (Object)this.topic, (Object)e.getMessage());
            }
        }
        return this.tokens;
    }

    private List<Token> parseTopic(String topic) throws ParseException {
        if (topic.length() == 0) {
            throw new ParseException("Bad format of topic, topic MUST be at least 1 character [MQTT-4.7.3-1] and this was empty", 0);
        }
        ArrayList<Token> res = new ArrayList<Token>();
        String[] splitted = topic.split("/");
        if (splitted.length == 0) {
            res.add(Token.EMPTY);
        }
        if (topic.endsWith("/")) {
            String[] newSplitted = new String[splitted.length + 1];
            System.arraycopy(splitted, 0, newSplitted, 0, splitted.length);
            newSplitted[splitted.length] = "";
            splitted = newSplitted;
        }
        for (int i = 0; i < splitted.length; ++i) {
            String s = splitted[i];
            if (s.isEmpty()) {
                res.add(Token.EMPTY);
                continue;
            }
            if (s.equals("#")) {
                if (i != splitted.length - 1) {
                    throw new ParseException("Bad format of topic, the multi symbol (#) has to be the last one after a separator", i);
                }
                res.add(Token.MULTI);
                continue;
            }
            if (s.contains("#")) {
                throw new ParseException("Bad format of topic, invalid subtopic name: " + s, i);
            }
            if (s.equals("+")) {
                res.add(Token.SINGLE);
                continue;
            }
            if (s.contains("+")) {
                throw new ParseException("Bad format of topic, invalid subtopic name: " + s, i);
            }
            res.add(new Token(s));
        }
        return res;
    }

    public Token headToken() {
        List<Token> tokens = this.getTokens();
        if (tokens.isEmpty()) {
            return null;
        }
        return tokens.get(0);
    }

    public boolean isEmpty() {
        List<Token> tokens = this.getTokens();
        return tokens == null || tokens.isEmpty();
    }

    public Topic exceptHeadToken() {
        List<Token> tokens = this.getTokens();
        if (tokens.isEmpty()) {
            return new Topic(Collections.emptyList());
        }
        ArrayList<Token> tokensCopy = new ArrayList<Token>(tokens);
        tokensCopy.remove(0);
        return new Topic(tokensCopy);
    }

    public boolean isValid() {
        if (this.tokens == null) {
            this.getTokens();
        }
        return this.valid;
    }

    public boolean match(Topic subscriptionTopic) {
        int i;
        List<Token> msgTokens = this.getTokens();
        List<Token> subscriptionTokens = subscriptionTopic.getTokens();
        for (i = 0; i < subscriptionTokens.size(); ++i) {
            Token subToken = subscriptionTokens.get(i);
            if (!Token.MULTI.equals(subToken) && !Token.SINGLE.equals(subToken)) {
                if (i >= msgTokens.size()) {
                    return false;
                }
                Token msgToken = msgTokens.get(i);
                if (msgToken.equals(subToken)) continue;
                return false;
            }
            if (!Token.MULTI.equals(subToken)) continue;
            return true;
        }
        return i == msgTokens.size();
    }

    public String toString() {
        return this.topic;
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Topic other = (Topic)obj;
        return Objects.equals(this.topic, other.topic);
    }

    public int hashCode() {
        return this.topic.hashCode();
    }
}

