/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mysql;

import com.github.netty.core.AbstractChannelHandler;
import com.github.netty.protocol.mysql.exception.ProxyException;
import com.github.netty.protocol.mysql.server.ServerErrorPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.function.Supplier;

public class MysqlProxyHandler
extends AbstractChannelHandler<ByteBuf, ByteBuf> {
    private static final AttributeKey<ByteBuf> READY_WRITE_PACKET_ATTR = AttributeKey.valueOf((String)(MysqlProxyHandler.class + "#ByteBuf"));
    private final Supplier<Channel> channelSupplier;

    public MysqlProxyHandler(Supplier<Channel> channelSupplier) {
        super(false);
        this.channelSupplier = channelSupplier;
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        ServerErrorPacket errorPacket;
        if (cause instanceof ProxyException) {
            int errorNumber = ((ProxyException)cause).getErrorNumber();
            errorPacket = new ServerErrorPacket(0, errorNumber, "#HY000".getBytes(), cause.toString());
        } else {
            errorPacket = new ServerErrorPacket(0, 3000, "#HY000".getBytes(), cause.toString());
        }
        ctx.channel().writeAndFlush((Object)errorPacket).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    @Override
    protected void onMessageReceived(ChannelHandlerContext ctx, ByteBuf msg) throws Exception {
        ByteBuf userByteBuf = ctx.alloc().heapBuffer(msg.readableBytes());
        msg.getBytes(0, userByteBuf);
        Channel channel = this.channelSupplier.get();
        MysqlProxyHandler.setReadyWritePacket(channel, msg);
        ctx.fireChannelRead((Object)userByteBuf);
        ByteBuf readyWritePacket = MysqlProxyHandler.getReadyWritePacket(channel);
        if (readyWritePacket != null) {
            channel.write((Object)readyWritePacket);
        }
    }

    public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
        this.channelSupplier.get().writeAndFlush((Object)Unpooled.EMPTY_BUFFER);
    }

    public static void setReadyWritePacket(Channel channel, ByteBuf byteBuf) {
        channel.attr(READY_WRITE_PACKET_ATTR).set((Object)byteBuf);
    }

    public static ByteBuf getReadyWritePacket(Channel channel) {
        return (ByteBuf)channel.attr(READY_WRITE_PACKET_ATTR).get();
    }
}

