/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mysql;

import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.protocol.mysql.CapabilityFlags;
import com.github.netty.protocol.mysql.MysqlCharacterSet;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import java.util.EnumSet;
import java.util.Set;

public class Session {
    private static final AttributeKey<Session> SESSION_KEY = AttributeKey.valueOf((String)(Session.class.getName() + "#Session"));
    private static final AttributeKey<Integer> CONNECTION_ID_KEY = AttributeKey.valueOf((String)(Integer.class.getName() + "#connectionId"));
    private static final AttributeKey<MysqlCharacterSet> SERVER_CHARSET_KEY = AttributeKey.valueOf((String)(MysqlCharacterSet.class.getName() + "#server"));
    private static final AttributeKey<MysqlCharacterSet> CLIENT_CHARSET_KEY = AttributeKey.valueOf((String)(MysqlCharacterSet.class.getName() + "#client"));
    private static final AttributeKey<EnumSet<CapabilityFlags>> CAPABILITIES_ATTR = AttributeKey.valueOf((String)(CapabilityFlags.class.getName() + "#CapabilityFlags"));
    private static final LoggerX logger = LoggerFactoryX.getLogger(Session.class);
    private volatile Channel frontendChannel;
    private volatile Channel backendChannel;
    private String id;
    private Integer connectionId;
    private MysqlCharacterSet clientCharacterSet;
    private MysqlCharacterSet serverCharacterSet;

    public Session() {
    }

    public Session(String id) {
        this.id = id;
    }

    public String getId() {
        return this.id;
    }

    public EnumSet<CapabilityFlags> getFrontendCapabilities() {
        return this.getCapabilities(this.frontendChannel);
    }

    public EnumSet<CapabilityFlags> getBackendCapabilities() {
        return this.getCapabilities(this.backendChannel);
    }

    private EnumSet<CapabilityFlags> getCapabilities(Channel frontendChannel) {
        Attribute attr = frontendChannel.attr(CAPABILITIES_ATTR);
        EnumSet<CapabilityFlags> capabilityFlags = (EnumSet<CapabilityFlags>)attr.get();
        if (capabilityFlags == null) {
            capabilityFlags = CapabilityFlags.getImplicitCapabilities();
            attr.set(capabilityFlags);
        }
        return capabilityFlags;
    }

    public void setBackendCapabilities(Set<CapabilityFlags> capabilities) {
        Attribute attr = this.backendChannel.attr(CAPABILITIES_ATTR);
        attr.set(EnumSet.copyOf(capabilities));
    }

    public void setFrontendCapabilities(Set<CapabilityFlags> capabilities) {
        Attribute attr = this.frontendChannel.attr(CAPABILITIES_ATTR);
        attr.set(EnumSet.copyOf(capabilities));
    }

    public void setClientCharsetAttr(MysqlCharacterSet characterSet) {
        this.clientCharacterSet = characterSet;
        this.frontendChannel.attr(CLIENT_CHARSET_KEY).set((Object)characterSet);
        this.backendChannel.attr(CLIENT_CHARSET_KEY).set((Object)characterSet);
    }

    public void setServerCharsetAttr(MysqlCharacterSet characterSet) {
        this.serverCharacterSet = characterSet;
        this.frontendChannel.attr(SERVER_CHARSET_KEY).set((Object)characterSet);
        this.backendChannel.attr(SERVER_CHARSET_KEY).set((Object)characterSet);
    }

    public MysqlCharacterSet getServerCharset() {
        if (this.serverCharacterSet != null) {
            return this.serverCharacterSet;
        }
        return MysqlCharacterSet.DEFAULT;
    }

    public MysqlCharacterSet getClientCharset() {
        if (this.clientCharacterSet != null) {
            return this.clientCharacterSet;
        }
        return MysqlCharacterSet.DEFAULT;
    }

    public Integer getConnectionId() {
        return this.connectionId;
    }

    public static Session getSession(Channel channel) {
        return (Session)channel.attr(SESSION_KEY).get();
    }

    public void setConnectionId(int connectionId) {
        this.connectionId = connectionId;
        this.frontendChannel.attr(CONNECTION_ID_KEY).set((Object)connectionId);
        this.backendChannel.attr(CONNECTION_ID_KEY).set((Object)connectionId);
    }

    public void setFrontendChannel(Channel frontendChannel) {
        this.frontendChannel = frontendChannel;
        frontendChannel.attr(SESSION_KEY).set((Object)this);
        frontendChannel.closeFuture().addListener((GenericFutureListener)new ConnectionCloseFutureListener(this));
    }

    public void setBackendChannel(Channel backendChannel) {
        this.backendChannel = backendChannel;
        backendChannel.attr(SESSION_KEY).set((Object)this);
        backendChannel.closeFuture().addListener((GenericFutureListener)new ConnectionCloseFutureListener(this));
    }

    public Channel getBackendChannel() {
        return this.backendChannel;
    }

    public Channel getFrontendChannel() {
        return this.frontendChannel;
    }

    public String toString() {
        return "Session[" + this.id + "]";
    }

    private static class ConnectionCloseFutureListener
    implements GenericFutureListener<ChannelFuture> {
        private final Session session;

        ConnectionCloseFutureListener(Session session) {
            this.session = session;
        }

        public void operationComplete(ChannelFuture future) throws Exception {
            Channel ch = future.channel();
            Channel backendChannel = this.session.backendChannel;
            Channel frontendChannel = this.session.frontendChannel;
            if (ch == frontendChannel) {
                logger.info("client channel closed ! [{}]", (Object)frontendChannel);
                if (backendChannel != null && (backendChannel.isActive() || backendChannel.isOpen())) {
                    backendChannel.close();
                }
            } else {
                logger.info("server channel closed ! [{}] ", (Object)backendChannel);
                if (frontendChannel != null && (frontendChannel.isActive() || frontendChannel.isOpen())) {
                    frontendChannel.close();
                }
            }
        }
    }
}

