/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mysql.server;

import com.github.netty.core.AbstractChannelHandler;
import com.github.netty.protocol.mysql.EventHandshakeSuccessful;
import com.github.netty.protocol.mysql.MysqlPacket;
import com.github.netty.protocol.mysql.Session;
import com.github.netty.protocol.mysql.listener.MysqlPacketListener;
import com.github.netty.protocol.mysql.server.ServerConnectionDecoder;
import com.github.netty.protocol.mysql.server.ServerHandshakePacket;
import com.github.netty.protocol.mysql.server.ServerOkPacket;
import com.github.netty.protocol.mysql.server.ServerPacket;
import com.github.netty.protocol.mysql.server.ServerResultsetDecoder;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import java.util.Collection;

public class MysqlBackendBusinessHandler
extends AbstractChannelHandler<ServerPacket, MysqlPacket> {
    private int maxPacketSize;
    private Session session;
    private ServerHandshakePacket lastHandshakePacket;
    private Collection<MysqlPacketListener> mysqlPacketListeners;

    public MysqlBackendBusinessHandler() {
        super(false);
    }

    @Override
    protected void onMessageReceived(ChannelHandlerContext ctx, ServerPacket msg) throws Exception {
        if (msg instanceof ServerHandshakePacket) {
            this.lastHandshakePacket = (ServerHandshakePacket)msg;
            this.onHandshake(ctx, (ServerHandshakePacket)msg);
        } else if (this.lastHandshakePacket != null && msg instanceof ServerOkPacket) {
            EventHandshakeSuccessful eventHandshakeSuccessful = new EventHandshakeSuccessful(this.lastHandshakePacket, (ServerOkPacket)msg);
            this.session.getBackendChannel().pipeline().fireUserEventTriggered((Object)eventHandshakeSuccessful);
            this.session.getFrontendChannel().pipeline().fireUserEventTriggered((Object)eventHandshakeSuccessful);
            this.lastHandshakePacket = null;
        }
        if (this.mysqlPacketListeners != null && !this.mysqlPacketListeners.isEmpty()) {
            for (MysqlPacketListener mysqlPacketListener : this.mysqlPacketListeners) {
                try {
                    mysqlPacketListener.onMysqlPacket(msg, ctx, this.session, "backend");
                }
                catch (Exception e) {
                    this.logger.warn("{} exception = {} ", mysqlPacketListener.toString(), e.toString(), e);
                }
            }
        }
        this.onMysqlPacket(ctx, msg);
    }

    @Override
    protected void onUserEventTriggered(ChannelHandlerContext ctx, Object evt) {
        super.onUserEventTriggered(ctx, evt);
        if (evt instanceof EventHandshakeSuccessful) {
            this.onHandshakeSuccessful(ctx, (EventHandshakeSuccessful)evt);
        }
    }

    protected void onHandshake(ChannelHandlerContext ctx, ServerHandshakePacket packet) {
        this.session.setBackendCapabilities(packet.getCapabilities());
        this.session.setServerCharsetAttr(packet.getCharacterSet());
        this.session.setConnectionId(packet.getConnectionId());
    }

    protected void onHandshakeSuccessful(ChannelHandlerContext ctx, EventHandshakeSuccessful event) {
        if (ctx.pipeline().context(ServerConnectionDecoder.class) != null) {
            ctx.pipeline().replace(ServerConnectionDecoder.class, "ServerResultsetDecoder", (ChannelHandler)new ServerResultsetDecoder(this.session, this.getMaxPacketSize()));
        }
    }

    protected void onMysqlPacket(ChannelHandlerContext ctx, ServerPacket packet) {
    }

    public void setMaxPacketSize(int maxPacketSize) {
        this.maxPacketSize = maxPacketSize;
    }

    public int getMaxPacketSize() {
        return this.maxPacketSize;
    }

    public Session getSession() {
        return this.session;
    }

    public void setSession(Session session) {
        this.session = session;
    }

    public Collection<MysqlPacketListener> getMysqlPacketListeners() {
        return this.mysqlPacketListeners;
    }

    public void setMysqlPacketListeners(Collection<MysqlPacketListener> mysqlPacketListeners) {
        this.mysqlPacketListeners = mysqlPacketListeners;
    }
}

