/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mysql.server;

import com.github.netty.protocol.mysql.AbstractPacketDecoder;
import com.github.netty.protocol.mysql.CapabilityFlags;
import com.github.netty.protocol.mysql.CodecUtils;
import com.github.netty.protocol.mysql.MysqlCharacterSet;
import com.github.netty.protocol.mysql.ServerStatusFlag;
import com.github.netty.protocol.mysql.Session;
import com.github.netty.protocol.mysql.server.ServerDecoder;
import com.github.netty.protocol.mysql.server.ServerHandshakePacket;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.CodecException;
import io.netty.util.CharsetUtil;
import java.util.EnumSet;
import java.util.List;

public class ServerConnectionDecoder
extends AbstractPacketDecoder
implements ServerDecoder {
    private Session session;

    public ServerConnectionDecoder(Session session, int maxPacketSize) {
        super(maxPacketSize);
        this.session = session;
    }

    @Override
    protected void decodePacket(ChannelHandlerContext ctx, int sequenceId, ByteBuf packet, List<Object> out) {
        EnumSet<CapabilityFlags> capabilities = this.session.getFrontendCapabilities();
        MysqlCharacterSet serverCharset = this.session.getServerCharset();
        short header = packet.readUnsignedByte();
        switch (header) {
            case 0: {
                out.add(this.decodeOkResponse(sequenceId, packet, capabilities, serverCharset));
                break;
            }
            case 254: {
                if (capabilities.contains((Object)CapabilityFlags.CLIENT_PLUGIN_AUTH)) {
                    this.decodeAuthSwitchRequest(sequenceId, packet, out);
                    break;
                }
                out.add(this.decodeEofResponse(sequenceId, packet, capabilities));
                break;
            }
            case 255: {
                out.add(this.decodeErrorResponse(sequenceId, packet, serverCharset));
                break;
            }
            case 1: {
                throw new UnsupportedOperationException("Implement auth more data");
            }
            default: {
                this.decodeHandshake(ctx, packet, sequenceId, out, header);
            }
        }
    }

    private void decodeAuthSwitchRequest(int sequenceId, ByteBuf packet, List<Object> out) {
        throw new UnsupportedOperationException("Implement decodeAuthSwitchRequest decode.");
    }

    private void decodeHandshake(ChannelHandlerContext ctx, ByteBuf packet, int sequenceId, List<Object> out, int protocolVersion) {
        if (protocolVersion < 10) {
            throw new CodecException("Unsupported version of MySQL");
        }
        ServerHandshakePacket.Builder builder = ServerHandshakePacket.builder();
        builder.sequenceId(sequenceId).protocolVersion(protocolVersion).serverVersion((CharSequence)CodecUtils.readNullTerminatedString(packet)).connectionId(packet.readIntLE()).addAuthData(packet, 8);
        packet.skipBytes(1);
        builder.addCapabilities(CodecUtils.toEnumSet(CapabilityFlags.class, packet.readUnsignedShortLE()));
        if (packet.isReadable()) {
            MysqlCharacterSet characterSet = MysqlCharacterSet.findById(packet.readByte());
            builder.characterSet(characterSet).addServerStatus(CodecUtils.readShortEnumSet(packet, ServerStatusFlag.class)).addCapabilities(CodecUtils.toEnumSet(CapabilityFlags.class, packet.readUnsignedShortLE() << 16));
            if (builder.hasCapability(CapabilityFlags.CLIENT_SECURE_CONNECTION)) {
                byte authDataLen = packet.readByte();
                packet.skipBytes(10);
                int readableBytes = Math.max(13, authDataLen - 8);
                builder.addAuthData(packet, readableBytes);
                if (builder.hasCapability(CapabilityFlags.CLIENT_PLUGIN_AUTH) && packet.isReadable()) {
                    int len = packet.readableBytes();
                    if (packet.getByte(packet.readerIndex() + len - 1) == 0) {
                        --len;
                    }
                    builder.authPluginName(CodecUtils.readFixedLengthString(packet, len, CharsetUtil.UTF_8));
                    packet.skipBytes(1);
                }
            }
        }
        ServerHandshakePacket handshake = builder.build();
        out.add(handshake);
    }
}

