/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mysql.server;

import com.github.netty.protocol.mysql.AbstractMySqlPacket;
import com.github.netty.protocol.mysql.ServerStatusFlag;
import com.github.netty.protocol.mysql.server.ServerPacket;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Set;

public class ServerEofPacket
extends AbstractMySqlPacket
implements ServerPacket {
    private final int warnings;
    private final Set<ServerStatusFlag> statusFlags = EnumSet.noneOf(ServerStatusFlag.class);

    public ServerEofPacket(int sequenceId, int warnings, ServerStatusFlag ... flags) {
        super(sequenceId);
        this.warnings = warnings;
        Collections.addAll(this.statusFlags, flags);
    }

    public ServerEofPacket(int sequenceId, int warnings, Collection<ServerStatusFlag> flags) {
        super(sequenceId);
        this.warnings = warnings;
        this.statusFlags.addAll(flags);
    }

    public int getWarnings() {
        return this.warnings;
    }

    public Set<ServerStatusFlag> getStatusFlags() {
        return this.statusFlags;
    }

    @Override
    public String toString() {
        return super.toString() + "," + this.statusFlags;
    }
}

