/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.mysql.server;

import com.github.netty.protocol.mysql.AbstractPacketEncoder;
import com.github.netty.protocol.mysql.CapabilityFlags;
import com.github.netty.protocol.mysql.CodecUtils;
import com.github.netty.protocol.mysql.ServerStatusFlag;
import com.github.netty.protocol.mysql.Session;
import com.github.netty.protocol.mysql.server.ServerColumnCountPacket;
import com.github.netty.protocol.mysql.server.ServerColumnDefinitionPacket;
import com.github.netty.protocol.mysql.server.ServerEofPacket;
import com.github.netty.protocol.mysql.server.ServerErrorPacket;
import com.github.netty.protocol.mysql.server.ServerHandshakePacket;
import com.github.netty.protocol.mysql.server.ServerOkPacket;
import com.github.netty.protocol.mysql.server.ServerPacket;
import com.github.netty.protocol.mysql.server.ServerResultsetRowPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.channel.ChannelHandlerContext;
import java.nio.charset.Charset;
import java.util.EnumSet;

public class ServerPacketEncoder
extends AbstractPacketEncoder<ServerPacket> {
    private Session session;

    public ServerPacketEncoder(Session session) {
        this.session = session;
    }

    @Override
    protected void encodePacket(ChannelHandlerContext ctx, ServerPacket packet, ByteBuf buf) {
        EnumSet<CapabilityFlags> capabilities = this.session.getFrontendCapabilities();
        Charset serverCharset = this.session.getServerCharset().getCharset();
        if (packet instanceof ServerColumnCountPacket) {
            this.encodeColumnCount((ServerColumnCountPacket)packet, buf);
        } else if (packet instanceof ServerColumnDefinitionPacket) {
            this.encodeColumnDefinition(serverCharset, (ServerColumnDefinitionPacket)packet, buf);
        } else if (packet instanceof ServerEofPacket) {
            this.encodeEofResponse(capabilities, (ServerEofPacket)packet, buf);
        } else if (packet instanceof ServerHandshakePacket) {
            this.encodeHandshake((ServerHandshakePacket)packet, buf);
        } else if (packet instanceof ServerOkPacket) {
            this.encodeOkResponse(capabilities, serverCharset, (ServerOkPacket)packet, buf);
        } else if (packet instanceof ServerResultsetRowPacket) {
            this.encodeResultsetRow(serverCharset, (ServerResultsetRowPacket)packet, buf);
        } else if (packet instanceof ServerErrorPacket) {
            this.encodeError(serverCharset, (ServerErrorPacket)packet, buf);
        } else {
            throw new IllegalStateException("Unknown packet type: " + packet.getClass());
        }
    }

    protected void encodeColumnCount(ServerColumnCountPacket columnCount, ByteBuf buf) {
        CodecUtils.writeLengthEncodedInt(buf, Long.valueOf(columnCount.getFieldCount()));
    }

    protected void encodeColumnDefinition(Charset serverCharset, ServerColumnDefinitionPacket packet, ByteBuf buf) {
        CodecUtils.writeLengthEncodedString(buf, packet.getCatalog(), serverCharset);
        CodecUtils.writeLengthEncodedString(buf, packet.getSchema(), serverCharset);
        CodecUtils.writeLengthEncodedString(buf, packet.getTable(), serverCharset);
        CodecUtils.writeLengthEncodedString(buf, packet.getOrgTable(), serverCharset);
        CodecUtils.writeLengthEncodedString(buf, packet.getName(), serverCharset);
        CodecUtils.writeLengthEncodedString(buf, packet.getOrgName(), serverCharset);
        buf.writeByte(12);
        buf.writeShortLE(packet.getCharacterSet().getId()).writeIntLE((int)packet.getColumnLength()).writeByte(packet.getType().getValue()).writeShortLE((int)CodecUtils.toLong(packet.getFlags())).writeByte(packet.getDecimals()).writeShort(0);
    }

    protected void encodeEofResponse(EnumSet<CapabilityFlags> capabilities, ServerEofPacket eof, ByteBuf buf) {
        buf.writeByte(254);
        if (capabilities.contains((Object)CapabilityFlags.CLIENT_PROTOCOL_41)) {
            buf.writeShortLE(eof.getWarnings()).writeShortLE((int)CodecUtils.toLong(eof.getStatusFlags()));
        }
    }

    protected void encodeHandshake(ServerHandshakePacket handshake, ByteBuf buf) {
        buf.writeByte(handshake.getProtocolVersion()).writeBytes(handshake.getServerVersion().array()).writeByte(0).writeIntLE(handshake.getConnectionId()).writeBytes(handshake.getAuthPluginData(), 8).writeByte(0).writeShortLE((int)CodecUtils.toLong(handshake.getCapabilities())).writeByte(handshake.getCharacterSet().getId()).writeShortLE((int)CodecUtils.toLong(handshake.getServerStatus())).writeShortLE((int)(CodecUtils.toLong(handshake.getCapabilities()) >> 16));
        if (handshake.getCapabilities().contains((Object)CapabilityFlags.CLIENT_PLUGIN_AUTH)) {
            buf.writeByte(handshake.getAuthPluginData().readableBytes() + 8);
        } else {
            buf.writeByte(0);
        }
        buf.writeZero(10);
        if (handshake.getCapabilities().contains((Object)CapabilityFlags.CLIENT_SECURE_CONNECTION)) {
            int padding = 13 - handshake.getAuthPluginData().readableBytes();
            buf.writeBytes(handshake.getAuthPluginData());
            if (padding > 0) {
                buf.writeZero(padding);
            }
        }
        if (handshake.getCapabilities().contains((Object)CapabilityFlags.CLIENT_PLUGIN_AUTH)) {
            ByteBufUtil.writeUtf8((ByteBuf)buf, (CharSequence)handshake.getAuthPluginName());
            buf.writeByte(0);
        }
    }

    protected void encodeOkResponse(EnumSet<CapabilityFlags> capabilities, Charset serverCharset, ServerOkPacket response, ByteBuf buf) {
        buf.writeByte(0);
        CodecUtils.writeLengthEncodedInt(buf, response.getAffectedRows());
        CodecUtils.writeLengthEncodedInt(buf, response.getLastInsertId());
        if (capabilities.contains((Object)CapabilityFlags.CLIENT_PROTOCOL_41)) {
            buf.writeShortLE((int)CodecUtils.toLong(response.getStatusFlags())).writeShortLE(response.getWarnings());
        } else if (capabilities.contains((Object)CapabilityFlags.CLIENT_TRANSACTIONS)) {
            buf.writeShortLE((int)CodecUtils.toLong(response.getStatusFlags()));
        }
        if (capabilities.contains((Object)CapabilityFlags.CLIENT_SESSION_TRACK)) {
            CodecUtils.writeLengthEncodedString(buf, response.getInfo(), serverCharset);
            if (response.getStatusFlags().contains((Object)ServerStatusFlag.SESSION_STATE_CHANGED)) {
                CodecUtils.writeLengthEncodedString(buf, response.getSessionStateChanges(), serverCharset);
            }
        } else if (response.getInfo() != null) {
            buf.writeCharSequence((CharSequence)response.getInfo(), serverCharset);
        }
    }

    protected void encodeResultsetRow(Charset serverCharset, ServerResultsetRowPacket packet, ByteBuf buf) {
        for (String value : packet.getValues()) {
            CodecUtils.writeLengthEncodedString(buf, value, serverCharset);
        }
    }

    protected void encodeError(Charset serverCharset, ServerErrorPacket packet, ByteBuf buffer) {
        String message = packet.getMessage();
        if (message == null) {
            message = "";
        }
        byte[] messageBytes = message.getBytes(serverCharset);
        buffer.writeByte(-1);
        CodecUtils.writeUB2(buffer, packet.getErrorNumber());
        buffer.writeBytes(packet.getSqlState());
        buffer.writeBytes(messageBytes);
    }
}

