/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.nrpc;

import com.github.netty.protocol.nrpc.RpcClientReactivePublisher;
import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;

public class RpcClientCompletableFuture<COMPLETE_RESULT>
extends CompletableFuture<COMPLETE_RESULT> {
    private Subscription subscription;

    RpcClientCompletableFuture(RpcClientReactivePublisher source) {
        source.subscribe(new SubscriberAdapter(this));
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.subscription != null) {
            this.subscription.cancel();
        }
        return super.cancel(mayInterruptIfRunning);
    }

    public static class SubscriberAdapter<RESULT>
    implements Subscriber<RESULT> {
        private final RpcClientCompletableFuture<RESULT> completableFuture;
        private RESULT result;
        private Throwable throwable;

        private SubscriberAdapter(RpcClientCompletableFuture<RESULT> completableFuture) {
            this.completableFuture = completableFuture;
        }

        public void onSubscribe(Subscription s) {
            s.request(1L);
            ((RpcClientCompletableFuture)this.completableFuture).subscription = s;
        }

        public void onNext(RESULT o) {
            this.result = o;
        }

        public void onError(Throwable t) {
            this.throwable = t;
        }

        public void onComplete() {
            Throwable throwable = this.throwable;
            RESULT result = this.result;
            this.throwable = null;
            this.result = null;
            if (throwable != null) {
                this.completableFuture.completeExceptionally(throwable);
            } else {
                this.completableFuture.complete(result);
            }
        }
    }
}

