/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.nrpc.codec;

import com.github.netty.protocol.nrpc.RpcClient;
import com.github.netty.protocol.nrpc.RpcMethod;
import com.github.netty.protocol.nrpc.RpcServerInstance;
import com.github.netty.protocol.nrpc.codec.DataCodecUtil;
import java.lang.reflect.Type;
import java.nio.charset.Charset;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;

public interface DataCodec {
    public static final Charset CHARSET_UTF8 = Charset.forName("UTF-8");

    default public String buildThrowableRpcMessage(Throwable throwable) {
        return DataCodecUtil.buildThrowableRpcMessage(throwable);
    }

    public byte[] encodeRequestData(Object[] var1, RpcMethod<RpcClient> var2);

    public Object decodeResponseData(byte[] var1, RpcMethod<RpcClient> var2);

    default public Object decodeChunkResponseData(byte[] data, RpcMethod<RpcClient> rpcMethod) {
        return this.decodeChunkResponseData(data, rpcMethod.getChunkGenericReturnType());
    }

    public Object decodeChunkResponseData(byte[] var1, Type var2);

    public byte[] encodeChunkResponseData(Object var1);

    public byte[] encodeResponseData(Object var1, RpcMethod<RpcServerInstance> var2);

    public Object[] decodeRequestData(byte[] var1, RpcMethod<RpcServerInstance> var2);

    public List<Consumer<Map<String, Object>>> getEncodeRequestConsumerList();

    public List<Consumer<Map<String, Object>>> getDecodeRequestConsumerList();

    public static enum Encode {
        BINARY(0),
        APP(1);

        private int code;

        private Encode(byte code) {
            this.code = code;
        }

        public static Encode indexOf(int code) {
            for (Encode encode : Encode.values()) {
                if (encode.code != code) continue;
                return encode;
            }
            throw new IllegalArgumentException("value=" + code);
        }

        public int getCode() {
            return this.code;
        }
    }
}

