/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.nrpc.codec;

import com.github.netty.core.util.SystemPropertyUtil;
import com.github.netty.protocol.nrpc.codec.DataCodec;
import com.github.netty.protocol.nrpc.codec.FastJsonDataCodec;
import com.github.netty.protocol.nrpc.codec.JacksonDataCodec;
import com.github.netty.protocol.nrpc.codec.JdkDataCodec;

public class DataCodecUtil {
    public static final String SYSTEM_PROPERTY_CODEC_KEY = "netty-nrpc.codec";
    private static final boolean EXIST_FASTJSON;
    private static final boolean EXIST_JACKSON;

    public static String buildThrowableRpcMessage(Throwable throwable) {
        String message = DataCodecUtil.getMessage(throwable);
        Throwable cause = DataCodecUtil.getCause(throwable);
        if (cause != null && cause != throwable) {
            message = message + ". cause=" + DataCodecUtil.getMessage(cause);
        }
        return message;
    }

    private static Throwable getCause(Throwable throwable) {
        Throwable cause;
        if (throwable == null || throwable.getCause() == null) {
            return null;
        }
        do {
            cause = throwable;
        } while ((throwable = throwable.getCause()) != null);
        return cause;
    }

    private static String getMessage(Throwable t) {
        String message = t.getMessage();
        return message == null ? t.toString() : message;
    }

    public static String getDataCodec() {
        String codec = SystemPropertyUtil.get(SYSTEM_PROPERTY_CODEC_KEY);
        if (codec != null && codec.length() > 0) {
            return codec;
        }
        return "jdk";
    }

    public static void setDataCodec(String codec) {
        System.setProperty(SYSTEM_PROPERTY_CODEC_KEY, codec);
    }

    public static DataCodec newDataCodec() {
        DataCodec dataCodec;
        String codec = SystemPropertyUtil.get(SYSTEM_PROPERTY_CODEC_KEY);
        if (codec != null && codec.length() > 0) {
            switch (codec) {
                case "fastjson": {
                    dataCodec = new FastJsonDataCodec();
                    break;
                }
                case "jackson": {
                    dataCodec = new JacksonDataCodec();
                    break;
                }
                default: {
                    dataCodec = new JdkDataCodec();
                    break;
                }
                case "auto": {
                    if (EXIST_FASTJSON) {
                        dataCodec = new FastJsonDataCodec();
                        break;
                    }
                    if (EXIST_JACKSON) {
                        dataCodec = new JacksonDataCodec();
                        break;
                    }
                    dataCodec = new JdkDataCodec();
                    break;
                }
            }
        } else {
            dataCodec = new JdkDataCodec();
        }
        return dataCodec;
    }

    static {
        boolean existJackson;
        boolean existFastJson;
        try {
            Class.forName("com.alibaba.fastjson.JSON");
            existFastJson = true;
        }
        catch (Throwable e) {
            existFastJson = false;
        }
        try {
            Class.forName("com.fasterxml.jackson.databind.ObjectMapper");
            existJackson = true;
        }
        catch (Throwable e) {
            existJackson = false;
        }
        EXIST_FASTJSON = existFastJson;
        EXIST_JACKSON = existJackson;
    }
}

