/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.nrpc.codec;

import com.github.netty.protocol.nrpc.RpcPacket;
import com.github.netty.protocol.nrpc.codec.DataCodec;
import com.github.netty.protocol.nrpc.codec.RpcEncoder;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.LengthFieldBasedFrameDecoder;
import io.netty.util.ReferenceCountUtil;

public class RpcDecoder
extends LengthFieldBasedFrameDecoder {
    private static final byte[] EMPTY = new byte[0];
    private static final int LENGTH_FIELD_OFFSET = RpcEncoder.PROTOCOL_HEADER.length + 1 + 1;

    public RpcDecoder() {
        this(0xA00000);
    }

    public RpcDecoder(int maxLength) {
        super(maxLength, LENGTH_FIELD_OFFSET, 4, 0, 0, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object decode(ChannelHandlerContext ctx, ByteBuf buffer) throws Exception {
        ByteBuf msg = (ByteBuf)super.decode(ctx, buffer);
        if (msg == null) {
            return null;
        }
        try {
            Object object = this.decodeToPojo(msg);
            return object;
        }
        finally {
            if (msg.refCnt() > 0) {
                ReferenceCountUtil.safeRelease((Object)msg);
            }
        }
    }

    protected Object decodeToPojo(ByteBuf msg) {
        msg.skipBytes(RpcEncoder.PROTOCOL_HEADER.length);
        byte rpcType = msg.readByte();
        byte ack = msg.readByte();
        long totalLength = msg.readUnsignedInt();
        long totalPacketLength = totalLength + (long)LENGTH_FIELD_OFFSET;
        switch (rpcType) {
            case 1: {
                RpcPacket.RequestPacket packet = RpcPacket.RequestPacket.newInstance();
                packet.setPacketLength(totalPacketLength);
                packet.setAck(ack);
                packet.setRequestId(msg.readInt());
                packet.setTimeout(msg.readInt());
                packet.setRequestMappingName(msg.readCharSequence((int)msg.readUnsignedByte(), RpcEncoder.RPC_CHARSET).toString());
                packet.setVersion(msg.readCharSequence((int)msg.readUnsignedByte(), RpcEncoder.RPC_CHARSET).toString());
                packet.setMethodName(msg.readCharSequence((int)msg.readUnsignedByte(), RpcEncoder.RPC_CHARSET).toString());
                long dataLength = msg.readUnsignedInt();
                if (dataLength > 0L) {
                    packet.setData(new byte[(int)dataLength]);
                    msg.readBytes(packet.getData());
                } else {
                    packet.setData(EMPTY);
                }
                return packet;
            }
            case 2: 
            case 5: 
            case 6: {
                RpcPacket.ResponsePacket packet = RpcPacket.ResponsePacket.newInstance(rpcType);
                packet.setPacketLength(totalPacketLength);
                packet.setAck(ack);
                packet.setRequestId(msg.readInt());
                packet.setStatus(msg.readUnsignedShort());
                packet.setEncode(DataCodec.Encode.indexOf(msg.readUnsignedByte()));
                packet.setMessage(msg.readCharSequence((int)msg.readUnsignedByte(), RpcEncoder.RPC_CHARSET).toString());
                long dataLength = msg.readUnsignedInt();
                if (dataLength > 0L) {
                    packet.setData(new byte[(int)dataLength]);
                    msg.readBytes(packet.getData());
                } else {
                    packet.setData(null);
                }
                if (packet instanceof RpcPacket.ResponseChunkPacket) {
                    ((RpcPacket.ResponseChunkPacket)packet).setChunkId(msg.readUnsignedShort());
                } else if (packet instanceof RpcPacket.ResponseChunkAckPacket) {
                    ((RpcPacket.ResponseChunkAckPacket)packet).setAckChunkId(msg.readUnsignedShort());
                }
                return packet;
            }
        }
        RpcPacket packet = new RpcPacket(rpcType);
        packet.setPacketLength(totalPacketLength);
        packet.setAck(ack);
        if (totalLength > 0L) {
            packet.setData(new byte[(int)totalLength]);
            msg.readBytes(packet.getData());
        } else {
            packet.setData(null);
        }
        return packet;
    }
}

