/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet;

import com.github.netty.core.util.CaseInsensitiveKeyMap;
import com.github.netty.core.util.RecyclableUtil;
import com.github.netty.protocol.servlet.NettyOutputStream;
import com.github.netty.protocol.servlet.ServletContext;
import com.github.netty.protocol.servlet.util.HttpHeaderUtil;
import com.github.netty.protocol.servlet.util.MimeMappingsX;
import io.netty.buffer.ByteBuf;
import io.netty.handler.codec.DateFormatter;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class DefaultServlet
extends HttpServlet {
    private static final List<Range> FULL = Collections.unmodifiableList(new ArrayList());
    private static final Charset ISO_8859_1 = Charset.forName("ISO-8859-1");
    private static final String BOUNDARY = "CATALINA_MIME_BOUNDARY";
    private static final byte[] MIME_BOUNDARY_BEGIN = "\r\n--CATALINA_MIME_BOUNDARY".getBytes(ISO_8859_1);
    private static final byte[] MIME_BOUNDARY_END = "\r\n--CATALINA_MIME_BOUNDARY--".getBytes(ISO_8859_1);
    public static final Properties DEFAULT_MIME_TYPE_MAPPINGS = new Properties();
    private Set<String> homePages = new LinkedHashSet<String>(Arrays.asList("index.html", "index.htm", "index"));
    private String characterEncoding = "utf-8";
    private Map<String, String> mimeTypeMappings = new CaseInsensitiveKeyMap<String>();

    public DefaultServlet() {
        DEFAULT_MIME_TYPE_MAPPINGS.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> this.mimeTypeMappings.put(k.toString(), v.toString())));
    }

    public void init() {
        ServletContext servletContext = (ServletContext)this.getServletContext();
        for (MimeMappingsX.MappingX mapping : servletContext.getMimeMappings()) {
            this.mimeTypeMappings.put(mapping.getExtension(), mapping.getMimeType());
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String requestURI = request.getRequestURI();
        File resource = this.getFile(requestURI);
        if (resource == null) {
            this.sendNotFound(request, response);
        } else if (resource.isFile()) {
            this.sendFile(request, response, resource, null);
        } else {
            File homePage = this.getHomePage(request, requestURI);
            if (homePage != null) {
                this.sendFile(request, response, homePage, "text/html");
            } else {
                this.sendDir(request, response, resource, requestURI);
            }
        }
    }

    public Map<String, String> getMimeTypeMappings() {
        return this.mimeTypeMappings;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getContentType(File file) {
        String name = file.getName();
        int dotIndex = name.lastIndexOf(46);
        if (dotIndex == -1) {
            return null;
        }
        String ext = name.substring(dotIndex + 1);
        return this.getMimeTypeMappings().get(ext);
    }

    public Set<String> getHomePages() {
        return this.homePages;
    }

    protected void sendNotFound(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendError(404);
    }

    protected void sendDir(HttpServletRequest request, HttpServletResponse response, File dir, String requestDir) throws IOException {
        this.sendNotFound(request, response);
    }

    protected void sendFile(HttpServletRequest request, HttpServletResponse response, File file, String contentType) throws IOException {
        String characterEncoding = this.getCharacterEncoding();
        if (characterEncoding != null && characterEncoding.length() > 0) {
            response.setCharacterEncoding(characterEncoding);
        }
        if (contentType == null || contentType.isEmpty()) {
            contentType = this.getContentType(file);
        }
        if (contentType != null && contentType.length() > 0) {
            response.setContentType(contentType);
        }
        this.sendRange(request, response, file, contentType);
    }

    protected void sendRange(HttpServletRequest request, HttpServletResponse response, File file, String contentType) throws IOException {
        String lastModifiedHttp;
        WebResource resource = new WebResource(file);
        List<Range> ranges = DefaultServlet.parseRange(request, response, resource);
        if (ranges == null) {
            return;
        }
        response.setHeader("Accept-Ranges", "bytes");
        String eTag = resource.getETag();
        if (eTag != null) {
            response.setHeader("ETag", eTag);
        }
        if ((lastModifiedHttp = resource.getLastModifiedHttp()) != null) {
            response.setHeader("Last-Modified", lastModifiedHttp);
        }
        HttpServletResponse r = response;
        while (r instanceof ServletResponseWrapper) {
            r = ((ServletResponseWrapper)r).getResponse();
        }
        NettyOutputStream ostream = (NettyOutputStream)r.getOutputStream();
        if (ranges.isEmpty()) {
            ostream.write(file);
        } else {
            response.setStatus(206);
            if (ranges.size() == 1) {
                Range range = ranges.get(0);
                long contentLength = range.getContentLength();
                response.addHeader("Content-Range", range.getContentRangeValue());
                response.setContentLengthLong(contentLength);
                ostream.write(file, range.start, contentLength);
            } else {
                response.setContentType("multipart/byteranges; boundary=CATALINA_MIME_BOUNDARY");
                this.sendMultipartByteRanges(file, ostream, ranges, contentType);
            }
        }
    }

    protected void sendMultipartByteRanges(File file, NettyOutputStream ostream, List<Range> ranges, String contentType) throws IOException {
        ByteBuf contentTypeByteBuf = null;
        if (contentType != null && contentType.length() > 0) {
            contentTypeByteBuf = RecyclableUtil.newReadOnlyBuffer(("Content-Type: " + contentType).getBytes(ISO_8859_1));
            contentTypeByteBuf.release();
        }
        for (Range range : ranges) {
            ostream.write(RecyclableUtil.newReadOnlyBuffer(MIME_BOUNDARY_BEGIN));
            if (contentTypeByteBuf != null) {
                contentTypeByteBuf.retain();
                ostream.write(contentTypeByteBuf);
            }
            ostream.write(RecyclableUtil.newReadOnlyBuffer(range.getContentRange().getBytes(ISO_8859_1)));
            ostream.write(file, range.start, range.getContentLength());
        }
        ostream.write(RecyclableUtil.newReadOnlyBuffer(MIME_BOUNDARY_END));
    }

    protected File getHomePage(HttpServletRequest request, String dir) throws MalformedURLException {
        String dirPath = "/".equals(dir) ? "" : dir;
        for (String homePage : this.getHomePages()) {
            File file = this.getFile(dirPath + "/" + homePage);
            if (file == null || !file.isFile()) continue;
            return file;
        }
        return null;
    }

    protected File getFile(String path) throws MalformedURLException {
        URL resource = this.getServletContext().getResource(path);
        if (resource == null) {
            return null;
        }
        return new File(resource.getFile());
    }

    protected static List<Range> parseRange(HttpServletRequest request, HttpServletResponse response, WebResource resource) throws IOException {
        long fileLength;
        String ifRangeStr = request.getHeader("If-Range");
        if (ifRangeStr != null && ifRangeStr.length() > 0) {
            long lastModified;
            String eTag;
            long headerValueTime = -1L;
            try {
                Date ifRangeDate = DateFormatter.parseHttpDate((CharSequence)ifRangeStr);
                if (ifRangeDate != null) {
                    headerValueTime = ifRangeDate.getTime();
                }
            }
            catch (IllegalArgumentException ifRangeDate) {
                // empty catch block
            }
            if (headerValueTime == -1L ? !(eTag = resource.getETag()).equals(ifRangeStr.trim()) : Math.abs((lastModified = resource.getLastModified()) - headerValueTime) > 1000L) {
                return FULL;
            }
        }
        if ((fileLength = resource.getContentLength()) == 0L) {
            return FULL;
        }
        String rangeHeader = request.getHeader("Range");
        if (rangeHeader == null) {
            return FULL;
        }
        HttpHeaderUtil.Ranges ranges = HttpHeaderUtil.Ranges.parse(new StringReader(rangeHeader));
        if (ranges == null) {
            response.addHeader("Content-Range", "bytes */" + fileLength);
            response.sendError(416);
            return null;
        }
        if (!ranges.units.equals("bytes")) {
            return FULL;
        }
        ArrayList<Range> result = new ArrayList<Range>(ranges.entries.size());
        for (HttpHeaderUtil.Entry entry : ranges.entries) {
            Range currentRange = new Range();
            if (entry.start == -1L) {
                currentRange.start = fileLength - entry.end;
                if (currentRange.start < 0L) {
                    currentRange.start = 0L;
                }
                currentRange.end = fileLength - 1L;
            } else if (entry.end == -1L) {
                currentRange.start = entry.start;
                currentRange.end = fileLength - 1L;
            } else {
                currentRange.start = entry.start;
                currentRange.end = entry.end;
            }
            currentRange.length = fileLength;
            if (!currentRange.validate()) {
                response.addHeader("Content-Range", "bytes */" + fileLength);
                response.sendError(416);
                return null;
            }
            result.add(currentRange);
        }
        return result;
    }

    static {
        try (InputStream is = DefaultServlet.class.getResourceAsStream("/MimeTypeMappings.properties");){
            DEFAULT_MIME_TYPE_MAPPINGS.load(is);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static class WebResource {
        private String weakETag;
        private final long lastModified;
        private final long length;

        public WebResource(File file) {
            this.length = file.length();
            this.lastModified = file.lastModified();
        }

        public long getLastModified() {
            return this.lastModified;
        }

        public String getLastModifiedHttp() {
            if (this.lastModified <= 0L) {
                return null;
            }
            return DateFormatter.format((Date)new Date(this.lastModified));
        }

        public long getContentLength() {
            return this.length;
        }

        public String getETag() {
            if (this.weakETag == null) {
                long contentLength = this.getContentLength();
                long lastModified = this.getLastModified();
                if (contentLength >= 0L || lastModified >= 0L) {
                    this.weakETag = "W/\"" + contentLength + "-" + lastModified + "\"";
                }
            }
            return this.weakETag;
        }

        public String toString() {
            return this.getETag();
        }
    }

    protected static class Range {
        public long start;
        public long end;
        public long length;

        protected Range() {
        }

        public boolean validate() {
            if (this.end >= this.length) {
                this.end = this.length - 1L;
            }
            return this.start >= 0L && this.end >= 0L && this.start <= this.end && this.length > 0L;
        }

        public long getContentLength() {
            return this.end - this.start + 1L;
        }

        public String getContentRangeValue() {
            return "bytes " + this.start + "-" + this.end + "/" + this.length;
        }

        public String getContentRange() {
            return "Content-Range: " + this.getContentRangeValue() + "\r\n";
        }

        public String toString() {
            return this.getContentRange();
        }
    }
}

