/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet;

import com.github.netty.core.util.ExpiryLRUMap;
import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.core.util.Recyclable;
import com.github.netty.protocol.servlet.ServletContext;
import com.github.netty.protocol.servlet.ServletHttpExchange;
import com.github.netty.protocol.servlet.ServletRequestDispatcher;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.AsyncContext;
import javax.servlet.AsyncEvent;
import javax.servlet.AsyncListener;
import javax.servlet.DispatcherType;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletAsyncContext
implements AsyncContext,
Recyclable {
    private static final LoggerX logger = LoggerFactoryX.getLogger(ServletAsyncContext.class);
    private static final int STATUS_INIT = 0;
    private static final int STATUS_START = 1;
    private static final int STATUS_DISPATCH = 2;
    private static final int STATUS_COMPLETE = 3;
    private static final AtomicInteger TASK_ID_INCR = new AtomicInteger();
    private static final ExpiryLRUMap<Integer, ServletAsyncContext> TIMEOUT_TASK_MAP = new ExpiryLRUMap(256, Long.MAX_VALUE, Long.MAX_VALUE, null);
    private final Executor executor;
    private final AtomicBoolean timeoutFlag = new AtomicBoolean();
    private AtomicBoolean recycleFlag = new AtomicBoolean(false);
    private AtomicBoolean ioThreadExecuteOverFlag = new AtomicBoolean(false);
    private AtomicInteger status = new AtomicInteger(0);
    private long timeout;
    private List<ServletAsyncListenerWrapper> asyncListenerWrapperList;
    private final Runnable timeoutTask = () -> {
        if (this.timeoutFlag.compareAndSet(false, true)) {
            try {
                if (this.asyncListenerWrapperList != null) {
                    Throwable throwable = null;
                    boolean eventNotify = false;
                    for (ServletAsyncListenerWrapper listenerWrapper : new ArrayList<ServletAsyncListenerWrapper>(this.asyncListenerWrapperList)) {
                        eventNotify = throwable != null;
                        AsyncEvent event = new AsyncEvent((AsyncContext)this, listenerWrapper.servletRequest, listenerWrapper.servletResponse, throwable);
                        try {
                            listenerWrapper.asyncListener.onTimeout(event);
                        }
                        catch (Throwable e) {
                            if (throwable != null) {
                                e.addSuppressed(throwable);
                            }
                            throwable = e;
                        }
                    }
                    if (throwable != null && !eventNotify) {
                        logger.error("asyncContext notifyEvent.onTimeout() error={}", (Object)throwable.toString(), (Object)throwable);
                    }
                }
            }
            finally {
                this.recycle();
            }
        }
    };
    private ServletContext servletContext;
    private ServletHttpExchange servletHttpExchange;
    private ServletRequest servletRequest;
    private ServletResponse servletResponse;
    private volatile Integer timeoutTaskId;
    private volatile long startTimestamp;

    public ServletAsyncContext(ServletHttpExchange servletHttpExchange, ServletContext servletContext, Executor executor) {
        this.servletHttpExchange = Objects.requireNonNull(servletHttpExchange);
        this.servletContext = Objects.requireNonNull(servletContext);
        this.executor = Objects.requireNonNull(executor);
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public boolean isTimeout() {
        return this.timeoutFlag.get();
    }

    public ServletRequest getRequest() {
        return this.servletRequest;
    }

    public ServletResponse getResponse() {
        return this.servletResponse;
    }

    public boolean hasOriginalRequestAndResponse() {
        return this.servletHttpExchange.getRequest() == this.servletRequest && this.servletHttpExchange.getResponse() == this.servletResponse;
    }

    public void setServletResponse(ServletResponse servletResponse) {
        this.servletResponse = servletResponse;
    }

    public void setServletRequest(ServletRequest servletRequest) {
        this.servletRequest = servletRequest;
    }

    public void dispatch() {
        String contextPath;
        String path;
        ServletRequest servletRequest = this.servletRequest;
        if (servletRequest instanceof HttpServletRequest) {
            path = ((HttpServletRequest)servletRequest).getRequestURI();
            contextPath = ((HttpServletRequest)servletRequest).getContextPath();
        } else {
            path = this.servletHttpExchange.getRequest().getRequestURI();
            contextPath = this.servletHttpExchange.getRequest().getContextPath();
        }
        if (contextPath.length() > 1) {
            path = path.substring(contextPath.length());
        }
        this.dispatch(this.servletContext, path);
    }

    public void dispatch(String path) {
        this.dispatch(this.servletContext, path);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispatch(javax.servlet.ServletContext context, String path) {
        if (this.isComplete()) {
            return;
        }
        this.status.set(2);
        String contextPath = context.getContextPath();
        String dispatcherPath = contextPath == null || contextPath.isEmpty() ? path : contextPath + path;
        Object httpServletRequest = this.servletRequest instanceof HttpServletRequest ? (HttpServletRequest)this.servletRequest : this.servletHttpExchange.getRequest();
        Object httpServletResponse = this.servletResponse instanceof HttpServletResponse ? (HttpServletResponse)this.servletResponse : this.servletHttpExchange.getResponse();
        ServletRequestDispatcher dispatcher = this.servletContext.getRequestDispatcher(dispatcherPath, DispatcherType.ASYNC);
        try {
            if (dispatcher == null) {
                logger.warn("not found dispatcher. contextPath={}, path={}", (Object)context.getContextPath(), (Object)path);
                httpServletResponse.setStatus(404);
            } else {
                try {
                    dispatcher.dispatchAsync((HttpServletRequest)httpServletRequest, (HttpServletResponse)httpServletResponse, this);
                }
                catch (Throwable e) {
                    this.onError(e);
                }
            }
        }
        finally {
            this.complete();
        }
    }

    public void onError(Throwable throwable) {
        if (this.asyncListenerWrapperList != null) {
            boolean eventNotify = false;
            for (ServletAsyncListenerWrapper listenerWrapper : new ArrayList<ServletAsyncListenerWrapper>(this.asyncListenerWrapperList)) {
                eventNotify = throwable != null;
                AsyncEvent event = new AsyncEvent((AsyncContext)this, listenerWrapper.servletRequest, listenerWrapper.servletResponse, throwable);
                try {
                    listenerWrapper.asyncListener.onError(event);
                }
                catch (Throwable e) {
                    if (throwable != null) {
                        e.addSuppressed(throwable);
                    }
                    throwable = e;
                }
            }
            if (throwable != null && !eventNotify) {
                logger.error("asyncContext notifyEvent.onError() error={}", (Object)throwable.toString(), (Object)throwable);
            }
        }
    }

    public void complete() {
        this.complete(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(Throwable rootThrowable) {
        if (this.isComplete()) {
            return;
        }
        Integer timeoutTaskId = this.timeoutTaskId;
        if (timeoutTaskId != null) {
            TIMEOUT_TASK_MAP.remove(timeoutTaskId);
        }
        try {
            if (this.asyncListenerWrapperList != null) {
                Throwable throwable = rootThrowable;
                boolean eventNotify = false;
                for (ServletAsyncListenerWrapper listenerWrapper : new ArrayList<ServletAsyncListenerWrapper>(this.asyncListenerWrapperList)) {
                    eventNotify = throwable != null;
                    AsyncEvent event = new AsyncEvent((AsyncContext)this, listenerWrapper.servletRequest, listenerWrapper.servletResponse, throwable);
                    try {
                        listenerWrapper.asyncListener.onComplete(event);
                    }
                    catch (Throwable e) {
                        if (throwable != null) {
                            e.addSuppressed(throwable);
                        }
                        throwable = e;
                    }
                }
                if (throwable != null && !eventNotify) {
                    logger.error("asyncContext notifyEvent.onComplete() error={}", (Object)throwable.toString(), (Object)throwable);
                }
            }
            if (this.ioThreadExecuteOverFlag.get()) {
                this.recycle();
            }
        }
        finally {
            this.status.set(3);
        }
    }

    public void markIoThreadOverFlag() {
        this.ioThreadExecuteOverFlag.compareAndSet(false, true);
    }

    @Override
    public void recycle() {
        if (this.recycleFlag.compareAndSet(false, true)) {
            this.servletHttpExchange.recycle();
        }
    }

    public void start(Runnable runnable) {
        this.executor.execute(runnable);
    }

    public void setStart() {
        if (this.status.get() >= 2 || this.timeoutFlag.get()) {
            throw new IllegalStateException("The request associated with the AsyncContext has already completed processing.");
        }
        this.startTimestamp = System.currentTimeMillis();
        if (this.timeoutTaskId == null) {
            this.timeoutTaskId = TASK_ID_INCR.getAndIncrement();
        } else {
            TIMEOUT_TASK_MAP.remove(this.timeoutTaskId);
        }
        this.status.set(1);
        TIMEOUT_TASK_MAP.put(this.timeoutTaskId, this, this.timeout);
        if (this.asyncListenerWrapperList != null) {
            ArrayList<ServletAsyncListenerWrapper> list = new ArrayList<ServletAsyncListenerWrapper>(this.asyncListenerWrapperList);
            this.asyncListenerWrapperList.clear();
            Throwable throwable = null;
            boolean eventNotify = false;
            for (ServletAsyncListenerWrapper listenerWrapper : list) {
                eventNotify = throwable != null;
                AsyncEvent event = new AsyncEvent((AsyncContext)this, listenerWrapper.servletRequest, listenerWrapper.servletResponse, throwable);
                try {
                    listenerWrapper.asyncListener.onStartAsync(event);
                }
                catch (Throwable e) {
                    if (throwable != null) {
                        e.addSuppressed(throwable);
                    }
                    throwable = e;
                }
            }
            if (throwable != null && !eventNotify) {
                logger.error("asyncContext notifyEvent.onTimeout() error={}", (Object)throwable.toString(), (Object)throwable);
            }
        }
    }

    public void addListener(AsyncListener listener) {
        this.addListener(listener, this.servletRequest, this.servletResponse);
    }

    public void addListener(AsyncListener listener, ServletRequest servletRequest, ServletResponse servletResponse) {
        if (this.asyncListenerWrapperList == null) {
            this.asyncListenerWrapperList = new ArrayList<ServletAsyncListenerWrapper>(3);
        }
        this.asyncListenerWrapperList.add(new ServletAsyncListenerWrapper(listener, servletRequest, servletResponse));
    }

    public <T extends AsyncListener> T createListener(Class<T> clazz) throws ServletException {
        try {
            return (T)((AsyncListener)clazz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ServletException("asyncContext createListener error=" + e, (Throwable)e);
        }
    }

    public long getTimeout() {
        return this.timeout;
    }

    public void setTimeout(long timeout) {
        if (this.isComplete()) {
            return;
        }
        this.timeout = timeout;
        if (timeout <= 0L && this.timeoutTaskId != null) {
            TIMEOUT_TASK_MAP.remove(this.timeoutTaskId);
            return;
        }
        if (this.startTimestamp != 0L) {
            if (this.timeoutTaskId == null) {
                this.timeoutTaskId = TASK_ID_INCR.getAndIncrement();
            } else {
                TIMEOUT_TASK_MAP.remove(this.timeoutTaskId);
            }
            long startDiff = System.currentTimeMillis() - this.startTimestamp;
            long expiryTime = timeout - startDiff;
            if (expiryTime > 0L) {
                TIMEOUT_TASK_MAP.put(this.timeoutTaskId, this, expiryTime);
            } else {
                this.timeoutTask.run();
            }
        }
    }

    public boolean isStarted() {
        return this.status.get() >= 1;
    }

    public boolean isComplete() {
        return this.status.get() == 3;
    }

    public ServletHttpExchange getExchange() {
        return this.servletHttpExchange;
    }

    public boolean isChannelActive() {
        return this.servletHttpExchange != null && this.servletHttpExchange.isChannelActive();
    }

    static {
        TIMEOUT_TASK_MAP.setOnExpiryConsumer(e -> {
            ServletAsyncContext asyncContext = (ServletAsyncContext)e.getData();
            if (asyncContext.status.get() >= 2) {
                return;
            }
            asyncContext.executor.execute(asyncContext.timeoutTask);
        });
    }

    private static class ServletAsyncListenerWrapper {
        AsyncListener asyncListener;
        ServletRequest servletRequest;
        ServletResponse servletResponse;

        ServletAsyncListenerWrapper(AsyncListener asyncListener, ServletRequest servletRequest, ServletResponse servletResponse) {
            this.asyncListener = asyncListener;
            this.servletRequest = servletRequest;
            this.servletResponse = servletResponse;
        }
    }
}

