/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet;

import com.github.netty.Version;
import com.github.netty.core.util.HostUtil;
import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.core.util.ResourceManager;
import com.github.netty.core.util.SystemPropertyUtil;
import com.github.netty.protocol.servlet.DefaultServlet;
import com.github.netty.protocol.servlet.ServletErrorPageManager;
import com.github.netty.protocol.servlet.ServletEventListenerManager;
import com.github.netty.protocol.servlet.ServletFilterChain;
import com.github.netty.protocol.servlet.ServletFilterRegistration;
import com.github.netty.protocol.servlet.ServletRegistration;
import com.github.netty.protocol.servlet.ServletRequestDispatcher;
import com.github.netty.protocol.servlet.ServletSessionCookieConfig;
import com.github.netty.protocol.servlet.SessionLocalMemoryServiceImpl;
import com.github.netty.protocol.servlet.SessionService;
import com.github.netty.protocol.servlet.util.FilterMapper;
import com.github.netty.protocol.servlet.util.HttpConstants;
import com.github.netty.protocol.servlet.util.MimeMappingsX;
import com.github.netty.protocol.servlet.util.UrlMapper;
import com.github.netty.protocol.servlet.websocket.WebSocketServerContainer;
import io.netty.handler.codec.http.multipart.DefaultHttpDataFactory;
import io.netty.handler.codec.http.multipart.DiskAttribute;
import io.netty.handler.codec.http.multipart.DiskFileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.util.concurrent.FastThreadLocal;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterRegistration;
import javax.servlet.Servlet;
import javax.servlet.ServletContextAttributeEvent;
import javax.servlet.ServletContextAttributeListener;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import javax.servlet.ServletRegistration;
import javax.servlet.ServletRequestAttributeListener;
import javax.servlet.ServletRequestListener;
import javax.servlet.SessionTrackingMode;
import javax.servlet.descriptor.JspConfigDescriptor;
import javax.servlet.http.HttpSessionAttributeListener;
import javax.servlet.http.HttpSessionIdListener;
import javax.servlet.http.HttpSessionListener;

public class ServletContext
implements javax.servlet.ServletContext {
    private LoggerX logger = LoggerFactoryX.getLogger(this.getClass());
    public static final String SERVER_CONTAINER_SERVLET_CONTEXT_ATTRIBUTE = "javax.websocket.server.ServerContainer";
    private int sessionTimeout = 1200;
    private int responseWriterChunkMaxHeapByteLength = 0;
    private long uploadMinSize = 65536L;
    private long uploadFileTimeoutMs = -1L;
    private Map<String, Object> attributeMap = new LinkedHashMap<String, Object>(16);
    private Map<String, String> initParamMap = new LinkedHashMap<String, String>(16);
    private Map<String, ServletRegistration> servletRegistrationMap = new LinkedHashMap<String, ServletRegistration>(8);
    private Map<String, ServletFilterRegistration> filterRegistrationMap = new LinkedHashMap<String, ServletFilterRegistration>(8);
    private FastThreadLocal<Map<Charset, HttpDataFactory>> httpDataFactoryThreadLocal = new FastThreadLocal<Map<Charset, HttpDataFactory>>(){

        protected Map<Charset, HttpDataFactory> initialValue() throws Exception {
            return new LinkedHashMap<Charset, HttpDataFactory>(5);
        }
    };
    private Set<SessionTrackingMode> defaultSessionTrackingModeSet = new HashSet<SessionTrackingMode>(Arrays.asList(SessionTrackingMode.COOKIE, SessionTrackingMode.URL));
    private final ServletErrorPageManager servletErrorPageManager = new ServletErrorPageManager();
    private MimeMappingsX mimeMappings = new MimeMappingsX();
    private ServletEventListenerManager servletEventListenerManager = new ServletEventListenerManager();
    private ServletSessionCookieConfig sessionCookieConfig = new ServletSessionCookieConfig();
    private UrlMapper<ServletRegistration> servletUrlMapper = new UrlMapper(true);
    private FilterMapper<ServletFilterRegistration> filterUrlMapper = new FilterMapper();
    private ResourceManager resourceManager;
    private Supplier<Executor> asyncExecutorSupplier;
    private Supplier<Executor> defaultExecutorSupplier;
    private SessionService sessionService;
    private Set<SessionTrackingMode> sessionTrackingModeSet;
    private Servlet defaultServlet = new DefaultServlet();
    private boolean enableLookupFlag = false;
    private boolean autoFlush;
    private final Collection<String> notExistBodyParameters = new HashSet<String>();
    private String serverHeader;
    private String contextPath = "";
    private String requestCharacterEncoding;
    private String responseCharacterEncoding;
    private String servletContextName;
    private InetSocketAddress serverAddress;
    private ClassLoader classLoader;
    private int maxBufferBytes = 0x100000;

    public ServletContext() {
        this(null);
    }

    public ServletContext(ClassLoader classLoader) {
        this.classLoader = classLoader == null ? this.getClass().getClassLoader() : classLoader;
    }

    public void setDefaultServlet(Servlet defaultServlet) {
        this.defaultServlet = defaultServlet;
    }

    public Servlet getDefaultServlet() {
        return this.defaultServlet;
    }

    public void setMaxBufferBytes(int maxBufferBytes) {
        this.maxBufferBytes = maxBufferBytes;
    }

    public int getMaxBufferBytes() {
        return this.maxBufferBytes;
    }

    public boolean isAutoFlush() {
        return this.autoFlush;
    }

    public void setAutoFlush(boolean autoFlush) {
        this.autoFlush = autoFlush;
    }

    public long getUploadFileTimeoutMs() {
        return this.uploadFileTimeoutMs;
    }

    public void setUploadFileTimeoutMs(long uploadFileTimeoutMs) {
        this.uploadFileTimeoutMs = uploadFileTimeoutMs;
    }

    public boolean isEnableLookupFlag() {
        return this.enableLookupFlag;
    }

    public void setEnableLookupFlag(boolean enableLookupFlag) {
        this.enableLookupFlag = enableLookupFlag;
    }

    public void setServerAddress(InetSocketAddress serverAddress) {
        this.serverAddress = serverAddress;
    }

    public void setDocBase(String docBase) {
        String workspace = '/' + (this.serverAddress == null || HostUtil.isLocalhost(this.serverAddress.getHostName()) ? "localhost" : this.serverAddress.getHostName());
        this.setDocBase(docBase, workspace);
    }

    public void setDocBase(String docBase, String workspace) {
        ResourceManager old = this.resourceManager;
        this.resourceManager = new ResourceManager(docBase, workspace, this.classLoader);
        this.resourceManager.mkdirs("/");
        if (old != null) {
            this.logger.warn("ServletContext docBase override. old = {}, new = {}", (Object)old, (Object)this.resourceManager);
        }
        DiskFileUpload.deleteOnExitTemporaryFile = true;
        DiskAttribute.deleteOnExitTemporaryFile = true;
        DiskFileUpload.baseDirectory = this.resourceManager.getRealPath("/");
        DiskAttribute.baseDirectory = this.resourceManager.getRealPath("/");
    }

    public Executor getAsyncExecutor() {
        Executor executor = this.asyncExecutorSupplier.get();
        if (executor == null) {
            executor = this.defaultExecutorSupplier.get();
        }
        if (executor == null) {
            throw new IllegalStateException("no found async Executor");
        }
        return executor;
    }

    public Collection<String> getNotExistBodyParameters() {
        return this.notExistBodyParameters;
    }

    public void setAsyncExecutorSupplier(Supplier<Executor> asyncExecutorSupplier) {
        this.asyncExecutorSupplier = asyncExecutorSupplier;
    }

    public void setDefaultExecutorSupplier(Supplier<Executor> defaultExecutorSupplier) {
        this.defaultExecutorSupplier = defaultExecutorSupplier;
    }

    public Supplier<Executor> getDefaultExecutorSupplier() {
        return this.defaultExecutorSupplier;
    }

    public HttpDataFactory getHttpDataFactory(Charset charset) {
        Map httpDataFactoryMap = (Map)this.httpDataFactoryThreadLocal.get();
        HttpDataFactory factory = (HttpDataFactory)httpDataFactoryMap.get(charset);
        if (factory == null) {
            factory = new DefaultHttpDataFactory(this.uploadMinSize, charset);
            httpDataFactoryMap.put(charset, factory);
        }
        return factory;
    }

    public String getServletPath(String absoluteUri) {
        return this.servletUrlMapper.getServletPath(absoluteUri);
    }

    public long getUploadMinSize() {
        return this.uploadMinSize;
    }

    public void setUploadMinSize(long uploadMinSize) {
        this.uploadMinSize = uploadMinSize;
    }

    public MimeMappingsX getMimeMappings() {
        return this.mimeMappings;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public ServletErrorPageManager getErrorPageManager() {
        return this.servletErrorPageManager;
    }

    public void setServletContextName(String servletContextName) {
        this.servletContextName = servletContextName;
    }

    public void setServerHeader(String serverHeader) {
        this.serverHeader = serverHeader;
    }

    public String getServerHeader() {
        return this.serverHeader;
    }

    public void setContextPath(String contextPath) {
        this.contextPath = ServletContext.normPath(contextPath);
        this.filterUrlMapper.setRootPath(contextPath);
        this.servletUrlMapper.setRootPath(contextPath);
    }

    public ServletEventListenerManager getServletEventListenerManager() {
        return this.servletEventListenerManager;
    }

    public long getAsyncTimeout() {
        String value = this.getInitParameter("asyncTimeout");
        if (value == null || value.isEmpty()) {
            return 30000L;
        }
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return 30000L;
        }
    }

    public int getResponseWriterChunkMaxHeapByteLength() {
        return this.responseWriterChunkMaxHeapByteLength;
    }

    public void setResponseWriterChunkMaxHeapByteLength(int responseWriterChunkMaxHeapByteLength) {
        this.responseWriterChunkMaxHeapByteLength = responseWriterChunkMaxHeapByteLength;
    }

    public InetSocketAddress getServerAddress() {
        return this.serverAddress;
    }

    public void setSessionService(SessionService sessionService) {
        this.sessionService = sessionService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionService getSessionService() {
        if (this.sessionService == null) {
            ServletContext servletContext = this;
            synchronized (servletContext) {
                if (this.sessionService == null) {
                    this.sessionService = new SessionLocalMemoryServiceImpl();
                }
            }
        }
        return this.sessionService;
    }

    public int getSessionTimeout() {
        return this.sessionTimeout;
    }

    public void setSessionTimeout(int sessionTimeout) {
        if (sessionTimeout <= 0) {
            return;
        }
        this.sessionTimeout = sessionTimeout;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public ServletContext getContext(String uripath) {
        return this;
    }

    public int getMajorVersion() {
        return 4;
    }

    public int getMinorVersion() {
        return 0;
    }

    public int getEffectiveMajorVersion() {
        return 3;
    }

    public int getEffectiveMinorVersion() {
        return 0;
    }

    public String getMimeType(String file) {
        if (file == null) {
            return null;
        }
        int period = file.lastIndexOf(46);
        if (period < 0) {
            return null;
        }
        String extension = file.substring(period + 1);
        if (extension.length() < 1) {
            return null;
        }
        return this.mimeMappings.get(extension);
    }

    public Set<String> getResourcePaths(String path) {
        return this.resourceManager.getResourcePaths(path);
    }

    public URL getResource(String path) throws MalformedURLException {
        return this.resourceManager.getResource(path);
    }

    public InputStream getResourceAsStream(String path) {
        return this.resourceManager.getResourceAsStream(path);
    }

    public String getRealPath(String path) {
        return this.resourceManager.getRealPath(path);
    }

    public ServletRequestDispatcher getRequestDispatcher(String path) {
        return this.getRequestDispatcher(path, DispatcherType.REQUEST);
    }

    public ServletRequestDispatcher getRequestDispatcher(String path, DispatcherType dispatcherType) {
        UrlMapper.Element<ServletRegistration> element = this.servletUrlMapper.getMappingObjectByUri(path);
        if (element == null) {
            return null;
        }
        ServletRegistration servletRegistration = element.getObject();
        if (servletRegistration == null) {
            return null;
        }
        ServletFilterChain filterChain = ServletFilterChain.newInstance(this, servletRegistration);
        this.filterUrlMapper.addMappingObjectsByUri(path, dispatcherType, filterChain.getFilterRegistrationList());
        ServletRequestDispatcher dispatcher = ServletRequestDispatcher.newInstance(filterChain);
        dispatcher.setMapperElement(element);
        dispatcher.setPath(path);
        return dispatcher;
    }

    public ServletRequestDispatcher getNamedDispatcher(String name) {
        ServletRegistration servletRegistration;
        ServletRegistration servletRegistration2 = servletRegistration = null == name ? null : this.getServletRegistration(name);
        if (servletRegistration == null) {
            return null;
        }
        ServletFilterChain filterChain = ServletFilterChain.newInstance(this, servletRegistration);
        List<FilterMapper.Element<ServletFilterRegistration>> filterList = filterChain.getFilterRegistrationList();
        for (ServletFilterRegistration registration : this.filterRegistrationMap.values()) {
            for (String servletName : registration.getServletNameMappings()) {
                if (!servletName.equals(name)) continue;
                filterList.add(new FilterMapper.Element<ServletFilterRegistration>(name, registration));
            }
        }
        ServletRequestDispatcher dispatcher = ServletRequestDispatcher.newInstance(filterChain);
        dispatcher.setName(name);
        return dispatcher;
    }

    public Servlet getServlet(String name) throws ServletException {
        ServletRegistration registration = this.servletRegistrationMap.get(name);
        if (registration == null) {
            return null;
        }
        return registration.getServlet();
    }

    public Enumeration<Servlet> getServlets() {
        ArrayList<Servlet> list = new ArrayList<Servlet>();
        for (ServletRegistration registration : this.servletRegistrationMap.values()) {
            list.add(registration.getServlet());
        }
        return Collections.enumeration(list);
    }

    public Enumeration<String> getServletNames() {
        ArrayList<String> list = new ArrayList<String>();
        for (ServletRegistration registration : this.servletRegistrationMap.values()) {
            list.add(registration.getName());
        }
        return Collections.enumeration(list);
    }

    public void log(String msg) {
        this.logger.debug(msg);
    }

    public void log(Exception exception, String msg) {
        this.logger.debug(msg, exception);
    }

    public void log(String message, Throwable throwable) {
        this.logger.debug(message, throwable);
    }

    public String getServerInfo() {
        return Version.getServerInfo().concat("(JDK ").concat(Version.getJvmVersion()).concat(";").concat(Version.getOsName()).concat(" ").concat(Version.getArch()).concat(")");
    }

    public String getInitParameter(String name) {
        return this.initParamMap.get(name);
    }

    public Enumeration<String> getInitParameterNames() {
        return Collections.enumeration(this.initParamMap.keySet());
    }

    public boolean setInitParameter(String name, String value) {
        return this.initParamMap.putIfAbsent(name, value) == null;
    }

    public Object getAttribute(String name) {
        if (SERVER_CONTAINER_SERVLET_CONTEXT_ATTRIBUTE.equals(name)) {
            try {
                this.attributeMap.put(name, new WebSocketServerContainer());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return this.attributeMap.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributeMap.keySet());
    }

    public void setAttribute(String name, Object object) {
        Objects.requireNonNull(name);
        if (object == null) {
            this.removeAttribute(name);
            return;
        }
        Object oldObject = this.attributeMap.put(name, object);
        ServletEventListenerManager listenerManager = this.getServletEventListenerManager();
        if (listenerManager.hasServletContextAttributeListener()) {
            listenerManager.onServletContextAttributeAdded(new ServletContextAttributeEvent((javax.servlet.ServletContext)this, name, object));
            if (oldObject != null) {
                listenerManager.onServletContextAttributeReplaced(new ServletContextAttributeEvent((javax.servlet.ServletContext)this, name, oldObject));
            }
        }
    }

    public void removeAttribute(String name) {
        Object oldObject = this.attributeMap.remove(name);
        ServletEventListenerManager listenerManager = this.getServletEventListenerManager();
        if (listenerManager.hasServletContextAttributeListener()) {
            listenerManager.onServletContextAttributeRemoved(new ServletContextAttributeEvent((javax.servlet.ServletContext)this, name, oldObject));
        }
    }

    public String getServletContextName() {
        return this.servletContextName;
    }

    public ServletRegistration addServlet(String servletName, String className) {
        try {
            return this.addServlet(servletName, (Class)Class.forName(className).newInstance());
        }
        catch (ClassNotFoundException | IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("addServlet error =" + e + ",servletName=" + servletName, e);
        }
    }

    public ServletRegistration addServlet(String servletName, Servlet servlet) {
        Servlet newServlet = this.servletEventListenerManager.onServletAdded(servlet);
        ServletRegistration servletRegistration = newServlet == null ? new ServletRegistration(servletName, servlet, this, this.servletUrlMapper) : new ServletRegistration(servletName, newServlet, this, this.servletUrlMapper);
        this.servletRegistrationMap.put(servletName, servletRegistration);
        return servletRegistration;
    }

    public ServletRegistration addServlet(String servletName, Class<? extends Servlet> servletClass) {
        Servlet servlet = null;
        try {
            servlet = servletClass.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new IllegalStateException("createServlet error =" + e + ",servletName=" + servletName, e);
        }
        return this.addServlet(servletName, servlet);
    }

    public <T extends Servlet> T createServlet(Class<T> clazz) throws ServletException {
        try {
            return (T)((Servlet)clazz.getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new ServletException("createServlet error =" + e + ",clazz=" + clazz, (Throwable)e);
        }
    }

    public ServletRegistration getServletRegistration(String servletName) {
        return this.servletRegistrationMap.get(servletName);
    }

    public Map<String, ServletRegistration> getServletRegistrations() {
        return this.servletRegistrationMap;
    }

    public ServletFilterRegistration addFilter(String filterName, String className) {
        try {
            return this.addFilter(filterName, Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("addFilter error =" + e + ",filterName=" + filterName, e);
        }
    }

    public ServletFilterRegistration addFilter(String filterName, Filter filter) {
        ServletFilterRegistration registration = new ServletFilterRegistration(filterName, filter, this, this.filterUrlMapper);
        this.filterRegistrationMap.put(filterName, registration);
        return registration;
    }

    public ServletFilterRegistration addFilter(String filterName, Class<? extends Filter> filterClass) {
        try {
            return this.addFilter(filterName, filterClass.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("addFilter error =" + e, e);
        }
    }

    public <T extends Filter> T createFilter(Class<T> clazz) throws ServletException {
        try {
            return (T)((Filter)clazz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ServletException("createFilter error =" + e, (Throwable)e);
        }
    }

    public FilterRegistration getFilterRegistration(String filterName) {
        return this.filterRegistrationMap.get(filterName);
    }

    public Map<String, ServletFilterRegistration> getFilterRegistrations() {
        return this.filterRegistrationMap;
    }

    public ServletSessionCookieConfig getSessionCookieConfig() {
        return this.sessionCookieConfig;
    }

    public void setSessionTrackingModes(Set<SessionTrackingMode> sessionTrackingModes) {
        this.sessionTrackingModeSet = sessionTrackingModes;
    }

    public Set<SessionTrackingMode> getDefaultSessionTrackingModes() {
        return this.defaultSessionTrackingModeSet;
    }

    public Set<SessionTrackingMode> getEffectiveSessionTrackingModes() {
        if (this.sessionTrackingModeSet == null) {
            return this.getDefaultSessionTrackingModes();
        }
        return this.sessionTrackingModeSet;
    }

    public void addListener(String className) {
        try {
            this.addListener(Class.forName(className));
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("addListener error =" + e + ",className=" + className, e);
        }
    }

    public <T extends EventListener> void addListener(T listener) {
        Objects.requireNonNull(listener);
        boolean addFlag = false;
        ServletEventListenerManager listenerManager = this.getServletEventListenerManager();
        if (listener instanceof ServletContextAttributeListener) {
            listenerManager.addServletContextAttributeListener((ServletContextAttributeListener)listener);
            addFlag = true;
        }
        if (listener instanceof ServletRequestListener) {
            listenerManager.addServletRequestListener((ServletRequestListener)listener);
            addFlag = true;
        }
        if (listener instanceof ServletRequestAttributeListener) {
            listenerManager.addServletRequestAttributeListener((ServletRequestAttributeListener)listener);
            addFlag = true;
        }
        if (listener instanceof HttpSessionIdListener) {
            listenerManager.addHttpSessionIdListenerListener((HttpSessionIdListener)listener);
            addFlag = true;
        }
        if (listener instanceof HttpSessionAttributeListener) {
            listenerManager.addHttpSessionAttributeListener((HttpSessionAttributeListener)listener);
            addFlag = true;
        }
        if (listener instanceof HttpSessionListener) {
            listenerManager.addHttpSessionListener((HttpSessionListener)listener);
            addFlag = true;
        }
        if (listener instanceof ServletContextListener) {
            listenerManager.addServletContextListener((ServletContextListener)listener);
            addFlag = true;
        }
        if (!addFlag) {
            throw new IllegalArgumentException("applicationContext.addListener.iae.wrongType" + listener.getClass().getName());
        }
    }

    public void addListener(Class<? extends EventListener> listenerClass) {
        try {
            this.addListener(listenerClass.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new IllegalStateException("addListener listenerClass =" + listenerClass, e);
        }
    }

    public <T extends EventListener> T createListener(Class<T> clazz) throws ServletException {
        try {
            return (T)((EventListener)clazz.newInstance());
        }
        catch (IllegalAccessException | InstantiationException e) {
            throw new ServletException("addListener clazz =" + clazz, (Throwable)e);
        }
    }

    public JspConfigDescriptor getJspConfigDescriptor() {
        throw new UnsupportedOperationException("getJspConfigDescriptor");
    }

    public ClassLoader getClassLoader() {
        return this.resourceManager.getClassLoader();
    }

    public void declareRoles(String ... roleNames) {
        throw new UnsupportedOperationException("declareRoles");
    }

    public String getVirtualServerName() {
        return Version.getServerInfo().concat(" (").concat(this.serverAddress.getHostName()).concat(":").concat(SystemPropertyUtil.get("user.name")).concat(")");
    }

    public String getRequestCharacterEncoding() {
        if (this.requestCharacterEncoding == null) {
            return HttpConstants.DEFAULT_CHARSET.name();
        }
        return this.requestCharacterEncoding;
    }

    public void setRequestCharacterEncoding(String requestCharacterEncoding) {
        this.requestCharacterEncoding = requestCharacterEncoding;
    }

    public String getResponseCharacterEncoding() {
        if (this.responseCharacterEncoding == null) {
            return HttpConstants.DEFAULT_CHARSET.name();
        }
        return this.responseCharacterEncoding;
    }

    public void setResponseCharacterEncoding(String responseCharacterEncoding) {
        this.responseCharacterEncoding = responseCharacterEncoding;
    }

    public ServletRegistration.Dynamic addJspFile(String jspName, String jspFile) {
        throw new UnsupportedOperationException("addJspFile");
    }

    public static String normPath(String path) {
        if (path.isEmpty()) {
            return path;
        }
        while (path.startsWith("//")) {
            path = path.substring(1);
        }
        if (!path.startsWith("/")) {
            path = "/" + path;
        }
        if (path.length() > 1) {
            while (path.endsWith("/")) {
                path = path.substring(0, path.length() - 1);
            }
        }
        return path;
    }
}

