/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet;

import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.protocol.servlet.ServletErrorPage;
import com.github.netty.protocol.servlet.ServletHttpServletRequest;
import com.github.netty.protocol.servlet.ServletHttpServletResponse;
import com.github.netty.protocol.servlet.ServletRequestDispatcher;
import com.github.netty.protocol.servlet.util.ServletUtil;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.DispatcherType;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ServletErrorPageManager {
    private final LoggerX logger = LoggerFactoryX.getLogger(this.getClass());
    private boolean showErrorMessage = false;
    private final Map<String, ServletErrorPage> exceptionPages = new ConcurrentHashMap<String, ServletErrorPage>();
    private final Map<Integer, ServletErrorPage> statusPages = new ConcurrentHashMap<Integer, ServletErrorPage>();

    public void add(ServletErrorPage errorPage) {
        String exceptionType = errorPage.getExceptionType();
        if (exceptionType == null) {
            this.statusPages.put(errorPage.getStatus(), errorPage);
        } else {
            this.exceptionPages.put(exceptionType, errorPage);
        }
    }

    public void remove(ServletErrorPage errorPage) {
        String exceptionType = errorPage.getExceptionType();
        if (exceptionType == null) {
            this.statusPages.remove(errorPage.getStatus(), errorPage);
        } else {
            this.exceptionPages.remove(exceptionType, errorPage);
        }
    }

    public ServletErrorPage find(int statusCode) {
        return this.statusPages.get(statusCode);
    }

    public ServletErrorPage find(Throwable exceptionType) {
        if (exceptionType == null) {
            return null;
        }
        Class<?> clazz = exceptionType.getClass();
        String name = clazz.getName();
        while (!Object.class.equals(clazz)) {
            ServletErrorPage errorPage = this.exceptionPages.get(name);
            if (errorPage != null) {
                return errorPage;
            }
            if ((clazz = clazz.getSuperclass()) == null) break;
            name = clazz.getName();
        }
        return null;
    }

    public boolean isShowErrorMessage() {
        return this.showErrorMessage;
    }

    public void setShowErrorMessage(boolean showErrorMessage) {
        this.showErrorMessage = showErrorMessage;
    }

    public void handleErrorPage(ServletErrorPage errorPage, Throwable throwable, HttpServletRequest httpServletRequest, HttpServletResponse httpServletResponse) {
        block20: {
            if (errorPage == null) {
                if (throwable != null) {
                    String msg = "a unknown error! " + throwable;
                    this.logger.error(msg, throwable);
                    try {
                        httpServletResponse.setCharacterEncoding("utf-8");
                        httpServletResponse.setContentType("text/html");
                        httpServletResponse.setStatus(500);
                        httpServletResponse.getWriter().write("<!DOCTYPE html>\n<html lang=\"en\">\n<head>\n    <meta charset=\"UTF-8\">\n    <title>a unknown error!</title>\n</head>\n<body>\n<p>" + msg + "</p>\n</body>\n</html>");
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                return;
            }
            ServletHttpServletRequest request = ServletUtil.unWrapper((ServletRequest)httpServletRequest);
            ServletHttpServletResponse response = ServletUtil.unWrapper((ServletResponse)httpServletResponse);
            if (!request.getServletHttpExchange().getChannelHandlerContext().channel().isActive()) {
                return;
            }
            String errorPagePath = ServletErrorPageManager.getErrorPagePath(request, errorPage);
            if (errorPagePath == null) {
                return;
            }
            ServletRequestDispatcher dispatcher = request.getServletContext().getRequestDispatcher(errorPagePath, DispatcherType.ERROR);
            try {
                response.resetBuffer();
            }
            catch (IllegalStateException e) {
                this.logger.warn("stream close. not execute handleErrorPage. {}", (Object)Objects.toString(throwable, ""), (Object)throwable);
                return;
            }
            if (dispatcher == null) {
                try {
                    response.getWriter().write("not found ".concat(errorPagePath));
                    response.sendError(404);
                }
                catch (IOException e) {
                    this.logger.error("handleErrorPage() sendError. error={}", (Object)e.toString(), (Object)e);
                }
                return;
            }
            try {
                if (throwable != null) {
                    httpServletRequest.setAttribute("javax.servlet.error.exception", (Object)throwable);
                    httpServletRequest.setAttribute("javax.servlet.error.exception_type", throwable.getClass());
                    if (this.isShowErrorMessage()) {
                        String localizedMessage = throwable.getLocalizedMessage();
                        if (localizedMessage == null) {
                            StringWriter writer = new StringWriter();
                            throwable.printStackTrace(new PrintWriter(writer));
                            localizedMessage = writer.toString();
                        }
                        httpServletRequest.setAttribute("javax.servlet.error.message", (Object)localizedMessage);
                    }
                }
                httpServletRequest.setAttribute("javax.servlet.error.servlet_name", (Object)dispatcher.getName());
                httpServletRequest.setAttribute("javax.servlet.error.request_uri", (Object)request.getRequestURI());
                httpServletRequest.setAttribute("javax.servlet.error.status_code", (Object)response.getStatus());
                request.setDispatcherType(DispatcherType.ERROR);
                if (httpServletResponse.isCommitted()) {
                    dispatcher.include((ServletRequest)request, (ServletResponse)httpServletResponse, DispatcherType.ERROR);
                } else {
                    response.resetHeader();
                    response.resetBuffer(true);
                    dispatcher.forward((ServletRequest)request, (ServletResponse)httpServletResponse, DispatcherType.ERROR);
                    response.getOutputStream().setSuspendFlag(false);
                }
            }
            catch (Throwable e) {
                this.logger.error("on handleErrorPage error. url=" + request.getRequestURL() + ", case=" + e.getMessage(), e);
                if (e instanceof ThreadDeath) {
                    throw (ThreadDeath)e;
                }
                if (e instanceof StackOverflowError) {
                    return;
                }
                if (!(e instanceof VirtualMachineError)) break block20;
                throw (VirtualMachineError)e;
            }
        }
    }

    public static String getErrorPagePath(HttpServletRequest request, ServletErrorPage errorPage) {
        String contextPath;
        String path = errorPage.getPath();
        if (path == null || path.isEmpty()) {
            return null;
        }
        if (!path.startsWith("/")) {
            path = "/".concat(path);
        }
        return (contextPath = request.getContextPath()) == null || contextPath.isEmpty() ? path : contextPath.concat(path);
    }
}

