/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet;

import com.github.netty.protocol.servlet.ServletContext;
import com.github.netty.protocol.servlet.util.FilterMapper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.DispatcherType;
import javax.servlet.Filter;
import javax.servlet.FilterConfig;
import javax.servlet.FilterRegistration;

public class ServletFilterRegistration
implements FilterRegistration,
FilterRegistration.Dynamic {
    private String filterName;
    private Filter filter;
    private FilterConfig filterConfig;
    private ServletContext servletContext;
    private FilterMapper<ServletFilterRegistration> urlMapper;
    private boolean asyncSupported = true;
    private Map<String, String> initParameterMap = new LinkedHashMap<String, String>();
    private MappingSet mappingSet = new MappingSet();
    private Set<String> servletNameMappingSet = new HashSet<String>();
    private AtomicBoolean initFilter = new AtomicBoolean();

    public ServletFilterRegistration(String filterName, Filter servlet, ServletContext servletContext, FilterMapper<ServletFilterRegistration> urlMapper) {
        this.filterName = filterName;
        this.filter = servlet;
        this.servletContext = servletContext;
        this.urlMapper = urlMapper;
        this.filterConfig = new FilterConfig(){

            public String getFilterName() {
                return ServletFilterRegistration.this.filterName;
            }

            public ServletContext getServletContext() {
                return ServletFilterRegistration.this.servletContext;
            }

            public String getInitParameter(String name) {
                return ServletFilterRegistration.this.getInitParameter(name);
            }

            public Enumeration<String> getInitParameterNames() {
                return Collections.enumeration(ServletFilterRegistration.this.getInitParameters().keySet());
            }
        };
    }

    public FilterConfig getFilterConfig() {
        return this.filterConfig;
    }

    public Filter getFilter() {
        return this.filter;
    }

    public boolean isAsyncSupported() {
        return this.asyncSupported;
    }

    public boolean isInitFilterCas(boolean expect, boolean update) {
        return this.initFilter.compareAndSet(expect, update);
    }

    public boolean isInitFilter() {
        return this.initFilter.get();
    }

    public String getName() {
        return this.filterName;
    }

    public String getClassName() {
        return this.filter.getClass().getName();
    }

    public boolean setInitParameter(String name, String value) {
        return this.initParameterMap.put(name, value) != null;
    }

    public String getInitParameter(String name) {
        return this.initParameterMap.get(name);
    }

    public Set<String> setInitParameters(Map<String, String> initParameters) {
        this.initParameterMap = initParameters;
        return this.initParameterMap.keySet();
    }

    public Map<String, String> getInitParameters() {
        return this.initParameterMap;
    }

    public void setAsyncSupported(boolean isAsyncSupported) {
        this.asyncSupported = isAsyncSupported;
    }

    public void addMappingForServletNames(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... servletNames) {
        if (servletNames != null) {
            this.servletNameMappingSet.addAll(Arrays.asList(servletNames));
        }
    }

    public Collection<String> getServletNameMappings() {
        return this.servletNameMappingSet;
    }

    public void addMappingForUrlPatterns(EnumSet<DispatcherType> dispatcherTypes, boolean isMatchAfter, String ... urlPatterns) {
        if (urlPatterns != null) {
            for (String urlPattern : urlPatterns) {
                this.mappingSet.add(urlPattern, isMatchAfter, dispatcherTypes);
            }
        }
    }

    public Collection<String> getUrlPatternMappings() {
        return this.mappingSet;
    }

    public String toString() {
        return this.getName();
    }

    class MappingSet
    extends LinkedHashSet<String> {
        MappingSet() {
        }

        @Override
        public boolean add(String pattern) {
            return this.add(pattern, false, null);
        }

        @Override
        public boolean addAll(Collection c) {
            for (Object o : c) {
                this.add(o.toString());
            }
            return c.size() > 0;
        }

        public boolean add(String pattern, boolean isMatchAfter, EnumSet<DispatcherType> dispatcherTypes) {
            ServletFilterRegistration.this.urlMapper.addMapping(pattern, ServletFilterRegistration.this, ServletFilterRegistration.this.filterName, isMatchAfter, dispatcherTypes);
            return super.add(pattern);
        }

        @Override
        public void clear() {
            ServletFilterRegistration.this.urlMapper.clear();
            super.clear();
        }
    }
}

