/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet;

import com.github.netty.core.util.Recyclable;
import com.github.netty.core.util.Recycler;
import com.github.netty.protocol.servlet.ServletAsyncContext;
import com.github.netty.protocol.servlet.ServletContext;
import com.github.netty.protocol.servlet.ServletHttpServletRequest;
import com.github.netty.protocol.servlet.ServletHttpServletResponse;
import com.github.netty.protocol.servlet.ServletHttpSession;
import com.github.netty.protocol.servlet.util.HttpHeaderUtil;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.util.Attribute;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;

public class ServletHttpExchange
implements Recyclable,
AutoCloseable {
    private static final Recycler<ServletHttpExchange> RECYCLER = new Recycler<ServletHttpExchange>(ServletHttpExchange::new);
    private static final AttributeKey<ServletHttpSession> CHANNEL_ATTR_KEY_SESSION = AttributeKey.valueOf((String)(ServletHttpSession.class + "#ServletHttpSession"));
    private static final AttributeKey<ServletHttpExchange> CHANNEL_ATTR_KEY_EXCHANGE = AttributeKey.valueOf((String)(ServletHttpExchange.class + "#ServletHttpExchange"));
    private ServletHttpServletRequest request;
    private ServletHttpServletResponse response;
    private ChannelHandlerContext channelHandlerContext;
    private ServletContext servletContext;
    private boolean isHttpKeepAlive;
    private final AtomicInteger close = new AtomicInteger(0);
    private boolean websocket;
    private boolean abortFlag;
    public static final int CLOSE_NO = 0;
    public static final int CLOSE_ING = 1;
    public static final int CLOSE_YES = 2;
    private final Consumer<Object> recycleCallback = e -> {
        this.request.recycle();
        if (this.channelHandlerContext instanceof Recyclable) {
            ((Recyclable)this.channelHandlerContext).recycle();
        }
        this.close.set(2);
        if (this.isAbort()) {
            return;
        }
        if (this.channelHandlerContext != null) {
            ServletHttpExchange.setAttribute(this.channelHandlerContext, CHANNEL_ATTR_KEY_EXCHANGE, null);
        }
        this.response = null;
        this.request = null;
        this.servletContext = null;
        RECYCLER.recycleInstance(this);
    };

    private ServletHttpExchange() {
    }

    public static ServletHttpExchange newInstance(ServletContext servletContext, ChannelHandlerContext context, HttpRequest httpRequest) {
        ServletHttpExchange instance = RECYCLER.getInstance();
        ServletHttpExchange.setHttpExchange(context, instance);
        instance.close.set(0);
        instance.servletContext = servletContext;
        instance.channelHandlerContext = context;
        instance.isHttpKeepAlive = HttpHeaderUtil.isKeepAlive(httpRequest);
        instance.request = ServletHttpServletRequest.newInstance(instance, httpRequest);
        instance.response = ServletHttpServletResponse.newInstance(instance);
        return instance;
    }

    public static ServletHttpSession getHttpSession(ChannelHandlerContext channelHandlerContext) {
        return ServletHttpExchange.getAttribute(channelHandlerContext, CHANNEL_ATTR_KEY_SESSION);
    }

    public static void setHttpSession(ChannelHandlerContext channelHandlerContext, ServletHttpSession httpSession) {
        ServletHttpExchange.setAttribute(channelHandlerContext, CHANNEL_ATTR_KEY_SESSION, httpSession);
    }

    public static boolean isChannelActive(ChannelHandlerContext channelHandlerContext) {
        return channelHandlerContext != null && channelHandlerContext.channel() != null && channelHandlerContext.channel().isActive();
    }

    public static ServletHttpExchange getHttpExchange(ChannelHandlerContext channelHandlerContext) {
        return ServletHttpExchange.getAttribute(channelHandlerContext, CHANNEL_ATTR_KEY_EXCHANGE);
    }

    public static void setHttpExchange(ChannelHandlerContext channelHandlerContext, ServletHttpExchange httpExchange) {
        ServletHttpExchange.setAttribute(channelHandlerContext, CHANNEL_ATTR_KEY_EXCHANGE, httpExchange);
    }

    public void setWebsocket(boolean websocket) {
        this.websocket = websocket;
    }

    public boolean isWebsocket() {
        return this.websocket;
    }

    public ServletHttpSession getHttpSession() {
        return ServletHttpExchange.getHttpSession(this.channelHandlerContext);
    }

    public void setHttpSession(ServletHttpSession httpSession) {
        ServletHttpExchange.setHttpSession(this.channelHandlerContext, httpSession);
    }

    public boolean isHttpKeepAlive() {
        return this.isHttpKeepAlive;
    }

    public ServletHttpServletRequest getRequest() {
        return this.request;
    }

    public void touch(Object hit) {
        CompositeByteBuf byteBuf;
        if (this.request != null && (byteBuf = this.request.getInputStream0().unwrap()) != null) {
            byteBuf.touch(hit);
        }
    }

    public ServletContext getServletContext() {
        return this.servletContext;
    }

    public ServletHttpServletResponse getResponse() {
        return this.response;
    }

    public ChannelHandlerContext getChannelHandlerContext() {
        return this.channelHandlerContext;
    }

    public InetSocketAddress getServerAddress() {
        return this.servletContext.getServerAddress();
    }

    public InetSocketAddress getLocalAddress() {
        SocketAddress socketAddress = this.channelHandlerContext.channel().localAddress();
        if (socketAddress == null) {
            return null;
        }
        if (socketAddress instanceof InetSocketAddress) {
            return (InetSocketAddress)socketAddress;
        }
        return null;
    }

    public InetSocketAddress getRemoteAddress() {
        SocketAddress socketAddress = this.channelHandlerContext.channel().remoteAddress();
        if (socketAddress == null) {
            return null;
        }
        if (socketAddress instanceof InetSocketAddress) {
            return (InetSocketAddress)socketAddress;
        }
        return null;
    }

    public long getPendingWriteBytes() {
        ChannelHandlerContext context = this.channelHandlerContext;
        if (context != null) {
            ChannelOutboundBuffer buffer = context.channel().unsafe().outboundBuffer();
            if (buffer == null) {
                return 0L;
            }
            return buffer.totalPendingWriteBytes();
        }
        return -1L;
    }

    public static <T> T getAttribute(ChannelHandlerContext channelHandlerContext, AttributeKey<T> key) {
        Attribute attribute;
        if (channelHandlerContext != null && channelHandlerContext.channel() != null && (attribute = channelHandlerContext.channel().attr(key)) != null) {
            return (T)attribute.get();
        }
        return null;
    }

    public static <T> void setAttribute(ChannelHandlerContext context, AttributeKey<T> key, T value) {
        if (ServletHttpExchange.isChannelActive(context)) {
            context.channel().attr(key).set(value);
        }
    }

    public <T> T getAttribute(AttributeKey<T> key) {
        Attribute attribute;
        if (this.channelHandlerContext != null && this.channelHandlerContext.channel() != null && (attribute = this.channelHandlerContext.channel().attr(key)) != null) {
            return (T)attribute.get();
        }
        return null;
    }

    public <T> void setAttribute(AttributeKey<T> key, T value) {
        if (ServletHttpExchange.isChannelActive(this.channelHandlerContext)) {
            this.channelHandlerContext.channel().attr(key).set(value);
        }
    }

    public boolean isChannelActive() {
        return ServletHttpExchange.isChannelActive(this.channelHandlerContext);
    }

    public boolean isAsyncStartIng() {
        ServletHttpServletRequest request = this.request;
        if (request != null) {
            ServletAsyncContext asyncContext = request.getAsyncContext();
            return asyncContext != null && asyncContext.isStarted() && !asyncContext.isComplete();
        }
        return false;
    }

    public ServletAsyncContext getAsyncContext() {
        ServletHttpServletRequest request = this.getRequest();
        if (request != null) {
            return request.getAsyncContext();
        }
        return null;
    }

    public void abort() {
        this.abortFlag = true;
    }

    public boolean isAbort() {
        return this.abortFlag;
    }

    @Override
    public void recycle() {
        if (this.close.compareAndSet(0, 1)) {
            this.response.recycle(this.recycleCallback);
        }
    }

    @Override
    public void close() {
        if (this.websocket) {
            return;
        }
        this.recycle();
    }

    public int closeStatus() {
        return this.close.get();
    }
}

