/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet;

import com.github.netty.core.util.LinkedMultiValueMap;
import com.github.netty.core.util.Recyclable;
import com.github.netty.core.util.RecyclableUtil;
import com.github.netty.core.util.Recycler;
import com.github.netty.core.util.ResourceManager;
import com.github.netty.protocol.servlet.ServletAsyncContext;
import com.github.netty.protocol.servlet.ServletContext;
import com.github.netty.protocol.servlet.ServletEventListenerManager;
import com.github.netty.protocol.servlet.ServletFilePart;
import com.github.netty.protocol.servlet.ServletHttpExchange;
import com.github.netty.protocol.servlet.ServletHttpSession;
import com.github.netty.protocol.servlet.ServletInputStreamWrapper;
import com.github.netty.protocol.servlet.ServletRequestDispatcher;
import com.github.netty.protocol.servlet.ServletTextPart;
import com.github.netty.protocol.servlet.Session;
import com.github.netty.protocol.servlet.SessionService;
import com.github.netty.protocol.servlet.util.HttpHeaderConstants;
import com.github.netty.protocol.servlet.util.HttpHeaderUtil;
import com.github.netty.protocol.servlet.util.ServletUtil;
import com.github.netty.protocol.servlet.util.SnowflakeIdWorker;
import io.netty.handler.codec.CodecException;
import io.netty.handler.codec.DateFormatter;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.multipart.Attribute;
import io.netty.handler.codec.http.multipart.FileUpload;
import io.netty.handler.codec.http.multipart.HttpDataFactory;
import io.netty.handler.codec.http.multipart.HttpPostMultipartRequestDecoder;
import io.netty.handler.codec.http.multipart.HttpPostRequestDecoder;
import io.netty.handler.codec.http.multipart.HttpPostStandardRequestDecoder;
import io.netty.handler.codec.http.multipart.InterfaceHttpData;
import io.netty.handler.codec.http.multipart.InterfaceHttpPostRequestDecoder;
import io.netty.util.internal.PlatformDependent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.security.Principal;
import java.text.SimpleDateFormat;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.servlet.DispatcherType;
import javax.servlet.MultipartConfigElement;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestAttributeEvent;
import javax.servlet.ServletResponse;
import javax.servlet.ServletSecurityElement;
import javax.servlet.SessionTrackingMode;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import javax.servlet.http.HttpSessionEvent;
import javax.servlet.http.HttpUpgradeHandler;
import javax.servlet.http.Part;

public class ServletHttpServletRequest
implements HttpServletRequest,
Recyclable {
    private static final Recycler<ServletHttpServletRequest> RECYCLER = new Recycler<ServletHttpServletRequest>(ServletHttpServletRequest::new);
    private static final Locale[] DEFAULT_LOCALS = new Locale[]{Locale.getDefault()};
    private static final String RFC1123_DATE = "EEE, dd MMM yyyy HH:mm:ss zzz";
    private static final SimpleDateFormat[] FORMATS_TEMPLATE = new SimpleDateFormat[]{new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz", Locale.ENGLISH), new SimpleDateFormat("EEEEEE, dd-MMM-yy HH:mm:ss zzz", Locale.ENGLISH), new SimpleDateFormat("EEE MMMM d HH:mm:ss yyyy", Locale.ENGLISH)};
    private static final Map<String, ResourceManager> RESOURCE_MANAGER_MAP = new HashMap<String, ResourceManager>(2);
    private static final SnowflakeIdWorker SNOWFLAKE_ID_WORKER = new SnowflakeIdWorker();
    private ServletHttpExchange servletHttpExchange;
    private ServletAsyncContext asyncContext;
    private DispatcherType dispatcherType = null;
    private String serverName;
    private int serverPort;
    private String remoteHost;
    private String protocol;
    private String scheme;
    private String servletPath;
    private String queryString;
    private String pathInfo;
    private String requestURI;
    private String characterEncoding;
    private String sessionId;
    private SessionTrackingMode sessionIdSource;
    private MultipartConfigElement multipartConfigElement;
    private ServletSecurityElement servletSecurityElement;
    private ServletRequestDispatcher dispatcher;
    private ResourceManager resourceManager;
    private boolean decodePathsFlag = false;
    private boolean decodeCookieFlag = false;
    private boolean decodeParameterByUrlFlag = false;
    private volatile InterfaceHttpPostRequestDecoder postRequestDecoder = null;
    private boolean remoteSchemeFlag = false;
    private boolean usingInputStreamFlag = false;
    private final AtomicBoolean decodeBodyFlag = new AtomicBoolean();
    private BufferedReader reader;
    private HttpRequest nettyRequest;
    private boolean isMultipart;
    private boolean isFormUrlEncoder;
    private final Map<String, Object> attributeMap = Collections.synchronizedMap(new LinkedHashMap(16));
    private final LinkedMultiValueMap<String, String> parameterMap = new LinkedMultiValueMap(16);
    private final Map<String, String[]> unmodifiableParameterMap = new AbstractMap<String, String[]>(){

        @Override
        public Set<Map.Entry<String, String[]>> entrySet() {
            if (this.isEmpty()) {
                return Collections.emptySet();
            }
            HashSet<Map.Entry<String, String[]>> result = new HashSet<Map.Entry<String, String[]>>(6);
            Set entries = ServletHttpServletRequest.this.parameterMap.entrySet();
            for (Map.Entry entry : entries) {
                List value = entry.getValue();
                String[] valueArr = value != null ? value.toArray(new String[value.size()]) : null;
                result.add(new AbstractMap.SimpleImmutableEntry(entry.getKey(), valueArr));
            }
            return result;
        }

        @Override
        public String[] get(Object key) {
            Object value = ServletHttpServletRequest.this.parameterMap.get(key);
            if (value == null) {
                return null;
            }
            return value.toArray(new String[value.size()]);
        }

        @Override
        public boolean containsKey(Object key) {
            return ServletHttpServletRequest.this.parameterMap.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return ServletHttpServletRequest.this.parameterMap.containsValue(value);
        }

        @Override
        public int size() {
            return ServletHttpServletRequest.this.parameterMap.size();
        }
    };
    private final Supplier<ResourceManager> resourceManagerSupplier = () -> {
        if (this.resourceManager == null) {
            ServletHttpServletRequest servletHttpServletRequest = this;
            synchronized (servletHttpServletRequest) {
                if (this.resourceManager == null) {
                    ResourceManager resourceManager;
                    String location = null;
                    if (this.multipartConfigElement != null) {
                        location = this.multipartConfigElement.getLocation();
                    }
                    if (location != null && location.length() > 0) {
                        resourceManager = RESOURCE_MANAGER_MAP.get(location);
                        if (resourceManager == null) {
                            resourceManager = new ResourceManager(location);
                            RESOURCE_MANAGER_MAP.put(location, resourceManager);
                        }
                    } else {
                        resourceManager = this.getServletContext().getResourceManager();
                    }
                    this.resourceManager = resourceManager;
                }
            }
        }
        return this.resourceManager;
    };
    private final Supplier<InterfaceHttpPostRequestDecoder> postRequestDecoderSupplier = () -> {
        if (!this.isMultipart && !this.isFormUrlEncoder) {
            return null;
        }
        if (this.postRequestDecoder == null) {
            ServletHttpServletRequest servletHttpServletRequest = this;
            synchronized (servletHttpServletRequest) {
                if (this.postRequestDecoder == null) {
                    HttpPostMultipartRequestDecoder postRequestDecoder;
                    Charset charset = Charset.forName(this.getCharacterEncoding());
                    HttpDataFactory httpDataFactory = this.getHttpDataFactory(charset);
                    if (this.isMultipart) {
                        postRequestDecoder = new HttpPostMultipartRequestDecoder(httpDataFactory, this.nettyRequest, charset);
                    } else if (this.isFormUrlEncoder) {
                        postRequestDecoder = new HttpPostStandardRequestDecoder(httpDataFactory, this.nettyRequest, charset);
                    } else {
                        throw new HttpPostRequestDecoder.ErrorDataDecoderException();
                    }
                    this.postRequestDecoder = postRequestDecoder;
                }
            }
        }
        return this.postRequestDecoder;
    };
    private final ServletInputStreamWrapper inputStream = new ServletInputStreamWrapper(this.postRequestDecoderSupplier, this.resourceManagerSupplier);
    private final List<Part> fileUploadList = new ArrayList<Part>();
    private Cookie[] cookies;
    private Locale[] locales;
    private Boolean asyncSupportedFlag;

    protected ServletHttpServletRequest() {
    }

    public static ServletHttpServletRequest newInstance(ServletHttpExchange exchange, HttpRequest httpRequest) {
        String contentType;
        ServletHttpServletRequest instance = RECYCLER.getInstance();
        instance.servletHttpExchange = exchange;
        instance.nettyRequest = httpRequest;
        instance.isMultipart = HttpPostRequestDecoder.isMultipart((HttpRequest)httpRequest);
        instance.isFormUrlEncoder = instance.isMultipart ? false : (contentType = instance.getContentType()) != null && HttpHeaderUtil.isFormUrlEncoder(contentType.toLowerCase());
        instance.resourceManager = null;
        if (instance.postRequestDecoder != null) {
            try {
                instance.postRequestDecoder.destroy();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            instance.postRequestDecoder = null;
        }
        instance.inputStream.wrap(exchange.getChannelHandlerContext().alloc().compositeBuffer(Integer.MAX_VALUE));
        instance.inputStream.setFileSizeThreshold(instance.getFileSizeThreshold());
        instance.inputStream.setFileUploadTimeoutMs(exchange.getServletContext().getUploadFileTimeoutMs());
        return instance;
    }

    void setMultipartConfigElement(MultipartConfigElement multipartConfigElement) {
        this.multipartConfigElement = multipartConfigElement;
    }

    void setServletSecurityElement(ServletSecurityElement servletSecurityElement) {
        this.servletSecurityElement = servletSecurityElement;
    }

    void setDispatcherType(DispatcherType dispatcherType) {
        this.dispatcherType = dispatcherType;
    }

    void setDispatcher(ServletRequestDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }

    public int getFileSizeThreshold() {
        int fileSizeThreshold = 16384;
        fileSizeThreshold = this.multipartConfigElement != null ? Math.max(this.multipartConfigElement.getFileSizeThreshold(), fileSizeThreshold) : Math.max((int)this.getServletContext().getUploadMinSize(), fileSizeThreshold);
        return fileSizeThreshold;
    }

    public boolean isMultipart() {
        return this.isMultipart;
    }

    public boolean isAsync() {
        return this.asyncContext != null;
    }

    void setAsyncSupportedFlag(Boolean asyncSupportedFlag) {
        this.asyncSupportedFlag = asyncSupportedFlag;
    }

    public ServletHttpExchange getServletHttpExchange() {
        return this.servletHttpExchange;
    }

    public HttpRequest getNettyRequest() {
        return this.nettyRequest;
    }

    public HttpHeaders getNettyHeaders() {
        return this.nettyRequest.headers();
    }

    private Map<String, Object> getAttributeMap() {
        return this.attributeMap;
    }

    private void decodeScheme() {
        String proto = this.getHeader(HttpHeaderConstants.X_FORWARDED_PROTO.toString());
        if ("https".equalsIgnoreCase(proto)) {
            this.scheme = "https";
            this.remoteSchemeFlag = true;
        } else if ("http".equalsIgnoreCase(proto)) {
            this.scheme = "http";
            this.remoteSchemeFlag = true;
        } else {
            this.scheme = String.valueOf(this.nettyRequest.protocolVersion().protocolName()).toLowerCase();
            this.remoteSchemeFlag = false;
        }
    }

    private void decodeLocale() {
        Locale[] locales;
        String headerValue = this.getHeader(HttpHeaderConstants.ACCEPT_LANGUAGE.toString());
        if (headerValue == null) {
            locales = DEFAULT_LOCALS;
        } else {
            String[] values = headerValue.split(",");
            int length = values.length;
            locales = new Locale[length];
            for (int i = 0; i < length; ++i) {
                String value = values[i];
                String[] valueSp = value.split(";");
                Locale locale = valueSp.length > 0 ? Locale.forLanguageTag(valueSp[0]) : Locale.forLanguageTag(value);
                locales[i] = locale;
            }
        }
        this.locales = locales;
    }

    private void decodeCharacterEncoding() {
        String characterEncoding = ServletUtil.decodeCharacterEncoding(this.getContentType());
        if (characterEncoding == null) {
            characterEncoding = this.getServletContext().getRequestCharacterEncoding();
        }
        this.characterEncoding = characterEncoding;
    }

    private HttpDataFactory getHttpDataFactory(Charset charset) {
        HttpDataFactory factory = this.getServletContext().getHttpDataFactory(charset);
        if (this.multipartConfigElement != null) {
            factory.setMaxLimit(this.multipartConfigElement.getMaxFileSize());
        }
        return factory;
    }

    private void decodeBody() {
        try {
            this.getInputStream0().awaitDataIfNeed();
        }
        catch (IOException e) {
            PlatformDependent.throwException((Throwable)e);
        }
        if (this.postRequestDecoder == null) {
            return;
        }
        while (true) {
            try {
                if (!this.postRequestDecoder.hasNext()) {
                    return;
                }
            }
            catch (HttpPostRequestDecoder.EndOfDataDecoderException e) {
                return;
            }
            InterfaceHttpData interfaceData = this.postRequestDecoder.next();
            switch (interfaceData.getHttpDataType()) {
                case Attribute: {
                    String value;
                    Attribute data = (Attribute)interfaceData;
                    String name = data.getName();
                    try {
                        value = data.getValue();
                    }
                    catch (IOException e) {
                        value = "";
                    }
                    this.parameterMap.add(name, value);
                    if (!this.isMultipart) break;
                    ServletTextPart part = new ServletTextPart(data, this.resourceManagerSupplier);
                    this.fileUploadList.add(part);
                    break;
                }
                case FileUpload: {
                    Attribute data = (FileUpload)interfaceData;
                    ServletFilePart part = new ServletFilePart((FileUpload)data, this.resourceManagerSupplier);
                    this.fileUploadList.add(part);
                    break;
                }
            }
        }
    }

    private void decodeUrlParameter() {
        Charset charset = Charset.forName(this.getCharacterEncoding());
        ServletUtil.decodeByUrl(this.parameterMap, this.nettyRequest.uri(), charset);
        this.decodeParameterByUrlFlag = true;
    }

    private void decodeCookie() {
        String value = this.getHeader(HttpHeaderConstants.COOKIE.toString());
        if (value != null && value.length() > 0) {
            this.cookies = ServletUtil.decodeCookie(value);
        }
        this.decodeCookieFlag = true;
    }

    private void decodeRemoteHost() {
        if (this.getServletContext().isEnableLookupFlag()) {
            InetSocketAddress inetSocketAddress = this.servletHttpExchange.getRemoteAddress();
            if (inetSocketAddress == null) {
                throw new IllegalStateException("request invalid");
            }
            try {
                this.remoteHost = InetAddress.getByName(inetSocketAddress.getHostName()).getHostName();
            }
            catch (IOException iOException) {}
        } else {
            this.remoteHost = this.getRemoteAddr();
        }
    }

    private void decodeServerNameAndPort() {
        String host = this.getHeader(HttpHeaderConstants.HOST.toString());
        if (host != null && host.length() > 0) {
            StringBuilder sb = RecyclableUtil.newStringBuilder();
            int length = host.length();
            boolean hasPort = false;
            for (int i = 0; i < length; ++i) {
                char c = host.charAt(i);
                if (c == ':') {
                    this.serverName = sb.toString();
                    sb.setLength(0);
                    hasPort = true;
                    continue;
                }
                sb.append(c);
            }
            if (hasPort && sb.length() > 0) {
                this.serverPort = Integer.parseInt(sb.toString());
            } else {
                this.serverName = sb.toString();
                sb.setLength(0);
            }
        } else {
            this.serverName = this.getRemoteHost();
        }
        if (this.serverPort == 0) {
            String scheme = this.getScheme();
            this.serverPort = this.remoteSchemeFlag ? ("https".equalsIgnoreCase(scheme) ? 443 : 80) : 80;
        }
    }

    private void decodePaths() {
        String queryString;
        String requestURI = this.nettyRequest.uri();
        int queryInx = requestURI.indexOf(63);
        if (queryInx != -1) {
            queryString = requestURI.substring(queryInx + 1);
            requestURI = requestURI.substring(0, queryInx);
        } else {
            queryString = null;
        }
        this.requestURI = ServletContext.normPath(requestURI);
        this.queryString = queryString;
        this.decodePathsFlag = true;
    }

    private String newSessionId() {
        return String.valueOf(SNOWFLAKE_ID_WORKER.nextId());
    }

    public Cookie[] getCookies() {
        if (this.decodeCookieFlag) {
            return this.cookies;
        }
        this.decodeCookie();
        return this.cookies;
    }

    public long getDateHeader(String name) throws IllegalArgumentException {
        String value = this.getHeader(name);
        if (value == null || value.isEmpty()) {
            return -1L;
        }
        Date date = DateFormatter.parseHttpDate((CharSequence)value);
        if (date == null) {
            throw new IllegalArgumentException(value);
        }
        return date.getTime();
    }

    public String getHeader(String name) {
        String value = this.getNettyHeaders().get((CharSequence)name);
        return value == null ? null : value.toString();
    }

    public Enumeration<String> getHeaderNames() {
        final Set nameSet = this.getNettyHeaders().names();
        return new Enumeration<String>(){
            private Iterator iterator;
            {
                this.iterator = nameSet.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            @Override
            public String nextElement() {
                return this.iterator.next().toString();
            }
        };
    }

    public StringBuffer getRequestURL() {
        StringBuffer url = new StringBuffer();
        String scheme = this.getScheme();
        int port = this.getServerPort();
        if (port < 0) {
            port = 80;
        }
        url.append(scheme);
        url.append("://");
        url.append(this.getServerName());
        if ("http".equals(scheme) && port != 80 || "https".equals(scheme) && port != 443) {
            url.append(':');
            url.append(port);
        }
        url.append(this.getRequestURI());
        return url;
    }

    public String getPathInfo() {
        if (this.pathInfo == null && this.dispatcher != null) {
            this.pathInfo = ServletRequestDispatcher.getPathInfo(this.dispatcher.getPath(), this.dispatcher.getMapperElement());
        }
        return this.pathInfo;
    }

    public String getQueryString() {
        if (!this.decodePathsFlag) {
            this.decodePaths();
        }
        return this.queryString;
    }

    public String getRequestURI() {
        if (!this.decodePathsFlag) {
            this.decodePaths();
        }
        return this.requestURI;
    }

    public String getServletPath() {
        if (this.servletPath == null) {
            String servletPath = this.getServletContext().getServletPath(this.getRequestURI());
            String contextPath = this.getServletContext().getContextPath();
            if (contextPath.length() > 0) {
                servletPath = servletPath.replaceFirst(contextPath, "");
            }
            this.servletPath = ServletContext.normPath(servletPath);
        }
        return this.servletPath;
    }

    public Enumeration<String> getHeaders(String name) {
        final List collection = this.getNettyHeaders().getAll((CharSequence)name);
        return new Enumeration<String>(){
            private Iterator iterator;
            {
                this.iterator = collection.iterator();
            }

            @Override
            public boolean hasMoreElements() {
                return this.iterator.hasNext();
            }

            @Override
            public String nextElement() {
                return this.iterator.next().toString();
            }
        };
    }

    public int getIntHeader(String name) {
        String headerStringValue = this.getHeader(name);
        if (headerStringValue == null) {
            return -1;
        }
        return Integer.parseInt(headerStringValue);
    }

    public String getMethod() {
        return this.nettyRequest.method().toString();
    }

    public String getContextPath() {
        return this.getServletContext().getContextPath();
    }

    public ServletHttpSession getSession(boolean create) {
        boolean newSessionFlag;
        ServletContext servletContext;
        SessionService sessionService;
        Session session;
        String sessionId = null;
        ServletHttpSession httpSession = this.servletHttpExchange.getHttpSession();
        if (httpSession != null && httpSession.isValid()) {
            sessionId = this.getRequestedSessionId0();
            if (httpSession.getId().equals(sessionId)) {
                return httpSession;
            }
        }
        if (this.sessionIdSource == null && !create) {
            return null;
        }
        if (sessionId == null || sessionId.isEmpty()) {
            sessionId = this.getRequestedSessionId();
        }
        if ((session = (sessionService = (servletContext = this.getServletContext()).getSessionService()).getSession(sessionId)) == null && !create) {
            return null;
        }
        boolean bl = newSessionFlag = session == null;
        if (newSessionFlag) {
            long currTime = System.currentTimeMillis();
            session = new Session(sessionId);
            session.setCreationTime(currTime);
            session.setLastAccessedTime(currTime);
            session.setMaxInactiveInterval(servletContext.getSessionTimeout());
        }
        if (httpSession == null) {
            httpSession = new ServletHttpSession(servletContext);
        } else {
            httpSession.setServletContext(servletContext);
        }
        httpSession.wrap(session);
        httpSession.setNewSessionFlag(newSessionFlag);
        httpSession.access();
        this.servletHttpExchange.setHttpSession(httpSession);
        return httpSession;
    }

    public ServletHttpSession getSession() {
        return this.getSession(true);
    }

    public String changeSessionId() {
        ServletHttpSession httpSession = this.getSession(true);
        String oldSessionId = httpSession.getId();
        String newSessionId = this.newSessionId();
        ServletContext servletContext = this.getServletContext();
        servletContext.getSessionService().changeSessionId(oldSessionId, newSessionId);
        this.sessionId = newSessionId;
        httpSession.setId(this.sessionId);
        ServletEventListenerManager listenerManager = servletContext.getServletEventListenerManager();
        if (listenerManager.hasHttpSessionIdListener()) {
            listenerManager.onHttpSessionIdChanged(new HttpSessionEvent((HttpSession)httpSession), oldSessionId);
        }
        return newSessionId;
    }

    public boolean isRequestedSessionIdValid() {
        this.getRequestedSessionId0();
        return this.sessionIdSource == SessionTrackingMode.COOKIE || this.sessionIdSource == SessionTrackingMode.URL;
    }

    public boolean isRequestedSessionIdFromCookie() {
        this.getRequestedSessionId0();
        return this.sessionIdSource == SessionTrackingMode.COOKIE;
    }

    public boolean isRequestedSessionIdFromURL() {
        return this.isRequestedSessionIdFromUrl();
    }

    public boolean isRequestedSessionIdFromUrl() {
        this.getRequestedSessionId0();
        return this.sessionIdSource == SessionTrackingMode.URL;
    }

    private String getRequestedSessionId0() {
        if (this.sessionId != null) {
            return this.sessionId;
        }
        String userSettingCookieName = this.getServletContext().getSessionCookieConfig().getName();
        String cookieSessionName = userSettingCookieName != null && userSettingCookieName.length() > 0 ? userSettingCookieName : "JSESSIONID";
        String sessionId = ServletUtil.getCookieValue(this.getCookies(), cookieSessionName);
        if (sessionId != null && sessionId.length() > 0) {
            this.sessionIdSource = SessionTrackingMode.COOKIE;
        } else {
            String queryString = this.getQueryString();
            if (queryString != null && queryString.contains("jsessionid")) {
                sessionId = this.getParameter("jsessionid");
            }
            this.sessionIdSource = sessionId != null && sessionId.length() > 0 ? SessionTrackingMode.URL : null;
        }
        return sessionId;
    }

    public String getRequestedSessionId() {
        String sessionId = this.getRequestedSessionId0();
        if (sessionId == null || sessionId.isEmpty()) {
            sessionId = this.newSessionId();
        }
        this.sessionId = sessionId;
        return sessionId;
    }

    public Object getAttribute(String name) {
        Object value = this.getAttributeMap().get(name);
        return value;
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.getAttributeMap().keySet());
    }

    public String getCharacterEncoding() {
        if (this.characterEncoding == null) {
            this.decodeCharacterEncoding();
        }
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
        this.characterEncoding = env;
    }

    public int getContentLength() {
        return (int)this.getContentLengthLong();
    }

    public long getContentLengthLong() {
        return this.inputStream.getContentLength();
    }

    public String getContentType() {
        return this.getHeader(HttpHeaderConstants.CONTENT_TYPE.toString());
    }

    public ServletInputStreamWrapper getInputStream() {
        if (this.reader != null) {
            throw new IllegalStateException("getReader() has already been called for this request");
        }
        this.usingInputStreamFlag = true;
        return this.inputStream;
    }

    ServletInputStreamWrapper getInputStream0() {
        return this.inputStream;
    }

    public String getParameter(String name) {
        String[] values;
        if (this.getServletContext().getNotExistBodyParameters().contains(name)) {
            if (!this.decodeParameterByUrlFlag) {
                this.decodeUrlParameter();
            }
            values = this.unmodifiableParameterMap.get(name);
        } else {
            values = this.getParameterMap().get(name);
        }
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.getParameterMap().keySet());
    }

    public String[] getParameterValues(String name) {
        return this.getParameterMap().get(name);
    }

    public Map<String, String[]> getParameterMap() {
        if (!this.decodeParameterByUrlFlag) {
            this.decodeUrlParameter();
        }
        if (this.decodeBodyFlag.compareAndSet(false, true)) {
            if ("POST".equalsIgnoreCase(this.getMethod()) && this.getContentLength() > 0) {
                this.decodeBody();
            }
        } else {
            try {
                this.getInputStream0().awaitDataIfNeed();
            }
            catch (IOException e) {
                PlatformDependent.throwException((Throwable)e);
            }
        }
        return this.unmodifiableParameterMap;
    }

    public String getProtocol() {
        if (this.protocol == null) {
            this.protocol = this.nettyRequest.protocolVersion().toString();
        }
        return this.protocol;
    }

    public String getScheme() {
        if (this.scheme == null) {
            this.decodeScheme();
        }
        return this.scheme;
    }

    public String getServerName() {
        if (this.serverName == null) {
            this.decodeServerNameAndPort();
        }
        return this.serverName;
    }

    public int getServerPort() {
        if (this.serverPort == 0) {
            this.decodeServerNameAndPort();
        }
        return this.serverPort;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedReader getReader() throws IOException {
        if (this.usingInputStreamFlag) {
            throw new IllegalStateException("getInputStream() has already been called for this request");
        }
        if (this.reader == null) {
            ServletHttpServletRequest servletHttpServletRequest = this;
            synchronized (servletHttpServletRequest) {
                if (this.reader == null) {
                    String charset = this.getCharacterEncoding();
                    if (charset == null) {
                        charset = this.getServletContext().getRequestCharacterEncoding();
                    }
                    this.reader = new BufferedReader(new InputStreamReader((InputStream)((Object)this.getInputStream0()), charset));
                }
            }
        }
        return this.reader;
    }

    public String getRemoteAddr() {
        InetSocketAddress inetSocketAddress = this.servletHttpExchange.getRemoteAddress();
        if (inetSocketAddress == null) {
            return null;
        }
        InetAddress inetAddress = inetSocketAddress.getAddress();
        if (inetAddress == null) {
            return null;
        }
        return inetAddress.getHostAddress();
    }

    public String getRemoteHost() {
        if (this.remoteHost == null) {
            this.decodeRemoteHost();
        }
        return this.remoteHost;
    }

    public int getRemotePort() {
        InetSocketAddress inetSocketAddress = this.servletHttpExchange.getRemoteAddress();
        if (inetSocketAddress == null) {
            return 0;
        }
        return inetSocketAddress.getPort();
    }

    public void setAttribute(String name, Object object) {
        Objects.requireNonNull(name);
        if (object == null) {
            this.removeAttribute(name);
            return;
        }
        Object oldObject = this.getAttributeMap().put(name, object);
        ServletContext servletContext = this.getServletContext();
        ServletEventListenerManager listenerManager = servletContext.getServletEventListenerManager();
        if (listenerManager.hasServletRequestAttributeListener()) {
            listenerManager.onServletRequestAttributeAdded(new ServletRequestAttributeEvent((javax.servlet.ServletContext)servletContext, (ServletRequest)this, name, object));
            if (oldObject != null) {
                listenerManager.onServletRequestAttributeReplaced(new ServletRequestAttributeEvent((javax.servlet.ServletContext)servletContext, (ServletRequest)this, name, oldObject));
            }
        }
    }

    public void removeAttribute(String name) {
        Object oldObject = this.getAttributeMap().remove(name);
        ServletContext servletContext = this.getServletContext();
        ServletEventListenerManager listenerManager = servletContext.getServletEventListenerManager();
        if (listenerManager.hasServletRequestAttributeListener()) {
            listenerManager.onServletRequestAttributeRemoved(new ServletRequestAttributeEvent((javax.servlet.ServletContext)servletContext, (ServletRequest)this, name, oldObject));
        }
    }

    public Locale getLocale() {
        Locale[] locales;
        if (this.locales == null) {
            this.decodeLocale();
        }
        if ((locales = this.locales) == null || locales.length == 0) {
            return null;
        }
        return locales[0];
    }

    public Enumeration<Locale> getLocales() {
        if (this.locales == null) {
            this.decodeLocale();
        }
        return new Enumeration<Locale>(){
            private int index = 0;

            @Override
            public boolean hasMoreElements() {
                return this.index < ServletHttpServletRequest.this.locales.length;
            }

            @Override
            public Locale nextElement() {
                Locale locale = ServletHttpServletRequest.this.locales[this.index];
                ++this.index;
                return locale;
            }
        };
    }

    public boolean isSecure() {
        return "https".equals(this.getScheme());
    }

    public ServletRequestDispatcher getRequestDispatcher(String path) {
        return this.getServletContext().getRequestDispatcher(path, this.getDispatcherType());
    }

    public String getRealPath(String path) {
        return this.getServletContext().getRealPath(path);
    }

    public String getLocalName() {
        return this.getServletContext().getServerAddress().getHostName();
    }

    public String getLocalAddr() {
        return this.getServletContext().getServerAddress().getAddress().getHostAddress();
    }

    public int getLocalPort() {
        return this.getServletContext().getServerAddress().getPort();
    }

    public ServletContext getServletContext() {
        return this.servletHttpExchange.getServletContext();
    }

    public ServletAsyncContext startAsync() throws IllegalStateException {
        return this.startAsync((ServletRequest)this, (ServletResponse)this.servletHttpExchange.getResponse());
    }

    public ServletAsyncContext startAsync(ServletRequest servletRequest, ServletResponse servletResponse) throws IllegalStateException {
        if (!this.isAsyncSupported()) {
            throw new IllegalStateException("Asynchronous is not supported");
        }
        ServletContext servletContext = this.getServletContext();
        if (this.asyncContext == null) {
            this.asyncContext = new ServletAsyncContext(this.servletHttpExchange, servletContext, servletContext.getAsyncExecutor());
            this.asyncContext.setTimeout(servletContext.getAsyncTimeout());
        }
        this.asyncContext.setServletRequest(servletRequest);
        this.asyncContext.setServletResponse(servletResponse);
        this.asyncContext.setStart();
        return this.asyncContext;
    }

    public boolean isAsyncStarted() {
        return this.asyncContext != null && this.asyncContext.isStarted();
    }

    public boolean isAsyncSupported() {
        if (this.asyncSupportedFlag == null) {
            return true;
        }
        return this.asyncSupportedFlag;
    }

    public ServletAsyncContext getAsyncContext() {
        return this.asyncContext;
    }

    public DispatcherType getDispatcherType() {
        if (this.dispatcherType == null) {
            return DispatcherType.REQUEST;
        }
        return this.dispatcherType;
    }

    public String getPathTranslated() {
        ServletContext servletContext = this.getServletContext();
        String contextPath = servletContext.getContextPath();
        if (contextPath == null || contextPath.isEmpty()) {
            return null;
        }
        String pathInfo = this.getPathInfo();
        if (pathInfo == null) {
            return null;
        }
        return servletContext.getRealPath(pathInfo);
    }

    public String getAuthType() {
        return null;
    }

    public String getRemoteUser() {
        Principal principal = this.getUserPrincipal();
        if (principal != null) {
            return principal.getName();
        }
        return null;
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public boolean authenticate(HttpServletResponse response) throws IOException, ServletException {
        return true;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public void login(String username, String password) throws ServletException {
    }

    public void logout() throws ServletException {
    }

    public Collection<Part> getParts() throws IOException, ServletException {
        if (this.decodeBodyFlag.compareAndSet(false, true)) {
            try {
                this.decodeBody();
            }
            catch (CodecException e) {
                ServletException servletException;
                Throwable cause = this.getCause(e);
                if (cause instanceof IOException) {
                    this.setAttribute("javax.servlet.error.status_code", 400);
                    this.setAttribute("javax.servlet.error.exception", cause);
                    throw (IOException)cause;
                }
                if (cause instanceof IllegalStateException) {
                    this.setAttribute("javax.servlet.error.status_code", 400);
                    this.setAttribute("javax.servlet.error.exception", cause);
                    throw (IllegalStateException)cause;
                }
                if (cause instanceof IllegalArgumentException) {
                    IllegalStateException illegalStateException = new IllegalStateException("HttpServletRequest.getParts() -> decodeFile() fail : " + cause.getMessage(), cause);
                    illegalStateException.setStackTrace(cause.getStackTrace());
                    this.setAttribute("javax.servlet.error.status_code", 400);
                    this.setAttribute("javax.servlet.error.exception", illegalStateException);
                    throw illegalStateException;
                }
                if (cause != null) {
                    servletException = new ServletException("HttpServletRequest.getParts() -> decodeFile() fail : " + cause.getMessage(), cause);
                    servletException.setStackTrace(cause.getStackTrace());
                } else {
                    servletException = new ServletException("HttpServletRequest.getParts() -> decodeFile() fail : " + e.getMessage(), (Throwable)e);
                    servletException.setStackTrace(e.getStackTrace());
                }
                this.setAttribute("javax.servlet.error.status_code", 400);
                this.setAttribute("javax.servlet.error.exception", (Object)servletException);
                throw servletException;
            }
            catch (IllegalArgumentException e) {
                IllegalStateException illegalStateException = new IllegalStateException("HttpServletRequest.getParts() -> decodeFile() fail : " + e.getMessage(), e);
                illegalStateException.setStackTrace(e.getStackTrace());
                this.setAttribute("javax.servlet.error.status_code", 400);
                this.setAttribute("javax.servlet.error.exception", illegalStateException);
                throw illegalStateException;
            }
        } else {
            this.getInputStream0().awaitDataIfNeed();
        }
        return this.fileUploadList;
    }

    private Throwable getCause(Throwable throwable) {
        Throwable cause;
        if (throwable.getCause() == null) {
            return null;
        }
        do {
            cause = throwable;
        } while ((throwable = throwable.getCause()) != null);
        return cause;
    }

    public Part getPart(String name) throws IOException, ServletException {
        for (Part part : this.getParts()) {
            if (!name.equals(part.getName())) continue;
            return part;
        }
        return null;
    }

    public <T extends HttpUpgradeHandler> T upgrade(Class<T> httpUpgradeHandlerClass) throws IOException, ServletException {
        try {
            HttpUpgradeHandler handler = (HttpUpgradeHandler)httpUpgradeHandlerClass.newInstance();
            return (T)handler;
        }
        catch (Exception e) {
            throw new ServletException(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public void recycle() {
        ServletHttpSession httpSession = this.servletHttpExchange.getHttpSession();
        if (httpSession != null) {
            if (httpSession.isValid()) {
                httpSession.save();
            } else {
                httpSession.remove();
            }
            httpSession.clear();
        }
        this.inputStream.recycle();
        if (!this.fileUploadList.isEmpty()) {
            for (Part part : this.fileUploadList) {
                try {
                    part.delete();
                }
                catch (IOException iOException) {}
            }
        }
        if (this.postRequestDecoder != null) {
            this.postRequestDecoder.destroy();
            this.postRequestDecoder = null;
        }
        if (this.servletHttpExchange.isAbort()) {
            return;
        }
        this.nettyRequest = null;
        this.decodeBodyFlag.set(false);
        this.decodeParameterByUrlFlag = false;
        this.remoteSchemeFlag = false;
        this.decodeCookieFlag = false;
        this.decodePathsFlag = false;
        this.usingInputStreamFlag = false;
        this.reader = null;
        this.sessionIdSource = null;
        this.remoteHost = null;
        this.serverName = null;
        this.serverPort = 0;
        this.protocol = null;
        this.scheme = null;
        this.servletPath = null;
        this.queryString = null;
        this.pathInfo = null;
        this.requestURI = null;
        this.characterEncoding = null;
        this.sessionId = null;
        this.cookies = null;
        this.locales = null;
        this.asyncContext = null;
        this.servletHttpExchange = null;
        this.multipartConfigElement = null;
        this.servletSecurityElement = null;
        this.dispatcherType = null;
        this.dispatcher = null;
        this.parameterMap.clear();
        this.fileUploadList.clear();
        this.attributeMap.clear();
        RECYCLER.recycleInstance(this);
    }
}

