/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet;

import com.github.netty.core.util.Recyclable;
import com.github.netty.core.util.Wrapper;
import com.github.netty.protocol.servlet.NettyOutputStream;
import com.github.netty.protocol.servlet.ServletOutputStream;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelProgressivePromise;
import io.netty.handler.stream.ChunkedInput;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.function.Consumer;
import javax.servlet.WriteListener;

public class ServletOutputStreamWrapper
extends javax.servlet.ServletOutputStream
implements Wrapper<ServletOutputStream>,
Recyclable,
NettyOutputStream {
    private ServletOutputStream source;
    private boolean suspendFlag = false;
    private ChannelFutureListener closeListener;

    public ServletOutputStreamWrapper(ChannelFutureListener closeListener) {
        this.closeListener = closeListener;
    }

    public void setSuspendFlag(boolean suspendFlag) {
        this.suspendFlag = suspendFlag;
    }

    public boolean isSuspendFlag() {
        return this.suspendFlag;
    }

    @Override
    public ChannelProgressivePromise write(ByteBuffer httpBody) throws IOException {
        return this.source.write(httpBody);
    }

    @Override
    public ChannelProgressivePromise write(ByteBuf httpBody) throws IOException {
        return this.source.write(httpBody);
    }

    @Override
    public ChannelProgressivePromise write(ChunkedInput httpBody) throws IOException {
        return this.source.write(httpBody);
    }

    @Override
    public ChannelProgressivePromise write(FileChannel fileChannel, long position, long count) throws IOException {
        return this.source.write(fileChannel, position, count);
    }

    @Override
    public ChannelProgressivePromise write(File file, long position, long count) throws IOException {
        return this.source.write(file, position, count);
    }

    @Override
    public ChannelProgressivePromise write(File file) throws IOException {
        return this.source.write(file);
    }

    public boolean isReady() {
        return this.source.isReady();
    }

    public void setWriteListener(WriteListener listener) {
        this.source.setWriteListener(listener);
    }

    public void write(int b) throws IOException {
        if (this.isSuspendFlag()) {
            return;
        }
        this.source.write(b);
    }

    @Override
    public void close() {
        if (this.isSuspendFlag()) {
            return;
        }
        this.source.close();
    }

    @Override
    public void flush() throws IOException {
        if (this.isSuspendFlag()) {
            return;
        }
        this.source.flush();
    }

    public void resetBuffer() {
        if (this.isSuspendFlag()) {
            return;
        }
        this.source.resetBuffer();
    }

    public void write(byte[] b, int off, int len) throws IOException {
        if (this.isSuspendFlag()) {
            return;
        }
        this.source.write(b, off, len);
    }

    public void write(byte[] b) throws IOException {
        if (this.isSuspendFlag()) {
            return;
        }
        this.source.write(b);
    }

    @Override
    public void wrap(ServletOutputStream source) {
        if (this.closeListener != null) {
            source.setCloseListener(this.closeListener);
        }
        this.source = source;
    }

    @Override
    public ServletOutputStream unwrap() {
        return this.source;
    }

    @Override
    public <T> void recycle(Consumer<T> consumer) {
        ServletOutputStream out = this.source;
        if (out != null) {
            this.source = null;
            out.recycle(consumer);
        } else {
            consumer.accept(null);
        }
        this.suspendFlag = false;
    }
}

