/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet.util;

import com.github.netty.protocol.servlet.util.AntPathMatcher;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import javax.servlet.DispatcherType;

public class FilterMapper<T> {
    private String rootPath;
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();
    private final Object lock = new Object();
    private Element<T>[] array = new Element[0];
    private int insertPoint = 0;

    public FilterMapper() {
        this.antPathMatcher.setCachePatterns(Boolean.TRUE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this.lock;
        synchronized (object) {
            this.array = new Element[0];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void add(Element filterMap) {
        Object object = this.lock;
        synchronized (object) {
            Element<T>[] results = Arrays.copyOf(this.array, this.array.length + 1);
            results[this.array.length] = filterMap;
            this.array = results;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addBefore(Element filterMap) {
        Object object = this.lock;
        synchronized (object) {
            Element[] results = new Element[this.array.length + 1];
            System.arraycopy(this.array, 0, results, 0, this.insertPoint);
            System.arraycopy(this.array, this.insertPoint, results, this.insertPoint + 1, this.array.length - this.insertPoint);
            results[this.insertPoint] = filterMap;
            this.array = results;
            ++this.insertPoint;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Element filterMap) {
        Object object = this.lock;
        synchronized (object) {
            int n = -1;
            for (int i = 0; i < this.array.length; ++i) {
                if (this.array[i] != filterMap) continue;
                n = i;
                break;
            }
            if (n < 0) {
                return;
            }
            Element[] results = new Element[this.array.length - 1];
            System.arraycopy(this.array, 0, results, 0, n);
            System.arraycopy(this.array, n + 1, results, n, this.array.length - 1 - n);
            this.array = results;
            if (n < this.insertPoint) {
                --this.insertPoint;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRootPath(String rootPath) {
        while (rootPath.startsWith("/")) {
            rootPath = rootPath.substring(1);
        }
        rootPath = "/" + rootPath;
        Object object = this.lock;
        synchronized (object) {
            Element[] newElements = new Element[this.array.length];
            for (int i = 0; i < this.array.length; ++i) {
                Element element;
                Element<T> source = this.array[i];
                newElements[i] = element = new Element(rootPath, source.originalPattern, source.object, source.objectName, source.dispatcherTypes);
            }
            this.rootPath = rootPath;
            this.array = newElements;
        }
    }

    public void addMapping(String urlPattern, T object, String objectName, boolean isMatchAfter, EnumSet<DispatcherType> dispatcherTypes) throws IllegalArgumentException {
        Objects.requireNonNull(urlPattern);
        Element<T> element = new Element<T>(this.rootPath, urlPattern, object, objectName, dispatcherTypes);
        if (isMatchAfter) {
            this.add(element);
        } else {
            this.addBefore(element);
        }
    }

    public String getServletPath(String absoluteUri) {
        String path = FilterMapper.normPath(absoluteUri);
        for (Element<T> element : this.array) {
            if (!this.antPathMatcher.match(element.pattern, path, "*")) continue;
            return element.servletPath;
        }
        return absoluteUri;
    }

    public static String normPath(String path) {
        if (path == null || path.isEmpty()) {
            return path;
        }
        while (path.startsWith("//")) {
            path = path.substring(1);
        }
        if (path.length() > 1 && !path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    public Element<T> getMappingObjectByUri(String absoluteUri) {
        String path = FilterMapper.normPath(absoluteUri);
        for (Element<T> element : this.array) {
            if (!this.antPathMatcher.match(element.pattern, path, "*")) continue;
            return element;
        }
        return null;
    }

    public void addMappingObjectsByUri(String absoluteUri, DispatcherType dispatcherType, List<Element<T>> list) {
        String path = FilterMapper.normPath(absoluteUri);
        for (Element<T> element : this.array) {
            if (element.dispatcherTypes != null && !element.dispatcherTypes.contains(dispatcherType) || !this.antPathMatcher.match(element.pattern, path, "*")) continue;
            list.add(element);
        }
    }

    public static void main(String[] args) {
        FilterMapper<String> urlMapper = new FilterMapper<String>();
        urlMapper.addMapping("/t/", "", "default", false, null);
        urlMapper.addMapping("/t/", "", "1", false, null);
        urlMapper.addMapping("/t/", "", "2", false, null);
        urlMapper.addMapping("/*", "", "3", false, null);
        urlMapper.addMapping("/*.do", "", "4", false, null);
        Element e1 = urlMapper.getMappingObjectByUri("/t/a/d");
        assert (Objects.equals("1", e1.objectName));
        Element e2 = urlMapper.getMappingObjectByUri("/a");
        assert (Objects.equals("3", e2.objectName));
    }

    public static class Element<T> {
        String pattern;
        String originalPattern;
        T object;
        String objectName;
        String servletPath;
        String rootPath;
        boolean wildcardPatternFlag;
        boolean allPatternFlag;
        boolean defaultFlag;
        EnumSet<DispatcherType> dispatcherTypes;

        public Element(String objectName, T object) {
            this.objectName = objectName;
            this.object = object;
        }

        public Element(String rootPath, String originalPattern, T object, String objectName, EnumSet<DispatcherType> dispatcherTypes) {
            this.dispatcherTypes = dispatcherTypes;
            this.allPatternFlag = "/".equals(originalPattern) || "/*".equals(originalPattern) || "*".equals(originalPattern) || "/**".equals(originalPattern);
            this.pattern = rootPath != null ? rootPath.concat(originalPattern) : originalPattern;
            if (this.pattern.endsWith("/")) {
                do {
                    this.pattern = this.pattern.substring(0, this.pattern.length() - 1);
                } while (this.pattern.endsWith("/"));
                this.pattern = this.pattern + "/*";
            }
            this.pattern = FilterMapper.normPath(this.pattern);
            this.rootPath = rootPath;
            this.originalPattern = originalPattern;
            this.object = object;
            this.objectName = objectName;
            StringJoiner joiner = new StringJoiner("/");
            String[] pattens = this.pattern.split("/");
            for (int i = 0; i < pattens.length; ++i) {
                String path = pattens[i];
                if (path.contains("*")) {
                    this.wildcardPatternFlag = true;
                    if (i == pattens.length - 1) continue;
                }
                joiner.add(path);
            }
            this.defaultFlag = "default".equals(this.objectName);
            this.servletPath = joiner.toString();
        }

        public EnumSet<DispatcherType> getDispatcherTypes() {
            return this.dispatcherTypes;
        }

        public T getObject() {
            return this.object;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public String getPattern() {
            return this.pattern;
        }

        public String getServletPath() {
            return this.servletPath;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public String toString() {
            return "Element{pattern='" + this.pattern + '\'' + ", objectName='" + this.objectName + '\'' + '}';
        }
    }
}

