/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet.util;

import com.github.netty.core.util.LinkedMultiValueMap;
import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.RecyclableUtil;
import com.github.netty.protocol.servlet.ServletHttpServletRequest;
import com.github.netty.protocol.servlet.ServletHttpServletResponse;
import com.github.netty.protocol.servlet.util.HttpHeaderConstants;
import io.netty.handler.codec.DateFormatter;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.RecyclableArrayList;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletRequest;
import javax.servlet.ServletRequestWrapper;
import javax.servlet.ServletResponse;
import javax.servlet.ServletResponseWrapper;
import javax.servlet.http.Cookie;

public class ServletUtil {
    private static final String EMPTY_STRING = "";
    private static final char SPACE = ' ';
    private static long lastTimestamp = System.currentTimeMillis();
    private static Date lastDate = new Date(lastTimestamp);
    private static String nowRFCTime = DateFormatter.format((Date)lastDate);
    private static final Cookie[] EMPTY_COOKIE = new Cookie[0];

    public static String getDateByRfcHttp() {
        long timestamp = System.currentTimeMillis();
        if (timestamp - lastTimestamp > 1000L) {
            lastTimestamp = timestamp;
            lastDate.setTime(timestamp);
            nowRFCTime = DateFormatter.format((Date)lastDate);
        }
        return nowRFCTime;
    }

    public static String date2string(long date) {
        return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date(date));
    }

    public static String getCookieValue(Cookie[] cookies, String cookieName) {
        if (cookies == null || cookieName == null) {
            return null;
        }
        for (Cookie cookie : cookies) {
            String name;
            if (cookie == null || !cookieName.equals(name = cookie.getName())) continue;
            return cookie.getValue();
        }
        return null;
    }

    public static void decodeByUrl(LinkedMultiValueMap<String, String> parameterMap, String uri, Charset charset) {
        StringBuilder buffer = RecyclableUtil.newStringBuilder();
        ServletUtil.decodeParams(parameterMap, uri, ServletUtil.findPathEndIndex(uri), charset, 10000, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void decodeByUrl(Map<String, String[]> sourceParameterMap, String uri, Charset charset) {
        LinkedMultiValueMap<String, String> parameterMap = RecyclableUtil.newLinkedMultiValueMap();
        try {
            ServletUtil.decodeByUrl(parameterMap, uri, charset);
            for (Map.Entry<String, List<String>> entry : parameterMap.entrySet()) {
                String[] values = sourceParameterMap.get(entry.getKey());
                List<String> newValueList = entry.getValue();
                if (values != null) {
                    Collections.addAll(newValueList, values);
                }
                sourceParameterMap.put(entry.getKey(), newValueList.toArray(new String[0]));
            }
        }
        finally {
            parameterMap.clear();
        }
    }

    public static String decodeCharacterEncoding(String contentType) {
        if (contentType == null) {
            return null;
        }
        int start = contentType.indexOf(HttpHeaderConstants.CHARSET + "=");
        if (start < 0) {
            return null;
        }
        String encoding = contentType.substring(start + 8);
        int end = encoding.indexOf(59);
        if (end >= 0) {
            encoding = encoding.substring(0, end);
        }
        if ((encoding = encoding.trim()).length() > 2 && encoding.startsWith("\"") && encoding.endsWith("\"")) {
            encoding = encoding.substring(1, encoding.length() - 1);
        }
        return encoding.trim();
    }

    public static String encodeCookie(String cookieName, String cookieValue, int maxAge, String path, String domain, boolean secure, boolean httpOnly) {
        StringBuilder buf = RecyclableUtil.newStringBuilder();
        buf.append(cookieName);
        buf.append('=');
        buf.append(cookieValue);
        buf.append(';');
        buf.append(' ');
        if (maxAge > 0) {
            buf.append(HttpHeaderConstants.MAX_AGE_1.toString());
            buf.append('=');
            buf.append(maxAge);
            buf.append(';');
            buf.append(' ');
        }
        if (path != null) {
            buf.append(HttpHeaderConstants.PATH.toString());
            buf.append('=');
            buf.append(path);
            buf.append(';');
            buf.append(' ');
        }
        if (domain != null) {
            buf.append(HttpHeaderConstants.DOMAIN.toString());
            buf.append('=');
            buf.append(domain);
            buf.append(';');
            buf.append(' ');
        }
        if (secure) {
            buf.append(HttpHeaderConstants.SECURE);
            buf.append(';');
            buf.append(' ');
        }
        if (httpOnly) {
            buf.append(HttpHeaderConstants.HTTPONLY);
            buf.append(';');
            buf.append(' ');
        }
        if (buf.length() > 0) {
            buf.setLength(buf.length() - 2);
        }
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Cookie[] decodeCookie(String header) {
        int headerLen = header.length();
        if (headerLen == 0) {
            return EMPTY_COOKIE;
        }
        RecyclableArrayList cookies = RecyclableUtil.newRecyclableList(2);
        try {
            int i = 0;
            boolean rfc2965Style = false;
            if (header.regionMatches(true, 0, "$Version", 0, 8)) {
                i = header.indexOf(59) + 1;
                rfc2965Style = true;
            }
            while (i != headerLen) {
                String value;
                int newNameEnd;
                int newNameStart;
                block22: {
                    char c = header.charAt(i);
                    if (c == '\t' || c == '\n' || c == '\u000b' || c == '\f' || c == '\r' || c == ' ' || c == ',' || c == ';') {
                        ++i;
                        continue;
                    }
                    newNameStart = i;
                    newNameEnd = i;
                    if (i == headerLen) {
                        value = null;
                    } else {
                        do {
                            char curChar;
                            if ((curChar = header.charAt(i)) == ';') {
                                newNameEnd = i;
                                value = null;
                                break block22;
                            }
                            if (curChar != '=') continue;
                            newNameEnd = i++;
                            if (i == headerLen) {
                                value = EMPTY_STRING;
                                break block22;
                            }
                            int newValueStart = i;
                            char c2 = header.charAt(i);
                            if (c2 == '\"') {
                                StringBuilder newValueBuf = RecyclableUtil.newStringBuilder();
                                char q = c2;
                                boolean hadBackslash = false;
                                ++i;
                                while (true) {
                                    if (i == headerLen) {
                                        value = newValueBuf.toString();
                                        break block22;
                                    }
                                    if (hadBackslash) {
                                        hadBackslash = false;
                                        if ((c2 = header.charAt(i++)) == '\\' || c2 == '\"') {
                                            newValueBuf.setCharAt(newValueBuf.length() - 1, c2);
                                            continue;
                                        }
                                        newValueBuf.append(c2);
                                        continue;
                                    }
                                    if ((c2 = header.charAt(i++)) == q) {
                                        value = newValueBuf.toString();
                                        break block22;
                                    }
                                    newValueBuf.append(c2);
                                    if (c2 != '\\') continue;
                                    hadBackslash = true;
                                }
                            }
                            int semiPos = header.indexOf(59, i);
                            if (semiPos > 0) {
                                value = header.substring(newValueStart, semiPos);
                                i = semiPos;
                            } else {
                                value = header.substring(newValueStart);
                                i = headerLen;
                            }
                            break block22;
                        } while (++i != headerLen);
                        newNameEnd = headerLen;
                        value = null;
                    }
                }
                if (rfc2965Style && (header.regionMatches(newNameStart, "$Path", 0, "$Path".length()) || header.regionMatches(newNameStart, "$Domain", 0, "$Domain".length()) || header.regionMatches(newNameStart, "$Port", 0, "$Port".length()))) continue;
                String name = header.substring(newNameStart, newNameEnd);
                try {
                    cookies.add((Object)new Cookie(name, value));
                }
                catch (IllegalArgumentException e) {
                    LoggerFactoryX.getLogger(ServletUtil.class).warn("discard cookie. cause = {}", (Object)e.toString());
                }
            }
            Cookie[] cookieArray = (Cookie[])cookies.toArray((Object[])EMPTY_COOKIE);
            return cookieArray;
        }
        finally {
            cookies.recycle();
        }
    }

    public static ServletHttpServletResponse unWrapper(ServletResponse response) {
        if (response instanceof ServletResponseWrapper) {
            return ServletUtil.unWrapper(((ServletResponseWrapper)response).getResponse());
        }
        if (response instanceof ServletHttpServletResponse) {
            return (ServletHttpServletResponse)response;
        }
        return null;
    }

    public static ServletHttpServletRequest unWrapper(ServletRequest request) {
        if (request instanceof ServletRequestWrapper) {
            return ServletUtil.unWrapper(((ServletRequestWrapper)request).getRequest());
        }
        if (request instanceof ServletHttpServletRequest) {
            return (ServletHttpServletRequest)request;
        }
        return null;
    }

    private static int findPathEndIndex(String uri) {
        int len = uri.length();
        for (int i = 0; i < len; ++i) {
            char c = uri.charAt(i);
            if (c != '?' && c != '#') continue;
            return i;
        }
        return len;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static void decodeParams(LinkedMultiValueMap<String, String> parameterMap, String s, int from, Charset charset, int paramsLimit, StringBuilder buffer) {
        int i;
        int len = s.length();
        if (from >= len) {
            return;
        }
        if (s.charAt(from) == '?') {
            ++from;
        }
        int nameStart = from;
        int valueStart = -1;
        block5: for (i = from; i < len; ++i) {
            switch (s.charAt(i)) {
                case '=': {
                    if (nameStart == i) {
                        nameStart = i + 1;
                        break;
                    }
                    if (valueStart >= nameStart) break;
                    valueStart = i + 1;
                    break;
                }
                case '&': 
                case ';': {
                    if (ServletUtil.addParam(s, nameStart, valueStart, i, parameterMap, charset, buffer) && --paramsLimit == 0) {
                        return;
                    }
                    nameStart = i + 1;
                    break;
                }
                case '#': {
                    break block5;
                }
            }
        }
        ServletUtil.addParam(s, nameStart, valueStart, i, parameterMap, charset, buffer);
    }

    private static boolean addParam(String s, int nameStart, int valueStart, int valueEnd, LinkedMultiValueMap<String, String> parameterMap, Charset charset, StringBuilder buffer) {
        if (nameStart >= valueEnd) {
            return false;
        }
        if (valueStart <= nameStart) {
            valueStart = valueEnd + 1;
        }
        String name = ServletUtil.decodeComponent(s, nameStart, valueStart - 1, charset, buffer);
        String value = ServletUtil.decodeComponent(s, valueStart, valueEnd, charset, buffer);
        parameterMap.add(name, value);
        return true;
    }

    private static String decodeComponent(String s, int from, int toExcluded, Charset charset, StringBuilder strBuf) {
        int len = toExcluded - from;
        if (len <= 0) {
            return EMPTY_STRING;
        }
        int firstEscaped = -1;
        for (int i = from; i < toExcluded; ++i) {
            char c = s.charAt(i);
            if (c != '%' && c != '+') continue;
            firstEscaped = i;
            break;
        }
        if (firstEscaped == -1) {
            return s.substring(from, toExcluded);
        }
        CharsetDecoder decoder = CharsetUtil.decoder((Charset)charset);
        int decodedCapacity = (toExcluded - firstEscaped) / 3;
        ByteBuffer byteBuf = ByteBuffer.allocate(decodedCapacity);
        CharBuffer charBuf = CharBuffer.allocate(decodedCapacity);
        Buffer byteBufHandler = (Buffer)Buffer.class.cast(byteBuf);
        Buffer charBufHandler = (Buffer)Buffer.class.cast(charBuf);
        strBuf.setLength(0);
        strBuf.append(s, from, firstEscaped);
        for (int i = firstEscaped; i < toExcluded; ++i) {
            char c = s.charAt(i);
            if (c != '%') {
                strBuf.append(c != '+' ? c : (char)' ');
                continue;
            }
            byteBufHandler.clear();
            do {
                if (i + 3 > toExcluded) {
                    throw new IllegalArgumentException("unterminated escape sequence at index " + i + " of: " + s);
                }
                byteBuf.put(ServletUtil.decodeHexByte(s, i + 1));
            } while ((i += 3) < toExcluded && s.charAt(i) == '%');
            --i;
            byteBufHandler.flip();
            charBufHandler.clear();
            CoderResult result = decoder.reset().decode(byteBuf, charBuf, true);
            try {
                if (!result.isUnderflow()) {
                    result.throwException();
                }
                if (!(result = decoder.flush(charBuf)).isUnderflow()) {
                    result.throwException();
                }
            }
            catch (CharacterCodingException ex) {
                throw new IllegalStateException(ex);
            }
            charBufHandler.flip();
            strBuf.append(charBuf);
        }
        return strBuf.toString();
    }

    private static byte decodeHexByte(CharSequence s, int pos) {
        int hi = ServletUtil.decodeHexNibble(s.charAt(pos));
        int lo = ServletUtil.decodeHexNibble(s.charAt(pos + 1));
        if (hi == -1 || lo == -1) {
            throw new IllegalArgumentException(String.format("invalid hex byte '%s' at index %d of '%s'", s.subSequence(pos, pos + 2), pos, s));
        }
        return (byte)((hi << 4) + lo);
    }

    private static int decodeHexNibble(char c) {
        if (c >= '0' && c <= '9') {
            return c - 48;
        }
        if (c >= 'A' && c <= 'F') {
            return c - 55;
        }
        if (c >= 'a' && c <= 'f') {
            return c - 87;
        }
        return -1;
    }
}

