/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet.util;

import com.github.netty.protocol.servlet.util.AntPathMatcher;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import java.util.TreeSet;

public class UrlMapper<T> {
    private int sort = 0;
    private String rootPath;
    private Collection<Element<T>> elementList = new TreeSet<Element<T>>();
    private final boolean singlePattern;
    private final AntPathMatcher antPathMatcher = new AntPathMatcher();
    private final Comparator<? super Element<T>> addSortComparator = (o1, o2) -> o1.addSort < o2.addSort ? -1 : 1;

    public UrlMapper(boolean singlePattern) {
        this.singlePattern = singlePattern;
        this.antPathMatcher.setCachePatterns(Boolean.TRUE);
    }

    public void clear() {
        this.elementList.clear();
    }

    public void setRootPath(String rootPath) {
        while (rootPath.startsWith("/")) {
            rootPath = rootPath.substring(1);
        }
        this.rootPath = rootPath = "/" + rootPath;
        TreeSet<Element<T>> elementList = new TreeSet<Element<T>>();
        for (Element<T> element : this.elementList) {
            elementList.add(new Element(rootPath, element.originalPattern, element.object, element.objectName, this.sort++));
        }
        this.elementList = elementList;
    }

    public void addMapping(String urlPattern, T object, String objectName) throws IllegalArgumentException {
        Objects.requireNonNull(urlPattern);
        Objects.requireNonNull(object);
        Objects.requireNonNull(objectName);
        Collection<Element<T>> elementList = this.elementList;
        for (Element<T> element : elementList) {
            if (!this.singlePattern || !element.objectName.equals(objectName)) continue;
            throw new IllegalArgumentException("The [" + objectName + "] mapping exist!");
        }
        elementList.add(new Element<T>(this.rootPath, urlPattern, object, objectName, this.sort++));
    }

    public void removeMapping(String objectName) {
        Iterator<Element<T>> it = this.elementList.iterator();
        while (it.hasNext()) {
            Element<T> element = it.next();
            if (!element.objectName.equals(objectName)) continue;
            it.remove();
        }
    }

    public String getServletPath(String absoluteUri) {
        String path = UrlMapper.normPath(absoluteUri);
        Collection<Element<T>> elementList = this.elementList;
        for (Element<T> element : elementList) {
            if (!this.antPathMatcher.match(element.pattern, path, "*")) continue;
            return element.servletPath;
        }
        return absoluteUri;
    }

    public Element<T> getMappingObjectByUri(String absoluteUri) {
        String path = UrlMapper.normPath(absoluteUri);
        Collection<Element<T>> elementList = this.elementList;
        for (Element<T> element : elementList) {
            if (!this.antPathMatcher.match(element.pattern, path, "*")) continue;
            return element;
        }
        return null;
    }

    public static String normPath(String path) {
        if (path == null || path.isEmpty()) {
            return path;
        }
        while (path.startsWith("//")) {
            path = path.substring(1);
        }
        if (path.length() > 1 && !path.startsWith("/")) {
            path = "/" + path;
        }
        return path;
    }

    public void addMappingObjectsByUri(String absoluteUri, List<Element<T>> list) {
        String path = UrlMapper.normPath(absoluteUri);
        Collection<Element<T>> elementList = this.elementList;
        for (Element<T> element : elementList) {
            if (!this.antPathMatcher.match(element.pattern, path, "*")) continue;
            list.add(element);
        }
        list.sort(this.addSortComparator);
    }

    public static void main(String[] args) {
        UrlMapper<String> urlMapper = new UrlMapper<String>(false);
        urlMapper.addMapping("/t/", "", "default");
        urlMapper.addMapping("/t/", "", "1");
        urlMapper.addMapping("/t/", "", "2");
        urlMapper.addMapping("/*", "", "3");
        urlMapper.addMapping("/*.do", "", "4");
        Element e1 = urlMapper.getMappingObjectByUri("/t/a/d");
        assert (Objects.equals("1", e1.objectName));
        Element e2 = urlMapper.getMappingObjectByUri("/a");
        assert (Objects.equals("3", e2.objectName));
    }

    public static class Element<T>
    implements Comparable<Element<T>> {
        String pattern;
        String originalPattern;
        T object;
        String objectName;
        String servletPath;
        String rootPath;
        boolean wildcardPatternFlag;
        boolean allPatternFlag;
        boolean defaultFlag;
        int sort;
        int addSort;
        int firstWildcardIndex = -1;

        public Element(String objectName, T object) {
            this.objectName = objectName;
            this.object = object;
        }

        public Element(String rootPath, String originalPattern, T object, String objectName, int addSort) {
            int i;
            this.addSort = addSort;
            this.allPatternFlag = "/".equals(originalPattern) || "/*".equals(originalPattern) || "*".equals(originalPattern) || "/**".equals(originalPattern);
            this.pattern = rootPath != null ? rootPath.concat(originalPattern) : originalPattern;
            if (this.pattern.endsWith("/")) {
                do {
                    this.pattern = this.pattern.substring(0, this.pattern.length() - 1);
                } while (this.pattern.endsWith("/"));
                this.pattern = this.pattern + "/*";
            }
            this.pattern = UrlMapper.normPath(this.pattern);
            this.rootPath = rootPath;
            this.originalPattern = originalPattern;
            this.object = object;
            this.objectName = objectName;
            StringJoiner joiner = new StringJoiner("/");
            String[] pattens = this.pattern.split("/");
            for (i = 0; i < pattens.length; ++i) {
                String path = pattens[i];
                if (path.contains("*")) {
                    this.wildcardPatternFlag = true;
                    if (i == pattens.length - 1) continue;
                }
                joiner.add(path);
            }
            this.defaultFlag = "default".equals(this.objectName);
            this.servletPath = joiner.toString();
            this.sort = this.defaultFlag ? 300 : (this.allPatternFlag ? 200 : 100);
            int find = 0;
            for (i = 0; i < originalPattern.length(); ++i) {
                char c = originalPattern.charAt(i);
                if (c == '/') continue;
                ++find;
                if (c != '*') continue;
                this.firstWildcardIndex = find;
                break;
            }
        }

        public int getFirstWildcardIndex() {
            return this.firstWildcardIndex;
        }

        public boolean isAllPatternFlag() {
            return this.allPatternFlag;
        }

        public boolean isWildcardPatternFlag() {
            return this.wildcardPatternFlag;
        }

        public T getObject() {
            return this.object;
        }

        public String getObjectName() {
            return this.objectName;
        }

        public String getPattern() {
            return this.pattern;
        }

        public String getServletPath() {
            return this.servletPath;
        }

        public boolean equals(Object obj) {
            return this == obj;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        public String toString() {
            return "Element{pattern='" + this.pattern + '\'' + ", objectName='" + this.objectName + '\'' + ", addSort=" + this.addSort + '}';
        }

        @Override
        public int compareTo(Element<T> o) {
            return this.sort < o.sort ? -1 : 1;
        }
    }
}

