/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.protocol.servlet.websocket;

import com.github.netty.protocol.servlet.websocket.WebSocketSession;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.DeploymentException;
import javax.websocket.Endpoint;
import javax.websocket.Extension;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import javax.websocket.server.ServerContainer;
import javax.websocket.server.ServerEndpointConfig;

public class WebSocketServerContainer
implements WebSocketContainer,
ServerContainer {
    private static final CloseReason AUTHENTICATED_HTTP_SESSION_CLOSED = new CloseReason((CloseReason.CloseCode)CloseReason.CloseCodes.VIOLATED_POLICY, "This connection was established under an authenticated HTTP session that has ended.");
    private final Map<Endpoint, Set<Session>> endpointSessionMap = new HashMap<Endpoint, Set<Session>>();
    private final Map<Session, Session> sessions = new ConcurrentHashMap<Session, Session>();
    private final Object endPointSessionMapLock = new Object();
    private final ConcurrentMap<String, Set<Session>> authenticatedSessions = new ConcurrentHashMap<String, Set<Session>>();
    private long defaultAsyncTimeout = -1L;
    private int maxBinaryMessageBufferSize = 8192;
    private int maxTextMessageBufferSize = 8192;
    private volatile long defaultMaxSessionIdleTimeout = 0L;

    public long getDefaultMaxSessionIdleTimeout() {
        return this.defaultMaxSessionIdleTimeout;
    }

    public void setDefaultMaxSessionIdleTimeout(long timeout) {
        this.defaultMaxSessionIdleTimeout = timeout;
    }

    public int getDefaultMaxBinaryMessageBufferSize() {
        return this.maxBinaryMessageBufferSize;
    }

    public void setDefaultMaxBinaryMessageBufferSize(int max) {
        this.maxBinaryMessageBufferSize = max;
    }

    public int getDefaultMaxTextMessageBufferSize() {
        return this.maxTextMessageBufferSize;
    }

    public void setDefaultMaxTextMessageBufferSize(int max) {
        this.maxTextMessageBufferSize = max;
    }

    public Set<Extension> getInstalledExtensions() {
        WsExtension deflate = new WsExtension("permessage-deflate");
        return Collections.singleton(deflate);
    }

    public long getDefaultAsyncSendTimeout() {
        return this.defaultAsyncTimeout;
    }

    public void setAsyncSendTimeout(long timeout) {
        this.defaultAsyncTimeout = timeout;
    }

    public Session connectToServer(Object endpoint, URI path) throws DeploymentException, IOException {
        return null;
    }

    public Session connectToServer(Class<?> annotatedEndpointClass, URI path) throws DeploymentException, IOException {
        return null;
    }

    public Session connectToServer(Endpoint endpoint, ClientEndpointConfig clientEndpointConfiguration, URI path) throws DeploymentException, IOException {
        return null;
    }

    public Session connectToServer(Class<? extends Endpoint> endpoint, ClientEndpointConfig clientEndpointConfiguration, URI path) throws DeploymentException, IOException {
        return null;
    }

    public void addEndpoint(Class<?> clazz) throws DeploymentException {
    }

    public void addEndpoint(ServerEndpointConfig sec) throws DeploymentException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerSession(Endpoint endpoint, WebSocketSession wsSession) {
        if (!wsSession.isOpen()) {
            return;
        }
        Object object = this.endPointSessionMapLock;
        synchronized (object) {
            Set<Session> wsSessions = this.endpointSessionMap.get(endpoint);
            if (wsSessions == null) {
                wsSessions = new HashSet<Session>();
                this.endpointSessionMap.put(endpoint, wsSessions);
            }
            wsSessions.add(wsSession);
        }
        this.sessions.put(wsSession, wsSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterSession(Endpoint endpoint, WebSocketSession wsSession) {
        Object object = this.endPointSessionMapLock;
        synchronized (object) {
            Set<Session> wsSessions = this.endpointSessionMap.get(endpoint);
            if (wsSessions != null) {
                wsSessions.remove(wsSession);
                if (wsSessions.isEmpty()) {
                    this.endpointSessionMap.remove(endpoint);
                }
            }
        }
        this.sessions.remove(wsSession);
    }

    public void registerAuthenticatedSession(WebSocketSession wsSession, String httpSessionId) {
        Set wsSessions = (Set)this.authenticatedSessions.get(httpSessionId);
        if (wsSessions == null) {
            wsSessions = Collections.newSetFromMap(new ConcurrentHashMap());
            this.authenticatedSessions.putIfAbsent(httpSessionId, wsSessions);
            wsSessions = (Set)this.authenticatedSessions.get(httpSessionId);
        }
        wsSessions.add(wsSession);
    }

    public void unregisterAuthenticatedSession(WebSocketSession wsSession, String httpSessionId) {
        Set wsSessions = (Set)this.authenticatedSessions.get(httpSessionId);
        if (wsSessions != null) {
            wsSessions.remove(wsSession);
        }
    }

    public void closeAuthenticatedSession(String httpSessionId) {
        Set wsSessions = (Set)this.authenticatedSessions.remove(httpSessionId);
        if (wsSessions != null && !wsSessions.isEmpty()) {
            for (Session wsSession : wsSessions) {
                try {
                    wsSession.close(AUTHENTICATED_HTTP_SESSION_CLOSED);
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Session> getOpenSessions(Endpoint endpoint) {
        HashSet<Session> result = new HashSet<Session>();
        Object object = this.endPointSessionMapLock;
        synchronized (object) {
            Set<Session> sessions = this.endpointSessionMap.get(endpoint);
            if (sessions != null) {
                result.addAll(sessions);
            }
        }
        return result;
    }

    public static class WsExtension
    implements Extension {
        private final String name;
        private final List<Extension.Parameter> parameters = new ArrayList<Extension.Parameter>();

        WsExtension(String name) {
            this.name = name;
        }

        public boolean equals(Object obj) {
            if (obj instanceof Extension) {
                return Objects.equals(this.name, ((Extension)obj).getName());
            }
            return false;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public void addParameter(String name, String value) {
            this.parameters.add(new WsExtensionParameter(name, value));
        }

        public String getName() {
            return this.name;
        }

        public List<Extension.Parameter> getParameters() {
            return this.parameters;
        }

        public static class WsExtensionParameter
        implements Extension.Parameter {
            private final String name;
            private final String value;

            WsExtensionParameter(String name, String value) {
                this.name = name;
                this.value = value;
            }

            public String getName() {
                return this.name;
            }

            public String getValue() {
                return this.value;
            }
        }
    }
}

