/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.springboot;

import com.github.netty.core.util.AbortPolicyWithReport;
import com.github.netty.core.util.ApplicationX;
import com.github.netty.core.util.NettyThreadPoolExecutor;
import com.github.netty.protocol.DynamicProtocolChannelHandler;
import com.github.netty.protocol.mysql.client.MysqlFrontendBusinessHandler;
import com.github.netty.protocol.mysql.server.MysqlBackendBusinessHandler;
import com.github.netty.protocol.servlet.util.HttpAbortPolicyWithReport;
import io.netty.handler.logging.LogLevel;
import io.netty.util.ResourceLeakDetector;
import java.io.File;
import java.io.Serializable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionHandler;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.context.properties.NestedConfigurationProperty;

@ConfigurationProperties(prefix="server.netty", ignoreUnknownFields=true)
public class NettyProperties
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int maxConnections = 10000;
    private boolean enableTcpPackageLog = false;
    private long firstClientPacketReadTimeoutMs = 800L;
    private LogLevel tcpPackageLogLevel = LogLevel.DEBUG;
    private int serverIoThreads = Math.max(Runtime.getRuntime().availableProcessors(), 4);
    private int serverIoRatio = 100;
    private boolean tcpNodelay = false;
    private int soRcvbuf = -1;
    private int soSndbuf = -1;
    private int soBacklog = 50;
    private ResourceLeakDetector.Level resourceLeakDetectorLevel = ResourceLeakDetector.Level.DISABLED;
    private Class<? extends DynamicProtocolChannelHandler> channelHandler = DynamicProtocolChannelHandler.class;
    @NestedConfigurationProperty
    private final HttpServlet httpServlet = new HttpServlet();
    @NestedConfigurationProperty
    private final Nrpc nrpc = new Nrpc();
    @NestedConfigurationProperty
    private final Mqtt mqtt = new Mqtt();
    @NestedConfigurationProperty
    private final Rtsp rtsp = new Rtsp();
    @NestedConfigurationProperty
    private final Mysql mysql = new Mysql();
    private final transient ApplicationX application = new ApplicationX();

    public ApplicationX getApplication() {
        return this.application;
    }

    public void setSoBacklog(int soBacklog) {
        this.soBacklog = soBacklog;
    }

    public int getSoBacklog() {
        return this.soBacklog;
    }

    public int getSoRcvbuf() {
        return this.soRcvbuf;
    }

    public void setSoRcvbuf(int soRcvbuf) {
        this.soRcvbuf = soRcvbuf;
    }

    public int getSoSndbuf() {
        return this.soSndbuf;
    }

    public void setSoSndbuf(int soSndbuf) {
        this.soSndbuf = soSndbuf;
    }

    public boolean isTcpNodelay() {
        return this.tcpNodelay;
    }

    public void setTcpNodelay(boolean tcpNodelay) {
        this.tcpNodelay = tcpNodelay;
    }

    public ResourceLeakDetector.Level getResourceLeakDetectorLevel() {
        return this.resourceLeakDetectorLevel;
    }

    public void setResourceLeakDetectorLevel(ResourceLeakDetector.Level resourceLeakDetectorLevel) {
        this.resourceLeakDetectorLevel = resourceLeakDetectorLevel;
    }

    public long getFirstClientPacketReadTimeoutMs() {
        return this.firstClientPacketReadTimeoutMs;
    }

    public void setFirstClientPacketReadTimeoutMs(long firstClientPacketReadTimeoutMs) {
        this.firstClientPacketReadTimeoutMs = firstClientPacketReadTimeoutMs;
    }

    public Class<? extends DynamicProtocolChannelHandler> getChannelHandler() {
        return this.channelHandler;
    }

    public void setChannelHandler(Class<? extends DynamicProtocolChannelHandler> channelHandler) {
        this.channelHandler = channelHandler;
    }

    public LogLevel getTcpPackageLogLevel() {
        return this.tcpPackageLogLevel;
    }

    public void setTcpPackageLogLevel(LogLevel tcpPackageLogLevel) {
        this.tcpPackageLogLevel = tcpPackageLogLevel;
    }

    public int getServerIoThreads() {
        return this.serverIoThreads;
    }

    public void setServerIoThreads(int serverIoThreads) {
        this.serverIoThreads = serverIoThreads;
    }

    public int getServerIoRatio() {
        return this.serverIoRatio;
    }

    public void setServerIoRatio(int serverIoRatio) {
        this.serverIoRatio = serverIoRatio;
    }

    public boolean isEnableTcpPackageLog() {
        return this.enableTcpPackageLog;
    }

    public void setEnableTcpPackageLog(boolean enableTcpPackageLog) {
        this.enableTcpPackageLog = enableTcpPackageLog;
    }

    public int getMaxConnections() {
        return this.maxConnections;
    }

    public void setMaxConnections(int maxConnections) {
        this.maxConnections = maxConnections;
    }

    public Nrpc getNrpc() {
        return this.nrpc;
    }

    public Mqtt getMqtt() {
        return this.mqtt;
    }

    public Rtsp getRtsp() {
        return this.rtsp;
    }

    public HttpServlet getHttpServlet() {
        return this.httpServlet;
    }

    public Mysql getMysql() {
        return this.mysql;
    }

    public static class MysqlProxyLog {
        private boolean enable = false;
        private int logFlushInterval = 5000;
        private String logFileName = "-packet.log";
        private String logPath = "${user.dir}/netty-mysql";

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public int getLogFlushInterval() {
            return this.logFlushInterval;
        }

        public void setLogFlushInterval(int logFlushInterval) {
            this.logFlushInterval = logFlushInterval;
        }

        public String getLogFileName() {
            return this.logFileName;
        }

        public void setLogFileName(String logFileName) {
            this.logFileName = logFileName;
        }

        public String getLogPath() {
            return this.logPath;
        }

        public void setLogPath(String logPath) {
            this.logPath = logPath;
        }
    }

    public static class Mysql {
        private boolean enabled = false;
        private int packetMaxLength = 0x1000000;
        private String mysqlHost = "localhost";
        private int mysqlPort = 3306;
        @NestedConfigurationProperty
        private final MysqlProxyLog proxyLog = new MysqlProxyLog();
        private Class<? extends MysqlBackendBusinessHandler> backendBusinessHandler = MysqlBackendBusinessHandler.class;
        private Class<? extends MysqlFrontendBusinessHandler> frontendBusinessHandler = MysqlFrontendBusinessHandler.class;

        public boolean isEnabled() {
            return this.enabled;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public MysqlProxyLog getProxyLog() {
            return this.proxyLog;
        }

        public int getPacketMaxLength() {
            return this.packetMaxLength;
        }

        public void setPacketMaxLength(int packetMaxLength) {
            this.packetMaxLength = packetMaxLength;
        }

        public String getMysqlHost() {
            return this.mysqlHost;
        }

        public void setMysqlHost(String mysqlHost) {
            this.mysqlHost = mysqlHost;
        }

        public int getMysqlPort() {
            return this.mysqlPort;
        }

        public void setMysqlPort(int mysqlPort) {
            this.mysqlPort = mysqlPort;
        }

        public Class<? extends MysqlFrontendBusinessHandler> getFrontendBusinessHandler() {
            return this.frontendBusinessHandler;
        }

        public Class<? extends MysqlBackendBusinessHandler> getBackendBusinessHandler() {
            return this.backendBusinessHandler;
        }

        public void setFrontendBusinessHandler(Class<? extends MysqlFrontendBusinessHandler> frontendBusinessHandler) {
            this.frontendBusinessHandler = frontendBusinessHandler;
        }

        public void setBackendBusinessHandler(Class<? extends MysqlBackendBusinessHandler> backendBusinessHandler) {
            this.backendBusinessHandler = backendBusinessHandler;
        }
    }

    public static class Rtsp {
    }

    public static class Mqtt {
        private boolean enabled = false;
        private int messageMaxLength = 8192;
        private int nettyReaderIdleTimeSeconds = 10;
        private int autoFlushIdleMs = 0;

        public int getMessageMaxLength() {
            return this.messageMaxLength;
        }

        public void setMessageMaxLength(int messageMaxLength) {
            this.messageMaxLength = messageMaxLength;
        }

        public int getNettyReaderIdleTimeSeconds() {
            return this.nettyReaderIdleTimeSeconds;
        }

        public void setNettyReaderIdleTimeSeconds(int nettyReaderIdleTimeSeconds) {
            this.nettyReaderIdleTimeSeconds = nettyReaderIdleTimeSeconds;
        }

        public int getAutoFlushIdleMs() {
            return this.autoFlushIdleMs;
        }

        public void setAutoFlushIdleMs(int autoFlushIdleMs) {
            this.autoFlushIdleMs = autoFlushIdleMs;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public boolean isEnabled() {
            return this.enabled;
        }
    }

    public static class Nrpc {
        private Codec codec = Codec.jdk;
        private int clientIoThreads = 0;
        private int clientIoRatio = 100;
        private int clientConnectTimeout = 1000;
        private int clientServerResponseTimeout = 1000;
        private int clientHeartIntervalTimeMs = -1;
        private boolean clientReconnectScheduledTaskEnable = false;
        private int clientReconnectScheduledIntervalMs = 5000;
        private boolean clientEnableHeartLog = false;
        private boolean clientMethodOverwriteCheck = false;
        private boolean serverMethodOverwriteCheck = true;
        private int serverMessageMaxLength = 0xA00000;
        private String clientDefaultVersion = "";
        private String serverDefaultVersion = "";
        @NestedConfigurationProperty
        private final ServerThreadPool threadPool = new ServerThreadPool();

        public Codec getCodec() {
            return this.codec;
        }

        public void setCodec(Codec codec) {
            this.codec = codec;
            if (codec != null) {
                System.setProperty("netty-nrpc.codec", codec.name());
            }
        }

        public ServerThreadPool getThreadPool() {
            return this.threadPool;
        }

        public boolean isClientReconnectScheduledTaskEnable() {
            return this.clientReconnectScheduledTaskEnable;
        }

        public void setClientReconnectScheduledTaskEnable(boolean clientReconnectScheduledTaskEnable) {
            this.clientReconnectScheduledTaskEnable = clientReconnectScheduledTaskEnable;
        }

        public String getServerDefaultVersion() {
            return this.serverDefaultVersion;
        }

        public void setClientReconnectScheduledIntervalMs(int clientReconnectScheduledIntervalMs) {
            this.clientReconnectScheduledIntervalMs = clientReconnectScheduledIntervalMs;
        }

        public int getClientReconnectScheduledIntervalMs() {
            return this.clientReconnectScheduledIntervalMs;
        }

        public void setServerDefaultVersion(String serverDefaultVersion) {
            this.serverDefaultVersion = serverDefaultVersion;
        }

        public int getClientServerResponseTimeout() {
            return this.clientServerResponseTimeout;
        }

        public void setClientServerResponseTimeout(int clientServerResponseTimeout) {
            this.clientServerResponseTimeout = clientServerResponseTimeout;
        }

        public boolean isServerMethodOverwriteCheck() {
            return this.serverMethodOverwriteCheck;
        }

        public void setServerMethodOverwriteCheck(boolean serverMethodOverwriteCheck) {
            this.serverMethodOverwriteCheck = serverMethodOverwriteCheck;
        }

        public boolean isClientMethodOverwriteCheck() {
            return this.clientMethodOverwriteCheck;
        }

        public void setClientMethodOverwriteCheck(boolean clientMethodOverwriteCheck) {
            this.clientMethodOverwriteCheck = clientMethodOverwriteCheck;
        }

        public int getClientHeartIntervalTimeMs() {
            return this.clientHeartIntervalTimeMs;
        }

        public void setClientHeartIntervalTimeMs(int clientHeartIntervalTimeMs) {
            this.clientHeartIntervalTimeMs = clientHeartIntervalTimeMs;
        }

        public int getClientConnectTimeout() {
            return this.clientConnectTimeout;
        }

        public void setClientConnectTimeout(int clientConnectTimeout) {
            this.clientConnectTimeout = clientConnectTimeout;
        }

        public String getClientDefaultVersion() {
            return this.clientDefaultVersion;
        }

        public void setClientDefaultVersion(String clientDefaultVersion) {
            this.clientDefaultVersion = clientDefaultVersion;
        }

        public int getClientIoThreads() {
            return this.clientIoThreads;
        }

        public void setClientIoThreads(int clientIoThreads) {
            this.clientIoThreads = clientIoThreads;
        }

        public int getClientIoRatio() {
            return this.clientIoRatio;
        }

        public void setClientIoRatio(int clientIoRatio) {
            this.clientIoRatio = clientIoRatio;
        }

        public boolean isClientEnableHeartLog() {
            return this.clientEnableHeartLog;
        }

        public void setClientEnableHeartLog(boolean clientEnableHeartLog) {
            this.clientEnableHeartLog = clientEnableHeartLog;
        }

        public int getServerMessageMaxLength() {
            return this.serverMessageMaxLength;
        }

        public void setServerMessageMaxLength(int serverMessageMaxLength) {
            this.serverMessageMaxLength = serverMessageMaxLength;
        }

        public static enum Codec {
            fastjson,
            jackson,
            jdk,
            auto;

        }

        public static class ServerThreadPool {
            private boolean enable = true;
            private Class<? extends ExecutorService> executor = NettyThreadPoolExecutor.class;
            private Class<? extends RejectedExecutionHandler> rejected = AbortPolicyWithReport.class;
            private int coreThreads = 2;
            private int maxThreads = 50;
            private int keepAliveSeconds = 180;
            private int queues = 0;
            private boolean fixed = false;
            private String poolName = "NettyX-nrpc";
            private String dumpPath = System.getProperty("user.home");

            public boolean isEnable() {
                return this.enable;
            }

            public void setEnable(boolean enable) {
                this.enable = enable;
            }

            public String getDumpPath() {
                return this.dumpPath;
            }

            public void setDumpPath(String dumpPath) {
                this.dumpPath = dumpPath;
            }

            public String getPoolName() {
                return this.poolName;
            }

            public void setPoolName(String poolName) {
                this.poolName = poolName;
            }

            public Class<? extends RejectedExecutionHandler> getRejected() {
                return this.rejected;
            }

            public void setRejected(Class<? extends RejectedExecutionHandler> rejected) {
                this.rejected = rejected;
            }

            public int getKeepAliveSeconds() {
                return this.keepAliveSeconds;
            }

            public void setKeepAliveSeconds(int keepAliveSeconds) {
                this.keepAliveSeconds = keepAliveSeconds;
            }

            public Class<? extends ExecutorService> getExecutor() {
                return this.executor;
            }

            public void setExecutor(Class<? extends ExecutorService> executor) {
                this.executor = executor;
            }

            public int getCoreThreads() {
                return this.coreThreads;
            }

            public void setCoreThreads(int coreThreads) {
                this.coreThreads = coreThreads;
            }

            public int getMaxThreads() {
                return this.maxThreads;
            }

            public void setMaxThreads(int maxThreads) {
                this.maxThreads = maxThreads;
            }

            public int getQueues() {
                return this.queues;
            }

            public void setQueues(int queues) {
                this.queues = queues;
            }

            public boolean isFixed() {
                return this.fixed;
            }

            public void setFixed(boolean fixed) {
                this.fixed = fixed;
            }
        }
    }

    public static class HttpServlet {
        private int autoFlushIdleMs = 0;
        private int requestMaxContentSize = 0x1400000;
        private int requestMaxHeaderLineSize = 40960;
        private int requestMaxHeaderSize = 81920;
        private int responseMaxBufferSize = 81920;
        private long uploadFileTimeoutMs = -1L;
        private String[] notExistBodyParameter = new String[]{"_method", "JSESSIONID"};
        @NestedConfigurationProperty
        private final ServerThreadPool threadPool = new ServerThreadPool();
        private boolean enablesLocalFileSession = false;
        private String sessionRemoteServerAddress;
        private int responseWriterChunkMaxHeapByteLength = 0;
        private File basedir;
        private boolean enableNsLookup = false;
        private boolean showExceptionMessage = true;
        private boolean startupFailExit = true;

        public boolean isStartupFailExit() {
            return this.startupFailExit;
        }

        public void setStartupFailExit(boolean startupFailExit) {
            this.startupFailExit = startupFailExit;
        }

        public String[] getNotExistBodyParameter() {
            return this.notExistBodyParameter;
        }

        public void setNotExistBodyParameter(String[] notExistBodyParameter) {
            this.notExistBodyParameter = notExistBodyParameter;
        }

        public boolean isShowExceptionMessage() {
            return this.showExceptionMessage;
        }

        public void setShowExceptionMessage(boolean showExceptionMessage) {
            this.showExceptionMessage = showExceptionMessage;
        }

        public int getAutoFlushIdleMs() {
            return this.autoFlushIdleMs;
        }

        public void setAutoFlushIdleMs(int autoFlushIdleMs) {
            this.autoFlushIdleMs = autoFlushIdleMs;
        }

        public long getUploadFileTimeoutMs() {
            return this.uploadFileTimeoutMs;
        }

        public void setUploadFileTimeoutMs(long uploadFileTimeoutMs) {
            this.uploadFileTimeoutMs = uploadFileTimeoutMs;
        }

        public ServerThreadPool getThreadPool() {
            return this.threadPool;
        }

        public int getResponseMaxBufferSize() {
            return this.responseMaxBufferSize;
        }

        public void setResponseMaxBufferSize(int responseMaxBufferSize) {
            this.responseMaxBufferSize = responseMaxBufferSize;
        }

        public boolean isEnableNsLookup() {
            return this.enableNsLookup;
        }

        public void setEnableNsLookup(boolean enableNsLookup) {
            this.enableNsLookup = enableNsLookup;
        }

        public int getRequestMaxContentSize() {
            return this.requestMaxContentSize;
        }

        public void setRequestMaxContentSize(int requestMaxContentSize) {
            this.requestMaxContentSize = requestMaxContentSize;
        }

        public int getRequestMaxHeaderLineSize() {
            return this.requestMaxHeaderLineSize;
        }

        public void setRequestMaxHeaderLineSize(int requestMaxHeaderLineSize) {
            this.requestMaxHeaderLineSize = requestMaxHeaderLineSize;
        }

        public int getRequestMaxHeaderSize() {
            return this.requestMaxHeaderSize;
        }

        public void setRequestMaxHeaderSize(int requestMaxHeaderSize) {
            this.requestMaxHeaderSize = requestMaxHeaderSize;
        }

        public boolean isEnablesLocalFileSession() {
            return this.enablesLocalFileSession;
        }

        public void setEnablesLocalFileSession(boolean enablesLocalFileSession) {
            this.enablesLocalFileSession = enablesLocalFileSession;
        }

        public String getSessionRemoteServerAddress() {
            return this.sessionRemoteServerAddress;
        }

        public void setSessionRemoteServerAddress(String sessionRemoteServerAddress) {
            this.sessionRemoteServerAddress = sessionRemoteServerAddress;
        }

        public int getResponseWriterChunkMaxHeapByteLength() {
            return this.responseWriterChunkMaxHeapByteLength;
        }

        public void setResponseWriterChunkMaxHeapByteLength(int responseWriterChunkMaxHeapByteLength) {
            this.responseWriterChunkMaxHeapByteLength = responseWriterChunkMaxHeapByteLength;
        }

        public File getBasedir() {
            return this.basedir;
        }

        public void setBasedir(File basedir) {
            this.basedir = basedir;
        }

        public static class ServerThreadPool {
            private boolean enable = false;
            private Class<? extends Executor> executor = NettyThreadPoolExecutor.class;
            private Class<? extends RejectedExecutionHandler> rejected = HttpAbortPolicyWithReport.class;
            private int coreThreads = 2;
            private int maxThreads = 50;
            private int keepAliveSeconds = 180;
            private int queues = 0;
            private boolean fixed = false;
            private String poolName = "NettyX-http";
            private String dumpPath = System.getProperty("user.home");

            public boolean isEnable() {
                return this.enable;
            }

            public void setEnable(boolean enable) {
                this.enable = enable;
            }

            public String getDumpPath() {
                return this.dumpPath;
            }

            public void setDumpPath(String dumpPath) {
                this.dumpPath = dumpPath;
            }

            public String getPoolName() {
                return this.poolName;
            }

            public void setPoolName(String poolName) {
                this.poolName = poolName;
            }

            public Class<? extends RejectedExecutionHandler> getRejected() {
                return this.rejected;
            }

            public void setRejected(Class<? extends RejectedExecutionHandler> rejected) {
                this.rejected = rejected;
            }

            public int getKeepAliveSeconds() {
                return this.keepAliveSeconds;
            }

            public void setKeepAliveSeconds(int keepAliveSeconds) {
                this.keepAliveSeconds = keepAliveSeconds;
            }

            public Class<? extends Executor> getExecutor() {
                return this.executor;
            }

            public void setExecutor(Class<? extends Executor> executor) {
                this.executor = executor;
            }

            public int getCoreThreads() {
                return this.coreThreads;
            }

            public void setCoreThreads(int coreThreads) {
                this.coreThreads = coreThreads;
            }

            public int getMaxThreads() {
                return this.maxThreads;
            }

            public void setMaxThreads(int maxThreads) {
                this.maxThreads = maxThreads;
            }

            public int getQueues() {
                return this.queues;
            }

            public void setQueues(int queues) {
                this.queues = queues;
            }

            public boolean isFixed() {
                return this.fixed;
            }

            public void setFixed(boolean fixed) {
                this.fixed = fixed;
            }
        }
    }
}

