/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.springboot.client;

import com.github.netty.annotation.NRpcMethod;
import com.github.netty.annotation.NRpcParam;
import com.github.netty.core.util.AnnotationMethodToMethodNameFunction;
import com.github.netty.core.util.AnnotationMethodToParameterNamesFunction;
import com.github.netty.core.util.ApplicationX;
import com.github.netty.core.util.Recyclable;
import com.github.netty.core.util.ReflectUtil;
import com.github.netty.core.util.StringUtil;
import com.github.netty.protocol.nrpc.RpcClient;
import com.github.netty.protocol.nrpc.RpcClientAop;
import com.github.netty.protocol.nrpc.RpcMethod;
import com.github.netty.protocol.nrpc.RpcServerChannelHandler;
import com.github.netty.protocol.nrpc.RpcServerInstance;
import com.github.netty.protocol.nrpc.exception.RpcConnectException;
import com.github.netty.springboot.NettyProperties;
import com.github.netty.springboot.client.NettyRpcFilter;
import com.github.netty.springboot.client.NettyRpcFullRequest;
import com.github.netty.springboot.client.NettyRpcLoadBalanced;
import com.github.netty.springboot.client.NettyRpcRequest;
import io.netty.util.concurrent.FastThreadLocal;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;

public class NettyRpcClientProxy
implements InvocationHandler {
    private String serviceName;
    private final String requestMappingName;
    private final Class<?> interfaceClass;
    private final String rpcInstanceKey;
    private final String version;
    private int timeout;
    private NettyProperties properties;
    private Supplier<NettyRpcLoadBalanced> loadBalancedSupplier;
    private final AnnotationMethodToParameterNamesFunction annotationMethodToParameterNamesFunction = new AnnotationMethodToParameterNamesFunction(NRpcParam.class, RequestParam.class, RequestBody.class, RequestHeader.class, PathVariable.class, CookieValue.class, RequestPart.class);
    private final AnnotationMethodToMethodNameFunction annotationMethodToMethodNameFunction = new AnnotationMethodToMethodNameFunction(NRpcMethod.class, RequestMapping.class);
    private static final Map<InetSocketAddress, RpcClient> CLIENT_MAP = new ConcurrentHashMap<InetSocketAddress, RpcClient>(64);
    private static final FastThreadLocal<DefaultNettyRpcRequest> REQUEST_THREAD_LOCAL = new FastThreadLocal<DefaultNettyRpcRequest>(){

        protected DefaultNettyRpcRequest initialValue() throws Exception {
            return new DefaultNettyRpcRequest();
        }
    };
    private static final FastThreadLocal<NettyRpcFilterChain> FILTER_CHAIN_THREAD_LOCAL = new FastThreadLocal<NettyRpcFilterChain>(){

        protected NettyRpcFilterChain initialValue() throws Exception {
            return new NettyRpcFilterChain();
        }
    };

    NettyRpcClientProxy(String serviceName, String requestMappingName, Class interfaceClass, NettyProperties properties, Supplier<NettyRpcLoadBalanced> loadBalancedSupplier) {
        this.serviceName = serviceName;
        this.interfaceClass = interfaceClass;
        this.properties = properties;
        this.loadBalancedSupplier = loadBalancedSupplier;
        this.requestMappingName = StringUtil.isEmpty(requestMappingName) ? this.getRequestMappingName(interfaceClass) : requestMappingName;
        this.version = RpcServerInstance.getVersion(interfaceClass, properties.getNrpc().getClientDefaultVersion());
        this.rpcInstanceKey = RpcClient.getClientInstanceKey(interfaceClass, this.requestMappingName, this.version);
        this.timeout = properties.getNrpc().getClientServerResponseTimeout();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        int parameterCount = method.getParameterCount();
        if (method.getDeclaringClass() == Object.class) {
            return method.invoke((Object)this, args);
        }
        if ("toString".equals(methodName) && parameterCount == 0) {
            return this.toString();
        }
        if ("hashCode".equals(methodName) && parameterCount == 0) {
            return this.hashCode();
        }
        if ("equals".equals(methodName) && parameterCount == 1) {
            return this.equals(args[0]);
        }
        NettyRpcFilterChain filterChain = (NettyRpcFilterChain)FILTER_CHAIN_THREAD_LOCAL.get();
        DefaultNettyRpcRequest request = (DefaultNettyRpcRequest)REQUEST_THREAD_LOCAL.get();
        DefaultNettyRpcRequest.access$202(request, args);
        request.method = method;
        request.proxy = proxy;
        request.timeout = this.timeout;
        request.clientProxy = this;
        try {
            InetSocketAddress address = this.chooseAddress(request);
            request.remoteAddress = address;
            RpcClient rpcClient = this.getClient(address);
            request.rpcClient = rpcClient;
            RpcClient.Sender sender = rpcClient.getRpcInstance(this.rpcInstanceKey);
            if (sender == null) {
                sender = rpcClient.newRpcInstance(this.interfaceClass, this.timeout, this.version, this.requestMappingName, this.annotationMethodToParameterNamesFunction, this.annotationMethodToMethodNameFunction, this.properties.getNrpc().isClientMethodOverwriteCheck());
            }
            request.sender = sender;
            filterChain.nettyRpcFilterList = this.getNettyRpcFilterList();
            filterChain.doFilter(request);
            Object object = request.getResponse();
            return object;
        }
        finally {
            request.recycle();
            filterChain.recycle();
        }
    }

    public List<NettyRpcFilter> getNettyRpcFilterList() {
        List<NettyRpcFilter> nettyRpcFilterList = this.properties.getApplication().getBeanForType(NettyRpcFilter.class);
        nettyRpcFilterList.sort((Comparator<NettyRpcFilter>)AnnotationAwareOrderComparator.INSTANCE);
        return nettyRpcFilterList;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        if (timeout > 0) {
            this.timeout = timeout;
        }
    }

    public AnnotationMethodToMethodNameFunction getAnnotationMethodToMethodNameFunction() {
        return this.annotationMethodToMethodNameFunction;
    }

    public AnnotationMethodToParameterNamesFunction getAnnotationMethodToParameterNamesFunction() {
        return this.annotationMethodToParameterNamesFunction;
    }

    public String getRequestMappingName(Class objectType) {
        String requestMappingName = RpcServerChannelHandler.getRequestMappingName(objectType);
        if (StringUtil.isNotEmpty(requestMappingName)) {
            return requestMappingName;
        }
        RequestMapping requestMapping = ReflectUtil.findAnnotation(objectType, RequestMapping.class);
        if (requestMapping != null) {
            requestMappingName = requestMapping.name();
            String[] values = requestMapping.value();
            String[] paths = requestMapping.path();
            if (StringUtil.isEmpty(requestMappingName) && values.length > 0) {
                requestMappingName = values[0];
            }
            if (StringUtil.isEmpty(requestMappingName) && paths.length > 0) {
                requestMappingName = paths[0];
            }
            if (StringUtil.isNotEmpty(requestMappingName)) {
                return requestMappingName;
            }
        }
        requestMappingName = RpcServerChannelHandler.generateRequestMappingName(objectType);
        return requestMappingName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RpcClient getClient(InetSocketAddress address) {
        RpcClient rpcClient = CLIENT_MAP.get(address);
        if (rpcClient == null) {
            Map<InetSocketAddress, RpcClient> map = CLIENT_MAP;
            synchronized (map) {
                rpcClient = CLIENT_MAP.get(address);
                if (rpcClient == null) {
                    NettyProperties.Nrpc nrpc = this.properties.getNrpc();
                    rpcClient = new RpcClient(address);
                    rpcClient.getAopList().addAll(this.properties.getApplication().getBeanForType(RpcClientAop.class));
                    rpcClient.setIoThreadCount(nrpc.getClientIoThreads());
                    rpcClient.setIoRatio(nrpc.getClientIoRatio());
                    rpcClient.setConnectTimeout(nrpc.getClientConnectTimeout());
                    rpcClient.setIdleTimeMs(nrpc.getClientHeartIntervalTimeMs());
                    rpcClient.setReconnectScheduledIntervalMs(nrpc.getClientReconnectScheduledIntervalMs());
                    rpcClient.setEnableRpcHeartLog(nrpc.isClientEnableHeartLog());
                    rpcClient.setEnableReconnectScheduledTask(nrpc.isClientReconnectScheduledTaskEnable());
                    CLIENT_MAP.put(address, rpcClient);
                }
            }
        }
        return rpcClient;
    }

    public InetSocketAddress chooseAddress(NettyRpcRequest request) {
        InetSocketAddress address;
        try {
            address = this.loadBalancedSupplier.get().chooseAddress(request);
        }
        catch (Exception e) {
            throw new RpcConnectException("Rpc Failed to select client address.  cause [" + e.getLocalizedMessage() + "]", e);
        }
        if (address == null) {
            throw new NullPointerException("Rpc Failed to select client address. cause [return address is null]");
        }
        return address;
    }

    public static NettyRpcRequest getRequest() {
        return (NettyRpcRequest)REQUEST_THREAD_LOCAL.get();
    }

    public static NettyRpcFilter.FilterChain getFilterChain() {
        return (NettyRpcFilter.FilterChain)FILTER_CHAIN_THREAD_LOCAL.get();
    }

    public static Map<InetSocketAddress, RpcClient> getClientMap() {
        return CLIENT_MAP;
    }

    public String getRequestMappingName() {
        return this.requestMappingName;
    }

    public String getVersion() {
        return this.version;
    }

    public Class<?> getInterfaceClass() {
        return this.interfaceClass;
    }

    public String getRpcInstanceKey() {
        return this.rpcInstanceKey;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public NettyProperties getProperties() {
        return this.properties;
    }

    public Supplier<NettyRpcLoadBalanced> getLoadBalancedSupplier() {
        return this.loadBalancedSupplier;
    }

    public void setLoadBalancedSupplier(Supplier<NettyRpcLoadBalanced> loadBalancedSupplier) {
        this.loadBalancedSupplier = loadBalancedSupplier;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String toString() {
        return "NettyRpcClientProxy{serviceName='" + this.serviceName + '\'' + ", requestMappingName='" + this.requestMappingName + '\'' + ", interfaceClass=" + this.interfaceClass + ", version='" + this.version + '\'' + ", timeout=" + this.timeout + '}';
    }

    private static class DefaultNettyRpcRequest
    implements NettyRpcFullRequest,
    Recyclable {
        private AtomicBoolean responseGetFlag = new AtomicBoolean(false);
        private Method method;
        private Object[] args;
        private NettyRpcClientProxy clientProxy;
        private int timeout;
        private Object proxy;
        private RpcClient rpcClient;
        private InetSocketAddress remoteAddress;
        private RpcClient.Sender sender;
        private volatile Object response;
        private volatile Throwable throwable;
        private volatile boolean doneFlag;

        private DefaultNettyRpcRequest() {
        }

        @Override
        public String getRpcInstanceKey() {
            return this.clientProxy.rpcInstanceKey;
        }

        @Override
        public NettyRpcClientProxy getClientProxy() {
            return this.clientProxy;
        }

        @Override
        public Supplier<NettyRpcLoadBalanced> getLoadBalancedSupplier() {
            return this.clientProxy.loadBalancedSupplier;
        }

        @Override
        public Object getProxy() {
            return this.proxy;
        }

        @Override
        public Method getMethod() {
            return this.method;
        }

        @Override
        public Object[] getArgs() {
            return this.args;
        }

        @Override
        public String getServiceName() {
            return this.clientProxy.serviceName;
        }

        @Override
        public String getRequestMappingName() {
            return this.clientProxy.requestMappingName;
        }

        @Override
        public String getVersion() {
            return this.clientProxy.version;
        }

        @Override
        public void setTimeout(int timeout) {
            this.timeout = timeout;
        }

        @Override
        public int getTimeout() {
            return this.timeout;
        }

        @Override
        public NettyProperties getNettyProperties() {
            return this.clientProxy.properties;
        }

        @Override
        public ApplicationX getApplication() {
            return this.clientProxy.properties.getApplication();
        }

        @Override
        public Map<InetSocketAddress, RpcClient> getClientMap() {
            return CLIENT_MAP;
        }

        @Override
        public Class getInterfaceClass() {
            return this.clientProxy.interfaceClass;
        }

        @Override
        public RpcClient getRpcClient() {
            return this.rpcClient;
        }

        @Override
        public RpcClient.Sender getSender() {
            return this.sender;
        }

        @Override
        public RpcMethod<RpcClient> getRpcMethod() {
            if (this.sender == null) {
                return null;
            }
            String rpcMethodName = RpcMethod.getMethodDescriptorName(this.method);
            return this.sender.getRpcMethodMap().get(rpcMethodName);
        }

        @Override
        public Map<String, RpcMethod<RpcClient>> getRpcMethodMap() {
            if (this.sender == null) {
                return null;
            }
            return this.sender.getRpcMethodMap();
        }

        @Override
        public InetSocketAddress getRemoteAddress() {
            return this.remoteAddress;
        }

        @Override
        public Object getResponse() throws Throwable {
            if (this.sender == null) {
                return null;
            }
            if (this.responseGetFlag.compareAndSet(false, true)) {
                this.sender.setTimeout(this.timeout);
                try {
                    this.response = this.sender.invoke(this.getProxy(), this.getMethod(), this.getArgs());
                }
                catch (Throwable t) {
                    this.throwable = t;
                    throw t;
                }
                finally {
                    this.doneFlag = true;
                }
            } else if (this.doneFlag) {
                if (this.throwable != null) {
                    throw this.throwable;
                }
            } else {
                throw new ConcurrentModificationException("other thread call getting response!");
            }
            return this.response;
        }

        @Override
        public void recycle() {
            this.args = null;
            this.method = null;
            this.clientProxy = null;
            this.proxy = null;
            this.remoteAddress = null;
            this.rpcClient = null;
            this.sender = null;
            this.response = null;
            this.throwable = null;
            this.doneFlag = false;
            this.responseGetFlag.set(false);
        }

        static /* synthetic */ Object[] access$202(DefaultNettyRpcRequest x0, Object[] x1) {
            x0.args = x1;
            return x1;
        }
    }

    private static class NettyRpcFilterChain
    implements NettyRpcFilter.FilterChain,
    Recyclable {
        private List<NettyRpcFilter> nettyRpcFilterList;
        private int count = 0;

        private NettyRpcFilterChain() {
        }

        @Override
        public void doFilter(NettyRpcFullRequest request) throws Throwable {
            if (this.count < this.nettyRpcFilterList.size()) {
                this.nettyRpcFilterList.get(this.count++).doFilter(request, this);
            }
        }

        @Override
        public List<NettyRpcFilter> getNettyRpcFilterList() {
            return Collections.unmodifiableList(this.nettyRpcFilterList);
        }

        @Override
        public void recycle() {
            this.count = 0;
            this.nettyRpcFilterList = null;
        }
    }
}

