/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.springboot.server;

import com.github.netty.core.AbstractNettyServer;
import com.github.netty.core.util.ApplicationX;
import com.github.netty.core.util.LoggerFactoryX;
import com.github.netty.core.util.LoggerX;
import com.github.netty.core.util.StringUtil;
import com.github.netty.protocol.HttpServletProtocol;
import com.github.netty.protocol.servlet.ServletContext;
import com.github.netty.protocol.servlet.ServletErrorPage;
import com.github.netty.protocol.servlet.SessionCompositeServiceImpl;
import com.github.netty.protocol.servlet.SessionLocalFileServiceImpl;
import com.github.netty.protocol.servlet.SessionLocalMemoryServiceImpl;
import com.github.netty.protocol.servlet.SessionService;
import com.github.netty.springboot.NettyProperties;
import com.github.netty.springboot.SpringUtil;
import com.github.netty.springboot.server.NettyTcpServerFactory;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.SslContextBuilder;
import java.lang.reflect.InvocationTargetException;
import java.net.InetSocketAddress;
import java.net.URL;
import java.security.KeyStore;
import java.util.Arrays;
import java.util.concurrent.Executor;
import java.util.function.Supplier;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.TrustManagerFactory;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryAware;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.boot.autoconfigure.web.ServerProperties;
import org.springframework.boot.autoconfigure.web.servlet.MultipartProperties;
import org.springframework.boot.web.server.Compression;
import org.springframework.boot.web.server.ErrorPage;
import org.springframework.boot.web.server.MimeMappings;
import org.springframework.boot.web.server.Ssl;
import org.springframework.boot.web.server.SslStoreProvider;
import org.springframework.boot.web.servlet.server.AbstractServletWebServerFactory;
import org.springframework.util.ClassUtils;
import org.springframework.util.ResourceUtils;

public class HttpServletProtocolSpringAdapter
extends HttpServletProtocol
implements BeanPostProcessor,
BeanFactoryAware {
    private static final LoggerX LOGGER = LoggerFactoryX.getLogger(HttpServletProtocol.class);
    private final NettyProperties properties;
    private final ApplicationX application;
    private BeanFactory beanFactory;
    private AbstractServletWebServerFactory webServerFactory;

    public HttpServletProtocolSpringAdapter(NettyProperties properties, ClassLoader classLoader, Supplier<Executor> executorSupplier, Supplier<Executor> defaultExecutorSupplier) {
        super(new ServletContext(classLoader == null ? ClassUtils.getDefaultClassLoader() : classLoader), executorSupplier, defaultExecutorSupplier);
        this.properties = properties;
        this.application = properties.getApplication();
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (SpringUtil.isSingletonBean(this.beanFactory, beanName)) {
            this.application.addSingletonBean(bean, beanName, false);
        }
        if (bean instanceof AbstractServletWebServerFactory && ((AbstractServletWebServerFactory)bean).getPort() > 0) {
            this.webServerFactory = (AbstractServletWebServerFactory)bean;
        }
        return bean;
    }

    @Override
    public <T extends AbstractNettyServer> void onServerStart(T server) throws Exception {
        super.onServerStart(server);
        ServletContext servletContext = this.getServletContext();
        this.application.addSingletonBean(servletContext);
        LOGGER.info("Netty servlet on port: {}, with context path '{}'", (Object)servletContext.getServerAddress().getPort(), (Object)servletContext.getContextPath());
    }

    private static Number getNumberBytes(Object object, String methodName) throws InvocationTargetException, IllegalAccessException {
        Object value = ClassUtils.getMethod(object.getClass(), (String)methodName, (Class[])new Class[0]).invoke(object, new Object[0]);
        if (!(value instanceof Number)) {
            value = ClassUtils.getMethod(value.getClass(), (String)"toBytes", (Class[])new Class[0]).invoke(value, new Object[0]);
        }
        return (Number)value;
    }

    @Override
    protected void configurableServletContext() throws Exception {
        if (this.webServerFactory == null) {
            return;
        }
        try {
            ServletContext servletContext = this.getServletContext();
            ServerProperties serverProperties = this.application.getBean(ServerProperties.class, null, false);
            MultipartProperties multipartProperties = this.application.getBean(MultipartProperties.class, null, false);
            InetSocketAddress address = NettyTcpServerFactory.getServerSocketAddress(this.webServerFactory.getAddress(), this.webServerFactory.getPort());
            servletContext.setServerAddress(address);
            servletContext.setEnableLookupFlag(this.properties.getHttpServlet().isEnableNsLookup());
            servletContext.setAutoFlush(this.properties.getHttpServlet().getAutoFlushIdleMs() > 0);
            servletContext.setUploadFileTimeoutMs(this.properties.getHttpServlet().getUploadFileTimeoutMs());
            servletContext.setContextPath(this.webServerFactory.getContextPath());
            servletContext.setServerHeader(this.webServerFactory.getServerHeader());
            servletContext.setServletContextName(this.webServerFactory.getDisplayName());
            servletContext.setResponseWriterChunkMaxHeapByteLength(this.properties.getHttpServlet().getResponseWriterChunkMaxHeapByteLength());
            servletContext.getErrorPageManager().setShowErrorMessage(this.properties.getHttpServlet().isShowExceptionMessage());
            servletContext.setSessionTimeout((int)this.webServerFactory.getSession().getTimeout().getSeconds());
            servletContext.setSessionService(this.newSessionService(this.properties, servletContext));
            for (MimeMappings.Mapping mapping : this.webServerFactory.getMimeMappings()) {
                servletContext.getMimeMappings().add(mapping.getExtension(), mapping.getMimeType());
            }
            servletContext.getNotExistBodyParameters().addAll(Arrays.asList(this.properties.getHttpServlet().getNotExistBodyParameter()));
            Compression compression = this.webServerFactory.getCompression();
            if (compression != null && compression.getEnabled()) {
                super.setEnableContentCompression(compression.getEnabled());
                super.setContentSizeThreshold(HttpServletProtocolSpringAdapter.getNumberBytes(compression, "getMinResponseSize").intValue());
                super.setCompressionMimeTypes((String[])compression.getMimeTypes().clone());
                super.setCompressionExcludedUserAgents(compression.getExcludedUserAgents());
            }
            if (serverProperties != null) {
                super.setMaxHeaderSize(HttpServletProtocolSpringAdapter.getNumberBytes(serverProperties, "getMaxHttpHeaderSize").intValue());
            }
            String location = null;
            if (multipartProperties != null && multipartProperties.getEnabled()) {
                Number maxRequestSize = HttpServletProtocolSpringAdapter.getNumberBytes(multipartProperties, "getMaxRequestSize");
                Number maxFileSize = HttpServletProtocolSpringAdapter.getNumberBytes(multipartProperties, "getMaxFileSize");
                Number fileSizeThreshold = HttpServletProtocolSpringAdapter.getNumberBytes(multipartProperties, "getFileSizeThreshold");
                super.setMaxChunkSize(maxRequestSize.longValue());
                super.setMaxContentLength(maxFileSize.longValue());
                servletContext.setUploadMinSize(fileSizeThreshold.longValue());
                location = multipartProperties.getLocation();
            }
            if (location != null && !location.isEmpty()) {
                servletContext.setDocBase(location, "");
            } else {
                servletContext.setDocBase(this.webServerFactory.getDocumentRoot().getAbsolutePath());
            }
            for (ErrorPage errorPage : this.webServerFactory.getErrorPages()) {
                ServletErrorPage servletErrorPage = new ServletErrorPage(errorPage.getStatusCode(), errorPage.getException(), errorPage.getPath());
                servletContext.getErrorPageManager().add(servletErrorPage);
            }
            Ssl ssl = this.webServerFactory.getSsl();
            if (ssl != null && ssl.isEnabled()) {
                SslStoreProvider sslStoreProvider = this.webServerFactory.getSslStoreProvider();
                KeyManagerFactory keyManagerFactory = this.getKeyManagerFactory(ssl, sslStoreProvider);
                SslContextBuilder sslContextBuilder = this.getSslContext(keyManagerFactory, ssl, sslStoreProvider);
                super.setSslContextBuilder(sslContextBuilder);
            }
        }
        catch (Exception e) {
            BeanInitializationException exception = new BeanInitializationException(e.getMessage(), (Throwable)e);
            exception.setStackTrace(e.getStackTrace());
            throw exception;
        }
    }

    protected SessionService newSessionService(NettyProperties properties, ServletContext servletContext) {
        SessionService sessionService;
        if (StringUtil.isNotEmpty(properties.getHttpServlet().getSessionRemoteServerAddress())) {
            InetSocketAddress address;
            String remoteSessionServerAddress = properties.getHttpServlet().getSessionRemoteServerAddress();
            if (remoteSessionServerAddress.contains(":")) {
                String[] addressArr = remoteSessionServerAddress.split(":");
                address = new InetSocketAddress(addressArr[0], Integer.parseInt(addressArr[1]));
            } else {
                address = new InetSocketAddress(remoteSessionServerAddress, 80);
            }
            SessionCompositeServiceImpl compositeSessionService = new SessionCompositeServiceImpl();
            compositeSessionService.enableRemoteRpcSession(address, 80, 1, properties.getNrpc().isClientEnableHeartLog(), properties.getNrpc().getClientHeartIntervalTimeMs(), properties.getNrpc().getClientReconnectScheduledIntervalMs());
            sessionService = compositeSessionService;
        } else {
            sessionService = properties.getHttpServlet().isEnablesLocalFileSession() ? new SessionLocalFileServiceImpl(servletContext.getResourceManager()) : new SessionLocalMemoryServiceImpl();
        }
        return sessionService;
    }

    protected SslContextBuilder getSslContext(KeyManagerFactory keyManagerFactory, Ssl ssl, SslStoreProvider sslStoreProvider) throws Exception {
        SslContextBuilder builder = SslContextBuilder.forServer((KeyManagerFactory)keyManagerFactory);
        builder.trustManager(this.getTrustManagerFactory(ssl, sslStoreProvider));
        if (ssl.getEnabledProtocols() != null) {
            builder.protocols(ssl.getEnabledProtocols());
        }
        if (ssl.getCiphers() != null) {
            builder.ciphers(Arrays.asList(ssl.getCiphers()));
        }
        if (ssl.getClientAuth() == Ssl.ClientAuth.NEED) {
            builder.clientAuth(ClientAuth.REQUIRE);
        } else if (ssl.getClientAuth() == Ssl.ClientAuth.WANT) {
            builder.clientAuth(ClientAuth.OPTIONAL);
        }
        ApplicationProtocolConfig protocolConfig = new ApplicationProtocolConfig(ApplicationProtocolConfig.Protocol.ALPN, ApplicationProtocolConfig.SelectorFailureBehavior.NO_ADVERTISE, ApplicationProtocolConfig.SelectedListenerFailureBehavior.ACCEPT, new String[]{"h2", "http/1.1"});
        builder.applicationProtocolConfig(protocolConfig);
        return builder;
    }

    protected TrustManagerFactory getTrustManagerFactory(Ssl ssl, SslStoreProvider sslStoreProvider) throws Exception {
        KeyStore store = sslStoreProvider != null ? sslStoreProvider.getTrustStore() : this.loadKeyStore(ssl.getTrustStoreType(), ssl.getTrustStoreProvider(), ssl.getTrustStore(), ssl.getTrustStorePassword());
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(store);
        return trustManagerFactory;
    }

    protected KeyManagerFactory getKeyManagerFactory(Ssl ssl, SslStoreProvider sslStoreProvider) throws Exception {
        char[] keyPassword;
        KeyStore keyStore = sslStoreProvider != null ? sslStoreProvider.getKeyStore() : this.loadKeyStore(ssl.getKeyStoreType(), ssl.getKeyStoreProvider(), ssl.getKeyStore(), ssl.getKeyStorePassword());
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
        char[] cArray = keyPassword = ssl.getKeyPassword() != null ? ssl.getKeyPassword().toCharArray() : null;
        if (keyPassword == null && ssl.getKeyStorePassword() != null) {
            keyPassword = ssl.getKeyStorePassword().toCharArray();
        }
        keyManagerFactory.init(keyStore, keyPassword);
        return keyManagerFactory;
    }

    protected KeyStore loadKeyStore(String type, String provider, String resource, String password) throws Exception {
        if (resource == null) {
            return null;
        }
        type = type != null ? type : "JKS";
        KeyStore store = provider != null ? KeyStore.getInstance(type, provider) : KeyStore.getInstance(type);
        URL url = ResourceUtils.getURL((String)resource);
        store.load(url.openStream(), password == null ? null : password.toCharArray());
        return store;
    }

    public void setBeanFactory(BeanFactory beanFactory) throws BeansException {
        this.beanFactory = beanFactory;
    }
}

