/*
 * Decompiled with CFR 0.152.
 */
package com.github.netty.springboot.server;

import com.github.netty.annotation.NRpcParam;
import com.github.netty.annotation.NRpcService;
import com.github.netty.core.AbstractNettyServer;
import com.github.netty.core.util.AnnotationMethodToParameterNamesFunction;
import com.github.netty.core.util.ApplicationX;
import com.github.netty.core.util.ClassFileMethodToParameterNamesFunction;
import com.github.netty.core.util.ReflectUtil;
import com.github.netty.core.util.StringUtil;
import com.github.netty.protocol.NRpcProtocol;
import java.lang.reflect.Method;
import java.util.List;
import java.util.function.Function;
import org.springframework.web.bind.annotation.CookieValue;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestHeader;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RequestPart;

public class NRpcProtocolSpringAdapter
extends NRpcProtocol {
    private final ClassFileMethodToParameterNamesFunction classFileMethodToParameterNamesFunction = new ClassFileMethodToParameterNamesFunction();
    private final AnnotationMethodToParameterNamesFunction annotationMethodToParameterNamesFunction = new AnnotationMethodToParameterNamesFunction(NRpcParam.class, RequestParam.class, RequestBody.class, RequestHeader.class, PathVariable.class, CookieValue.class, RequestPart.class);

    public NRpcProtocolSpringAdapter(ApplicationX application) {
        super(application);
    }

    @Override
    public <T extends AbstractNettyServer> void onServerStart(T server) throws Exception {
        List list = super.getApplication().getBeanForAnnotation(NRpcService.class);
        this.getAnnotationMethodToMethodNameFunction().getMethodNameAnnotationClasses().add(RequestMapping.class);
        for (Object serviceImpl : list) {
            if (super.existInstance(serviceImpl)) continue;
            RequestMapping requestMapping = this.getRequestMapping(serviceImpl);
            if (requestMapping != null) {
                String requestMappingName = this.getRequestMappingName(requestMapping);
                Function<Method, String[]> methodToParameterNamesFunction = this.getMethodToParameterNamesFunction(serviceImpl);
                super.addInstance(serviceImpl, requestMappingName, methodToParameterNamesFunction);
                continue;
            }
            super.addInstance(serviceImpl);
        }
        super.onServerStart(server);
    }

    protected Function<Method, String[]> getMethodToParameterNamesFunction(Object serviceImpl) {
        if (ReflectUtil.hasParameterAnnotation(serviceImpl.getClass(), this.annotationMethodToParameterNamesFunction.getParameterAnnotationClasses())) {
            return this.annotationMethodToParameterNamesFunction;
        }
        return this.classFileMethodToParameterNamesFunction;
    }

    protected String getRequestMappingName(RequestMapping requestMapping) {
        String requestMappingName = requestMapping.name();
        String[] values = requestMapping.value();
        String[] paths = requestMapping.path();
        if (StringUtil.isEmpty(requestMappingName) && values.length > 0) {
            requestMappingName = values[0];
        }
        if (StringUtil.isEmpty(requestMappingName) && paths.length > 0) {
            requestMappingName = paths[0];
        }
        if (StringUtil.isEmpty(requestMappingName)) {
            throw new IllegalArgumentException("RequestMapping isEmpty!");
        }
        return requestMappingName;
    }

    public AnnotationMethodToParameterNamesFunction getAnnotationMethodToParameterNamesFunction() {
        return this.annotationMethodToParameterNamesFunction;
    }

    protected RequestMapping getRequestMapping(Object serviceImpl) {
        Class annotationOnClass = ReflectUtil.findClassByAnnotation(serviceImpl.getClass(), RequestMapping.class);
        if (annotationOnClass == null) {
            return null;
        }
        return annotationOnClass.getDeclaredAnnotation(RequestMapping.class);
    }
}

