/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.epoll;

import com.github.netty.core.TcpChannel;
import com.github.netty.core.util.LoggerX;
import io.netty.channel.ChannelOutboundBuffer;
import io.netty.channel.EventLoop;
import io.netty.channel.SingleThreadEventLoop;
import io.netty.channel.epoll.AbstractEpollChannel;
import io.netty.channel.epoll.Native;

public class EpollChannelReportRunnable
implements Runnable {
    private LoggerX logger;

    public EpollChannelReportRunnable(LoggerX logger) {
        this.logger = logger;
    }

    @Override
    public void run() {
        if (!TcpChannel.getChannels().values().isEmpty()) {
            for (TcpChannel ctx : TcpChannel.getChannels().values()) {
                AbstractEpollChannel channel = (AbstractEpollChannel)ctx.getChannel();
                boolean isFlushPending = channel.isFlagSet(Native.EPOLLOUT);
                ChannelOutboundBuffer outboundBuffer = ctx.getChannel().unsafe().outboundBuffer();
                long totalPendingWriteBytes = outboundBuffer == null ? 0L : outboundBuffer.totalPendingWriteBytes();
                EventLoop eventLoop = ctx.getChannel().eventLoop();
                boolean inEventLoop = eventLoop.inEventLoop();
                int pendingTasks = ((SingleThreadEventLoop)ctx.getChannel().eventLoop()).pendingTasks();
                this.logger.info("remote = {}, isFlushPending = {}, totalPendingWriteBytes = {}/B, eventLoop = {}, pendingTasks = {}", ctx.getChannel().remoteAddress(), isFlushPending, totalPendingWriteBytes, eventLoop, pendingTasks);
            }
            this.logger.info("-----------------------");
        }
    }
}

