/*
 * Decompiled with CFR 0.152.
 */
package javax.servlet.http;

import java.text.MessageFormat;
import java.util.BitSet;

class CookieNameValidator {
    protected final BitSet allowed = new BitSet(128);

    protected CookieNameValidator(String separators) {
        this.allowed.set(32, 127);
        for (int i = 0; i < separators.length(); ++i) {
            char ch = separators.charAt(i);
            this.allowed.clear(ch);
        }
    }

    void validate(String name) {
        if (name == null || name.length() == 0) {
            throw new IllegalArgumentException("Cookie name may not be null or zero length");
        }
        if (!this.isToken(name)) {
            throw new IllegalArgumentException(MessageFormat.format("Cookie name [{0}] is a reserved token", name));
        }
    }

    private boolean isToken(String possibleToken) {
        int len = possibleToken.length();
        for (int i = 0; i < len; ++i) {
            char c = possibleToken.charAt(i);
            if (this.allowed.get(c)) continue;
            return false;
        }
        return true;
    }
}

