/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.contrib.apache.httpclient.notification;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.wechat.pay.contrib.apache.httpclient.auth.Verifier;
import com.wechat.pay.contrib.apache.httpclient.exception.ParseException;
import com.wechat.pay.contrib.apache.httpclient.exception.ValidationException;
import com.wechat.pay.contrib.apache.httpclient.notification.Notification;
import com.wechat.pay.contrib.apache.httpclient.notification.Request;
import com.wechat.pay.contrib.apache.httpclient.util.AesUtil;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.GeneralSecurityException;

public class NotificationHandler {
    private final Verifier verifier;
    private final byte[] apiV3Key;
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public NotificationHandler(Verifier verifier, byte[] apiV3Key) {
        if (verifier == null) {
            throw new IllegalArgumentException("verifier\u4e3a\u7a7a");
        }
        if (apiV3Key == null || apiV3Key.length == 0) {
            throw new IllegalArgumentException("apiV3Key\u4e3a\u7a7a");
        }
        this.verifier = verifier;
        this.apiV3Key = apiV3Key;
    }

    public Notification parse(Request request) throws ValidationException, ParseException {
        this.validate(request);
        return this.parseBody(request.getBody());
    }

    private void validate(Request request) throws ValidationException {
        if (request == null) {
            throw new ValidationException("request\u4e3a\u7a7a");
        }
        String serialNumber = request.getSerialNumber();
        byte[] message = request.getMessage();
        String signature = request.getSignature();
        if (serialNumber == null || serialNumber.isEmpty()) {
            throw new ValidationException("serialNumber\u4e3a\u7a7a");
        }
        if (message == null || message.length == 0) {
            throw new ValidationException("message\u4e3a\u7a7a");
        }
        if (signature == null || signature.isEmpty()) {
            throw new ValidationException("signature\u4e3a\u7a7a");
        }
        if (!this.verifier.verify(serialNumber, message, signature)) {
            String errorMessage = String.format("\u9a8c\u7b7e\u5931\u8d25\uff1aserial=[%s] message=[%s] sign=[%s]", serialNumber, new String(message), signature);
            throw new ValidationException(errorMessage);
        }
    }

    private Notification parseBody(String body) throws ParseException {
        Notification notification;
        ObjectReader objectReader = objectMapper.reader();
        try {
            notification = (Notification)objectReader.readValue(body, Notification.class);
        }
        catch (IOException ioException) {
            throw new ParseException("\u89e3\u6790body\u5931\u8d25\uff0cbody:" + body, ioException);
        }
        this.validateNotification(notification);
        this.setDecryptData(notification);
        return notification;
    }

    private void validateNotification(Notification notification) throws ParseException {
        if (notification == null) {
            throw new ParseException("body\u89e3\u6790\u4e3a\u7a7a");
        }
        String id = notification.getId();
        if (id == null || id.isEmpty()) {
            throw new ParseException("body\u4e0d\u5408\u6cd5\uff0cid\u4e3a\u7a7a\u3002body\uff1a" + notification.toString());
        }
        String createTime = notification.getCreateTime();
        if (createTime == null || createTime.isEmpty()) {
            throw new ParseException("body\u4e0d\u5408\u6cd5\uff0ccreateTime\u4e3a\u7a7a\u3002body\uff1a" + notification.toString());
        }
        String eventType = notification.getEventType();
        if (eventType == null || eventType.isEmpty()) {
            throw new ParseException("body\u4e0d\u5408\u6cd5\uff0ceventType\u4e3a\u7a7a\u3002body\uff1a" + notification.toString());
        }
        String summary = notification.getSummary();
        if (summary == null || summary.isEmpty()) {
            throw new ParseException("body\u4e0d\u5408\u6cd5\uff0csummary\u4e3a\u7a7a\u3002body\uff1a" + notification.toString());
        }
        String resourceType = notification.getResourceType();
        if (resourceType == null || resourceType.isEmpty()) {
            throw new ParseException("body\u4e0d\u5408\u6cd5\uff0cresourceType\u4e3a\u7a7a\u3002body\uff1a" + notification.toString());
        }
        Notification.Resource resource = notification.getResource();
        if (resource == null) {
            throw new ParseException("body\u4e0d\u5408\u6cd5\uff0cresource\u4e3a\u7a7a\u3002notification\uff1a" + notification.toString());
        }
        String algorithm = resource.getAlgorithm();
        if (algorithm == null || algorithm.isEmpty()) {
            throw new ParseException("body\u4e0d\u5408\u6cd5\uff0calgorithm\u4e3a\u7a7a\u3002body\uff1a" + notification.toString());
        }
        String originalType = resource.getOriginalType();
        if (originalType == null || originalType.isEmpty()) {
            throw new ParseException("body\u4e0d\u5408\u6cd5\uff0coriginal_type\u4e3a\u7a7a\u3002body\uff1a" + notification.toString());
        }
        String ciphertext = resource.getCiphertext();
        if (ciphertext == null || ciphertext.isEmpty()) {
            throw new ParseException("body\u4e0d\u5408\u6cd5\uff0cciphertext\u4e3a\u7a7a\u3002body\uff1a" + notification.toString());
        }
        String nonce = resource.getNonce();
        if (nonce == null || nonce.isEmpty()) {
            throw new ParseException("body\u4e0d\u5408\u6cd5\uff0cnonce\u4e3a\u7a7a\u3002body\uff1a" + notification.toString());
        }
    }

    private void setDecryptData(Notification notification) throws ParseException {
        String decryptData;
        Notification.Resource resource = notification.getResource();
        String getAssociateddData = "";
        if (resource.getAssociatedData() != null) {
            getAssociateddData = resource.getAssociatedData();
        }
        byte[] associatedData = getAssociateddData.getBytes(StandardCharsets.UTF_8);
        byte[] nonce = resource.getNonce().getBytes(StandardCharsets.UTF_8);
        String ciphertext = resource.getCiphertext();
        AesUtil aesUtil = new AesUtil(this.apiV3Key);
        try {
            decryptData = aesUtil.decryptToString(associatedData, nonce, ciphertext);
        }
        catch (GeneralSecurityException e) {
            throw new ParseException("AES\u89e3\u5bc6\u5931\u8d25\uff0cresource\uff1a" + resource.toString(), e);
        }
        notification.setDecryptData(decryptData);
    }
}

