/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.core.exception;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.wechat.pay.java.core.exception.WechatPayException;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.util.GsonUtil;

public class ServiceException
extends WechatPayException {
    private static final long serialVersionUID = -7174975090366956652L;
    private final HttpRequest httpRequest;
    private final int httpStatusCode;
    private final String responseBody;
    private String errorCode;
    private String errorMessage;

    public ServiceException(HttpRequest httpRequest, int httpStatusCode, String responseBody) {
        super(String.format("Wrong HttpStatusCode[%d]%nhttpResponseBody[%.1024s]\tHttpRequest[%s]", httpStatusCode, responseBody, httpRequest));
        this.httpRequest = httpRequest;
        this.httpStatusCode = httpStatusCode;
        this.responseBody = responseBody;
        if (responseBody != null && !responseBody.isEmpty()) {
            JsonObject jsonObject = (JsonObject)GsonUtil.getGson().fromJson(responseBody, JsonObject.class);
            JsonElement code = jsonObject.get("code");
            JsonElement message = jsonObject.get("message");
            this.errorCode = code == null ? null : code.getAsString();
            this.errorMessage = message == null ? null : message.getAsString();
        }
    }

    public static long getSerialVersionUID() {
        return -7174975090366956652L;
    }

    public HttpRequest getHttpRequest() {
        return this.httpRequest;
    }

    public String getResponseBody() {
        return this.responseBody;
    }

    public int getHttpStatusCode() {
        return this.httpStatusCode;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

