/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.service.billdownload;

import com.wechat.pay.java.core.exception.MalformedMessageException;
import com.wechat.pay.java.core.util.ShaUtil;
import com.wechat.pay.java.service.billdownload.model.HashType;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public class DigestBillEntity {
    private final DigestInputStream digestInputStream;
    private final String hashValue;

    public DigestBillEntity(InputStream inputStream, String hashValue, HashType hashType) {
        MessageDigest md = this.getMessageDigestInstance(hashType);
        this.digestInputStream = new DigestInputStream(inputStream, md);
        this.hashValue = hashValue;
    }

    private MessageDigest getMessageDigestInstance(HashType hashType) {
        String algorithm = hashType == HashType.SHA1 ? "SHA-1" : hashType.name();
        try {
            return MessageDigest.getInstance(algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            throw new MalformedMessageException("Unsupported hash_type: " + hashType.name(), (Throwable)e);
        }
    }

    private String digestAndEncodeHex() {
        MessageDigest md = this.digestInputStream.getMessageDigest();
        byte[] hash = md.digest();
        return ShaUtil.toHexString((byte[])hash);
    }

    public InputStream getInputStream() {
        return this.digestInputStream;
    }

    public final boolean verifyHash() {
        String digest = this.digestAndEncodeHex();
        return digest.equalsIgnoreCase(this.hashValue);
    }
}

