/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.service.weixinpayscanandride;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.HostName;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.JsonRequestBody;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.QueryParameter;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.core.http.UrlEncoder;
import com.wechat.pay.java.core.util.GsonUtil;
import com.wechat.pay.java.service.weixinpayscanandride.model.CreateTransactionRequest;
import com.wechat.pay.java.service.weixinpayscanandride.model.QueryTransactionRequest;
import com.wechat.pay.java.service.weixinpayscanandride.model.QueryUserServiceRequest;
import com.wechat.pay.java.service.weixinpayscanandride.model.TransactionsEntity;
import com.wechat.pay.java.service.weixinpayscanandride.model.UserServiceEntity;
import java.util.Objects;

public class WeixinPayScanAndRideService {
    private final HttpClient httpClient;
    private final HostName hostName;

    private WeixinPayScanAndRideService(HttpClient httpClient, HostName hostName) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.hostName = hostName;
    }

    public TransactionsEntity createTransaction(CreateTransactionRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/qrcode/transactions";
        CreateTransactionRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, TransactionsEntity.class);
        return (TransactionsEntity)httpResponse.getServiceResponse();
    }

    public TransactionsEntity queryTransaction(QueryTransactionRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/qrcode/transactions/out-trade-no/{out_trade_no}";
        QueryTransactionRequest realRequest = request;
        requestPath = requestPath.replace("{out_trade_no}", UrlEncoder.urlEncode((String)realRequest.getOutTradeNo()));
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getSubMchid() != null) {
            queryParameter.add("sub_mchid", (Object)UrlEncoder.urlEncode((String)realRequest.getSubMchid()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, TransactionsEntity.class);
        return (TransactionsEntity)httpResponse.getServiceResponse();
    }

    public UserServiceEntity queryUserService(QueryUserServiceRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/qrcode/user-services/contract-id/{contract_id}";
        QueryUserServiceRequest realRequest = request;
        requestPath = requestPath.replace("{contract_id}", UrlEncoder.urlEncode((String)realRequest.getContractId()));
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getAppid() != null) {
            queryParameter.add("appid", (Object)UrlEncoder.urlEncode((String)realRequest.getAppid()));
        }
        if (realRequest.getSubAppid() != null) {
            queryParameter.add("sub_appid", (Object)UrlEncoder.urlEncode((String)realRequest.getSubAppid()));
        }
        if (realRequest.getSubMchid() != null) {
            queryParameter.add("sub_mchid", (Object)UrlEncoder.urlEncode((String)realRequest.getSubMchid()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, UserServiceEntity.class);
        return (UserServiceEntity)httpResponse.getServiceResponse();
    }

    private RequestBody createRequestBody(Object request) {
        return new JsonRequestBody.Builder().body(GsonUtil.toJson((Object)request)).build();
    }

    public static class Builder {
        private HttpClient httpClient;
        private HostName hostName;

        public Builder config(Config config) {
            this.httpClient = new DefaultHttpClientBuilder().config(config).build();
            return this;
        }

        public Builder hostName(HostName hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public WeixinPayScanAndRideService build() {
            return new WeixinPayScanAndRideService(this.httpClient, this.hostName);
        }
    }
}

