/*
 * Decompiled with CFR 0.152.
 */
package com.wechat.pay.java.service.wexinpayscoreparking;

import com.wechat.pay.java.core.Config;
import com.wechat.pay.java.core.http.DefaultHttpClientBuilder;
import com.wechat.pay.java.core.http.HostName;
import com.wechat.pay.java.core.http.HttpClient;
import com.wechat.pay.java.core.http.HttpHeaders;
import com.wechat.pay.java.core.http.HttpMethod;
import com.wechat.pay.java.core.http.HttpRequest;
import com.wechat.pay.java.core.http.HttpResponse;
import com.wechat.pay.java.core.http.JsonRequestBody;
import com.wechat.pay.java.core.http.MediaType;
import com.wechat.pay.java.core.http.QueryParameter;
import com.wechat.pay.java.core.http.RequestBody;
import com.wechat.pay.java.core.http.UrlEncoder;
import com.wechat.pay.java.core.util.GsonUtil;
import com.wechat.pay.java.service.wexinpayscoreparking.model.CreateParkingRequest;
import com.wechat.pay.java.service.wexinpayscoreparking.model.CreateTransactionRequest;
import com.wechat.pay.java.service.wexinpayscoreparking.model.Parking;
import com.wechat.pay.java.service.wexinpayscoreparking.model.PlateService;
import com.wechat.pay.java.service.wexinpayscoreparking.model.QueryPlateServiceRequest;
import com.wechat.pay.java.service.wexinpayscoreparking.model.QueryTransactionRequest;
import com.wechat.pay.java.service.wexinpayscoreparking.model.Transaction;
import java.util.Objects;

public class WexinPayScoreParkingService {
    private final HttpClient httpClient;
    private final HostName hostName;

    private WexinPayScoreParkingService(HttpClient httpClient, HostName hostName) {
        this.httpClient = Objects.requireNonNull(httpClient);
        this.hostName = hostName;
    }

    public Parking createParking(CreateParkingRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/vehicle/parking/parkings";
        CreateParkingRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, Parking.class);
        return (Parking)httpResponse.getServiceResponse();
    }

    public PlateService queryPlateService(QueryPlateServiceRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/vehicle/parking/services/find";
        QueryPlateServiceRequest realRequest = request;
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getAppid() != null) {
            queryParameter.add("appid", (Object)UrlEncoder.urlEncode((String)realRequest.getAppid()));
        }
        if (realRequest.getSubMchid() != null) {
            queryParameter.add("sub_mchid", (Object)UrlEncoder.urlEncode((String)realRequest.getSubMchid()));
        }
        if (realRequest.getPlateNumber() != null) {
            queryParameter.add("plate_number", (Object)UrlEncoder.urlEncode((String)realRequest.getPlateNumber()));
        }
        if (realRequest.getOpenid() != null) {
            queryParameter.add("openid", (Object)UrlEncoder.urlEncode((String)realRequest.getOpenid()));
        }
        if (realRequest.getPlateColor() != null) {
            queryParameter.add("plate_color", (Object)UrlEncoder.urlEncode((String)realRequest.getPlateColor().toString()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, PlateService.class);
        return (PlateService)httpResponse.getServiceResponse();
    }

    public Transaction createTransaction(CreateTransactionRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/vehicle/transactions/parking";
        CreateTransactionRequest realRequest = request;
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.POST).url(requestPath).headers(headers).body(this.createRequestBody(realRequest)).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, Transaction.class);
        return (Transaction)httpResponse.getServiceResponse();
    }

    public Transaction queryTransaction(QueryTransactionRequest request) {
        String requestPath = "https://api.mch.weixin.qq.com/v3/vehicle/transactions/out-trade-no/{out_trade_no}";
        QueryTransactionRequest realRequest = request;
        requestPath = requestPath.replace("{out_trade_no}", UrlEncoder.urlEncode((String)realRequest.getOutTradeNo()));
        QueryParameter queryParameter = new QueryParameter();
        if (realRequest.getSubMchid() != null) {
            queryParameter.add("sub_mchid", (Object)UrlEncoder.urlEncode((String)realRequest.getSubMchid()));
        }
        requestPath = requestPath + queryParameter.getQueryStr();
        if (this.hostName != null) {
            requestPath = requestPath.replaceFirst(HostName.API.getValue(), this.hostName.getValue());
        }
        HttpHeaders headers = new HttpHeaders();
        headers.addHeader("Accept", MediaType.APPLICATION_JSON.getValue());
        headers.addHeader("Content-Type", MediaType.APPLICATION_JSON.getValue());
        HttpRequest httpRequest = new HttpRequest.Builder().httpMethod(HttpMethod.GET).url(requestPath).headers(headers).build();
        HttpResponse httpResponse = this.httpClient.execute(httpRequest, Transaction.class);
        return (Transaction)httpResponse.getServiceResponse();
    }

    private RequestBody createRequestBody(Object request) {
        return new JsonRequestBody.Builder().body(GsonUtil.toJson((Object)request)).build();
    }

    public static class Builder {
        private HttpClient httpClient;
        private HostName hostName;

        public Builder config(Config config) {
            this.httpClient = new DefaultHttpClientBuilder().config(config).build();
            return this;
        }

        public Builder hostName(HostName hostName) {
            this.hostName = hostName;
            return this;
        }

        public Builder httpClient(HttpClient httpClient) {
            this.httpClient = httpClient;
            return this;
        }

        public WexinPayScoreParkingService build() {
            return new WexinPayScoreParkingService(this.httpClient, this.hostName);
        }
    }
}

