/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.pki;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Security;
import java.security.UnrecoverableEntryException;
import java.security.UnrecoverableKeyException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.ResourceBundle;
import java.util.Vector;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.X509KeyManager;
import javax.security.auth.x500.X500Principal;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.CertificateRequest;
import oracle.security.crypto.cert.PKCS12;
import oracle.security.crypto.cert.PKCS12Bag;
import oracle.security.crypto.cert.PKCS12KeyBag;
import oracle.security.crypto.cert.PKCS12Safe;
import oracle.security.crypto.cert.PKCS12ShroudedKeyBag;
import oracle.security.crypto.cert.PKCS7;
import oracle.security.crypto.cert.RevokedCertificate;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cert.X509Extension;
import oracle.security.crypto.cert.ext.SubjectKeyIDExtension;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.core.RSAPrivateKey;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.crypto.core.SignatureException;
import oracle.security.crypto.util.CryptoUtils;
import oracle.security.pki.OracleCertExtension;
import oracle.security.pki.OracleKeyStoreSpi;
import oracle.security.pki.OraclePKIDebug;
import oracle.security.pki.OraclePKIPrincipalImpl;
import oracle.security.pki.OraclePKIProvider;
import oracle.security.pki.OraclePKIRSAPrivateKey;
import oracle.security.pki.OraclePKIX509CertImpl;
import oracle.security.pki.OracleSSOKeyStoreSpi;
import oracle.security.pki.OracleSecretStore;
import oracle.security.pki.OracleSecretStoreException;
import oracle.security.pki.OracleWalletJks;
import oracle.security.pki.OracleWalletPersona;
import oracle.security.pki.h;
import oracle.security.pki.j;
import oracle.security.pki.k;
import oracle.security.pki.l;
import oracle.security.pki.o;
import oracle.security.pki.textui.OraclePKIGenFunc;
import oracle.security.wallet.NZException;
import oracle.security.wallet.NZNative;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class OracleWallet {
    static ResourceBundle b = ResourceBundle.getBundle("oracle.security.pki.resources.OraclePKIMsg");
    private static final String a = "file:";
    private static final String i = "reg:";
    private static final char j = ':';
    protected static final String c = "-----BEGIN NEW CERTIFICATE REQUEST-----";
    protected static final String d = "-----END NEW CERTIFICATE REQUEST-----";
    protected static final String e = "-----BEGIN CERTIFICATE-----";
    protected static final String f = "-----END CERTIFICATE-----";
    private String k = null;
    private byte[] l = null;
    private char[] m = null;
    private char[] n = null;
    private o o = null;
    private int p = 0;
    private OracleSecretStore q = null;
    private AlgorithmIdentifier r = null;
    private AlgorithmIdentifier s = null;
    public static final int MIGRATE_ALL = 0;
    public static final int MIGRATE_KEY_ENTIRES_ONLY = 1;
    public static final int MIGRATE_TRUSTED_ENTRIES_ONLY = 2;
    private static String t = "MIICNDCCAaECEAKtZn5ORf5eV288mBle3cAwDQYJKoZIhvcNAQECBQAwXzELMAkGA1UEBhMCVVMxIDAeBgNVBAoTF1JTQSBEYXRhIFNlY3VyaXR5LCBJbmMuMS4wLAYDVQQLEyVTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk0MTEwOTAwMDAwMFoXDTEwMDEwNzIzNTk1OVowXzELMAkGA1UEBhMCVVMxIDAeBgNVBAoTF1JTQSBEYXRhIFNlY3VyaXR5LCBJbmMuMS4wLAYDVQQLEyVTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGbMA0GCSqGSIb3DQEBAQUAA4GJADCBhQJ+AJLOesGugz5aqomDV6wlAXYMra6OLDfO6zV4ZFQD5YRAUcm/jwjiioII0haGN1XpsSECrXZogZoFokvJSyVmIlZsiAeP94FZbYQHZXATcXY+m3dM41CJVphIuR2nKRoTLkoRWZweFdVJVCxzOmmCsZc5nG1wZ0jl3S3WyB57AgMBAAEwDQYJKoZIhvcNAQECBQADfgBl3X7hsuyw4jrg7HFGmhkRuNPHoLQDQCYCPgmc4RKz0Vr2N6W3YQO2WxZpO8ZECAyIUwxrl0nHPjXcbLm7qt9cuzovk2C2qUtN8iD3zV9/ZHuO3ABc1/p3yjkWWW8O6tO1g39NTUJWdrTJXwT4OPjr0l91X817/OWOgHz8UA==";
    private static String u = "MIICPDCCAaUCEDJQM89Q0VbzXIGtZVxPyCUwDQYJKoZIhvcNAQECBQAwXzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAxIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk2MDEyOTAwMDAwMFoXDTIwMDEwNzIzNTk1OVowXzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAxIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDlGb9to1ZhLZlIcfZn3rmN67eehoAKkQ76OCWvRoiC5XOooJskXQ0fzGVuDLDQVoQYh5oGmxChc9+0WDlrbsH2FdWoqD+qEgaNMax/sDTXjzRniAnNFBHiTkVWaR94AoDa3EeRKbs2yWNcxeDXLYd7obcysHswuiovMaruo2fa2wIDAQABMA0GCSqGSIb3DQEBAgUAA4GBAEtEZmBoZOSYG/OwcuaViXzde7OVwB0u2NgZ0C00PcZQmhCGjKo/O6gE/DdSlcPZydvN8oYGxLEb8IKIMEKOF1AcZHq4PplJdJf8rAJD+5YMVgQlDHx8h50kp9jwMim1pN9dokzFFjKoQvZFprY2ueC/ZTaTwtLXa9zeWdaiNfhF";
    private static String v = "MIICPDCCAaUCEC0b/EoXjaOR6+f/9YtFvgswDQYJKoZIhvcNAQECBQAwXzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAyIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk2MDEyOTAwMDAwMFoXDTI4MDgwMTIzNTk1OVowXzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAyIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQC2WoujDWojg4BrzzmH9CETMwZMJaLtVRKXxaeAufqDwSCg+i8VDXyhYGt+eSz6Bg86rvYbb7HS/y8oUl+DfUvEerf4Zh+AVPy3wo5ZShRXRtGak75BkQO7FYCTXOvnzAhsPz6zSvz/S2wj1VCCJkQZjiPDceoZJEcEnnW/yKYAHwIDAQABMA0GCSqGSIb3DQEBAgUAA4GBAIobK/o5wXTXXtgZZKJYSi034DNHD6zt96rbHuSLBlxgJ8pFUs4W7z8GZOeUaHxgMxURaa+dYo2jA1Rrpr7l7gUYYAS/QoD90KioHgE796Ncr6Pc5iaAIzy4RHT3Cq5Ji2F4zCS/iIqnDupzGUH9TQPwiNHleI2lKk/2lw0Xd8rY";
    private static String w = "MIICPDCCAaUCEHC65B0Q2Sk0tjjKewPMur8wDQYJKoZIhvcNAQECBQAwXzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MB4XDTk2MDEyOTAwMDAwMFoXDTI4MDgwMTIzNTk1OVowXzELMAkGA1UEBhMCVVMxFzAVBgNVBAoTDlZlcmlTaWduLCBJbmMuMTcwNQYDVQQLEy5DbGFzcyAzIFB1YmxpYyBQcmltYXJ5IENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDJXFme8huKARS0EN8EQNvjV69qRUCPhAwL0TPZ2RHP7gJYHyX3KqhEBarsAx94f56TuZoAqiN91qyFomNFx3InzPRMxnVx0jnvT0Lwdd8KkMaOIG+YD/isI19wKTakyYbnsZogy1Olhec9vn2a/iRFM9x2Fe0PonFkTGUugWhFpwIDAQABMA0GCSqGSIb3DQEBAgUAA4GBALtMEivPLCYATxQT3ab7/AoRhIzzKBxnki98tsX63/Dolbwdj2wsqFHMc9ikwFPwTtYmwHYBV4GSXiHx0bH/59AhWM1pF+NEHJwZRDmJXNycAA9WjQKZ7aKQRUzkuxCkPfAyAw7xzvjoyVGM5mKf5p/AfbdynMk2OmufTqj/ZA1k";
    public static final String GTE_CYBERTRUSTGLOBAL_CERT = "MIICWjCCAcMCAgGlMA0GCSqGSIb3DQEBBAUAMHUxCzAJBgNVBAYTAlVTMRgwFgYDVQQKEw9HVEUgQ29ycG9yYXRpb24xJzAlBgNVBAsTHkdURSBDeWJlclRydXN0IFNvbHV0aW9ucywgSW5jLjEjMCEGA1UEAxMaR1RFIEN5YmVyVHJ1c3QgR2xvYmFsIFJvb3QwHhcNOTgwODEzMDAyOTAwWhcNMTgwODEzMjM1OTAwWjB1MQswCQYDVQQGEwJVUzEYMBYGA1UEChMPR1RFIENvcnBvcmF0aW9uMScwJQYDVQQLEx5HVEUgQ3liZXJUcnVzdCBTb2x1dGlvbnMsIEluYy4xIzAhBgNVBAMTGkdURSBDeWJlclRydXN0IEdsb2JhbCBSb290MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCVD6C28FCc6HrHiM3dFw4usJTQGz0O9pTAipTHBsiQl8i4ZBp6fmw8U+E3KHNgf7KXUwefU/ltWJTSr41tiGeA5u2ylc9yMcqlHHK6XALnZELn+aks1joNrI1CqiQBOeacPwGFVw1Yh0X404Wqk2kmhXBIgD8SFcd5tB8FLztimQIDAQABMA0GCSqGSIb3DQEBBAUAA4GBAG3rGwnpXtlR22ciYaQqPEh346B8pt5zohQDhT37qw4wxYMWM4ETCJ57NE7fQMh017l93PR2VX2bY1QY6fDq81yx2YtCHrnAlU66+tXifPVoYb+O7AWXX1uw16OFNMQkpw0PlZPvy5TYnh+dXIVtx6quTx8itc2VrbqnzPmrC3p/";
    public static final String ENTRUST_PREMIUM_CERT = "MIIEXDCCA0SgAwIBAgIEOGO5ZjANBgkqhkiG9w0BAQUFADCBtDEUMBIGA1UEChMLRW50cnVzdC5uZXQxQDA+BgNVBAsUN3d3dy5lbnRydXN0Lm5ldC9DUFNfMjA0OCBpbmNvcnAuIGJ5IHJlZi4gKGxpbWl0cyBsaWFiLikxJTAjBgNVBAsTHChjKSAxOTk5IEVudHJ1c3QubmV0IExpbWl0ZWQxMzAxBgNVBAMTKkVudHJ1c3QubmV0IENlcnRpZmljYXRpb24gQXV0aG9yaXR5ICgyMDQ4KTAeFw05OTEyMjQxNzUwNTFaFw0xOTEyMjQxODIwNTFaMIG0MRQwEgYDVQQKEwtFbnRydXN0Lm5ldDFAMD4GA1UECxQ3d3d3LmVudHJ1c3QubmV0L0NQU18yMDQ4IGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxpYWIuKTElMCMGA1UECxMcKGMpIDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDEzMDEGA1UEAxMqRW50cnVzdC5uZXQgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkgKDIwNDgpMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEArU1LqRKGsuqjIAcVFmQqK0vRvwtKTY7tgHalZ7d4QMBzQshowNtTK91euHaYNZOLGp18EzoOH1u3Hs/lJBQesYGpjX24zGtLA/ECDNyrpUAkAH90lKGdCCmziAv1h3edVc3kw37XamSrhRSGlVuXMlBvPci6Zgzj/L24ScF2iUkZ/cCovYmjZy/Gn7xxGWC4LeksyZB2ZnuU4q941mVTXTzWnLLPKQP5L6RQstRIzgUyVYr9smRMDuSYB3Xbf9+5CFVghTAp+XtIpGmG4zU/HoZdenoVve8AjhUiVBcAkCaTvA5JaJG/+EfTnZVCwQ5N328mz8MYIWJmQ3DW1cAH4QIDAQABo3QwcjARBglghkgBhvhCAQEEBAMCAAcwHwYDVR0jBBgwFoAUVeSB0RGAvtiJuQijMfmhJAkWuXAwHQYDVR0OBBYEFFXkgdERgL7YibkIozH5oSQJFrlwMB0GCSqGSIb2fQdBAAQQMA4bCFY1LjA6NC4wAwIEkDANBgkqhkiG9w0BAQUFAAOCAQEAWUesIYSKF8mciVMeuoCFGsY8Tj6xnLZ8xpJdGGQC49MGCBFhfGPjK50xA3B20qMooPS7mmNz7W3lKtvtFKkrxjYR0CvrB4ul2p5cGZ1WEvVUKcgF7bISKo30Axv/55IQh7A6tcOdBTcSo8f0FbnVpDkWm1M6I5HxqIKiaohowXkCIryqptau37AUX7iH0N18f3v/rxzP5tsHrV7bhZ3QKw0z2wTR5klAEyt2+z7pnIkPFc4YsIV4IU9rTw76NmfNB/L/CNDi3tm/Kq+4h4YhPATKt5Rof8886ZjXOP/swNlQ8C5LWK5Gb9Auw2DaclVyvUxFnmG6v4SBkgPR0ml8xQ==";
    public static final String ENTRUST_GLOBAL_CERT = "MIIElTCCA/6gAwIBAgIEOJsRPDANBgkqhkiG9w0BAQQFADCBujEUMBIGA1UEChMLRW50cnVzdC5uZXQxPzA9BgNVBAsUNnd3dy5lbnRydXN0Lm5ldC9TU0xfQ1BTIGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxpYWIuKTElMCMGA1UECxMcKGMpIDIwMDAgRW50cnVzdC5uZXQgTGltaXRlZDE6MDgGA1UEAxMxRW50cnVzdC5uZXQgU2VjdXJlIFNlcnZlciBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw0wMDAyMDQxNzIwMDBaFw0yMDAyMDQxNzUwMDBaMIG6MRQwEgYDVQQKEwtFbnRydXN0Lm5ldDE/MD0GA1UECxQ2d3d3LmVudHJ1c3QubmV0L1NTTF9DUFMgaW5jb3JwLiBieSByZWYuIChsaW1pdHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMjAwMCBFbnRydXN0Lm5ldCBMaW1pdGVkMTowOAYDVQQDEzFFbnRydXN0Lm5ldCBTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQDHwV9OcfHO8GCGD9JYf9Mzly0XonUwtZZkJi9ow0SrqHXmAGc0V55lxyKbc+bT3QgON1WqJUaBbL3+qPZ1V1eMkGxKwz6LS0MKyRFWmponIpnPVZ5h2QLifLZ8OAfc439PmrkDQYC2dWcTC5/oVzbIXQA23mYU2m52H083jIITiQIDAQABo4IBpDCCAaAwEQYJYIZIAYb4QgEBBAQDAgAHMIHjBgNVHR8EgdswgdgwgdWggdKggc+kgcwwgckxFDASBgNVBAoTC0VudHJ1c3QubmV0MT8wPQYDVQQLFDZ3d3cuZW50cnVzdC5uZXQvU1NMX0NQUyBpbmNvcnAuIGJ5IHJlZi4gKGxpbWl0cyBsaWFiLikxJTAjBgNVBAsTHChjKSAyMDAwIEVudHJ1c3QubmV0IExpbWl0ZWQxOjA4BgNVBAMTMUVudHJ1c3QubmV0IFNlY3VyZSBTZXJ2ZXIgQ2VydGlmaWNhdGlvbiBBdXRob3JpdHkxDTALBgNVBAMTBENSTDEwKwYDVR0QBCQwIoAPMjAwMDAyMDQxNzIwMDBagQ8yMDIwMDIwNDE3NTAwMFowCwYDVR0PBAQDAgEGMB8GA1UdIwQYMBaAFMtswGvjuz7L/CKc/vuLkpyw8m4iMB0GA1UdDgQWBBTLbMBr47s+y/winP77i5KcsPJuIjAMBgNVHRMEBTADAQH/MB0GCSqGSIb2fQdBAAQQMA4bCFY1LjA6NC4wAwIEkDANBgkqhkiG9w0BAQQFAAOBgQBi24GRzsiad0Iv7L0no1MPUBvqTpLwqa+poLpIYcvvyQbvH9X07t9WLebKahlzqlO+krNQAraFJnJj2HVQYnUUt7NQGj/KEQALhUVpbbalrlHhStyCP2yMNLJ3a9kC9n8O6mUE8c1UyrrJzOCE98g+EZfTYAkYvAX/bIkz8OwVDw==";
    public static final String ENTRUST_MAIN_CERT = "MIIE2DCCBEGgAwIBAgIEN0rSQzANBgkqhkiG9w0BAQUFADCBwzELMAkGA1UEBhMCVVMxFDASBgNVBAoTC0VudHJ1c3QubmV0MTswOQYDVQQLEzJ3d3cuZW50cnVzdC5uZXQvQ1BTIGluY29ycC4gYnkgcmVmLiAobGltaXRzIGxpYWIuKTElMCMGA1UECxMcKGMpIDE5OTkgRW50cnVzdC5uZXQgTGltaXRlZDE6MDgGA1UEAxMxRW50cnVzdC5uZXQgU2VjdXJlIFNlcnZlciBDZXJ0aWZpY2F0aW9uIEF1dGhvcml0eTAeFw05OTA1MjUxNjA5NDBaFw0xOTA1MjUxNjM5NDBaMIHDMQswCQYDVQQGEwJVUzEUMBIGA1UEChMLRW50cnVzdC5uZXQxOzA5BgNVBAsTMnd3dy5lbnRydXN0Lm5ldC9DUFMgaW5jb3JwLiBieSByZWYuIChsaW1pdHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMTk5OSBFbnRydXN0Lm5ldCBMaW1pdGVkMTowOAYDVQQDEzFFbnRydXN0Lm5ldCBTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MIGdMA0GCSqGSIb3DQEBAQUAA4GLADCBhwKBgQDNKIM0VBuJ8w+vN5Ex/68xYMmo6LIQaO2f55M28Qpku0f1BBc/I0dNxScZgSYMVHINiC3ZH5oSn7yzcdOAGT9HZnuMNSjSuQrfJNqc1lB5gXpa0zf3wkrYKZImZNHkmGw6AIr1NJtl+O3jEP/9uElY3KDegjlrgbEWGWG5VLbmQwIBA6OCAdcwggHTMBEGCWCGSAGG+EIBAQQEAwIABzCCARkGA1UdHwSCARAwggEMMIHeoIHboIHYpIHVMIHSMQswCQYDVQQGEwJVUzEUMBIGA1UEChMLRW50cnVzdC5uZXQxOzA5BgNVBAsTMnd3dy5lbnRydXN0Lm5ldC9DUFMgaW5jb3JwLiBieSByZWYuIChsaW1pdHMgbGlhYi4pMSUwIwYDVQQLExwoYykgMTk5OSBFbnRydXN0Lm5ldCBMaW1pdGVkMTowOAYDVQQDEzFFbnRydXN0Lm5ldCBTZWN1cmUgU2VydmVyIENlcnRpZmljYXRpb24gQXV0aG9yaXR5MQ0wCwYDVQQDEwRDUkwxMCmgJ6AlhiNodHRwOi8vd3d3LmVudHJ1c3QubmV0L0NSTC9uZXQxLmNybDArBgNVHRAEJDAigA8xOTk5MDUyNTE2MDk0MFqBDzIwMTkwNTI1MTYwOTQwWjALBgNVHQ8EBAMCAQYwHwYDVR0jBBgwFoAU8BdiE1U9s/8KAGv7UISX8+1i0BowHQYDVR0OBBYEFPAXYhNVPbP/CgBr+1CEl/PtYtAaMAwGA1UdEwQFMAMBAf8wGQYJKoZIhvZ9B0EABAwwChsEVjQuMAMCBJAwDQYJKoZIhvcNAQEFBQADgYEAkNwwAvpkdMKnCqV8IY00F6j7Rw7/JXyNEwr75Ji174z4xRAN95K+8cPV1ZVqBLssziY2ZcgxxufuP+NXdYR6Ee9GTxj005i7qIcyunL2POI9n9cd2cNgQ4xYDiKWL2KjLB+6rQXvqzJ4h6BUcxm1XAX5Uj5tLUUL9wqT6u0G+bI=";
    static Class g;
    static Class h;

    public OracleWallet() {
        this.a();
    }

    public static OracleWallet getInstance(String string) {
        OracleWallet oracleWallet = null;
        oracleWallet = string != null && string.equals("jks") ? new OracleWalletJks() : new OracleWallet();
        return oracleWallet;
    }

    public String getLocation() {
        return this.k;
    }

    public void setLocation(String string) {
        this.k = string;
    }

    public void setWalletRioType(int n2) {
        this.p = n2;
    }

    public void setCertSignAlgorithm(String string) {
        if (string == null) {
            return;
        }
        if (string.equals("md5")) {
            this.r = AlgID.md5WithRSAEncryption;
        } else if (string.equalsIgnoreCase("sha1")) {
            this.r = AlgID.sha_1WithRSAEncryption;
        } else if (string.equalsIgnoreCase("sha256")) {
            this.r = AlgID.sha256WithRSAEncryption;
        } else if (string.equalsIgnoreCase("sha384")) {
            this.r = AlgID.sha384WithRSAEncryption;
        } else if (string.equalsIgnoreCase("sha512")) {
            this.r = AlgID.sha512WithRSAEncryption;
        } else {
            return;
        }
    }

    public String getCertSignAlgorithm() {
        if (this.r != null) {
            return this.r.toString();
        }
        return "(default)";
    }

    public void setCRLSignAlgorithm(String string) {
        if (string == null) {
            return;
        }
        if (string.equalsIgnoreCase("md5")) {
            this.s = AlgID.md5WithRSAEncryption;
        } else if (string.equalsIgnoreCase("sha1")) {
            this.s = AlgID.sha_1WithRSAEncryption;
        } else if (string.equalsIgnoreCase("sha256")) {
            this.s = AlgID.sha256WithRSAEncryption;
        } else if (string.equalsIgnoreCase("sha384")) {
            this.s = AlgID.sha384WithRSAEncryption;
        } else if (string.equalsIgnoreCase("sha512")) {
            this.s = AlgID.sha512WithRSAEncryption;
        } else {
            return;
        }
    }

    public String getCRLSignAlgorithm() {
        if (this.s != null) {
            return this.s.toString();
        }
        return "(default)";
    }

    public static String getDefaultLocation() {
        return null;
    }

    public static boolean isValidPassword(char[] cArray) {
        String string = new String(cArray);
        int n2 = 8;
        boolean bl = false;
        boolean bl2 = false;
        if (string == null || string.length() <= 0) {
            return false;
        }
        if (string.length() < 8) {
            return false;
        }
        int n3 = string.length();
        Character c2 = new Character('i');
        for (int i2 = 0; !(i2 >= n3 || bl && bl2); ++i2) {
            if (Character.isLetter(string.charAt(i2))) {
                bl = true;
                continue;
            }
            bl2 = true;
        }
        return bl && bl2;
    }

    public static int[] getKeysizes() {
        return new int[]{512, 768, 1024, 2048, 4096};
    }

    public void createSelfSigned(X500Principal x500Principal, int n2, int n3) throws IOException {
        this.a(x500Principal, n2, n3, null, null, BigInteger.ZERO, null, null);
    }

    public void createSelfSigned(X500Principal x500Principal, int n2, int n3, BigInteger bigInteger) throws IOException {
        this.a(x500Principal, n2, n3, null, null, bigInteger, null, null);
    }

    public void createSelfSigned(X500Principal x500Principal, int n2, int n3, BigInteger bigInteger, OracleCertExtension oracleCertExtension) throws IOException {
        this.a(x500Principal, n2, n3, null, null, bigInteger, oracleCertExtension, null);
    }

    public void createSelfSigned(X500Principal x500Principal, int n2, int n3, BigInteger bigInteger, String string) throws IOException {
        this.a(x500Principal, n2, n3, null, null, bigInteger, null, string);
    }

    public void createSelfSigned(X500Principal x500Principal, int n2, int n3, BigInteger bigInteger, OracleCertExtension oracleCertExtension, String string) throws IOException {
        this.a(x500Principal, n2, n3, null, null, bigInteger, oracleCertExtension, string);
    }

    public void createSelfSigned(X500Principal x500Principal, int n2, Date date, Date date2) throws IOException {
        this.a(x500Principal, n2, 0, date, date2, BigInteger.ZERO, null, null);
    }

    public void createSelfSigned(X500Principal x500Principal, int n2, Date date, Date date2, BigInteger bigInteger) throws IOException {
        this.a(x500Principal, n2, 0, date, date2, bigInteger, null, null);
    }

    public void createSelfSigned(X500Principal x500Principal, int n2, Date date, Date date2, BigInteger bigInteger, OracleCertExtension oracleCertExtension) throws IOException {
        this.a(x500Principal, n2, 0, date, date2, bigInteger, oracleCertExtension, null);
    }

    public void createSelfSigned(X500Principal x500Principal, int n2, Date date, Date date2, BigInteger bigInteger, String string) throws IOException {
        this.a(x500Principal, n2, 0, date, date2, bigInteger, null, string);
    }

    public void createSelfSigned(X500Principal x500Principal, int n2, Date date, Date date2, BigInteger bigInteger, OracleCertExtension oracleCertExtension, String string) throws IOException {
        this.a(x500Principal, n2, 0, date, date2, bigInteger, oracleCertExtension, string);
    }

    private void a(X500Principal x500Principal, int n2, int n3, Date date, Date date2, BigInteger bigInteger, OracleCertExtension oracleCertExtension, String string) throws IOException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (n2 != 512 && n2 != 768 && n2 != 1024 && n2 != 2048 && n2 != 4096) {
            throw new IOException(b.getString("PKI-07008"));
        }
        KeyPairGenerator keyPairGenerator = null;
        try {
            keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            IOException iOException = new IOException(noSuchAlgorithmException.getLocalizedMessage());
            throw (IOException)iOException.initCause(noSuchAlgorithmException);
        }
        keyPairGenerator.initialize(n2);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(privateKey.getEncoded());
        RSAPublicKey rSAPublicKey = new RSAPublicKey(publicKey.getEncoded());
        oracle.security.crypto.core.KeyPair keyPair2 = new oracle.security.crypto.core.KeyPair((oracle.security.crypto.core.PublicKey)rSAPublicKey, (oracle.security.crypto.core.PrivateKey)rSAPrivateKey);
        X500Name x500Name = new X500Name(x500Principal.toString());
        CertificateRequest certificateRequest = new CertificateRequest(x500Name, keyPair2);
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        X509 x509 = null;
        try {
            x509 = n3 == 0 ? new X509(x500Name, (oracle.security.crypto.core.PublicKey)rSAPublicKey, x500Name, (oracle.security.crypto.core.PrivateKey)rSAPrivateKey, bigInteger, date, date2, this.r) : new X509(x500Name, (oracle.security.crypto.core.PublicKey)rSAPublicKey, x500Name, (oracle.security.crypto.core.PrivateKey)rSAPrivateKey, bigInteger, n3, this.r);
            if (oracleCertExtension != null && oracleCertExtension.getSubjectKeyId()) {
                x509.addExtension((X509Extension)new SubjectKeyIDExtension(CryptoUtils.generateKeyID((oracle.security.crypto.core.PublicKey)rSAPublicKey), false));
            }
            oraclePKIX509CertImpl = new OraclePKIX509CertImpl(x509);
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            throw (IOException)iOException.initCause(exception);
        }
        try {
            if (oraclePKIX509CertImpl != null) {
                if (this.m == null) {
                    this.n = this.b();
                }
                this.internalAddCertReq(certificateRequest, rSAPrivateKey, string);
                if (this.m == null) {
                    this.n = this.b(this.n);
                }
                String string2 = null;
                if (string != null) {
                    int n4 = 1;
                    string2 = string + ' ' + Integer.toString(n4);
                }
                this.internalAddTrustedCert(oraclePKIX509CertImpl, string2);
                if (this.m == null) {
                    this.n = this.b(this.n);
                }
                this.internalAddUserCert(oraclePKIX509CertImpl, string);
                if (this.m == null) {
                    this.n = this.b(this.n);
                }
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException(exception.getLocalizedMessage());
            throw (IOException)iOException.initCause(exception);
        }
    }

    public void create(char[] cArray) throws IOException {
        this.a();
        if (!OracleWallet.isValidPassword(cArray)) {
            throw new IOException(b.getString("PKI-01002"));
        }
        if (cArray != null) {
            this.m = new char[cArray.length];
            System.arraycopy(cArray, 0, this.m, 0, cArray.length);
        }
        this.l = null;
        this.o = new j();
        KeyStore keyStore = this.getKeyStore();
        this.a(keyStore);
        try {
            this.setKeyStore(keyStore);
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            throw (IOException)iOException.initCause(exception);
        }
    }

    protected void a(KeyStore keyStore) throws IOException {
        OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(new X509(new BASE64Decoder().decodeBuffer(u)));
        OraclePKIX509CertImpl oraclePKIX509CertImpl2 = new OraclePKIX509CertImpl(new X509(new BASE64Decoder().decodeBuffer(v)));
        OraclePKIX509CertImpl oraclePKIX509CertImpl3 = new OraclePKIX509CertImpl(new X509(new BASE64Decoder().decodeBuffer(w)));
        OraclePKIX509CertImpl oraclePKIX509CertImpl4 = new OraclePKIX509CertImpl(new X509(new BASE64Decoder().decodeBuffer(t)));
        OraclePKIX509CertImpl oraclePKIX509CertImpl5 = new OraclePKIX509CertImpl(new X509(new BASE64Decoder().decodeBuffer(GTE_CYBERTRUSTGLOBAL_CERT)));
        OraclePKIX509CertImpl oraclePKIX509CertImpl6 = new OraclePKIX509CertImpl(new X509(new BASE64Decoder().decodeBuffer(ENTRUST_PREMIUM_CERT)));
        OraclePKIX509CertImpl oraclePKIX509CertImpl7 = new OraclePKIX509CertImpl(new X509(new BASE64Decoder().decodeBuffer(ENTRUST_GLOBAL_CERT)));
        OraclePKIX509CertImpl oraclePKIX509CertImpl8 = new OraclePKIX509CertImpl(new X509(new BASE64Decoder().decodeBuffer(ENTRUST_MAIN_CERT)));
        try {
            keyStore.setCertificateEntry(oraclePKIX509CertImpl4.getSubjectDN().getName(), oraclePKIX509CertImpl4);
            keyStore.setCertificateEntry(oraclePKIX509CertImpl.getSubjectDN().getName(), oraclePKIX509CertImpl);
            keyStore.setCertificateEntry(oraclePKIX509CertImpl2.getSubjectDN().getName(), oraclePKIX509CertImpl2);
            keyStore.setCertificateEntry(oraclePKIX509CertImpl3.getSubjectDN().getName(), oraclePKIX509CertImpl3);
            keyStore.setCertificateEntry(oraclePKIX509CertImpl5.getSubjectDN().getName(), oraclePKIX509CertImpl5);
        }
        catch (GeneralSecurityException generalSecurityException) {
            throw new IOException();
        }
    }

    public InputStream getWalletArray(boolean bl) throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.m != null && !bl) {
            byteArrayInputStream = new ByteArrayInputStream(this.l);
        } else if (this.m != null && bl) {
            l l2 = new l();
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(this.l);
            byteArrayInputStream = l2.b(byteArrayInputStream2) == 0 ? (ByteArrayInputStream)this.a(1) : new ByteArrayInputStream(this.l);
        } else if (this.m == null && bl) {
            byteArrayInputStream = new ByteArrayInputStream(this.l);
        } else {
            throw new IOException("Cannot create p12 without password.");
        }
        return byteArrayInputStream;
    }

    public byte[] getWalletArrayB(boolean bl) throws IOException {
        ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)this.getWalletArray(bl);
        int n2 = byteArrayInputStream.available();
        byte[] byArray = new byte[n2];
        byteArrayInputStream.read(byArray, 0, n2);
        return byArray;
    }

    public void setWalletArray(InputStream inputStream, char[] cArray) throws IOException {
        this.a();
        if (cArray != null) {
            this.m = new char[cArray.length];
            System.arraycopy(cArray, 0, this.m, 0, cArray.length);
        }
        try {
            int n2 = inputStream.available();
            this.o = this.a(cArray);
            this.l = new byte[n2];
            inputStream.read(this.l);
            OraclePKIDebug.a("Oracle Wallet: wallet size " + this.l.length);
            try {
                this.getSecretStore();
            }
            catch (Throwable throwable) {
                OraclePKIDebug.a("OracleWallet: " + throwable.toString());
                this.a();
                IOException iOException = new IOException();
                iOException.initCause(throwable);
                throw iOException;
            }
        }
        catch (Throwable throwable) {
            this.a();
            throw new IOException(b.getString("PKI-02002"));
        }
    }

    public void setWalletArray(byte[] byArray, char[] cArray) throws IOException {
        this.setWalletArray(new ByteArrayInputStream(byArray), cArray);
    }

    public synchronized void open(String string, char[] cArray) throws IOException {
        this.a();
        if (cArray != null) {
            this.m = new char[cArray.length];
            System.arraycopy(cArray, 0, this.m, 0, cArray.length);
        }
        try {
            Object object;
            this.o = this.a(string, cArray);
            this.l = this.o.a();
            OraclePKIDebug.a("Oracle Wallet: wallet size " + this.l.length);
            if (this.m == null) {
                l l2 = new l();
                try {
                    object = new ByteArrayInputStream(this.l);
                    l2.b((InputStream)object);
                    this.n = l2.a((InputStream)object);
                }
                catch (IOException iOException) {
                    this.a();
                    throw new IOException(iOException.getMessage());
                }
            }
            try {
                this.getSecretStore();
            }
            catch (Throwable throwable) {
                OraclePKIDebug.a("OracleWallet: " + throwable.toString());
                this.a();
                object = new IOException();
                ((Throwable)object).initCause(throwable);
                throw object;
            }
        }
        catch (Throwable throwable) {
            this.a();
            throw new IOException(b.getString("PKI-02002"));
        }
    }

    public void openDefault(char[] cArray) throws IOException {
        String string = "";
        this.open(string, cArray);
        throw new IOException("not implemented");
    }

    public void createSSO() throws IOException {
        if (this.m == null && this.o == null) {
            this.m = new char[]{'t', 'e', 's', 't'};
            KeyStore keyStore = this.getKeyStore();
            this.a(keyStore);
            try {
                this.setKeyStore(keyStore);
            }
            catch (Exception exception) {
                IOException iOException = new IOException();
                throw (IOException)iOException.initCause(exception);
            }
            ByteArrayInputStream byteArrayInputStream = (ByteArrayInputStream)this.a(2);
            this.a();
            this.l = new byte[((InputStream)byteArrayInputStream).available()];
            byteArrayInputStream.read(this.l);
            OraclePKIDebug.a("OracleWallet: created ALO " + this.l.length + " bytes.");
        }
    }

    public void createSSO_OLD() throws IOException {
        if (this.m == null && this.o == null) {
            this.m = new char[]{'t', 'e', 's', 't'};
            KeyStore keyStore = this.getKeyStore();
            this.a(keyStore);
            try {
                this.setKeyStore(keyStore);
            }
            catch (Exception exception) {
                IOException iOException = new IOException();
                throw (IOException)iOException.initCause(exception);
            }
            this.o = this.a(this.k, this.m);
            OraclePKIDebug.a("OracleWallet: saving sso (ALO) " + this.l.length + " bytes.");
            this.o.b(this.l, this.m, 2);
        } else {
            OraclePKIDebug.a("OracleWallet: saving sso (AL) " + this.l.length + " bytes.");
            this.o.b(this.l, this.m, 1);
        }
    }

    public void deleteSSOWallet() throws IOException {
        this.o.d();
    }

    public void deleteWallet() throws IOException {
        this.o.c();
    }

    public void save() throws IOException {
        OraclePKIDebug.a("OracleWallet: saving " + this.l.length + " bytes.");
        String string = this.k;
        if (string == null) {
            string = this.o.e();
        }
        this.saveAs(string);
    }

    public synchronized void saveAs(String string) throws IOException {
        if (string == null) {
            throw new IOException("wrl not specified.");
        }
        l l2 = new l();
        o o2 = this.a(string, new char[16]);
        if (this.m == null) {
            Object object;
            Object object2;
            OraclePKIDebug.a("OracleWallet: saving sso (ALO) " + this.l.length + " bytes.");
            char[] cArray = null;
            try {
                object2 = new ByteArrayInputStream(this.l);
                if (l2.b((InputStream)object2) == 2) {
                    cArray = l2.a((InputStream)object2);
                    if (this.n == null) {
                        this.n = cArray;
                    }
                    object = new PKCS12(new String(cArray), (InputStream)object2);
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(object.length());
                    object.output((OutputStream)byteArrayOutputStream);
                    this.l = byteArrayOutputStream.toByteArray();
                }
            }
            catch (IOException iOException) {
                throw new IOException(iOException.getMessage());
            }
            o2.b(this.l, this.n, 2);
            this.m = null;
            object2 = null;
            try {
                object2 = l2.a(this.n, 2);
            }
            catch (IOException iOException) {
                throw new IOException(iOException.getMessage());
            }
            object = new ByteArrayOutputStream(((Object)object2).length + this.l.length);
            ((OutputStream)object).write((byte[])object2);
            ((OutputStream)object).write(this.l);
            this.l = ((ByteArrayOutputStream)object).toByteArray();
        } else {
            String string2 = null;
            string2 = string.endsWith("ewallet.p12") ? string.replaceAll("ewallet.p12", "cwallet.sso") : string.concat("/cwallet.sso");
            o o3 = this.a(string2, null);
            if (!o3.b()) {
                OraclePKIDebug.a("OracleWallet: saving p12 " + this.l.length + " bytes.");
                o2.a(this.l, this.m);
            } else {
                OraclePKIDebug.a("OracleWallet: saving p12 (& sso or lsso) " + this.l.length + " bytes.");
                byte[] byArray = o3.a();
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
                int n2 = l2.b(byteArrayInputStream);
                if (n2 == 1 || n2 == 3) {
                    o2.a(this.l, this.m, n2);
                }
            }
        }
        this.o = o2;
    }

    public synchronized void saveSSO() throws IOException {
        OraclePKIDebug.a("OracleWallet: saving sso " + this.l.length + " bytes.");
        this.o.b(this.l, this.m, 1);
    }

    public void saveLSSO() throws IOException {
        OraclePKIDebug.a("OracleWallet: saving lsso " + this.l.length + " bytes.");
        this.o.b(this.l, this.m, 3);
    }

    public boolean exists(String string) throws IOException {
        o o2 = this.a(string, this.m);
        return o2.b();
    }

    public synchronized OracleSecretStore getSecretStore() throws IOException, OracleSecretStoreException {
        ByteArrayInputStream byteArrayInputStream = null;
        OraclePKIDebug.a("OracleWallet: getSecretStore");
        if (this.q == null) {
            this.q = new OracleSecretStore();
            if (this.l != null) {
                byteArrayInputStream = new ByteArrayInputStream(this.l);
            }
            this.q.load(byteArrayInputStream, this.m);
        }
        return this.q;
    }

    public KeyStore getKeyStore() throws IOException {
        KeyStore keyStore = null;
        try {
            if (null == Security.getProvider("OraclePKI")) {
                Security.insertProviderAt(new OraclePKIProvider(), 1);
            }
            keyStore = this.m != null ? KeyStore.getInstance("PKCS12", "OraclePKI") : KeyStore.getInstance("SSO", "OraclePKI");
            ByteArrayInputStream byteArrayInputStream = null;
            if (this.l != null) {
                byteArrayInputStream = new ByteArrayInputStream(this.l);
            }
            keyStore.load(byteArrayInputStream, this.m);
        }
        catch (GeneralSecurityException generalSecurityException) {
            return null;
        }
        return keyStore;
    }

    public synchronized void setSecretStore(OracleSecretStore oracleSecretStore) throws IOException, OracleSecretStoreException {
        OraclePKIDebug.a("OracleWallet: setSecretStore");
        ByteArrayInputStream byteArrayInputStream = null;
        if (oracleSecretStore != this.q) {
            throw new OracleSecretStoreException("Secretstore mismatch.");
        }
        if (this.l != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.l);
        }
        this.l = oracleSecretStore.setStoreInWallet(byteArrayInputStream, this.m);
    }

    public void setKeyStore(KeyStore keyStore) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: setKeyStore");
        OracleKeyStoreSpi oracleKeyStoreSpi = new OracleKeyStoreSpi();
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.l != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.l);
        }
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.m);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.l = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, keyStore, this.m);
    }

    public OracleWallet migratePKCS12toJKS(char[] cArray, int n2) throws IOException {
        String string;
        Enumeration<String> enumeration;
        if (!OracleWallet.isValidPassword(cArray)) {
            throw new IOException(b.getString("PKI-01002"));
        }
        OracleWallet oracleWallet = OracleWallet.getInstance("jks");
        oracleWallet.create(cArray);
        KeyStore keyStore = oracleWallet.getKeyStore();
        KeyStore keyStore2 = this.getKeyStore();
        try {
            enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                string = enumeration.nextElement();
                keyStore.deleteEntry(string);
            }
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            iOException.initCause(exception);
            throw iOException;
        }
        try {
            enumeration = keyStore2.aliases();
            while (enumeration.hasMoreElements()) {
                Object object;
                Certificate[] certificateArray;
                string = enumeration.nextElement();
                if ((n2 == 0 || n2 == 2) && keyStore2.isCertificateEntry(string)) {
                    certificateArray = (Certificate[])keyStore2.getCertificate(string);
                    object = new ByteArrayInputStream(certificateArray.getEncoded());
                    keyStore.setCertificateEntry(string, (Certificate)certificateArray);
                    continue;
                }
                if (n2 != 0 && n2 != 1 || !keyStore2.isKeyEntry(string)) continue;
                certificateArray = keyStore2.getCertificateChain(string);
                object = keyStore2.getKey(string, this.m);
                if (certificateArray == null) {
                    X509 x509 = null;
                    BigInteger bigInteger = new BigInteger("7");
                    int n3 = 3650;
                    X500Name x500Name = new X500Name("CN=" + string);
                    CertificateRequest certificateRequest = ((OraclePKIRSAPrivateKey)keyStore2.getKey(string, this.m)).getCertificateRequest();
                    RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(object.getEncoded());
                    x509 = new X509(certificateRequest.getSubject(), certificateRequest.getPublicKey(), certificateRequest.getSubject(), (oracle.security.crypto.core.PrivateKey)rSAPrivateKey, bigInteger, n3);
                    CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                    X509Certificate x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(x509.getEncoded()));
                    Certificate[] certificateArray2 = new Certificate[]{x509Certificate};
                    keyStore.setKeyEntry(string, (Key)object, cArray, certificateArray2);
                    continue;
                }
                keyStore.setKeyEntry(string, (Key)object, cArray, certificateArray);
            }
            oracleWallet.setKeyStore(keyStore);
        }
        catch (Exception exception) {
            IOException iOException = new IOException();
            iOException.initCause(exception);
            throw iOException;
        }
        return oracleWallet;
    }

    public void migrateJKStoPKCS12(KeyStore keyStore, char[] cArray, String[] stringArray) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateEncodingException, CertificateException, UnrecoverableEntryException {
        OraclePKIDebug.a("OracleWallet: migrateJKStoPKCS12");
        if (cArray == null) {
            throw new IOException("keystore password cannot be null");
        }
        try {
            if (stringArray != null) {
                for (int i2 = 0; i2 < stringArray.length; ++i2) {
                    String string = stringArray[i2];
                    if (keyStore.entryInstanceOf(string, g == null ? OracleWallet.a("java.security.KeyStore$PrivateKeyEntry") : g)) {
                        this.a(keyStore, cArray, string);
                        continue;
                    }
                    if (keyStore.entryInstanceOf(string, h == null ? OracleWallet.a("java.security.KeyStore$TrustedCertificateEntry") : h)) {
                        this.a(keyStore, string);
                        continue;
                    }
                    if (keyStore.containsAlias(string)) continue;
                    throw new IOException("Invalid alias : " + string);
                }
            } else {
                Enumeration<String> enumeration = keyStore.aliases();
                while (enumeration.hasMoreElements()) {
                    String string = enumeration.nextElement();
                    if (keyStore.entryInstanceOf(string, g == null ? OracleWallet.a("java.security.KeyStore$PrivateKeyEntry") : g)) {
                        this.a(keyStore, cArray, string);
                        continue;
                    }
                    if (keyStore.entryInstanceOf(string, h == null ? OracleWallet.a("java.security.KeyStore$TrustedCertificateEntry") : h)) {
                        this.a(keyStore, string);
                        continue;
                    }
                    if (keyStore.containsAlias(string)) continue;
                    throw new IOException("Invalid alias : " + string);
                }
            }
        }
        catch (UnrecoverableEntryException unrecoverableEntryException) {
            throw new UnrecoverableEntryException("passwords of the keystore and key entries should be the same");
        }
    }

    void a(KeyStore keyStore, char[] cArray, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateEncodingException, CertificateException, UnrecoverableEntryException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.m == null) {
            this.n = this.b();
        }
        KeyStore.PasswordProtection passwordProtection = new KeyStore.PasswordProtection(cArray);
        KeyStore.PrivateKeyEntry privateKeyEntry = (KeyStore.PrivateKeyEntry)keyStore.getEntry(string, passwordProtection);
        PrivateKey privateKey = privateKeyEntry.getPrivateKey();
        X509Certificate x509Certificate = (X509Certificate)privateKeyEntry.getCertificate();
        X509Certificate[] x509CertificateArray = (X509Certificate[])privateKeyEntry.getCertificateChain();
        PublicKey publicKey = x509Certificate.getPublicKey();
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(privateKey.getEncoded());
        RSAPublicKey rSAPublicKey = new RSAPublicKey(publicKey.getEncoded());
        oracle.security.crypto.core.KeyPair keyPair = new oracle.security.crypto.core.KeyPair((oracle.security.crypto.core.PublicKey)rSAPublicKey, (oracle.security.crypto.core.PrivateKey)rSAPrivateKey);
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = new OraclePKIX509CertImpl[x509CertificateArray.length];
        for (int i2 = 0; i2 < x509CertificateArray.length; ++i2) {
            oraclePKIX509CertImplArray[i2] = new OraclePKIX509CertImpl(new X509(x509CertificateArray[i2].getEncoded()));
        }
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray2 = this.a(oraclePKIX509CertImplArray);
        if (oraclePKIX509CertImplArray2.length > 1) {
            for (int i3 = 0; i3 < oraclePKIX509CertImplArray2.length - 1; ++i3) {
                try {
                    String string2 = keyStore.getCertificateAlias(oraclePKIX509CertImplArray2[i3]);
                    this.internalAddTrustedCert(oraclePKIX509CertImplArray2[i3], string2);
                    if (this.m != null) continue;
                    this.n = this.b(this.n);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            this.a(x500Principal, keyPair, rSAPrivateKey, string);
            this.internalAddUserCert(oraclePKIX509CertImplArray2[oraclePKIX509CertImplArray2.length - 1], string);
            if (this.m == null) {
                this.n = this.b(this.n);
            }
        } else {
            try {
                this.internalAddTrustedCert(oraclePKIX509CertImplArray[0], string);
                if (this.m == null) {
                    this.n = this.b(this.n);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            X500Principal x500Principal = x509Certificate.getSubjectX500Principal();
            int n2 = 1;
            string = string + ' ' + Integer.toString(n2);
            this.a(x500Principal, keyPair, rSAPrivateKey, string);
            this.internalAddUserCert(oraclePKIX509CertImplArray[0], string);
            if (this.m == null) {
                this.n = this.b(this.n);
            }
        }
    }

    void a(KeyStore keyStore, String string) throws IOException, KeyStoreException, CertificateEncodingException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.m == null) {
            this.n = this.b();
        }
        X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
        OraclePKIX509CertImpl oraclePKIX509CertImpl = new OraclePKIX509CertImpl(new X509(x509Certificate.getEncoded()));
        try {
            this.internalAddTrustedCert(oraclePKIX509CertImpl, string);
            if (this.m == null) {
                this.n = this.b(this.n);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void a(X500Principal x500Principal, oracle.security.crypto.core.KeyPair keyPair, RSAPrivateKey rSAPrivateKey, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        X500Name x500Name = new X500Name(x500Principal.toString());
        CertificateRequest certificateRequest = new CertificateRequest(x500Name, keyPair);
        if (this.m == null) {
            this.n = this.b();
        }
        this.internalAddCertReq(certificateRequest, rSAPrivateKey, string);
        if (this.m == null) {
            this.n = this.b(this.n);
        }
    }

    public Enumeration listAliases() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: listAliases");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.l != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.l);
        }
        oracleKeyStoreSpi = this.m != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.m);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        return oracleKeyStoreSpi.engineAliases();
    }

    public CRL createCRL(int n2) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String string;
        KeyStore keyStore = this.getKeyStore();
        RSAPrivateKey rSAPrivateKey = null;
        X509 x509 = null;
        X500Name x500Name = null;
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            rSAPrivateKey = new RSAPrivateKey(keyStore.getKey(string, null).getEncoded());
            x509 = ((OraclePKIX509CertImpl)keyStore.getCertificate(string)).getX509();
            break;
        }
        if (rSAPrivateKey == null || x509 == null) {
            throw new IOException(b.getString("PKI-04002"));
        }
        try {
            string = null;
            x500Name = x509.getSubject();
            string = this.s == null ? new CRL(x500Name, (oracle.security.crypto.core.PrivateKey)rSAPrivateKey, n2) : new CRL(x500Name, (oracle.security.crypto.core.PrivateKey)rSAPrivateKey, n2, this.s);
            return string;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public CRL revokeCertificate(InputStream inputStream, CRL cRL) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(inputStream);
        RevokedCertificate revokedCertificate = new RevokedCertificate(oraclePKIX509CertImplArray[0].getSerialNumber(), new Date());
        cRL.addCertificate(revokedCertificate);
        KeyStore keyStore = this.getKeyStore();
        RSAPrivateKey rSAPrivateKey = null;
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            rSAPrivateKey = new RSAPrivateKey(keyStore.getKey(string, null).getEncoded());
            break;
        }
        if (rSAPrivateKey == null) {
            throw new IOException(b.getString("PKI-04002"));
        }
        if (this.s == null) {
            cRL.setPrivateKey(rSAPrivateKey);
        } else {
            cRL.setPrivateKey(rSAPrivateKey, this.s);
        }
        return cRL;
    }

    public static boolean getRevocationStatus(InputStream inputStream, CRL cRL) throws IOException {
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(inputStream);
        return cRL.isRevoked(oraclePKIX509CertImplArray[0].getSerialNumber());
    }

    public static boolean verifyCRLSignature(InputStream inputStream, CRL cRL) throws IOException, AuthenticationException {
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(inputStream);
        RSAPublicKey rSAPublicKey = new RSAPublicKey(oraclePKIX509CertImplArray[0].getPublicKey().getEncoded());
        cRL.setPublicKey((oracle.security.crypto.core.PublicKey)rSAPublicKey);
        return cRL.verifySignature();
    }

    public void addCertRequest(X500Principal x500Principal, int n2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.addCertRequest(x500Principal, n2, null, null);
    }

    public void addCertRequest(X500Principal x500Principal, int n2, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.addCertRequest(x500Principal, n2, null, string);
    }

    public void addCertRequest(X500Principal x500Principal, int n2, OracleCertExtension oracleCertExtension) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.addCertRequest(x500Principal, n2, oracleCertExtension, null);
    }

    public void addCertRequest(X500Principal x500Principal, int n2, OracleCertExtension oracleCertExtension, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (n2 != 512 && n2 != 768 && n2 != 1024 && n2 != 2048 && n2 != 4096) {
            throw new IOException(b.getString("PKI-07008"));
        }
        KeyPairGenerator keyPairGenerator = KeyPairGenerator.getInstance("RSA");
        keyPairGenerator.initialize(n2);
        KeyPair keyPair = keyPairGenerator.generateKeyPair();
        PublicKey publicKey = keyPair.getPublic();
        PrivateKey privateKey = keyPair.getPrivate();
        RSAPrivateKey rSAPrivateKey = new RSAPrivateKey(privateKey.getEncoded());
        RSAPublicKey rSAPublicKey = new RSAPublicKey(publicKey.getEncoded());
        oracle.security.crypto.core.KeyPair keyPair2 = new oracle.security.crypto.core.KeyPair((oracle.security.crypto.core.PublicKey)rSAPublicKey, (oracle.security.crypto.core.PrivateKey)rSAPrivateKey);
        X500Name x500Name = new X500Name(x500Principal.toString());
        CertificateRequest certificateRequest = new CertificateRequest(x500Name, keyPair2);
        if (oracleCertExtension != null && oracleCertExtension.getSubjectKeyId()) {
            certificateRequest.addExtension((X509Extension)new SubjectKeyIDExtension(CryptoUtils.generateKeyID((oracle.security.crypto.core.PublicKey)rSAPublicKey), false));
        }
        if (this.m == null) {
            this.n = this.b();
        }
        this.internalAddCertReq(certificateRequest, rSAPrivateKey, string);
        if (this.m == null) {
            this.n = this.b(this.n);
        }
    }

    public void addCertRequest(CertificateRequest certificateRequest) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.m == null) {
            this.n = this.b();
        }
        this.internalAddCertReq(certificateRequest, null, null);
        if (this.m == null) {
            this.n = this.b(this.n);
        }
    }

    public String exportCertReqB64(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String string = null;
        KeyStore keyStore = this.getKeyStore();
        X500Name x500Name = new X500Name(x500Principal.toString());
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            String string2;
            String string3 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string3) || !x500Name.equals((Object)new X500Name(string2 = (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey(string3, null)).getCertificateRequest()).getSubject().toString()))) continue;
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            certificateRequest.output((OutputStream)byteArrayOutputStream);
            string = "-----BEGIN NEW CERTIFICATE REQUEST-----\n" + bASE64Encoder.encodeBuffer(byteArrayOutputStream.toByteArray()) + d;
            break;
        }
        return string;
    }

    public InputStream exportCertReq(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String string2 = this.exportCertReqB64(string);
        if (string2 != null) {
            return new ByteArrayInputStream(string2.getBytes());
        }
        return null;
    }

    public String exportCertReqB64(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String string2 = null;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            String string3 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string3) || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey(string3, null)).getCertificateRequest()) == null || !string.equals(string3)) continue;
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            certificateRequest.output((OutputStream)byteArrayOutputStream);
            string2 = "-----BEGIN NEW CERTIFICATE REQUEST-----\n" + bASE64Encoder.encodeBuffer(byteArrayOutputStream.toByteArray()) + d;
            break;
        }
        return string2;
    }

    public InputStream exportCertReq(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String string = this.exportCertReqB64(x500Principal);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        return byteArrayInputStream;
    }

    public InputStream createCert(InputStream inputStream, int n2) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.a(inputStream, n2, null, null, BigInteger.ZERO);
    }

    public InputStream createCert(InputStream inputStream, int n2, BigInteger bigInteger) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.a(inputStream, n2, null, null, bigInteger);
    }

    public InputStream createCert(InputStream inputStream, Date date, Date date2) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.a(inputStream, 0, date, date2, BigInteger.ZERO);
    }

    public InputStream createCert(InputStream inputStream, Date date, Date date2, BigInteger bigInteger) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        return this.a(inputStream, 0, date, date2, bigInteger);
    }

    private InputStream a(InputStream inputStream, int n2, Date date, Date date2, BigInteger bigInteger) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        Serializable serializable;
        Object object;
        CertificateRequest certificateRequest = new CertificateRequest(inputStream);
        KeyStore keyStore = this.getKeyStore();
        RSAPrivateKey rSAPrivateKey = null;
        X509 x509 = null;
        X509 x5092 = null;
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)object)) continue;
            rSAPrivateKey = new RSAPrivateKey(keyStore.getKey((String)object, null).getEncoded());
            serializable = keyStore.getCertificate((String)object);
            if (serializable == null) continue;
            x509 = ((OraclePKIX509CertImpl)serializable).getX509();
            break;
        }
        if (rSAPrivateKey == null || x509 == null) {
            throw new IOException(b.getString("PKI-04002"));
        }
        try {
            x5092 = n2 == 0 ? new X509(certificateRequest.getSubject(), certificateRequest.getPublicKey(), x509.getSubject(), (oracle.security.crypto.core.PrivateKey)rSAPrivateKey, bigInteger, date, date2, this.r) : new X509(certificateRequest, x509, (oracle.security.crypto.core.PrivateKey)rSAPrivateKey, bigInteger, n2, this.r);
            object = null;
            serializable = certificateRequest.getExtensions();
            if (serializable != null) {
                object = serializable.getExtensions();
                for (int i2 = 0; i2 < ((Vector)object).size(); ++i2) {
                    x5092.addExtension((X509Extension)((Vector)object).elementAt(i2));
                }
            }
        }
        catch (SignatureException signatureException) {
            serializable = new IOException("Unable to create certificate");
            serializable.initCause(signatureException);
            throw serializable;
        }
        object = null;
        serializable = new BASE64Encoder();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        x5092.output((OutputStream)byteArrayOutputStream);
        String string = "-----BEGIN CERTIFICATE-----\n" + serializable.encodeBuffer(byteArrayOutputStream.toByteArray()) + f;
        byte[] byArray = string.getBytes();
        object = new ByteArrayInputStream(byArray);
        return object;
    }

    public String exportCertB64(X500Principal x500Principal) throws IOException, KeyStoreException, CertificateEncodingException {
        String string = null;
        KeyStore keyStore = this.getKeyStore();
        X500Name x500Name = new X500Name(x500Principal.toString());
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string2;
            String string3 = enumeration.nextElement();
            OraclePKIX509CertImpl oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate(string3);
            if (oraclePKIX509CertImpl == null || !x500Name.equals((Object)new X500Name(string2 = ((Object)oraclePKIX509CertImpl.getSubjectDN()).toString()))) continue;
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            byte[] byArray = oraclePKIX509CertImpl.getEncoded();
            string = "-----BEGIN CERTIFICATE-----\n" + bASE64Encoder.encodeBuffer(byArray) + f;
            break;
        }
        return string;
    }

    public InputStream exportCert(String string) throws IOException, KeyStoreException, CertificateEncodingException {
        String string2 = this.exportCertB64(string);
        if (string2 != null) {
            return new ByteArrayInputStream(string2.getBytes());
        }
        return null;
    }

    public String exportCertB64(String string) throws IOException, KeyStoreException, CertificateEncodingException {
        String string2 = null;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string3 = enumeration.nextElement();
            OraclePKIX509CertImpl oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate(string3);
            if (oraclePKIX509CertImpl == null || !string.equals(string3)) continue;
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            byte[] byArray = oraclePKIX509CertImpl.getEncoded();
            string2 = "-----BEGIN CERTIFICATE-----\n" + bASE64Encoder.encodeBuffer(byArray) + f;
            break;
        }
        return string2;
    }

    public InputStream exportCert(X500Principal x500Principal) throws IOException, KeyStoreException, CertificateEncodingException {
        String string = this.exportCertB64(x500Principal);
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        return byteArrayInputStream;
    }

    public void importCertB64(String string, boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        this.importCert(byteArrayInputStream, bl, null);
    }

    public void importCertB64(String string, boolean bl, String string2) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        this.importCert(byteArrayInputStream, bl, string2);
    }

    public boolean canModify() throws IOException {
        ByteArrayInputStream byteArrayInputStream;
        l l2;
        int n2;
        boolean bl = true;
        if (this.m == null && ((n2 = (l2 = new l()).b(byteArrayInputStream = new ByteArrayInputStream(this.l))) == 1 || n2 == 3)) {
            bl = false;
        }
        return bl;
    }

    public void importCert(InputStream inputStream, boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        this.importCert(inputStream, bl, null);
    }

    public void importCert(InputStream inputStream, boolean bl, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException(b.getString("PKI-02008"));
        }
        if (this.m == null) {
            this.n = this.b();
        }
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(inputStream);
        if (bl) {
            for (int i2 = 0; i2 < oraclePKIX509CertImplArray.length; ++i2) {
                if (i2 == 0) {
                    this.internalAddTrustedCert(oraclePKIX509CertImplArray[i2], string);
                    continue;
                }
                this.internalAddTrustedCert(oraclePKIX509CertImplArray[i2], null);
            }
        } else if (oraclePKIX509CertImplArray.length > 1) {
            OraclePKIX509CertImpl[] oraclePKIX509CertImplArray2 = this.a(oraclePKIX509CertImplArray);
            for (int i3 = 0; i3 < oraclePKIX509CertImplArray2.length - 1; ++i3) {
                this.internalAddTrustedCert(oraclePKIX509CertImplArray2[i3], null);
            }
            this.internalAddUserCert(oraclePKIX509CertImplArray2[oraclePKIX509CertImplArray2.length - 1], string);
        } else {
            this.internalAddUserCert(oraclePKIX509CertImplArray[0], string);
        }
        if (this.m == null) {
            this.n = this.b(this.n);
        }
    }

    public void deleteCertReq(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.m == null) {
            this.n = this.b();
        }
        this.internalRemoveCertReq(x500Principal);
        if (this.m == null) {
            this.n = this.b(this.n);
        }
    }

    public void deleteCertReq(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.m == null) {
            this.n = this.b();
        }
        this.internalRemoveCertReq(string);
        if (this.m == null) {
            this.n = this.b(this.n);
        }
    }

    public void removePrivateKey(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.m == null) {
            this.n = this.b();
        }
        this.internalRemovePrivateKey(string);
        if (this.m == null) {
            this.n = this.b(this.n);
        }
    }

    public void deleteCert(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.m == null) {
            this.n = this.b();
        }
        this.internalRemoveUserCert(x500Principal);
        if (this.m == null) {
            this.n = this.b(this.n);
        }
    }

    public void deleteCert(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.m == null) {
            this.n = this.b();
        }
        this.internalRemoveUserCert(string);
        if (this.m == null) {
            this.n = this.b(this.n);
        }
    }

    public boolean isTrustedCertUsedInChain(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: isTrustedCertUsedInChain");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.l != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.l);
        }
        oracleKeyStoreSpi = this.m != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.m);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        return oracleKeyStoreSpi.a(x500Principal);
    }

    public boolean isTrustedCertUsedInChain(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: isTrustedCertUsedInChain");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.l != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.l);
        }
        oracleKeyStoreSpi = this.m != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.m);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        return oracleKeyStoreSpi.a(string);
    }

    public void removeTrustpoint(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.m == null) {
            this.n = this.b();
        }
        this.internalRemoveTrustedCert(x500Principal);
        if (this.m == null) {
            this.n = this.b(this.n);
        }
    }

    public void removeTrustpoint(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.m == null) {
            this.n = this.b();
        }
        this.internalRemoveTrustedCert(string);
        if (this.m == null) {
            this.n = this.b(this.n);
        }
    }

    public void removeTrustpoints() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        if (!this.canModify()) {
            throw new IOException("Cannot modify AL wallet.");
        }
        if (this.m == null) {
            this.n = this.b();
        }
        this.internalRemoveAllTrusted();
        if (this.m == null) {
            this.n = this.b(this.n);
        }
    }

    public int getPersonaCount() {
        return 1;
    }

    public X500Principal[] getCertReqDNs(int n2) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        X500Principal[] x500PrincipalArray;
        Vector<X500Principal> vector = new Vector<X500Principal>();
        if (n2 != 0) {
            throw new IOException("No persona with index=" + n2 + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            x500PrincipalArray = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)x500PrincipalArray) || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey((String)x500PrincipalArray, null)).getCertificateRequest()) == null) continue;
            vector.add(new X500Principal(certificateRequest.getSubject().toString()));
        }
        x500PrincipalArray = new X500Principal[vector.size()];
        int n3 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            x500PrincipalArray[n3] = (X500Principal)enumeration2.nextElement();
            ++n3;
        }
        return x500PrincipalArray;
    }

    public ArrayList getCertReqDNalias(int n2) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        ArrayList arrayList = new ArrayList();
        if (n2 != 0) {
            throw new IOException("No persona with index=" + n2 + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            CertificateRequest certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey(string, null)).getCertificateRequest();
            if (certificateRequest == null) continue;
            arrayList2.add(certificateRequest.getSubject().toString());
            arrayList2.add(string);
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public String[] getCertReqAliases(int n2) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String[] stringArray;
        Vector<String[]> vector = new Vector<String[]>();
        if (n2 != 0) {
            throw new IOException("No persona with index=" + n2 + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            stringArray = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)stringArray) || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey((String)stringArray, null)).getCertificateRequest()) == null) continue;
            vector.add(stringArray);
        }
        stringArray = new String[vector.size()];
        int n3 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            stringArray[n3] = (String)enumeration2.nextElement();
            ++n3;
        }
        return stringArray;
    }

    public String[] getPPvtAliases(int n2) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String[] stringArray;
        Vector<String[]> vector = new Vector<String[]>();
        if (n2 != 0) {
            throw new IOException("No persona with index=" + n2 + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            stringArray = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)stringArray) || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey((String)stringArray, null)).getCertificateRequest()) == null) continue;
            vector.add(stringArray);
        }
        stringArray = new String[vector.size()];
        int n3 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            stringArray[n3] = (String)enumeration2.nextElement();
            ++n3;
        }
        return stringArray;
    }

    public String[] getPPvtInfo(int n2, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateException {
        String[] stringArray = new String[2];
        Vector vector = new Vector();
        if (n2 != 0) {
            throw new IOException("No persona with index=" + n2 + " in wallet.");
        }
        int n3 = this.internalGetCRCompNum(string);
        stringArray[0] = Integer.toString(n3);
        stringArray[1] = Integer.toString(-1);
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        Object var8_8 = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            String string2 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string2) || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey(string2, null)).getCertificateRequest()) == null || !string.equals(string2)) continue;
            OraclePKIX509CertImpl oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate(string2);
            if (oraclePKIX509CertImpl != null) {
                stringArray[1] = Integer.toString(2);
                break;
            }
            stringArray[1] = Integer.toString(1);
            break;
        }
        return stringArray;
    }

    public byte[] getPPvtBytes(int n2, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateException {
        byte[] byArray = null;
        if (n2 != 0) {
            throw new IOException("No persona with index=" + n2 + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        Object var6_6 = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            OraclePKIRSAPrivateKey oraclePKIRSAPrivateKey;
            String string2 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string2) || (oraclePKIRSAPrivateKey = (OraclePKIRSAPrivateKey)keyStore.getKey(string2, null)) == null || !string.equals(string2)) continue;
            byArray = oraclePKIRSAPrivateKey.getEncoded();
            break;
        }
        return new String("").getBytes();
    }

    public byte[] getPPvtBytesUnEnc(int n2, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException, CertificateException {
        byte[] byArray = null;
        if (n2 != 0) {
            throw new IOException("No persona with index=" + n2 + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        Object var6_6 = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            OraclePKIRSAPrivateKey oraclePKIRSAPrivateKey;
            String string2 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string2) || (oraclePKIRSAPrivateKey = (OraclePKIRSAPrivateKey)keyStore.getKey(string2, null)) == null || !string.equals(string2)) continue;
            byArray = oraclePKIRSAPrivateKey.getEncoded();
            break;
        }
        return byArray;
    }

    public int getCertReqCount(int n2) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        int n3 = 0;
        if (n2 != 0) {
            throw new IOException("No persona with index=" + n2 + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string) || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey(string, null)).getCertificateRequest()) == null) continue;
            ++n3;
        }
        return n3;
    }

    public X500Principal[] getCertReqDNs(int n2, boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        X500Principal[] x500PrincipalArray;
        Vector<X500Principal> vector = new Vector<X500Principal>();
        if (n2 != 0) {
            throw new IOException("No persona with index=" + n2 + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            x500PrincipalArray = enumeration.nextElement();
            if (bl) {
                if (!keyStore.isKeyEntry((String)x500PrincipalArray) || keyStore.getCertificate((String)x500PrincipalArray) != null || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey((String)x500PrincipalArray, null)).getCertificateRequest()) == null) continue;
                vector.add(new X500Principal(certificateRequest.getSubject().toString()));
                continue;
            }
            if (!keyStore.isKeyEntry((String)x500PrincipalArray) || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey((String)x500PrincipalArray, null)).getCertificateRequest()) == null) continue;
            vector.add(new X500Principal(certificateRequest.getSubject().toString()));
        }
        x500PrincipalArray = new X500Principal[vector.size()];
        int n3 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            x500PrincipalArray[n3] = (X500Principal)enumeration2.nextElement();
            ++n3;
        }
        return x500PrincipalArray;
    }

    public ArrayList getCertReqDNalias(int n2, boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        ArrayList arrayList = new ArrayList();
        if (n2 != 0) {
            throw new IOException("No persona with index=" + n2 + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            String string = enumeration.nextElement();
            ArrayList<String> arrayList2 = new ArrayList<String>();
            if (bl) {
                if (!keyStore.isKeyEntry(string) || keyStore.getCertificate(string) != null || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey(string, null)).getCertificateRequest()) == null) continue;
                arrayList2.add(certificateRequest.getSubject().toString());
                arrayList2.add(string);
                arrayList.add(arrayList2);
                continue;
            }
            if (!keyStore.isKeyEntry(string) || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey(string, null)).getCertificateRequest()) == null) continue;
            arrayList2.add(certificateRequest.getSubject().toString());
            arrayList2.add(string);
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public int getCertReqCount(int n2, boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        int n3 = 0;
        if (n2 != 0) {
            throw new IOException("No persona with index=" + n2 + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        boolean bl2 = false;
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            String string = enumeration.nextElement();
            if (bl) {
                if (!keyStore.isKeyEntry(string) || keyStore.getCertificate(string) != null || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey(string, null)).getCertificateRequest()) == null) continue;
                ++n3;
                continue;
            }
            if (!keyStore.isKeyEntry(string) || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey(string, null)).getCertificateRequest()) == null) continue;
            ++n3;
        }
        return n3;
    }

    public String[] getCertReqInfo(int n2, int n3) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String[] stringArray = new String[4];
        if (n2 != 0) {
            throw new IOException("No persona with index=" + n2 + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        int n4 = 0;
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            CertificateRequest certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey(string, null)).getCertificateRequest();
            if (certificateRequest != null && n3 == n4) {
                stringArray[0] = certificateRequest.getSubject().toString();
                stringArray[1] = new Integer(((RSAPublicKey)certificateRequest.getPublicKey()).modulusLength() * 8).toString();
                stringArray[2] = new String(certificateRequest.getPublicKey().getAlgorithm());
                stringArray[3] = new String(string);
                break;
            }
            ++n4;
        }
        return stringArray;
    }

    public String[] getCertReqInfo(int n2, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String[] stringArray = new String[3];
        if (n2 != 0) {
            throw new IOException("No persona with index=" + n2 + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            CertificateRequest certificateRequest;
            String string2 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string2) || (certificateRequest = ((OraclePKIRSAPrivateKey)keyStore.getKey(string2, null)).getCertificateRequest()) == null || !string.equals(string2)) continue;
            stringArray[0] = certificateRequest.getSubject().toString();
            stringArray[1] = new Integer(((RSAPublicKey)certificateRequest.getPublicKey()).modulusLength() * 8).toString();
            stringArray[2] = new String(certificateRequest.getPublicKey().getAlgorithm());
            break;
        }
        return stringArray;
    }

    public X500Principal[] getCertDNs(int n2) throws IOException, KeyStoreException {
        X500Principal[] x500PrincipalArray;
        Vector<X500Principal> vector = new Vector<X500Principal>();
        if (n2 != 0) {
            throw new IOException("No persona with index=" + n2 + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            x500PrincipalArray = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)x500PrincipalArray) || (x509Certificate = (X509Certificate)keyStore.getCertificate((String)x500PrincipalArray)) == null) continue;
            vector.add(new X500Principal(((Object)x509Certificate.getSubjectDN()).toString()));
        }
        x500PrincipalArray = new X500Principal[vector.size()];
        int n3 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            x500PrincipalArray[n3] = (X500Principal)enumeration2.nextElement();
            ++n3;
        }
        return x500PrincipalArray;
    }

    public ArrayList getCertDNalias(int n2) throws IOException, KeyStoreException {
        ArrayList arrayList = new ArrayList();
        if (n2 != 0) {
            throw new IOException("No persona with index=" + n2 + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
            if (x509Certificate == null) continue;
            arrayList2.add(((Object)x509Certificate.getSubjectDN()).toString());
            arrayList2.add(string);
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public String[] getCertAliases(int n2) throws IOException, KeyStoreException {
        String[] stringArray;
        Vector<String[]> vector = new Vector<String[]>();
        if (n2 != 0) {
            throw new IOException("No persona with index=" + n2 + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            stringArray = enumeration.nextElement();
            if (!keyStore.isKeyEntry((String)stringArray) || (x509Certificate = (X509Certificate)keyStore.getCertificate((String)stringArray)) == null) continue;
            vector.add(stringArray);
        }
        stringArray = new String[vector.size()];
        int n3 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            stringArray[n3] = (String)enumeration2.nextElement();
            ++n3;
        }
        return stringArray;
    }

    public String[] getCertInfo(int n2, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        String[] stringArray = new String[12];
        Vector vector = new Vector();
        if (n2 != 0) {
            throw new IOException("No persona with index=" + n2 + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            OraclePKIX509CertImpl oraclePKIX509CertImpl;
            String string2 = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate(string2)) == null || !string.equals(string2)) continue;
            stringArray[0] = ((Object)oraclePKIX509CertImpl.getSubjectDN()).toString();
            stringArray[1] = ((Object)oraclePKIX509CertImpl.getIssuerDN()).toString();
            stringArray[2] = Integer.toString(oraclePKIX509CertImpl.getVersion());
            stringArray[3] = oraclePKIX509CertImpl.getSerialNumber().toString(16);
            stringArray[4] = Integer.toString((int)(oraclePKIX509CertImpl.getNotBefore().getTime() / 1000L));
            stringArray[5] = Integer.toString((int)(oraclePKIX509CertImpl.getNotAfter().getTime() / 1000L));
            stringArray[6] = new Integer(((java.security.interfaces.RSAPublicKey)oraclePKIX509CertImpl.getPublicKey()).getModulus().bitLength()).toString();
            stringArray[7] = this.a(oraclePKIX509CertImpl.getKeyUsage());
            stringArray[8] = oraclePKIX509CertImpl.getSigAlgName();
            stringArray[9] = oraclePKIX509CertImpl.getMD5Digest();
            stringArray[10] = oraclePKIX509CertImpl.getSHADigest();
            stringArray[11] = Integer.toString(this.internalGetCertCompNum(string));
            break;
        }
        return stringArray;
    }

    protected String a(boolean[] blArray) {
        return "SSL";
    }

    public int getCertCount(int n2) throws IOException, KeyStoreException, CertificateException {
        int n3 = 0;
        if (n2 != 0) {
            throw new IOException("No persona with index=" + n2 + " in wallet.");
        }
        Object var3_3 = null;
        Object var4_4 = null;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string) || (x509Certificate = (X509Certificate)keyStore.getCertificate(string)) == null) continue;
            ++n3;
        }
        return n3;
    }

    public X509Certificate getCert(int n2, int n3) throws IOException, KeyStoreException, CertificateException {
        if (n2 != 0) {
            throw new IOException("No persona with index=" + n2 + " in wallet.");
        }
        Object var3_3 = null;
        X509Certificate x509Certificate = null;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        int n4 = 0;
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isKeyEntry(string)) continue;
            X509Certificate x509Certificate2 = (X509Certificate)keyStore.getCertificate(string);
            if (x509Certificate2 != null && n3 == n4) {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(x509Certificate2.getEncoded()));
                break;
            }
            if (x509Certificate2 == null) continue;
            ++n4;
        }
        return x509Certificate;
    }

    public X509Certificate getSSLCert(boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        X509Certificate x509Certificate = null;
        String string = null;
        KeyStore keyStore = null;
        keyStore = this.getKeyStore();
        String string2 = "OracleX509";
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string2);
        keyManagerFactory.init(keyStore, this.m);
        KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
        String[] stringArray = new String[]{"RSA"};
        Principal[] principalArray = this.getTrustpointDNs(0);
        string = bl ? ((X509KeyManager)keyManagerArray[0]).chooseServerAlias(stringArray[0], principalArray, null) : ((X509KeyManager)keyManagerArray[0]).chooseClientAlias(stringArray, principalArray, null);
        if (string == null) {
            throw new IOException(b.getString("PKI-04016"));
        }
        x509Certificate = (X509Certificate)keyStore.getCertificate(string);
        return x509Certificate;
    }

    public String getSSLCertAlias(boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, UnrecoverableKeyException {
        String string = null;
        KeyStore keyStore = null;
        keyStore = this.getKeyStore();
        String string2 = "OracleX509";
        KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(string2);
        keyManagerFactory.init(keyStore, this.m);
        KeyManager[] keyManagerArray = keyManagerFactory.getKeyManagers();
        String[] stringArray = new String[]{"RSA"};
        Principal[] principalArray = this.getTrustpointDNs(0);
        string = bl ? ((X509KeyManager)keyManagerArray[0]).chooseServerAlias(stringArray[0], principalArray, null) : ((X509KeyManager)keyManagerArray[0]).chooseClientAlias(stringArray, principalArray, null);
        if (string == null) {
            throw new IOException(b.getString("PKI-04016"));
        }
        return string;
    }

    public X500Principal[] getTrustpointDNs(int n2) throws IOException, KeyStoreException {
        X500Principal[] x500PrincipalArray;
        Vector<X500Principal> vector = new Vector<X500Principal>();
        if (n2 != 0) {
            throw new IOException("No persona with index=" + n2 + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            x500PrincipalArray = enumeration.nextElement();
            if (!keyStore.isCertificateEntry((String)x500PrincipalArray) || (x509Certificate = (X509Certificate)keyStore.getCertificate((String)x500PrincipalArray)) == null) continue;
            vector.add(new X500Principal(((Object)x509Certificate.getSubjectDN()).toString()));
        }
        x500PrincipalArray = new X500Principal[vector.size()];
        int n3 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            x500PrincipalArray[n3] = (X500Principal)enumeration2.nextElement();
            ++n3;
        }
        return x500PrincipalArray;
    }

    public ArrayList getTrustpointDNalias(int n2) throws IOException, KeyStoreException {
        ArrayList arrayList = new ArrayList();
        if (n2 != 0) {
            throw new IOException("No persona with index=" + n2 + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string)) continue;
            ArrayList<String> arrayList2 = new ArrayList<String>();
            X509Certificate x509Certificate = (X509Certificate)keyStore.getCertificate(string);
            if (x509Certificate == null) continue;
            arrayList2.add(((Object)x509Certificate.getSubjectDN()).toString());
            arrayList2.add(string);
            arrayList.add(arrayList2);
        }
        return arrayList;
    }

    public String[] getTrustpointAliases(int n2) throws IOException, KeyStoreException {
        String[] stringArray;
        Vector<String[]> vector = new Vector<String[]>();
        if (n2 != 0) {
            throw new IOException("No persona with index=" + n2 + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            stringArray = enumeration.nextElement();
            if (!keyStore.isCertificateEntry((String)stringArray) || (x509Certificate = (X509Certificate)keyStore.getCertificate((String)stringArray)) == null) continue;
            vector.add(stringArray);
        }
        stringArray = new String[vector.size()];
        int n3 = 0;
        Enumeration enumeration2 = vector.elements();
        while (enumeration2.hasMoreElements()) {
            stringArray[n3] = (String)enumeration2.nextElement();
            ++n3;
        }
        return stringArray;
    }

    public String[] getTrustpointInfo(int n2, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        String[] stringArray = new String[12];
        Vector vector = new Vector();
        if (n2 != 0) {
            throw new IOException("No persona with index=" + n2 + " in wallet.");
        }
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = null;
        enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            OraclePKIX509CertImpl oraclePKIX509CertImpl;
            String string2 = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string2) || (oraclePKIX509CertImpl = (OraclePKIX509CertImpl)keyStore.getCertificate(string2)) == null || !string.equals(string2)) continue;
            stringArray[0] = ((Object)oraclePKIX509CertImpl.getSubjectDN()).toString();
            stringArray[1] = ((Object)oraclePKIX509CertImpl.getIssuerDN()).toString();
            stringArray[2] = Integer.toString(oraclePKIX509CertImpl.getVersion());
            stringArray[3] = oraclePKIX509CertImpl.getSerialNumber().toString(16);
            stringArray[4] = Integer.toString((int)(oraclePKIX509CertImpl.getNotBefore().getTime() / 1000L));
            stringArray[5] = Integer.toString((int)(oraclePKIX509CertImpl.getNotAfter().getTime() / 1000L));
            stringArray[6] = new Integer(((java.security.interfaces.RSAPublicKey)oraclePKIX509CertImpl.getPublicKey()).getModulus().bitLength()).toString();
            stringArray[7] = this.a(oraclePKIX509CertImpl.getKeyUsage());
            stringArray[8] = oraclePKIX509CertImpl.getSigAlgName();
            stringArray[9] = oraclePKIX509CertImpl.getMD5Digest();
            stringArray[10] = oraclePKIX509CertImpl.getSHADigest();
            stringArray[11] = Integer.toString(this.internalGetTCertCompNum(string));
            break;
        }
        return stringArray;
    }

    public int getTrustpointCount(int n2) throws IOException, KeyStoreException, CertificateException {
        int n3 = 0;
        if (n2 != 0) {
            throw new IOException("No persona with index=" + n2 + " in wallet.");
        }
        Object var3_3 = null;
        Object var4_4 = null;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        boolean bl = false;
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            String string = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string) || (x509Certificate = (X509Certificate)keyStore.getCertificate(string)) == null) continue;
            ++n3;
        }
        return n3;
    }

    public X509Certificate getTrustpoint(int n2, int n3) throws IOException, KeyStoreException, CertificateException {
        if (n2 != 0) {
            throw new IOException("No persona with index=" + n2 + " in wallet.");
        }
        Object var3_3 = null;
        X509Certificate x509Certificate = null;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        int n4 = 0;
        while (enumeration.hasMoreElements()) {
            String string = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string)) continue;
            X509Certificate x509Certificate2 = (X509Certificate)keyStore.getCertificate(string);
            if (x509Certificate2 != null && n3 == n4) {
                CertificateFactory certificateFactory = CertificateFactory.getInstance("X.509");
                x509Certificate = (X509Certificate)certificateFactory.generateCertificate(new ByteArrayInputStream(x509Certificate2.getEncoded()));
                break;
            }
            ++n4;
        }
        return x509Certificate;
    }

    public void changePassword(char[] cArray) throws IOException {
        if (cArray == null) {
            throw new IOException("Password cannot be null string.");
        }
        if (!OracleWallet.isValidPassword(cArray)) {
            throw new IOException(b.getString("PKI-01002"));
        }
        if (this.m == null) {
            throw new IOException("Cannot modify SSO wallet password.");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.l);
        PKCS12 pKCS12 = new PKCS12(new String(this.m), (InputStream)byteArrayInputStream);
        Vector vector = pKCS12.getAuthSafes();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            PKCS12Safe pKCS12Safe = (PKCS12Safe)vector.elementAt(i2);
            Vector vector2 = pKCS12Safe.getBags();
            for (int i3 = 0; i3 < vector2.size(); ++i3) {
                PKCS12Bag pKCS12Bag = (PKCS12Bag)vector2.elementAt(i3);
                if (!(pKCS12Bag instanceof PKCS12ShroudedKeyBag)) continue;
                oracle.security.crypto.core.PrivateKey privateKey = ((PKCS12ShroudedKeyBag)pKCS12Bag).getPrivateKey();
                PKCS12KeyBag pKCS12KeyBag = new PKCS12KeyBag(pKCS12Safe, privateKey);
                vector2.removeElementAt(i3);
                vector2.addElement(pKCS12KeyBag);
            }
            pKCS12Safe.setBags(vector2);
            ((PKCS12Safe)vector.elementAt(i2)).setPassword(new String(cArray));
        }
        pKCS12.setPassword(new String(cArray));
        try {
            OraclePKIDebug.a("Verifying wallet " + pKCS12.verify());
        }
        catch (AuthenticationException authenticationException) {
            OraclePKIDebug.a("Verifying wallet failed" + (Object)((Object)authenticationException));
            throw new IOException(b.getString("PKI-02004"));
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(pKCS12.length());
        pKCS12.output((OutputStream)byteArrayOutputStream);
        this.l = byteArrayOutputStream.toByteArray();
        this.m = cArray;
    }

    public InputStream exportCertChain(X500Principal x500Principal) throws IOException, KeyStoreException, CertificateException {
        String string = this.exportCertChainB64(x500Principal);
        return new ByteArrayInputStream(string.getBytes());
    }

    public String exportCertChainB64(X500Principal x500Principal) throws IOException, KeyStoreException, CertificateException {
        Object object;
        Enumeration<String> enumeration;
        Certificate[] certificateArray;
        String string = null;
        String string2 = null;
        boolean bl = false;
        KeyStore keyStore = this.getKeyStore();
        if (x500Principal != null) {
            certificateArray = new X500Name(x500Principal.toString());
            enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                String string3;
                string2 = enumeration.nextElement();
                object = (OraclePKIX509CertImpl)keyStore.getCertificate(string2);
                if (object == null || !keyStore.isKeyEntry(string2) || !certificateArray.equals((Object)new X500Name(string3 = ((Object)((OraclePKIX509CertImpl)object).getSubjectDN()).toString()))) continue;
                bl = true;
                break;
            }
            if (!bl) {
                OraclePKIDebug.a("No certificate with matching DN found in wallet.");
                return string;
            }
        } else {
            enumeration = keyStore.aliases();
            while (enumeration.hasMoreElements()) {
                string2 = enumeration.nextElement();
                if (!keyStore.isKeyEntry(string2)) continue;
                bl = true;
                break;
            }
            if (!bl) {
                OraclePKIDebug.a("No user certificate found in wallet.");
                return string;
            }
        }
        certificateArray = keyStore.getCertificateChain(string2);
        object = new PKCS7();
        OraclePKIDebug.a("Found cert chain of length = " + certificateArray.length);
        if (certificateArray.length > 1) {
            for (int i2 = 1; i2 < certificateArray.length; ++i2) {
                object.addCertificate(new X509(((OraclePKIX509CertImpl)certificateArray[i2]).getEncoded()));
            }
        } else if (certificateArray.length == 1) {
            object.addCertificate(new X509(((OraclePKIX509CertImpl)certificateArray[0]).getEncoded()));
        } else {
            OraclePKIDebug.a("Certificate chain length is zero");
            return string;
        }
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        byte[] byArray = object.getEncoded();
        string = "-----BEGIN CERTIFICATE-----\n" + bASE64Encoder.encodeBuffer(byArray) + f;
        return string;
    }

    public InputStream exportCertChain(String string) throws IOException, KeyStoreException, CertificateException {
        String string2 = this.exportCertChainB64(string);
        if (string2 != null) {
            return new ByteArrayInputStream(string2.getBytes());
        }
        return null;
    }

    public String exportCertChainB64(String string) throws IOException, KeyStoreException, CertificateException {
        String string2 = null;
        boolean bl = false;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        String string3 = null;
        while (enumeration.hasMoreElements()) {
            string3 = enumeration.nextElement();
            if (!string.equals(string3) || !keyStore.isKeyEntry(string3)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            OraclePKIDebug.a("No certificate with matching alias found in wallet.");
            return string2;
        }
        Certificate[] certificateArray = keyStore.getCertificateChain(string3);
        PKCS7 pKCS7 = new PKCS7();
        OraclePKIDebug.a("Found cert chain of length = " + certificateArray.length);
        if (certificateArray.length > 1) {
            for (int i2 = 1; i2 < certificateArray.length; ++i2) {
                pKCS7.addCertificate(new X509(certificateArray[i2].getEncoded()));
            }
        } else if (certificateArray.length == 1) {
            pKCS7.addCertificate(new X509(certificateArray[0].getEncoded()));
        } else {
            OraclePKIDebug.a("Certificate chain length is zero");
            return string2;
        }
        BASE64Encoder bASE64Encoder = new BASE64Encoder();
        byte[] byArray = pKCS7.getEncoded();
        string2 = "-----BEGIN CERTIFICATE-----\n" + bASE64Encoder.encodeBuffer(byArray) + f;
        return string2;
    }

    public String exportUserCertChainB64() throws IOException, KeyStoreException, CertificateException {
        String string = null;
        try {
            X509Certificate x509Certificate = this.getSSLCert(true);
            String string2 = ((Object)x509Certificate.getSubjectDN()).toString();
            string = this.exportCertChainB64(new X500Principal(string2));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
        return string;
    }

    public String trustpointNeededB64(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        return this.trustpointNeededB64(string, null, true);
    }

    public String trustpointNeededB64(String string, String string2, boolean bl) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        Object object;
        boolean bl2 = false;
        OraclePKIX509CertImpl oraclePKIX509CertImpl = null;
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string.getBytes());
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray = OraclePKIGenFunc.readCertsAt(byteArrayInputStream);
        for (int i2 = 0; i2 < oraclePKIX509CertImplArray.length; ++i2) {
            object = ((Object)oraclePKIX509CertImplArray[i2].getSubjectDN()).toString();
            bl2 = this.isTrustedCertUsedInChain(new X500Principal((String)object));
            if (bl2) {
                return null;
            }
            if (string2 == null || !string2.equals(object)) continue;
            oraclePKIX509CertImpl = oraclePKIX509CertImplArray[i2];
        }
        if (string2 != null) {
            if (oraclePKIX509CertImpl != null) {
                BASE64Encoder bASE64Encoder = new BASE64Encoder();
                object = oraclePKIX509CertImpl.getEncoded();
                String string3 = "-----BEGIN CERTIFICATE-----\n" + bASE64Encoder.encodeBuffer((byte[])object) + f;
                return string3;
            }
            throw new IOException("No trustpoint with matching DN in chain");
        }
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray2 = this.a(oraclePKIX509CertImplArray);
        oraclePKIX509CertImpl = bl ? oraclePKIX509CertImplArray2[oraclePKIX509CertImplArray2.length - 1] : oraclePKIX509CertImplArray2[0];
        object = new BASE64Encoder();
        byte[] byArray = oraclePKIX509CertImpl.getEncoded();
        String string4 = "-----BEGIN CERTIFICATE-----\n" + object.encodeBuffer(byArray) + f;
        return string4;
    }

    public String exportTrustedB64(String string) throws IOException, KeyStoreException, CertificateEncodingException {
        String string2 = null;
        KeyStore keyStore = this.getKeyStore();
        Enumeration<String> enumeration = keyStore.aliases();
        while (enumeration.hasMoreElements()) {
            X509Certificate x509Certificate;
            String string3 = enumeration.nextElement();
            if (!keyStore.isCertificateEntry(string3) || (x509Certificate = (X509Certificate)keyStore.getCertificate(string3)) == null || !string.equals(string3)) continue;
            BASE64Encoder bASE64Encoder = new BASE64Encoder();
            byte[] byArray = x509Certificate.getEncoded();
            string2 = "-----BEGIN CERTIFICATE-----\n" + bASE64Encoder.encodeBuffer(byArray) + f;
            break;
        }
        return string2;
    }

    public boolean isAutoLoginOnly() throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        try {
            this.getSecretStore();
        }
        catch (Exception exception) {
            this.a();
            IOException iOException = new IOException(b.getString("PKI-03004"));
            iOException.initCause(exception);
            throw iOException;
        }
        if (this.l == null) {
            throw new IOException("Wallet array is null.");
        }
        byteArrayInputStream = new ByteArrayInputStream(this.l);
        if (this.m != null) {
            return false;
        }
        l l2 = new l();
        return l2.b(byteArrayInputStream) == 2;
    }

    public void internalAddCertReq(CertificateRequest certificateRequest, RSAPrivateKey rSAPrivateKey, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: internalAddCertReq");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.l != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.l);
        }
        oracleKeyStoreSpi = this.m != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.m);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.l = oracleKeyStoreSpi.a(byteArrayInputStream, this.m, certificateRequest, rSAPrivateKey, string);
    }

    public void internalRemoveCertReq(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        OraclePKIDebug.a("OracleWallet: internalRemoveUserCertReq");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.l != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.l);
        }
        oracleKeyStoreSpi = this.m != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.m);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.l = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.m, x500Principal);
    }

    public void internalRemoveCertReq(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        OraclePKIDebug.a("OracleWallet: internalRemoveUserCertReq");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.l != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.l);
        }
        oracleKeyStoreSpi = this.m != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.m);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.l = oracleKeyStoreSpi.a((InputStream)byteArrayInputStream, this.m, string);
    }

    public void internalRemovePrivateKey(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        OraclePKIDebug.a("OracleWallet: internalRemoveUserCertReq");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.l != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.l);
        }
        oracleKeyStoreSpi = this.m != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.m);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.l = oracleKeyStoreSpi.h(byteArrayInputStream, this.m, string);
    }

    public int internalGetCRCompNum(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, UnrecoverableKeyException {
        OraclePKIDebug.a("OracleWallet: internalGetCRCompNum");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.l != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.l);
        }
        oracleKeyStoreSpi = this.m != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.m);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        return oracleKeyStoreSpi.i(byteArrayInputStream, this.m, string);
    }

    public int internalGetTCertCompNum(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: internalGetTCertCompNum");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.l != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.l);
        }
        oracleKeyStoreSpi = this.m != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.m);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        return oracleKeyStoreSpi.k(byteArrayInputStream, this.m, string);
    }

    public int internalGetCertCompNum(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: internalGetCertCompNum");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.l != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.l);
        }
        oracleKeyStoreSpi = this.m != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.m);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        return oracleKeyStoreSpi.j(byteArrayInputStream, this.m, string);
    }

    public void internalAddTrustedCert(OraclePKIX509CertImpl oraclePKIX509CertImpl, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: internalAddTrustedCert");
        if (!oraclePKIX509CertImpl.getX509().getPublicKey().getAlgorithm().equals("RSA")) {
            throw new IOException(b.getString("PKI-04019") + oraclePKIX509CertImpl.getX509().getPublicKey().getAlgorithm());
        }
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.l != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.l);
        }
        oracleKeyStoreSpi = this.m != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.m);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.l = oracleKeyStoreSpi.a(byteArrayInputStream, this.m, oraclePKIX509CertImpl, string);
    }

    public void internalRemoveTrustedCert(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: internalRemoveTrustedCert");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.l != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.l);
        }
        oracleKeyStoreSpi = this.m != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.m);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.l = oracleKeyStoreSpi.c((InputStream)byteArrayInputStream, this.m, x500Principal);
    }

    public void internalRemoveTrustedCert(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: internalRemoveTrustedCert");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.l != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.l);
        }
        oracleKeyStoreSpi = this.m != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.m);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.l = oracleKeyStoreSpi.c((InputStream)byteArrayInputStream, this.m, string);
    }

    public void internalRemoveAllTrusted() throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: internalRemoveAllTrusted");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.l != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.l);
        }
        oracleKeyStoreSpi = this.m != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.m);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.l = oracleKeyStoreSpi.b(byteArrayInputStream, this.m);
    }

    public void internalAddUserCert(OraclePKIX509CertImpl oraclePKIX509CertImpl, String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: internalAddUserCert");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.l != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.l);
        }
        oracleKeyStoreSpi = this.m != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.m);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.l = oracleKeyStoreSpi.b(byteArrayInputStream, this.m, oraclePKIX509CertImpl, string);
    }

    public void internalRemoveUserCert(X500Principal x500Principal) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: internalRemoveUserCert");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.l != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.l);
        }
        oracleKeyStoreSpi = this.m != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.m);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.l = oracleKeyStoreSpi.b((InputStream)byteArrayInputStream, this.m, x500Principal);
    }

    public void internalRemoveUserCert(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: internalRemoveUserCert");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.l != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.l);
        }
        oracleKeyStoreSpi = this.m != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.m);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.l = oracleKeyStoreSpi.b((InputStream)byteArrayInputStream, this.m, string);
    }

    public Enumeration getWalletPersonas() {
        Hashtable<String, OracleWalletPersona> hashtable = new Hashtable<String, OracleWalletPersona>();
        OracleWalletPersona oracleWalletPersona = new OracleWalletPersona(this);
        hashtable.put("one", oracleWalletPersona);
        return hashtable.elements();
    }

    public void Pkcs11AddCertReq(String string, String string2, String string3, String string4, int n2, String string5) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException, NZException {
        byte[] byArray = NZNative.Pkcs11AddCertReq((String)string, (String)string2, (String)string3, (String)string4, (int)n2, (String)string5);
        if (byArray == null) {
            throw new IOException("creq is null");
        }
        CertificateRequest certificateRequest = new CertificateRequest(byArray);
        this.addCertRequest(certificateRequest);
    }

    public boolean containsPkcs11Info() throws IOException, NoSuchAlgorithmException, CertificateException {
        String[] stringArray = this.getPkcs11Info();
        return stringArray[0] != null;
    }

    public String[] getPkcs11Info() throws IOException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet:getP11Info ");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.l != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.l);
        }
        oracleKeyStoreSpi = this.m != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.m);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        String[] stringArray = new String[]{oracleKeyStoreSpi.getP11Lib(), oracleKeyStoreSpi.getP11TokenLabel(), oracleKeyStoreSpi.getP11TokenPassphrase(), oracleKeyStoreSpi.getP11CertLabel()};
        return stringArray;
    }

    public void addP11Lib(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: addPkcs11Info");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.l != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.l);
        }
        oracleKeyStoreSpi = this.m != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.m);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.l = oracleKeyStoreSpi.d(byteArrayInputStream, this.m, string);
    }

    public void addP11TokenLabel(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: addPkcs11Info");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.l != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.l);
        }
        oracleKeyStoreSpi = this.m != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.m);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.l = oracleKeyStoreSpi.e(byteArrayInputStream, this.m, string);
    }

    public void addP11TokenPwd(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: addPkcs11Info");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.l != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.l);
        }
        oracleKeyStoreSpi = this.m != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.m);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.l = oracleKeyStoreSpi.f(byteArrayInputStream, this.m, string);
    }

    public void addP11CertLbl(String string) throws IOException, KeyStoreException, NoSuchAlgorithmException, CertificateException {
        OraclePKIDebug.a("OracleWallet: addPkcs11Info");
        OracleKeyStoreSpi oracleKeyStoreSpi = null;
        ByteArrayInputStream byteArrayInputStream = null;
        if (this.l != null) {
            byteArrayInputStream = new ByteArrayInputStream(this.l);
        }
        oracleKeyStoreSpi = this.m != null ? new OracleKeyStoreSpi() : new OracleSSOKeyStoreSpi();
        oracleKeyStoreSpi.engineLoad(byteArrayInputStream, this.m);
        if (byteArrayInputStream != null) {
            byteArrayInputStream.reset();
        }
        this.l = oracleKeyStoreSpi.g(byteArrayInputStream, this.m, string);
    }

    private void a() {
        this.m = null;
        this.k = null;
        this.l = null;
        this.o = null;
        this.q = null;
    }

    private o a(String string, char[] cArray) throws IOException {
        if (string.indexOf(58) < 2) {
            string = a + string;
        }
        if (string.toLowerCase().startsWith(a)) {
            if (cArray == null) {
                return new h(string.substring(a.length()));
            }
            return new k(string.substring(a.length()));
        }
        throw new IOException("Unsupported WRL type" + string);
    }

    private o a(char[] cArray) throws IOException {
        if (cArray == null) {
            return new h(null);
        }
        return new k(null);
    }

    private InputStream a(int n2) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.l);
        char[] cArray = null;
        byte[] byArray = new byte[1024];
        byte[] byArray2 = null;
        l l2 = new l();
        try {
            cArray = l2.a(byArray);
            byArray2 = l2.a(cArray, n2);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        byteArrayOutputStream.write(byArray2);
        PKCS12 pKCS12 = new PKCS12(new String(this.m), (InputStream)byteArrayInputStream);
        pKCS12.setPassword(new String(cArray));
        Vector vector = pKCS12.getAuthSafes();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            ((PKCS12Safe)vector.elementAt(i2)).setPassword(new String(cArray));
        }
        try {
            pKCS12.output((OutputStream)byteArrayOutputStream);
            OraclePKIDebug.a("Verifying wallet " + pKCS12.verify());
        }
        catch (AuthenticationException authenticationException) {
            OraclePKIDebug.a("Verifying wallet failed" + (Object)((Object)authenticationException));
            throw new IOException("Could not create SSO wallet from p12" + (Object)((Object)authenticationException));
        }
        byte[] byArray3 = byteArrayOutputStream.toByteArray();
        return new ByteArrayInputStream(byArray3);
    }

    private char[] b() throws IOException {
        char[] cArray = null;
        if (this.m == null) {
            l l2 = new l();
            try {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.l);
                l2.b(byteArrayInputStream);
                cArray = l2.a(byteArrayInputStream);
            }
            catch (IOException iOException) {
                this.a();
                throw new IOException(iOException.getMessage());
            }
        }
        return cArray;
    }

    private char[] b(char[] cArray) throws IOException {
        if (this.m != null) {
            throw new IOException("");
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.l);
        char[] cArray2 = null;
        byte[] byArray = new byte[1024];
        byte[] byArray2 = null;
        l l2 = new l();
        try {
            cArray2 = l2.a(byArray);
            byArray2 = l2.a(cArray2, 2);
        }
        catch (IOException iOException) {
            throw new IOException(iOException.getMessage());
        }
        byteArrayOutputStream.write(byArray2);
        PKCS12 pKCS12 = new PKCS12(new String(cArray), (InputStream)byteArrayInputStream);
        pKCS12.setPassword(new String(cArray2));
        Vector vector = pKCS12.getAuthSafes();
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            ((PKCS12Safe)vector.elementAt(i2)).setPassword(new String(cArray2));
        }
        try {
            pKCS12.output((OutputStream)byteArrayOutputStream);
            OraclePKIDebug.a("Verifying wallet " + pKCS12.verify());
        }
        catch (AuthenticationException authenticationException) {
            OraclePKIDebug.a("Verifying wallet failed" + (Object)((Object)authenticationException));
            throw new IOException("Could not create SSO wallet from p12" + (Object)((Object)authenticationException));
        }
        this.l = byteArrayOutputStream.toByteArray();
        return cArray2;
    }

    OraclePKIX509CertImpl[] a(OraclePKIX509CertImpl[] oraclePKIX509CertImplArray) throws IOException {
        int n2;
        int n3;
        int n4;
        OraclePKIX509CertImpl[] oraclePKIX509CertImplArray2 = new OraclePKIX509CertImpl[oraclePKIX509CertImplArray.length];
        Vector<OraclePKIX509CertImpl> vector = new Vector<OraclePKIX509CertImpl>(oraclePKIX509CertImplArray.length);
        Vector vector2 = new Vector(oraclePKIX509CertImplArray.length);
        for (n4 = 0; n4 < oraclePKIX509CertImplArray.length; ++n4) {
            vector.addElement(oraclePKIX509CertImplArray[n4]);
        }
        n4 = 0;
        for (n3 = 0; n3 < oraclePKIX509CertImplArray.length; ++n3) {
            OraclePKIPrincipalImpl oraclePKIPrincipalImpl;
            OraclePKIPrincipalImpl oraclePKIPrincipalImpl2 = (OraclePKIPrincipalImpl)((OraclePKIX509CertImpl)vector.get(n3)).getIssuerDN();
            if (!oraclePKIPrincipalImpl2.equals(oraclePKIPrincipalImpl = (OraclePKIPrincipalImpl)((OraclePKIX509CertImpl)vector.get(n3)).getSubjectDN())) continue;
            n4 = 1;
            vector2.addElement(vector.get(n3));
            vector.remove(n3);
            break;
        }
        if (n4 == 0) {
            throw new IOException("No self-signed cert in chain.");
        }
        n3 = 0;
        block2: do {
            n3 = 0;
            for (n2 = 0; n2 < vector.size(); ++n2) {
                if (!((Object)((OraclePKIX509CertImpl)vector.get(n2)).getIssuerDN()).equals(((OraclePKIX509CertImpl)vector2.lastElement()).getSubjectDN())) continue;
                n3 = 1;
                vector2.addElement(vector.get(n2));
                vector.remove(n2);
                continue block2;
            }
        } while (n3 != 0);
        if (vector.size() != 0 || vector2.size() != oraclePKIX509CertImplArray.length) {
            throw new IOException("Could not form complete chain.");
        }
        for (n2 = 0; n2 < oraclePKIX509CertImplArray.length; ++n2) {
            oraclePKIX509CertImplArray2[n2] = (OraclePKIX509CertImpl)vector2.get(n2);
        }
        return oraclePKIX509CertImplArray2;
    }

    static Class a(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError().initCause(classNotFoundException);
        }
    }
}

