/*
 * Decompiled with CFR 0.152.
 */
package com.rabbitmq.http.client;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.rabbitmq.http.client.domain.AlivenessTestResult;
import com.rabbitmq.http.client.domain.BindingInfo;
import com.rabbitmq.http.client.domain.ChannelInfo;
import com.rabbitmq.http.client.domain.ClusterId;
import com.rabbitmq.http.client.domain.ConnectionInfo;
import com.rabbitmq.http.client.domain.CurrentUserDetails;
import com.rabbitmq.http.client.domain.Definitions;
import com.rabbitmq.http.client.domain.ExchangeInfo;
import com.rabbitmq.http.client.domain.NodeInfo;
import com.rabbitmq.http.client.domain.OverviewResponse;
import com.rabbitmq.http.client.domain.PolicyInfo;
import com.rabbitmq.http.client.domain.QueueInfo;
import com.rabbitmq.http.client.domain.ShovelInfo;
import com.rabbitmq.http.client.domain.ShovelStatus;
import com.rabbitmq.http.client.domain.UserInfo;
import com.rabbitmq.http.client.domain.UserPermissions;
import com.rabbitmq.http.client.domain.VhostInfo;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.net.ssl.SSLContext;
import org.springframework.core.codec.Decoder;
import org.springframework.core.codec.Encoder;
import org.springframework.http.MediaType;
import org.springframework.http.client.reactive.ClientHttpConnector;
import org.springframework.http.client.reactive.ReactorClientHttpConnector;
import org.springframework.http.codec.json.Jackson2JsonDecoder;
import org.springframework.http.codec.json.Jackson2JsonEncoder;
import org.springframework.http.converter.json.Jackson2ObjectMapperBuilder;
import org.springframework.util.MimeType;
import org.springframework.util.StringUtils;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFilterFunction;
import org.springframework.web.reactive.function.client.ExchangeFilterFunctions;
import org.springframework.web.reactive.function.client.ExchangeStrategies;
import org.springframework.web.reactive.function.client.WebClient;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@Deprecated
public class ReactiveClient {
    private final WebClient client;

    public ReactiveClient(String url) throws MalformedURLException {
        this(url, (WebClient.Builder c) -> {}, null);
    }

    public ReactiveClient(String url, Consumer<WebClient.Builder> configurator) throws MalformedURLException {
        this(url, configurator, null);
    }

    public ReactiveClient(String url, Consumer<WebClient.Builder> configurator, SSLContext sslContext) throws MalformedURLException {
        this(ReactiveClient.urlWithoutCredentials(url), StringUtils.split((String)new URL(url).getUserInfo(), (String)":")[0], StringUtils.split((String)new URL(url).getUserInfo(), (String)":")[1], configurator, sslContext);
    }

    public ReactiveClient(String url, String username, String password) {
        this(url, username, password, builder -> {}, null);
    }

    public ReactiveClient(String url, String username, String password, Consumer<WebClient.Builder> configurator) {
        this(url, username, password, configurator, null);
    }

    public ReactiveClient(String url, String username, String password, Consumer<WebClient.Builder> configurator, SSLContext sslContext) {
        this.client = this.buildWebClient(url, username, password, configurator, sslContext);
    }

    protected WebClient buildWebClient(String url, String username, String password, Consumer<WebClient.Builder> configurator, SSLContext sslContext) {
        ExchangeStrategies strategies = ExchangeStrategies.builder().codecs(clientDefaultCodecsConfigurer -> {
            Jackson2ObjectMapperBuilder jacksonBuilder = Jackson2ObjectMapperBuilder.json().serializationInclusion(JsonInclude.Include.NON_NULL);
            clientDefaultCodecsConfigurer.defaultCodecs().jackson2JsonEncoder((Encoder)new Jackson2JsonEncoder(jacksonBuilder.build(), new MimeType[]{MediaType.APPLICATION_JSON}));
            clientDefaultCodecsConfigurer.defaultCodecs().jackson2JsonDecoder((Decoder)new Jackson2JsonDecoder(jacksonBuilder.build(), new MimeType[]{MediaType.APPLICATION_JSON}));
        }).build();
        WebClient.Builder builder = WebClient.builder().clientConnector((ClientHttpConnector)new ReactorClientHttpConnector(clientBuilder -> {
            if (sslContext != null) {
                clientBuilder.sslContext((SslContext)new JdkSslContext(sslContext, true, ClientAuth.NONE));
            }
        })).exchangeStrategies(strategies).baseUrl(url).filter(ExchangeFilterFunctions.basicAuthentication((String)username, (String)password)).filter(ExchangeFilterFunction.ofRequestProcessor(clientRequest -> {
            ClientRequest request = ClientRequest.from((ClientRequest)clientRequest).build();
            return Mono.just((Object)request);
        }));
        if (configurator != null) {
            configurator.accept(builder);
        }
        return builder.build();
    }

    private static String urlWithoutCredentials(String url) throws MalformedURLException {
        URL url1 = new URL(url);
        return StringUtils.replace((String)url, (String)(url1.getUserInfo() + "@"), (String)"");
    }

    public Mono<OverviewResponse> getOverview() {
        return this.client.get().uri("/overview", new Object[0]).retrieve().bodyToMono(OverviewResponse.class);
    }

    public Mono<AlivenessTestResult> alivenessTest(String vhost) {
        return this.client.get().uri("/aliveness-test/{vhost}", new Object[]{vhost}).retrieve().bodyToMono(AlivenessTestResult.class);
    }

    public Mono<CurrentUserDetails> whoAmI() {
        return this.client.get().uri("/whoami", new Object[0]).retrieve().bodyToMono(CurrentUserDetails.class);
    }

    public Flux<NodeInfo> getNodes() {
        return this.client.get().uri("/nodes", new Object[0]).retrieve().bodyToFlux(NodeInfo.class);
    }

    public Mono<NodeInfo> getNode(String name) {
        return this.client.get().uri("/nodes/{name}", new Object[]{name}).retrieve().bodyToMono(NodeInfo.class);
    }

    public Flux<ConnectionInfo> getConnections() {
        return this.client.get().uri("/connections", new Object[0]).retrieve().bodyToFlux(ConnectionInfo.class);
    }

    public Mono<ConnectionInfo> getConnection(String name) {
        return this.client.get().uri("/connections/{name}", new Object[]{name}).retrieve().bodyToMono(ConnectionInfo.class);
    }

    public Mono<ClientResponse> closeConnection(String name) {
        return this.client.delete().uri("/connections/{name}", new Object[]{name}).exchange();
    }

    public Mono<ClientResponse> closeConnection(String name, String reason) {
        return this.client.delete().uri("/connections/{name}", new Object[]{name}).header("X-Reason", new String[]{reason}).exchange();
    }

    public Flux<ChannelInfo> getChannels() {
        return this.client.get().uri("/channels", new Object[0]).retrieve().bodyToFlux(ChannelInfo.class);
    }

    public Flux<ChannelInfo> getChannels(String connectionName) {
        return this.client.get().uri("/connections/{connectionName}/channels", new Object[]{connectionName}).retrieve().bodyToFlux(ChannelInfo.class);
    }

    public Mono<ChannelInfo> getChannel(String name) {
        return this.client.get().uri("/channels/{name}", new Object[]{name}).retrieve().bodyToMono(ChannelInfo.class);
    }

    public Flux<VhostInfo> getVhosts() {
        return this.client.get().uri("/vhosts", new Object[0]).retrieve().bodyToFlux(VhostInfo.class);
    }

    public Mono<VhostInfo> getVhost(String name) {
        return this.client.get().uri("/vhosts/{name}", new Object[]{name}).retrieve().bodyToMono(VhostInfo.class);
    }

    public Mono<ClientResponse> createVhost(String name) {
        return ((WebClient.RequestBodySpec)this.client.put().uri("/vhosts/{name}", new Object[]{name})).contentLength(0L).exchange();
    }

    public Mono<ClientResponse> deleteVhost(String name) {
        return this.client.delete().uri("/vhosts/{name}", new Object[]{name}).exchange();
    }

    public Flux<UserPermissions> getPermissionsIn(String vhost) {
        return this.client.get().uri("/vhosts/{name}/permissions", new Object[]{vhost}).retrieve().bodyToFlux(UserPermissions.class);
    }

    public Flux<UserPermissions> getPermissionsOf(String username) {
        return this.client.get().uri("/users/{username}/permissions", new Object[]{username}).retrieve().bodyToFlux(UserPermissions.class);
    }

    public Flux<UserPermissions> getPermissions() {
        return this.client.get().uri("/permissions", new Object[0]).retrieve().bodyToFlux(UserPermissions.class);
    }

    public Mono<UserPermissions> getPermissions(String vhost, String username) {
        return this.client.get().uri("/permissions/{vhost}/{username}", new Object[]{vhost, username}).retrieve().bodyToMono(UserPermissions.class);
    }

    public Flux<ExchangeInfo> getExchanges() {
        return this.client.get().uri("/exchanges", new Object[0]).retrieve().bodyToFlux(ExchangeInfo.class);
    }

    public Flux<ExchangeInfo> getExchanges(String vhost) {
        return this.client.get().uri("/exchanges/{vhost}", new Object[]{vhost}).retrieve().bodyToFlux(ExchangeInfo.class);
    }

    public Flux<ExchangeInfo> getExchange(String vhost, String name) {
        return this.client.get().uri("/exchanges/{vhost}/{name}", new Object[]{vhost, name}).retrieve().bodyToFlux(ExchangeInfo.class);
    }

    public Flux<UserInfo> getUsers() {
        return this.client.get().uri("/users", new Object[0]).retrieve().bodyToFlux(UserInfo.class);
    }

    public Mono<UserInfo> getUser(String username) {
        return this.client.get().uri("/users/{username}", new Object[]{username}).retrieve().bodyToMono(UserInfo.class);
    }

    public Mono<ClientResponse> deleteUser(String username) {
        return this.client.delete().uri("/users/{username}", new Object[]{username}).exchange();
    }

    public Mono<ClientResponse> createUser(String username, char[] password, List<String> tags) {
        if (username == null) {
            throw new IllegalArgumentException("username cannot be null");
        }
        if (password == null) {
            throw new IllegalArgumentException("password cannot be null or empty. If you need to create a user that will only authenticate using an x509 certificate, use createUserWithPasswordHash with a blank hash.");
        }
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("password", new String(password));
        body.put("tags", StringUtils.collectionToCommaDelimitedString(tags));
        return ((WebClient.RequestBodySpec)this.client.put().uri("/users/{username}", new Object[]{username})).syncBody(body).exchange();
    }

    public Mono<ClientResponse> createUserWithPasswordHash(String username, char[] passwordHash, List<String> tags) {
        if (username == null) {
            throw new IllegalArgumentException("username cannot be null");
        }
        if (passwordHash == null) {
            passwordHash = "".toCharArray();
        }
        HashMap<String, String> body = new HashMap<String, String>();
        body.put("password_hash", String.valueOf(passwordHash));
        body.put("tags", StringUtils.collectionToCommaDelimitedString(tags));
        return ((WebClient.RequestBodySpec)this.client.put().uri("/users/{username}", new Object[]{username})).syncBody(body).exchange();
    }

    public Mono<ClientResponse> updateUser(String username, char[] password, List<String> tags) {
        if (username == null) {
            throw new IllegalArgumentException("username cannot be null");
        }
        HashMap<String, String> body = new HashMap<String, String>();
        if (password != null) {
            body.put("password", new String(password));
        }
        body.put("tags", StringUtils.collectionToCommaDelimitedString(tags));
        return ((WebClient.RequestBodySpec)this.client.put().uri("/users/{username}", new Object[]{username})).syncBody(body).exchange();
    }

    public Mono<ClientResponse> updatePermissions(String vhost, String username, UserPermissions permissions) {
        return ((WebClient.RequestBodySpec)this.client.put().uri("/permissions/{vhost}/{username}", new Object[]{vhost, username})).syncBody((Object)permissions).exchange();
    }

    public Mono<ClientResponse> clearPermissions(String vhost, String username) {
        return this.client.delete().uri("/permissions/{vhost}/{username}", new Object[]{vhost, username}).exchange();
    }

    public Mono<ClientResponse> declarePolicy(String vhost, String name, PolicyInfo info) {
        return ((WebClient.RequestBodySpec)this.client.put().uri("/policies/{vhost}/{name}", new Object[]{vhost, name})).syncBody((Object)info).exchange();
    }

    public Flux<PolicyInfo> getPolicies() {
        return this.client.get().uri("/policies", new Object[0]).retrieve().bodyToFlux(PolicyInfo.class);
    }

    public Flux<PolicyInfo> getPolicies(String vhost) {
        return this.client.get().uri("/policies/{vhost}", new Object[]{vhost}).retrieve().bodyToFlux(PolicyInfo.class);
    }

    public Mono<ClientResponse> deletePolicy(String vhost, String name) {
        return this.client.delete().uri("/policies/{vhost}/{name}", new Object[]{vhost, name}).exchange();
    }

    public Flux<BindingInfo> getBindings() {
        return this.client.get().uri("/bindings", new Object[0]).retrieve().bodyToFlux(BindingInfo.class);
    }

    public Flux<BindingInfo> getBindings(String vhost) {
        return this.client.get().uri("/bindings/{vhost}", new Object[]{vhost}).retrieve().bodyToFlux(BindingInfo.class);
    }

    public Flux<BindingInfo> getExchangeBindingsBySource(String vhost, String exchange) {
        String x = exchange.equals("") ? "amq.default" : exchange;
        return this.client.get().uri("/exchanges/{vhost}/{exchange}/bindings/source", new Object[]{vhost, x}).retrieve().bodyToFlux(BindingInfo.class);
    }

    public Flux<BindingInfo> getExchangeBindingsByDestination(String vhost, String exchange) {
        String x = exchange.equals("") ? "amq.default" : exchange;
        return this.client.get().uri("/exchanges/{vhost}/{exchange}/bindings/destination", new Object[]{vhost, x}).retrieve().bodyToFlux(BindingInfo.class);
    }

    public Flux<BindingInfo> getQueueBindings(String vhost, String queue) {
        return this.client.get().uri("/queues/{vhost}/{queue}/bindings", new Object[]{vhost, queue}).retrieve().bodyToFlux(BindingInfo.class);
    }

    public Flux<BindingInfo> getQueueBindingsBetween(String vhost, String exchange, String queue) {
        return this.client.get().uri("/bindings/{vhost}/e/{exchange}/q/{queue}", new Object[]{vhost, exchange, queue}).retrieve().bodyToFlux(BindingInfo.class);
    }

    public Flux<BindingInfo> getExchangeBindingsBetween(String vhost, String source, String destination) {
        return this.client.get().uri("/bindings/{vhost}/e/{source}/e/{destination}", new Object[]{vhost, source, destination}).retrieve().bodyToFlux(BindingInfo.class);
    }

    public Mono<ClusterId> getClusterName() {
        return this.client.get().uri("/cluster-name", new Object[0]).retrieve().bodyToMono(ClusterId.class);
    }

    public Mono<ClientResponse> setClusterName(String name) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name cannot be null or blank");
        }
        return ((WebClient.RequestBodySpec)this.client.put().uri("/cluster-name", new Object[0])).syncBody(Collections.singletonMap("name", name)).exchange();
    }

    public Flux<Map> getExtensions() {
        return this.client.get().uri("/extensions", new Object[0]).retrieve().bodyToFlux(Map.class);
    }

    public Mono<Definitions> getDefinitions() {
        return this.client.get().uri("/definitions", new Object[0]).retrieve().bodyToMono(Definitions.class);
    }

    public Mono<ClientResponse> declareQueue(String vhost, String name, QueueInfo info) {
        return ((WebClient.RequestBodySpec)this.client.put().uri("/queues/{vhost}/{name}", new Object[]{vhost, name})).syncBody((Object)info).exchange();
    }

    public Mono<ClientResponse> purgeQueue(String vhost, String name) {
        return this.client.delete().uri("/queues/{vhost}/{name}/contents", new Object[]{vhost, name}).exchange();
    }

    public Mono<ClientResponse> deleteQueue(String vhost, String name) {
        return this.client.delete().uri("/queues/{vhost}/{name}", new Object[]{vhost, name}).exchange();
    }

    public Mono<ClientResponse> declareExchange(String vhost, String name, ExchangeInfo info) {
        return ((WebClient.RequestBodySpec)this.client.put().uri("/exchanges/{vhost}/{name}", new Object[]{vhost, name})).syncBody((Object)info).exchange();
    }

    public Mono<ClientResponse> deleteExchange(String vhost, String name) {
        return this.client.delete().uri("/exchanges/{vhost}/{name}", new Object[]{vhost, name}).exchange();
    }

    public Flux<QueueInfo> getQueues() {
        return this.client.get().uri("/queues", new Object[0]).retrieve().bodyToFlux(QueueInfo.class);
    }

    public Flux<QueueInfo> getQueues(String vhost) {
        return this.client.get().uri("/queues/{vhost}", new Object[]{vhost}).retrieve().bodyToFlux(QueueInfo.class);
    }

    public Mono<QueueInfo> getQueue(String vhost, String name) {
        return this.client.get().uri("/queues/{vhost}/{name}", new Object[]{vhost, name}).retrieve().bodyToMono(QueueInfo.class);
    }

    public Mono<ClientResponse> bindQueue(String vhost, String queue, String exchange, String routingKey) {
        return this.bindQueue(vhost, queue, exchange, routingKey, new HashMap<String, Object>());
    }

    public Mono<ClientResponse> bindQueue(String vhost, String queue, String exchange, String routingKey, Map<String, Object> args) {
        if (vhost == null || vhost.isEmpty()) {
            throw new IllegalArgumentException("vhost cannot be null or blank");
        }
        if (queue == null || queue.isEmpty()) {
            throw new IllegalArgumentException("queue cannot be null or blank");
        }
        if (exchange == null || exchange.isEmpty()) {
            throw new IllegalArgumentException("exchange cannot be null or blank");
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        if (args != null) {
            body.put("args", args);
        }
        body.put("routing_key", routingKey);
        return ((WebClient.RequestBodySpec)this.client.post().uri("/bindings/{vhost}/e/{exchange}/q/{queue}", new Object[]{vhost, exchange, queue})).syncBody(body).exchange();
    }

    public Mono<ClientResponse> bindExchange(String vhost, String destination, String source, String routingKey) {
        return this.bindExchange(vhost, destination, source, routingKey, new HashMap<String, Object>());
    }

    public Mono<ClientResponse> bindExchange(String vhost, String destination, String source, String routingKey, Map<String, Object> args) {
        if (vhost == null || vhost.isEmpty()) {
            throw new IllegalArgumentException("vhost cannot be null or blank");
        }
        if (destination == null || destination.isEmpty()) {
            throw new IllegalArgumentException("destination cannot be null or blank");
        }
        if (source == null || source.isEmpty()) {
            throw new IllegalArgumentException("source cannot be null or blank");
        }
        HashMap<String, Object> body = new HashMap<String, Object>();
        if (args != null) {
            body.put("args", args);
        }
        body.put("routing_key", routingKey);
        return ((WebClient.RequestBodySpec)this.client.post().uri("/bindings/{vhost}/e/{source}/e/{destination}", new Object[]{vhost, source, destination})).syncBody(body).exchange();
    }

    public Mono<ClientResponse> declareShovel(String vhost, ShovelInfo info) {
        return ((WebClient.RequestBodySpec)this.client.put().uri("/parameters/shovel/{vhost}/{name}", new Object[]{vhost, info.getName()})).syncBody((Object)info).exchange();
    }

    public Flux<ShovelInfo> getShovels() {
        return this.client.get().uri("/parameters/shovel", new Object[0]).retrieve().bodyToFlux(ShovelInfo.class);
    }

    public Flux<ShovelStatus> getShovelsStatus() {
        return this.client.get().uri("/shovels", new Object[0]).retrieve().bodyToFlux(ShovelStatus.class);
    }

    public Mono<ClientResponse> deleteShovel(String vhost, String shovelName) {
        return this.client.delete().uri("/parameters/shovel/{vhost}/{name}", new Object[]{vhost, shovelName}).exchange();
    }
}

