/*
 * Decompiled with CFR 0.152.
 */
package io.spring.format.maven;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.DirectoryScanner;
import org.codehaus.plexus.util.FileUtils;

public abstract class FormatMojo
extends AbstractMojo {
    private static final String[] DEFAULT_INCLUDES = new String[]{"**/*.java"};
    private static final String GENERATED_SOURCES = File.separator + "generated-sources" + File.separator;
    private static final String GENERATED_TEST_SOURCES = File.separator + "generated-test-sources" + File.separator;
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    protected MavenProject project;
    @Parameter(defaultValue="${project.compileSourceRoots}")
    private List<String> sourceDirectories;
    @Parameter(defaultValue="${project.testCompileSourceRoots}")
    private List<String> testSourceDirectories;
    @Parameter(property="spring-javaformat.excludes")
    private String[] excludes;
    @Parameter(property="spring-javaformat.includes")
    private String[] includes;
    @Parameter(property="encoding", defaultValue="${project.build.sourceEncoding}")
    private String encoding;
    @Parameter(property="spring-javaformat.includeGeneratedSource", defaultValue="false")
    private boolean includeGeneratedSource;

    public final void execute() throws MojoExecutionException, MojoFailureException {
        ArrayList directories = new ArrayList();
        this.resolve(this.sourceDirectories).forEach(directories::add);
        this.resolve(this.testSourceDirectories).forEach(directories::add);
        ArrayList<File> files = new ArrayList<File>();
        for (File directory : directories) {
            files.addAll(this.scan(directory));
        }
        Charset encoding = this.encoding == null ? StandardCharsets.UTF_8 : Charset.forName(this.encoding);
        this.execute(files, encoding);
    }

    private Stream<File> resolve(List<String> directories) {
        return directories.stream().map(directory -> FileUtils.resolveFile((File)this.project.getBasedir(), (String)directory)).filter(this::include);
    }

    private boolean include(File file) {
        if (!file.exists()) {
            return false;
        }
        if (!file.isDirectory()) {
            return false;
        }
        return this.includeGeneratedSource || !this.isGeneratedSource(file);
    }

    private boolean isGeneratedSource(File file) {
        try {
            String path = file.getCanonicalPath() + File.separator;
            String projectPath = this.project.getBasedir().getCanonicalPath();
            return path.startsWith(projectPath) && (path.contains(GENERATED_SOURCES) || path.contains(GENERATED_TEST_SOURCES));
        }
        catch (IOException ex) {
            return false;
        }
    }

    private List<File> scan(File directory) {
        DirectoryScanner scanner = new DirectoryScanner();
        scanner.setBasedir(directory);
        scanner.setIncludes(this.hasLength(this.includes) ? this.includes : DEFAULT_INCLUDES);
        scanner.setExcludes(this.excludes);
        scanner.addDefaultExcludes();
        scanner.setCaseSensitive(false);
        scanner.setFollowSymlinks(false);
        scanner.scan();
        return Arrays.asList(scanner.getIncludedFiles()).stream().map(name -> new File(directory, (String)name)).collect(Collectors.toList());
    }

    private boolean hasLength(Object[] array) {
        return array != null && array.length > 0;
    }

    protected abstract void execute(List<File> var1, Charset var2) throws MojoExecutionException, MojoFailureException;
}

