/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.assembly.io;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.plugins.assembly.io.DefaultMessageHolder;
import org.apache.maven.plugins.assembly.io.Location;
import org.apache.maven.plugins.assembly.io.LocatorStrategy;
import org.apache.maven.plugins.assembly.io.MessageHolder;

final class Locator {
    private List<LocatorStrategy> strategies;
    private final MessageHolder messageHolder;

    Locator(List<LocatorStrategy> strategies, MessageHolder messageHolder) {
        this.messageHolder = messageHolder;
        this.strategies = new ArrayList<LocatorStrategy>(strategies);
    }

    Locator() {
        this.messageHolder = new DefaultMessageHolder();
        this.strategies = new ArrayList<LocatorStrategy>();
    }

    MessageHolder getMessageHolder() {
        return this.messageHolder;
    }

    void addStrategy(LocatorStrategy strategy) {
        this.strategies.add(strategy);
    }

    void removeStrategy(LocatorStrategy strategy) {
        this.strategies.remove(strategy);
    }

    void setStrategies(List<LocatorStrategy> strategies) {
        this.strategies.clear();
        this.strategies.addAll(strategies);
    }

    List<LocatorStrategy> getStrategies() {
        return this.strategies;
    }

    Location resolve(String locationSpecification) {
        Location location = null;
        Iterator<LocatorStrategy> it = this.strategies.iterator();
        while (location == null && it.hasNext()) {
            LocatorStrategy strategy = it.next();
            location = strategy.resolve(locationSpecification, this.messageHolder);
        }
        return location;
    }
}

