/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.bittorrent.internal.torrent;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.bittorrent.internal.torrent.Block;
import org.eclipse.bittorrent.internal.torrent.DataFile;
import org.eclipse.bittorrent.internal.torrent.PieceState;

public class Piece {
    private static final int BLOCK_REQUEST_SIZE = 16384;
    private final ArrayList files;
    private final ArrayList fileLengths;
    private final int number;
    private PieceState state;
    private int[] writtenBlocks;
    private boolean[] requested;
    private boolean[] completed;
    private int length = -1;
    private int blocks;
    private boolean isLastPiece;

    public Piece(PieceState state, int number) throws IllegalArgumentException {
        if (number < 0) {
            throw new IllegalArgumentException("A piece number cannot be negative");
        }
        this.state = state;
        this.number = number;
        this.files = new ArrayList();
        this.fileLengths = new ArrayList();
    }

    public void setLength(int length) throws IllegalArgumentException {
        if (length < 0) {
            throw new IllegalArgumentException("A piece's length cannot be negative");
        }
        this.length = length;
        this.isLastPiece = length % 16384 != 0;
        this.blocks = length / 16384 + (this.isLastPiece ? 1 : 0);
        this.requested = new boolean[this.blocks];
        this.completed = new boolean[this.blocks];
        this.writtenBlocks = new int[this.blocks];
    }

    public int getLength() {
        return this.length;
    }

    public void reset() {
        Arrays.fill(this.requested, false);
        Arrays.fill(this.completed, false);
        Arrays.fill(this.writtenBlocks, 0);
        this.state.reset();
    }

    private int getFileOffset(int pos, int index) {
        if (this.files.size() == 1) {
            return index;
        }
        int count = 0;
        int offset = 0;
        do {
            offset += ((Integer)this.fileLengths.get(count++)).intValue();
        } while (count <= pos);
        if (index > offset) {
            return -1;
        }
        pos = offset - (Integer)this.fileLengths.get(count - 1);
        if (pos <= index && index < offset) {
            return index - pos;
        }
        return -1;
    }

    public boolean write(int pieceIndex, byte[] block, int offset, int length) throws IOException {
        int blockIndex = pieceIndex / 16384;
        if (this.completed[blockIndex]) {
            return false;
        }
        this.state.addDownloadedBlock(pieceIndex, length);
        int[] ret = null;
        if (blockIndex == this.blocks - 1) {
            int limit = this.isLastPiece ? this.length % 16384 : 16384;
            int[] nArray = new int[3];
            nArray[0] = offset;
            nArray[1] = length;
            ret = nArray;
            int i = 0;
            while (i < this.files.size()) {
                ret = ((DataFile)this.files.get(i)).write(this.number, this.getFileOffset(i, pieceIndex), block, ret);
                if (ret == null) break;
                pieceIndex += ret[2];
                ++i;
            }
            int n = blockIndex;
            this.writtenBlocks[n] = this.writtenBlocks[n] + length;
            if (this.writtenBlocks[blockIndex] == limit) {
                this.completed[blockIndex] = true;
            }
        } else {
            int[] nArray = new int[3];
            nArray[0] = offset;
            nArray[1] = length;
            ret = nArray;
            int i = 0;
            while (i < this.files.size()) {
                ret = ((DataFile)this.files.get(i)).write(this.number, this.getFileOffset(i, pieceIndex), block, ret);
                if (ret == null) break;
                pieceIndex += ret[2];
                ++i;
            }
            int n = blockIndex;
            this.writtenBlocks[n] = this.writtenBlocks[n] + length;
            if (this.writtenBlocks[blockIndex] == 16384) {
                this.completed[blockIndex] = true;
            }
        }
        return true;
    }

    public int getWritten() {
        int total = 0;
        int i = 0;
        while (i < this.writtenBlocks.length) {
            total += this.writtenBlocks[i];
            ++i;
        }
        return total;
    }

    public void addFile(DataFile file, int length) throws IllegalArgumentException {
        if (file == null) {
            throw new IllegalArgumentException("The file cannot be null");
        }
        if (length < 0) {
            throw new IllegalArgumentException("The length cannot be a negative number");
        }
        this.files.add(file);
        this.fileLengths.add(new Integer(length));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isComplete() {
        boolean[] blArray = this.completed;
        synchronized (this.completed) {
            int i = 0;
            while (true) {
                if (i >= this.blocks) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return true;
                }
                if (!this.completed[i]) {
                    // ** MonitorExit[var1_1] (shouldn't be in output)
                    return false;
                }
                ++i;
            }
        }
    }

    public void setAsCompleted() {
        Arrays.fill(this.requested, true);
        Arrays.fill(this.completed, true);
        if (this.isLastPiece) {
            int i = 0;
            while (i < this.blocks - 1) {
                this.writtenBlocks[i] = 16384;
                ++i;
            }
            this.writtenBlocks[this.blocks - 1] = this.length % 16384;
        } else {
            int i = 0;
            while (i < this.blocks) {
                this.writtenBlocks[i] = 16384;
                ++i;
            }
        }
        this.state.setAsComplete(this.length);
    }

    public void setState(PieceState state) {
        this.state = state;
        Vector blocks = state.getBlocks();
        int i = 0;
        while (i < blocks.size()) {
            int j;
            int length;
            int remainder;
            Block block = (Block)blocks.get(i);
            int index = block.getIndex() / 16384;
            if (this.isLastPiece && block.getIndex() % 16384 != 0) {
                ++index;
            }
            if ((remainder = (length = block.getBlockLength()) % 16384) == 0) {
                j = 0;
                while (j < length) {
                    this.writtenBlocks[index] = 16384;
                    this.requested[index] = true;
                    this.completed[index] = true;
                    ++index;
                    j += 16384;
                }
            } else {
                j = 0;
                while (j < length - 16384) {
                    this.writtenBlocks[index] = 16384;
                    this.requested[index] = true;
                    this.completed[index] = true;
                    ++index;
                    j += 16384;
                }
                this.writtenBlocks[index] = remainder;
            }
            ++i;
        }
    }

    public int getNumber() {
        return this.number;
    }

    public synchronized int[] getRequestInformation() throws IllegalStateException {
        if (this.length == -1) {
            throw new IllegalStateException("The length has not been set yet for this piece");
        }
        if (this.isComplete()) {
            return null;
        }
        boolean allRequested = true;
        int i = 0;
        while (i < this.blocks) {
            if (!this.completed[i] && !this.requested[i]) {
                allRequested = false;
                break;
            }
            ++i;
        }
        int random = -1;
        if (!allRequested) {
            random = (int)(Math.random() * (double)this.blocks);
            while (this.requested[random]) {
                if (this.isComplete()) {
                    return null;
                }
                random = (int)(Math.random() * (double)this.blocks);
            }
            this.requested[random] = true;
        } else {
            random = (int)(Math.random() * (double)this.blocks);
            while (this.completed[random]) {
                if (this.isComplete()) {
                    return null;
                }
                random = (int)(Math.random() * (double)this.blocks);
            }
        }
        int[] nArray = new int[3];
        nArray[0] = this.number;
        nArray[1] = this.writtenBlocks[random] + random * 16384;
        nArray[2] = random == this.blocks - 1 ? (this.isLastPiece ? this.length % 16384 : 16384) : 16384;
        return nArray;
    }
}

