/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.js.nodes.temporal;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.dsl.Cached;
import com.oracle.truffle.api.dsl.Specialization;
import com.oracle.truffle.api.nodes.Node;
import com.oracle.truffle.api.profiles.InlinedBranchProfile;
import com.oracle.truffle.api.profiles.InlinedConditionProfile;
import com.oracle.truffle.api.strings.TruffleString;
import com.oracle.truffle.js.nodes.JavaScriptBaseNode;
import com.oracle.truffle.js.nodes.access.IsObjectNode;
import com.oracle.truffle.js.nodes.access.PropertyGetNode;
import com.oracle.truffle.js.nodes.cast.JSToStringNode;
import com.oracle.truffle.js.nodes.temporal.TemporalCalendarFieldsNode;
import com.oracle.truffle.js.nodes.temporal.TemporalGetOptionNode;
import com.oracle.truffle.js.nodes.temporal.TemporalMonthDayFromFieldsNode;
import com.oracle.truffle.js.nodes.temporal.ToTemporalCalendarWithISODefaultNode;
import com.oracle.truffle.js.runtime.JSContext;
import com.oracle.truffle.js.runtime.JSRealm;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalDateTimeRecord;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDate;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainDateTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainMonthDay;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainMonthDayObject;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainTime;
import com.oracle.truffle.js.runtime.builtins.temporal.JSTemporalPlainYearMonth;
import com.oracle.truffle.js.runtime.builtins.temporal.TemporalCalendar;
import com.oracle.truffle.js.runtime.objects.JSDynamicObject;
import com.oracle.truffle.js.runtime.objects.JSObject;
import com.oracle.truffle.js.runtime.objects.Undefined;
import com.oracle.truffle.js.runtime.util.TemporalConstants;
import com.oracle.truffle.js.runtime.util.TemporalUtil;
import java.util.List;

public abstract class ToTemporalMonthDayNode
extends JavaScriptBaseNode {
    @Node.Child
    private PropertyGetNode getMonthNode;
    @Node.Child
    private PropertyGetNode getMonthCodeNode;
    @Node.Child
    private PropertyGetNode getYearNode;
    @Node.Child
    private PropertyGetNode getCalendarNode;
    protected final JSContext ctx;

    protected ToTemporalMonthDayNode(JSContext context) {
        this.ctx = context;
    }

    public abstract JSTemporalPlainMonthDayObject execute(Object var1, JSDynamicObject var2);

    @Specialization
    public JSTemporalPlainMonthDayObject toTemporalMonthDay(Object item, JSDynamicObject options, @Cached InlinedBranchProfile errorBranch, @Cached InlinedConditionProfile isObjectProfile, @Cached InlinedConditionProfile setReferenceYear, @Cached InlinedConditionProfile returnPlainMonthDay, @Cached InlinedConditionProfile getCalendarPath, @Cached IsObjectNode isObjectNode, @Cached JSToStringNode toStringNode, @Cached TemporalGetOptionNode temporalGetOptionNode, @Cached(value="create(ctx)") ToTemporalCalendarWithISODefaultNode toTemporalCalendarWithISODefaultNode, @Cached(value="create(ctx)") TemporalMonthDayFromFieldsNode monthDayFromFieldsNode, @Cached(value="create(ctx)") TemporalCalendarFieldsNode calendarFieldsNode) {
        int referenceISOYear = 1972;
        JSRealm realm = this.getRealm();
        if (isObjectProfile.profile((Node)this, isObjectNode.executeBoolean(item))) {
            JSDynamicObject itemObj = (JSDynamicObject)((Object)item);
            if (JSTemporalPlainMonthDay.isJSTemporalPlainMonthDay((Object)itemObj)) {
                return (JSTemporalPlainMonthDayObject)itemObj;
            }
            JSDynamicObject calendar = null;
            boolean calendarAbsent = false;
            if (getCalendarPath.profile((Node)this, JSTemporalPlainDate.isJSTemporalPlainDate((Object)itemObj) || JSTemporalPlainDateTime.isJSTemporalPlainDateTime((Object)itemObj) || JSTemporalPlainTime.isJSTemporalPlainTime((Object)itemObj) || JSTemporalPlainYearMonth.isJSTemporalPlainYearMonth((Object)itemObj) || TemporalUtil.isTemporalZonedDateTime((Object)itemObj))) {
                assert (itemObj instanceof TemporalCalendar);
                calendar = ((TemporalCalendar)((Object)itemObj)).getCalendar();
                calendarAbsent = false;
            } else {
                Object calendarObj = this.getCalendar(itemObj);
                calendarAbsent = calendarObj == Undefined.instance;
                calendar = toTemporalCalendarWithISODefaultNode.execute(calendarObj);
            }
            List<TruffleString> fieldNames = calendarFieldsNode.execute(calendar, TemporalUtil.listDMMCY);
            JSObject fields = TemporalUtil.prepareTemporalFields(this.ctx, itemObj, fieldNames, TemporalUtil.listEmpty);
            if (this.getMonthNode == null || this.getMonthCodeNode == null || this.getYearNode == null) {
                CompilerDirectives.transferToInterpreterAndInvalidate();
                this.getMonthNode = (PropertyGetNode)this.insert(PropertyGetNode.create(TemporalConstants.MONTH, this.ctx));
                this.getMonthCodeNode = (PropertyGetNode)this.insert(PropertyGetNode.create(TemporalConstants.MONTH_CODE, this.ctx));
                this.getYearNode = (PropertyGetNode)this.insert(PropertyGetNode.create(TemporalConstants.YEAR, this.ctx));
            }
            Object month = this.getMonthNode.getValue((Object)fields);
            Object monthCode = this.getMonthCodeNode.getValue((Object)fields);
            Object year = this.getYearNode.getValue((Object)fields);
            if (setReferenceYear.profile((Node)this, calendarAbsent && month != Undefined.instance && monthCode == Undefined.instance && year == Undefined.instance)) {
                TemporalUtil.createDataPropertyOrThrow(this.ctx, fields, TemporalConstants.YEAR, referenceISOYear);
            }
            return monthDayFromFieldsNode.execute(calendar, fields, options);
        }
        TemporalUtil.toTemporalOverflow(options, temporalGetOptionNode);
        TruffleString string = toStringNode.executeString(item);
        JSTemporalDateTimeRecord result = TemporalUtil.parseTemporalMonthDayString(string);
        JSDynamicObject calendar = toTemporalCalendarWithISODefaultNode.execute(result.getCalendar());
        if (returnPlainMonthDay.profile((Node)this, result.getYear() == Integer.MIN_VALUE)) {
            return JSTemporalPlainMonthDay.create(this.ctx, realm, result.getMonth(), result.getDay(), calendar, referenceISOYear, this, errorBranch);
        }
        JSTemporalPlainMonthDayObject result2 = JSTemporalPlainMonthDay.create(this.ctx, realm, result.getMonth(), result.getDay(), calendar, referenceISOYear, this, errorBranch);
        return monthDayFromFieldsNode.execute(calendar, result2, Undefined.instance);
    }

    private Object getCalendar(JSDynamicObject obj) {
        if (this.getCalendarNode == null) {
            CompilerDirectives.transferToInterpreterAndInvalidate();
            this.getCalendarNode = (PropertyGetNode)this.insert(PropertyGetNode.create(TemporalConstants.CALENDAR, this.ctx));
        }
        return this.getCalendarNode.getValue((Object)obj);
    }
}

