/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.llvm.api;

import com.oracle.truffle.api.TruffleFile;
import com.oracle.truffle.api.TruffleLanguage;
import com.oracle.truffle.api.nodes.LanguageInfo;
import com.oracle.truffle.llvm.api.Toolchain;

abstract class ToolchainExampleSnippet {
    private ToolchainExampleSnippet() {
    }

    int runMake(TruffleLanguage.Env env) throws Exception {
        LanguageInfo llvmInfo = (LanguageInfo)env.getInternalLanguages().get("llvm");
        Toolchain toolchain = (Toolchain)env.lookup(llvmInfo, Toolchain.class);
        String id = toolchain.getIdentifier();
        TruffleFile cc = toolchain.getToolPath("CC");
        TruffleFile cl = toolchain.getToolPath("CL");
        TruffleFile cxx = toolchain.getToolPath("CXX");
        TruffleFile ld = toolchain.getToolPath("LD");
        String[] args = new String[]{"make", "CC=" + cc, "CL=" + cl, "CXX=" + cxx, "LD=" + ld, "OUTPUT_DIR=" + id};
        Process p = env.newProcessBuilder(args).start();
        p.waitFor();
        return p.exitValue();
    }
}

